/************************************************************************/
/*	bds1.46  2.29	 17mar87	ctdl.c				*/
/*		Command-interpreter code for Citadel			*/
/************************************************************************/
#include "229ctdl.h"
/************************************************************************/
/*				history 				*/
/* 86Apr23 BP,KK,MM networks, print, carr, global, etc			*/
/* 83Jul14 BAK	...							*/
/* 83Jun11 BAK  Edited to fix <typo>.hlp problem.  			*/
/* 83Mar08 CrT	Aide-special functions installed & tested...		*/
/* 83Feb24 CrT/SB Menus rearranged.					*/
/* 82Dec06 CrT	2.00 release.						*/
/* 82Nov05 CrT	removed main() from room2.c and split into sub-fn()s	*/
/************************************************************************/
/************************************************************************/
/*				Contents				*/
/*									*/
/*	doAide()		handles Aide-only commands		*/
/*	doChat()		handles C(hat)		command 	*/
/*	doEnter()		handles E(nter) 	command 	*/
/*	doGoto()		handles G(oto)		command 	*/
/*	doHelp()		handles H(elp)		command 	*/
/*	doKnown()		handles K(nown rooms)	command 	*/
/*	doLogin()		handles L(ogin) 	command 	*/
/*	doLogout()		handles T(erminate)	command 	*/
/*	doRead()		handles R(ead)		command 	*/
/*	doRegular()		fanout for above commands		*/
/*	doSysop()		handles sysop-only commands		*/
/*	getCommand()		prints prompt and gets command char	*/
/*	greeting()		System-entry blurb etc			*/
/*	main()			has the central menu code		*/
/************************************************************************/

/************************************************************************/
/*	doAide() handles the aide-only menu				*/
/*	    return FALSE to fall invisibly into default error msg	*/
/************************************************************************/
char doAide(moreYet, first)
char moreYet;
char first;	/* first parameter if TRUE		*/
{
    char oldName[NAMESIZE];
    int  rm;

    if (!aide)	 return FALSE;

    if (moreYet)   first = '\0';

    mPrintf("ide ");

    if (first)	   oChar(first);

    switch (toUpper(   first ? first : iChar()	  )) {
    case 'E':
	mPrintf("dit room\n ");
	strCpy(oldName, roomBuf.rbname);
	if (!renameRoom())   break;
	if (whichIO == MODEM)  {
	sPrintf(
	    msgBuf.mbtext,
	    "%s made %s>, %s>",
	    logBuf.lbname,
	    oldName,
	    roomBuf.rbname
	);
	aideMessage( /* noteDeletedMessage == */ FALSE);
				}
	break;
    case 'I':
	mPrintf("nsert\n ");
	if (thisRoom <= LOGROOM
		||
		pulledMLoc == ERROR) {
	    mPrintf("\n NO");
	    break;
	}
	note2Message(pulledMId, pulledMLoc);
	putRoom(thisRoom, &roomBuf);
	noteRoom();
	if (whichIO == MODEM)  {
  	sPrintf(
	    msgBuf.mbtext,
	    "To %s> by %s",
	    roomBuf.rbname,
	    logBuf.lbname
	)  ;
	aideMessage( /* noteDeletedMessage == */ TRUE);
				}
	break;
    case 'K':
	mPrintf("ill room\n ");
	if (thisRoom <= LOGROOM) {
	    mPrintf("\n NO");
	    break;
	}
	if (!getYesNo("OK"))   break;
	if (whichIO == MODEM)  {
	sPrintf(
	    msgBuf.mbtext,
	    "%s killed %s>",
	    logBuf.lbname,
	    roomBuf.rbname
	);
	aideMessage( /* noteDeletedMessage == */ FALSE);
				}
	roomBuf.rbflags ^= INUSE;
	putRoom(thisRoom, &roomBuf);
	noteRoom();
	getRoom(LOBBY, &roomBuf);
	break;
    case '?':
	tutorial("aide.mnu");
	break;
    case 'S':
        mPrintf("et date\n ");
        interpret(pInitDate);
        break;
  /*    case 'X':
        mPrintf("\b Exit to CP/M\n\n");
        if(!getYesNo("Sure "))break;
        exitToCpm=TRUE;
        return FALSE;     
   */
	default:
	mPrintf("?\n " 			);
	break;
    }
    return TRUE;
}

/************************************************************************/
/*	doChat()							*/
/************************************************************************/
doChat(moreYet, first)
char moreYet;	/* TRUE to accept folliwng parameters	*/
char first;	/* first paramter if TRUE		*/
{
    if (moreYet)   first = '\0';

    if (first)	   oChar(first);

    mPrintf("hat");

    if ((!loggedIn || noChat) && whichIO !=CONSOLE)   {
	tutorial("nochat.blb");
	return;
    }

    if (whichIO == MODEM)	ringSysop();
    else			interact() ;
}

/************************************************************************/
/*	doEnter() handles E(nter) command				*/
/************************************************************************/
doEnter(moreYet, first)
char moreYet;	/* TRUE to accept following parameters	*/
char first;	/* first parameter if TRUE		*/
{
#define CONFIGURATION	0
#define MESSAGE 	1
#define PASSWORD        2
#define ROOM    	3
#define FILE		4
    char what;			/* one of above five */
    char abort, done, WC;
    char iChar(), toUpper();


    if (moreYet)   first = '\0';

    abort	= FALSE  ;
    done	= FALSE  ;
    WC		= FALSE  ;
    what	= MESSAGE;

    if (!loggedIn  &&  !unlogEnterOk) {
	if (thisRoom!=MAILROOM)	{
		gotoRoom("Mail");
		mPrintf("\bTo Sysop");
		textDownload=TRUE;MakeMessage(WC);return;
	 }
     }

    if (thisRoom==LOGROOM) {
		mPrintf("\bNo");
		return;
     }

    mPrintf("nter ");

    if (first)	   oChar(first);

    do	{
	outFlag = OUTOK;

	switch (toUpper(   first ? first : iChar()   )) {
	case '\r':
	case '\n':
	    moreYet	= FALSE;
	    break;
	case 'F':
	    if (roomBuf.rbflags & CPMDIR) {
		mPrintf("ile-WC");
		WC	= TRUE;
		what	= FILE;
		done	= TRUE;
		break;
	    }else{mPrintf("\bNo']'");abort = TRUE;break;}
	default:
	    mPrintf("\b?");
	    abort	= TRUE;
	    if (expert)  break;
	case '?':
	    tutorial("entopt.mnu");
	    abort	= TRUE;
	    break;
	case 'C':
            mPrintf("nfg");
	    what	= CONFIGURATION;
	    done	= TRUE;
	    break;
	case 'M':
	    mPrintf("sg" );
	    what	= MESSAGE      ;
	    done	= TRUE;
	    break;
	case 'N':
            if ( !aide ){
	       mPrintf("\b?");
               abort=TRUE;
               break;
	    }
	    mPrintf("et Msg" );
	    what	= MESSAGE      ;
	    done	= TRUE;
            WC = TRUE;
	    break;
	case 'P':
	    mPrintf("sw");
	    what	= PASSWORD     ;
	    done	= TRUE;
	    break;
	case 'R':
	    mPrintf("oom"  );
	    if (!nonAideRoomOk && !aide)   {
		mPrintf(" No");
		abort	= TRUE;
		break;
	    }
	    what	= ROOM	       ;
	    done	= TRUE;
	    break;
	}
	first = '\0';
    } while (!done && moreYet && !abort);

    doCR();

    if (!abort) { textDownload = FALSE;
	switch (what) {
	case CONFIGURATION  :	configure()	;	break;
	case MESSAGE	    :	{textDownload = TRUE; makeMessage(WC); break;}
	case PASSWORD	    :	newPW() 	;	break;
	case ROOM	    :	makeRoom()	;	break;
	case FILE	    :	{textDownload = FALSE; upLoad(); break;}
	}
    }
}

/************************************************************************/
/*	doGoto() handles G(oto) command 				*/
/************************************************************************/
doGoto(expand, first)
char expand;	/* TRUE to accept following parameters	*/
char first;	/* first parameter if TRUE		*/
{
    char roomName[NAMESIZE];

    mPrintf("oto ");

    if ( !loggedIn ) { 
       mPrintf("Mail");
       gotoRoom("Mail");
       return;
    }
  
    if (!expand) {
	gotoRoom("");
	return;
    }

    getString("", roomName, NAMESIZE);
    normalizeString(roomName);

    if (roomName[0] == '?')	listRooms(/* doDull== */ TRUE);
    else			gotoRoom(roomName);
}

/************************************************************************/
/*	doHelp() handles H(elp) command 				*/
/************************************************************************/
doHelp(expand, first)
char expand;	/* TRUE to accept following parameters	*/
char first;	/* first parameter if TRUE		*/
{
    char fileName[NAMESIZE];
    if(!loggedIn)	{
		mPrintf("\b");
                  tutorial("newuser.mnu");
                  return;} 
    if (!expand) {
	mPrintf("elp");
	tutorial("dohelp.hlp");
	return;
    }
    mPrintf("elp ");
    getString("", fileName, NAMESIZE);
    normalizeString(fileName);
    if (fileName[0] == '?'
	 || strLen(fileName) > 8
	 || fileName[1] == ':'
	 || strLen(fileName) < 1
       ) {
	tutorial("helpopt.hlp");
   } else {
	/* adding the extention makes things look simpler for		*/
	/* the user... and restricts the files which can be read	*/
	strcat(fileName, ".hlp");
	tutorial(fileName);
    }
}

/************************************************************************/
/*	doKnown() handles K(nown rooms) command.			*/
/************************************************************************/
doKnown(expand, first)
char expand;	/* TRUE to accept following parameters	*/
char first;	/* first parameter if TRUE		*/
{
    if(!loggedIn)
	{mPrintf("\b?");
	 return;
	}
    mPrintf("nown");
    listRooms(/* doDull== */ TRUE);
}

/************************************************************************/
/*	doLogin() handles L(ogin) command				*/
/************************************************************************/
doLogin(moreYet, first)
char moreYet;	/* TRUE to accept following parameters	*/
char first;	/* first parameter if TRUE		*/
{
    char passWord[NAMESIZE];

    mPrintf("ogin ");
/*    if (!moreYet)   mPrintf("\n ");
*/    if (loggedIn)   {
	mPrintf("U R");
	return;
    }
    if (!moreYet) echo = NEITHER;
     else echo = BOTH;
    getString(moreYet ? "" : " password", passWord, NAMESIZE);
    normalizeString(passWord);
    echo	= BOTH;
    login(passWord);
}

/************************************************************************/
/*	doLogout() handles T(erminate) command				*/
/************************************************************************/
doLogout(expand, first)
char expand;	/* TRUE to accept following parameters	*/
char first;	/* first parameter if TRUE		*/
{
    char iChar(), toUpper();

    if (expand)   first = '\0';

    mPrintf("erminate ");

    if (first)	 oChar(first);

    switch (toUpper(	first ? first : iChar()    )) {
    case '?':
  	mPrintf("\n Q or S");
	break;
    case 'Q':
	mPrintf("uit");
	if (!expand)   {
	   if (!getYesNo("OK"))   break;
	}
	terminate( /* hangUp == */ TRUE);
	break;
    case 'S':
	mPrintf("tay");
	terminate( /* hangUp == */ FALSE);
	break;
    }
}

/************************************************************************/
/*	doRead() handles R(ead) command 				*/
/************************************************************************/
doRead(moreYet, first)
char moreYet;	/* TRUE to accept following parameters	*/
char first;	/* first parameter if TRUE		*/
{
    char iChar(), toUpper();
    int  fileDir(), transmitFile();
    char abort, doDir, done, hostFile, whichMess, revOrder, status, WC;
    char fileName[NAMESIZE];


    if (moreYet)   first = '\0';

    if (!loggedIn  &&  !unlogReadOk)
	{mPrintf("\b?");
         return;
	}
    mPrintf("\bread ");

    if (first)	   oChar(first);

    abort	= FALSE;
    doDir	= FALSE;
    done	= FALSE;
    hostFile	= FALSE;
    revOrder	= FALSE;
    status	= FALSE;
    WC		= FALSE;
    whichMess	= NEWoNLY;
    textDownload= TRUE;

    do {
	outFlag = OUTOK;

	switch (toUpper(   first ? first : iChar()   )) {
	case '\n':
	case '\r':
	    moreYet	= FALSE;
	    break;
	case 'F':
	    mPrintf("orward ");
	    revOrder	= FALSE;
	    whichMess	= OLDaNDnEW;
	    done	= TRUE;
	    break;
  	case 'G':
	    mPrintf("lobal new msg ");
	    whichMess	= GLOBALnEW;
	    done	= TRUE;
	    break;	
	case 'N':
	    mPrintf("ew ");
	    whichMess	= NEWoNLY;
	    done	= TRUE;
	    break;
	case 'O':
	    mPrintf("ld ");
	    revOrder	= TRUE;
	    whichMess	= OLDoNLY;
	    done	= TRUE;
	    break;
	case 'R':
	    mPrintf("everse ");
	    revOrder	= TRUE;
	    whichMess	= OLDaNDnEW;
	    done	= TRUE;
	    break;
	case 'S':
	    mPrintf("tatus ");
	    status	= TRUE;
	    done	= TRUE;
	    break;
        case 'U':
	    if (loggedIn) {
    	    mPrintf("sers");
	    abort	= TRUE;
	    userLog();  }
	    break;
	case 'W':
	    mPrintf("\bWC Protocol ");
	    WC		= TRUE;
	    break;
	case 'B':
	    if (roomBuf.rbflags & CPMDIR)   {
		mPrintf("\bWC-Binary");
		WC		= TRUE ;
		done		= TRUE ;
		hostFile	= TRUE ;
		textDownload	= FALSE;
		break;
	    }
	case 'D':
	    if (roomBuf.rbflags & CPMDIR)   {
		mPrintf("ir ");
		doDir	= TRUE;
		done	= TRUE;
		break;
	    }
	case 'T':
	    if (roomBuf.rbflags & CPMDIR)   {
		mPrintf("xtFile");
		done		= TRUE;
		hostFile	= TRUE;
		textDownload	= TRUE;
		break;
	    }
	default:
	    mPrintf(" ?");
	    abort	= TRUE;
	    setUp(FALSE);
	    if (expert)   break;
	case '?':
	    tutorial("readopt.mnu");
	    abort	= TRUE;
	    break;
	}
	first = '\0';
    } while (!done && moreYet && !abort);

    if (abort) return;

    if (status) {
	systat();
	return;
    }
    if (doDir) {
	FDSectCount	= 0;	/* global fileDir() totals sectors in	*/

	getString("afn or <CR>", fileName, NAMESIZE);

	normalizeString(fileName);

	if (strLen(fileName))	wildCard(fileDir, fileName);
	else			wildCard(fileDir, "*.*"   );
	doCR();
	mPrintf("We have %u kb Free on %c%d:",
				freeSpace,
				'A'+ roomBuf.rbdisk,
				roomBuf.rbuser);

	return;
    }

    if (hostFile) {
	getString("afn", fileName, NAMESIZE);
	normalizeString(fileName);
        FDSectCount = 0;
        if(strLen(fileName))  { wildCard(fileDir, fileName); }
	else		      {	wildCard(fileDir, "*.*"   ); }
        if (FDSectCount) { 
	doCR();
	mPrintf("Sending %d sectors",FDSectCount);
	doCR();
        if (WC && (!expert)) tutorial("wcdown.blb");
        if (!getYesNo("Ready to view or checksum read"))  return;
	usingWCprotocol = WC;
	wildCard(transmitFile, fileName);
	usingWCprotocol = FALSE;
	}
	return;
    }

    doCR();

    if(WC) {
    if (!getYesNo("Ready to WC read msgs"))  return;
	download(whichMess, revOrder);
	return;
    }

    if (whichMess != GLOBALnEW)   {
	showMessages(whichMess, revOrder);
    }
    else {
	while (outFlag != OUTSKIP   &&	 gotoRoom(""))	 {
	    givePrompt();
	    showMessages(NEWoNLY, revOrder);
	}
    }
  }
/************************************************************************/
/*	doRegular()							*/
/************************************************************************/
char doRegular(x, c)
char x, c;
{
    char toReturn;

    toReturn = FALSE;

    switch (c) {

    case 'C': doChat(  x, '\0');		    break;
    case 'D': doRead(  x, 'd' );		    break;
    case 'E': doEnter( x, 'm' );		    break;
    case 'G': doGoto(  x, '\0');		    break;
    case 'H': doHelp(  x, '\0');		    break;
    case 'K': doKnown( x, '\0');		    break;
    case 'L': doLogin( x, '\0');		    break;
    case 'N': doRead(  x, 'n' );		    break;
    case 'O': doRead(  x, 'o' );		    break;
    case 'R': doRead(  x, '\0');		    break;
    case 'T': doLogout(x, 'q' );		    break;
    case 'V': doRead(  x, 't' );		    break;
  
    case 0:
        if (newCarrier)   {
	    greeting();
	    newCarrier	= FALSE;
		          }
	if (justLostCarrier) {
	    justLostCarrier = FALSE;
	    if (loggedIn) terminate(FALSE);
			     }
	break;	/* irrelevant value */
    
    case '?':
	if (!loggedIn) {
	  tutorial ("newuser.mnu");
	  break;
			}
	tutorial("mainopt.mnu");
	if (whichIO == CONSOLE)   mPrintf("\n^P too\n ");
	break;

     case 'M':
	mPrintf("\bGoto Mail");
	gotoRoom("Mail");
	break;

  
      case '$':
	mPrintf("\b");
	tutorial ("sell.msg");
	break;

      case 'I':
	if ( loggedIn || !unlogLoginOK )  {
		mPrintf("ntro");
		tutorial ("intro.msg");   }
	break;				

      case 'X':
	if (!(roomBuf.rbflags & CPMDIR)) break;
	mPrintf("modem file");
	if(getYesNo("BBS to U")) {
		mPrintf(" ");doRead(x,'B');break;
	}else{
		if(getYesNo("U to BBS")) {
			mPrintf("E");doEnter(x,'F');break;
		}else	break;
	 }

    case 'A': if (!doAide(x, '?'))  toReturn=TRUE;    break;
    default:
	toReturn=TRUE;
	break;
    }

    return  toReturn;
}

/************************************************************************/
/*	doSysop() handles the sysop-only menu				*/
/*	    return FALSE to fall invisibly into default error msg	*/
/************************************************************************/
char doSysop(c, first)
char c;
char first;	/* first parameter if TRUE		*/
{
    char		who[NAMESIZE];
    struct logBuffer	lBuf;
    int 		logNo, ltabSlot;

    if (!onConsole)   return TRUE;

    while (TRUE)   {

	printf("\n Sys: ");

	switch (toUpper(   first ? first : iChar()    )) {
	case 'A':
	    printf("brt");
	    return FALSE;
	case 'C':
	    printf("hat %sable",
		(noChat = !noChat)
		?
		"dis"
		:
		"en"
	    );
	    break;
	case 'D':
	    debug = !debug;
	    printf("ebug=%d", debug);
	    break;
	case 'E':
            printf("dit rm ");
            renameRoom();
            break;
	case 'H':
	    printf("angUp");
	    interpret(pHangUp);
	    break;
        case 'K':
	    printf("ill usr");
	    if (!getYesNo("OK"))	break;
	    getString("who", who, NAMESIZE);
	    normalizeString(who);
	    logNo   = findPerson(who, &lBuf);
	    if (logNo == ERROR)   {
		printf("No");
		break;
	    }
	    printf(
		"%s gone",
		who
	    );
	    ltabSlot = PWSlot(lBuf.lbpw);
	    lBuf.lbname[0] = '\0';
	    lBuf.lbpw[0  ] = '\0';

	    putLog(&lBuf, logNo);

	    logTab[ltabSlot].ltpwhash	    = 0;
	    logTab[ltabSlot].ltnmhash	    = 0;

	    break;
	case 'M':
	    printf("dm/on ");
	    whichIO = MODEM;
	    setUp(FALSE);
	    printf("Chat %s ", noChat  ?  "off"  :  "on");
	    if (debug)	     printf("Bug on "  );
	    if (visibleMode) printf("Vis on ");
	    return FALSE;
	case 'P':
	    printf("rivs 2");
	    getString("who", who, NAMESIZE);
	    normalizeString(who);
	    logNo   = findPerson(who, &lBuf);
	    if (logNo == ERROR)   {
		printf("No");
		break;
	    }

	    lBuf.lbflags ^= AIDE;
	    printf(
		"%s %s aide",
		who,
		(lBuf.lbflags & AIDE)  ?  "is"  :  "not"
	    );
	    if (!getYesNo("OK"))	break;

	    putLog(&lBuf, logNo);

	    /* see if it is us: */
	    if (loggedIn  &&  strCmpU(logBuf.lbname, who)==SAMESTRING)	 {
		aide = lBuf.lbflags & AIDE;
	    }
	    break;
/*	case 'R':
	    printf("\bpatch");
	    patchDebug();
	    break;
*/	case 'S':
	    printf("et");
	    interpret(pInitDate);
	    break;
  	case 'V':
	    printf("is==%d",  visibleMode = !visibleMode);
	    break;
	case 'X':
	    printf("\bcpm");
	    if(!getYesNo("OK"))break;
            exitToCpm = TRUE;
	    return FALSE;
	case '?':
	    tutorial("ctdlopt.mnu");
	    break;
/*	case 'O':			/*printer toggle*/
		printf("n ^P\n ");
		print();
		break;
	case 'Q':
		printf("uit ^P\n ");
		noprint();
		break;
*/
	}
    }
}

/************************************************************************/
/*	getCommand() prints menu prompt and gets command char		*/
/*	Returns: char via parameter and expand flag as value  --	*/
/*		 i.e., TRUE if parameters follow else FALSE.		*/
/************************************************************************/
char getCommand(c)
char *c;
{
    char BBSCharReady(), iChar(), toUpper();
    char expand;

    outFlag = OUTOK;

  /*if (*c)*/ givePrompt();
    while (BBSCharReady())   iChar();	      /* eat type-ahead       */

    *c = toUpper(iChar());

    expand  = (
	*c == ' '
	||
	*c == '.'
    );
    if (expand) *c = toUpper(iChar());

    if (justLostCarrier) {
	justLostCarrier = FALSE;
	if (loggedIn) terminate(FALSE);
			    }
    return expand;
}

/************************************************************************/
/*	greeting() gives system-entry blurb etc 			*/
/************************************************************************/
greeting() {
    if (loggedIn) terminate(FALSE);

    setUp(TRUE);     pause(10);
  doCR();  
  mPrintf("        Welcome to the\n %S Citadel 2.29\n ", nodeTitle );
	tutorial ("prebul.msg");
/*  printDate(
	interpret(pGetYear ),
	interpret(pGetMonth),
	interpret(pGetDay  )
    );
*/
   gotoRoom("Lobby");
}

/************************************************************************/
/*	main() contains the central menu code				*/
/************************************************************************/
main() {
    char c, x;
    char getCommand(), init();
    
    if (FALSE) putChar();	/* pick up our own in modem.c	*/
    if (FALSE)	 getNumber();	/* dummy to force load */

    /* don't put any code above init()... readSysTab() will defeat it.	*/
    init();
    initCitadel();
    weAre	= CITADEL;
    greeting();

    while (!exitToCpm) {
	x	= getCommand(&c);

	outFlag = OUTOK;

	if ((c==CNTRLp)  ?  doSysop(0, '\0')  :  doRegular(x, c))  {
	                    mPrintf("  '?' for menu \n "   );
	}
    }
    if (loggedIn) terminate( /* hangUp == */ FALSE);
    writeSysTab(); 
}


