/************************************************************************/
/*  bds1.46  2.29   	17mar87         modem.c	 			*/
/*		modem code for Citadel bulletin board system		*/
/*	NB: this code is rather machine-dependent:  it will typically	*/
/*	need some twiddling for each new installation.			*/
/*			      82Nov05 CrT				*/
/************************************************************************/

/************************************************************************/
/*				history 				*/
/*									*/
/* 86Jan30 BP   keep track of callers with logMsg()			*/
/* 86Apr23 BP,KK,MM networks, print with carr, inVis(), etc		*/
/* 83Mar01 CrT	FastIn() ignores LFs etc -- CRLF folks won't be trapped.*/
/* 83Feb25 CrT	Possible fix for backspace-in-message-entry problem.	*/
/* 83Feb18 CrT	fastIn() upload mode cutting in on people.  Fixed.	*/
/* 82Dec16 dvm	modemInit revised for FDC-1, with kludge for use with	*/
/*		Big Board development system				*/
/* 82Dec06 CrT	2.00 release.						*/
/* 82Nov15 CrT	readfile() & sendfile() borrowed from TelEdit.c 	*/
/* 82Nov05 CrT	Individual history file established			*/
/************************************************************************/

#include "229ctdl.h"

/************************************************************************/
/*				Contents				*/
/*									*/
/*	BBSCharReady()		returns true if user input is ready	*/
/*  #	fastIn()		kludge code compiling other stuff inline*/
/*	getCh() 		bottom-level console-input filter	*/
/*  #	getMod()		bottom-level modem-input   filter	*/
/*	interpret()		interprets a configuration routine	*/
/*	KBReady()		returns TRUE if a console char is ready */
/*	getCh() 		returns a console char			*/
/*	iChar() 		top-level user-input function		*/
/*      inVis()			kk's filter for nets			*/
/*	logMsg()		to keep track of callers		*/
/*	modIn() 		returns a user char			*/
/*	mOReady()		returns true if modem can accept a char */
/*	oChar() 		top-level user-output function		*/
/*  #	outMod()		bottom-level modem output		*/
/*	pause() 		pauses for N/100 seconds		*/
/*	putChar()							*/
/*	recieve()		read modem char or time out		*/
/*	readFile()		accept a file using WC protocol 	*/
/*	sendWCChar()		send file with WC-protocol handshaking	*/
/*									*/
/*	# == routines you should certainly check when porting system	*/
/************************************************************************/

/************************************************************************/
/*		The principal dependencies:				*/
/*									*/
/*  iChar   modIn				    outMod		*/
/*	    modIn   getMod  getCh   mIReady kBReady outMod  carrDetect	*/
/*		    getMod						*/
/*			    getCh					*/
/*				    mIReady				*/
/*					    kBReady			*/
/*							    carrDetect	*/
/*									*/
/*  oChar					    outMod		*/
/*						    outMod  mOReady	*/
/************************************************************************/


/************************************************************************/
/*	BBSCharReady() returns TRUE if char is available from user	*/
/*	NB: user may be on modem, or may be sysop in CONSOLE mode	*/
/************************************************************************/
char BBSCharReady()
{
    char KBReady();

    return ( (haveCarrier  &&  interpret(pMIReady) )
            || (whichIO==CONSOLE  &&   KBReady() )
	    || (KBReady() && getCh() == SPECIAL)
	   );

}

/*   now using fprintf(2,      .bp.
/************************************************************************/
/*  			maher's printer bit  				*/
/*  run ddt, L addr where addr is your bios jump table start, find your */
/*  console out routine and use the address to its left as your poke to */
/*  address (in piedpipers it's E20C)  and CD starts printing like ^P & */
/*  C3 stops printing as another ^P would... other computers may need   */
/*  other values poked.							*/
/*  if you don't use this visibleMode triggered print comment it out    */
/*  here and where it's called in ctdl & log				*/
/************************************************************************/

print() {
	if (visibleMode) {
		poke (0xE20C,0xCD);
			}
	}
noprint() {
	poke (0xE20C,0xC3);
	}
*/

/************************************************************************/
/*	fastIn() is  a special kludge to read in text from the modem	*/
/*	as quickly as possible, to allow message upload without 	*/
/*	handshaking.  Hence we hand-compile some other routines inline	*/
/*	Called only from getText(), when whichIO==MODEM.		*/
/*	Externals:    see below 					*/
/*									*/
/*	This code is probably overkill for 300 baud, but it may handle	*/
/*	1200 baud as well.						*/
/*									*/
/*	code being speed-optimized would normally be:			*/
/*									*/
/*	while ( 							*/
/*	    !(	(c=iChar()) == NEWLINE	 &&   buf[i-1] == NEWLINE )	*/
/*	    &&	i < lim 						*/
/*	    &&	(haveCarrier || whichIO == CONSOLE)			*/
/*	) {								*/
/*	    if (c != BACKSPACE)  buf[i++] = c;				*/
/*	    else {							*/
/*		/  handle deletes:	 /				*/
/*		oChar(' ');						*/
/*		oChar(BACKSPACE);					*/
/*		if (i>0  &&  buf[i-1] != NEWLINE)  i--; 		*/
/*		else				   oChar(BELL); 	*/
/*	    }								*/
/*	}								*/
/************************************************************************/
#define cursor		fpc1		/* external char *		*/
#define BUFEND		fpc2		/* external char *		*/
#define tryCount	fi1		/* external int 		*/
#define isFast		fi2		/* external int 		*/
#define ch		fc1		/* external char		*/
#define lastWasNL	fc2		/* external char		*/
#define slow		fc3		/* external char		*/
fastIn(continuing)
char continuing;	/* TRUE if we are continuing a message	*/
{
    char cache, notFinished;
    int  tryStart, shortTime;
    unsigned  slp, cnt;
    slp = (100 * megaHz);
    cnt = slp;
    isFast	= 0;

    tryStart	= 500*megaHz;
    shortTime	= 480*megaHz;
    cursor	= &msgBuf.mbtext[0	  ];
    BUFEND	= &msgBuf.mbtext[MAXTEXT-1];

    if (continuing)   while (*cursor) ++cursor; /* find where we were	*/

    notFinished = TRUE;
    lastWasNL	= FALSE;

    /* put newline at start of buffer to simplify BACKSPACE check:	*/
    cache		  = msgBuf.mbtext[-1];
    msgBuf.mbtext[-1]	  = NEWLINE;

    while (notFinished	 &&   cursor < BUFEND) {
	tryCount = tryStart;	/* try to be waiting for each char	*/
	while (--tryCount  &&  !interpret(pMIReady));

	if (tryCount>shortTime) isFast++;
	else			isFast--;

	if (!tryCount) {
	    /* no modem char -- take break to check other stuff */
	    if (KBReady()) {
		if (getCh() == SPECIAL) {
		    whichIO	= CONSOLE;
		    notFinished = FALSE;
		    setUp(FALSE);
		}
	    }
	    if ( !--cnt) { /* user asleep ? */
		notFinished = FALSE;
		interpret(pHangUp);
	    }
	    if (!interpret(pCarrDetect)){ /* let modIn() announce it etc */
	 	modIn();
		notFinished	= FALSE;
	    }
	} else {
	    /* time to read modem char: */
	    cnt = slp;  /* credit the sleep switch */
	    switch (ch =  filter[ inp(mData) & 0x7F ]) {
	    case NEWLINE:
		if (lastWasNL)	{
		    notFinished = FALSE;
		} else {
		    lastWasNL	= TRUE;

		    *cursor++	= ch;

		    if (isFast>0  ||  !termLF)	 ch = '\r';
		    else {
			oChar('\r');
	/*		while (!interpret(pMOReady));	/* for outp()	*/
	*/	    }
		}
		isFast	= 0;	/* figure speed of each line independently */
		break;
	    case BACKSPACE:
		/* people don't upload backspaces -- one hopes! --	*/
		/* so we don't worry about speed so much here:		*/
		if (*--cursor == NEWLINE) {
		    /* trying to erase to previous line -- disallow	*/
		    /* because we have no upline:			*/
		    ch = BELL;
		    cursor++;
		} else {
		    oChar(BACKSPACE);
		    oChar(' ');     /* erase last char			*/
		}
		while (!interpret(pMOReady));		/* for outp()	*/
		break;
	    case '\0':
		/* ignore unwanted chars completely: */
		break;
	    default:
		lastWasNL	= FALSE;
		*cursor++	= ch;
		break;
	    }
	    /* echo to console--expendable but nice: */
	if (visibleMode || thisRoom!=1 || whichIO==CONSOLE)
	    putCh(ch);
	    while (!interpret(pMOReady));	    /* for outp()   */
          outp(mData, ch);	/* (was:)assume port is ready by now	*/
	}
    }
    *cursor		= '\0'; 	/* tie off message		*/

    if (cursor == BUFEND) {
		while (haveCarrier && (modIn() != SPECIAL)) {
                  outFlag = OUTOK;
		  mPrintf("\7\n FULL, ^F TO CONT");
		 }
     }

    msgBuf.mbtext[-1]	= cache;	/* return borrowed space	*/
}

/*
/************************************************************************/
/*	getCall()							*/
/************************************************************************/
getCall() {

	while (TRUE)  {
		if (KBReady()) {
        	    if (getCh() == SPECIAL) {
			    printf("\n >CON<\n ");
			    whichIO = CONSOLE;
			    setUp(FALSE);
			    return(0);
		    }
	 	}

		if (interpret(pMIReady)) {
			if (getMod() == '2') {
				mPrintf("\n ATH1\n ");
				call(0xC800,0,0);    /* num baud patch */
				return(0);
			}
	    	}
	}
}
*/

/************************************************************************/
/*	getCh() reads a console char					*/
/*	    In CONSOLE mode, CRs are changed to newlines		*/
/*	    Rubouts are changed to backspaces				*/
/*	Returns:	resulting char					*/
/************************************************************************/
char getCh()
{
    char c;
    char bios();

    return bios(3);
}

/************************************************************************/
/*	getMod() is bottom-level modem-input routine			*/
/*	  kills any parity bit						*/
/*	  rubout			-> backspace			*/
/*	  CR				-> newline			*/
/*	  other nonprinting chars	-> blank			*/
/*	Returns: result 						*/
/************************************************************************/
char getMod() {
	char inp();

	return inp(mData) & 0x7F;
}

/************************************************************************/
/*	iChar() is the top-level user-input function -- this is the	*/
/*	function the rest of Citadel uses to obtain user input		*/
/************************************************************************/
char iChar() {
    char modIn();
    char c;

    if (justLostCarrier)   return 0;	/* ugly patch	*/

    c = filter[modIn()];

    switch (echo) {
    case BOTH:
	if (haveCarrier) {
	    if (c == '\n')	doCR();
	    else		outMod(c);
	}
	if (visibleMode || thisRoom!=1 || whichIO==CONSOLE) /*Maher's*/
	putCh(c);
	break;
    case CALLER:
	if (whichIO == MODEM) {
	    if (c == '\n')	doCR();
	    else		outMod(c);
	} else {
	    putCh(c);
	}
	break;
    }
    return(c);
}

/************************************************************************/
/*	interpret() interprets a configuration routine			*/
/*	Returns byte value computed					*/
/************************************************************************/
char interpret(instr)
union {
    char **pp;
    int  *pi;
    char *pc;
} instr;
{
    char inp();
    char accum; 	/* our sole accumulator */
    char *prompt;
    int  lowLim, topLim;

    while (TRUE) {
	switch (*instr.pc++) {
	case RET:	return accum;				break;
	case ANDI:	accum	       &= *instr.pc++;		break;
	case INP:	accum		= inp(*instr.pc++);	break;
	case XORI:	accum	       ^= *instr.pc++;		break;

	case LOAD:	accum		= *(*instr.pp++);	break;
	case LOADI:	accum		= *instr.pc++;		break;
	case LOADX:	accum		= scratch[*instr.pc++]; break;
	case ORI:	accum	       |= *instr.pc++;		break;
	case OUTP:	outp(*instr.pc++, accum);		break;
	case PAUSEI:	pause(*instr.pc++);			break;
	case STORE:	*(*instr.pp++)	= accum;		break;
	case STOREX:	scratch[*instr.pc++]	= accum;	break;
	case OPRNUMBER:
	    prompt	= instr.pc;
	    while(*instr.pc++); 	/* step over prompt	*/
	    lowLim	= *instr.pc++;
	    topLim	= *instr.pc++;
	    accum	= getNumber(prompt, lowLim, topLim);
	    break;
	case OUTSTRING:
	    while(*instr.pc) {
		pause(5);	/* SmartModem can't handle 300 baud	*/
		outMod(*instr.pc++);	/* output string */
	    }
	    instr.pc++; 				/* skip null	 */
	    break;
	default:
	    printf("Bad%d", *(instr.pc-1));
	    break;
	}
    }
}

/************************************************************************/
/*   THIS IS A NEW FUNCTION						*/
/*   inVis() converts given char to nul if nonprinting			*/
/*   borrowed rudely from visible()	from Kerry Kyes			*/
/************************************************************************/
char inVis(c)
char c;
{
    c = c & 0x7F;   
    if(c<' ' && !(c==0x0D||c==0x0A||c==0x09||c==0x08)) c = '\0';
    if (c == 0x7F) c ='\10';   
    return(c);
}

/************************************************************************/
/*	KBReady() returns TRUE if a console char is ready		*/
/************************************************************************/
char KBReady()
{
    char bios();

    return bios(2);
}

/************************************************************************/
/*	logMsg() saves callers in Logroom>				*/
/************************************************************************/
logMsg()
{
    int ourRoom;

    /* message is already set up in msgBuf.mbtext */
    putRoom(ourRoom=thisRoom, &roomBuf);
    getRoom(LOGROOM, &roomBuf);

    strCpy(msgBuf.mbauth, "Cit");
    msgBuf.mbto[0] = '\0';
    if (putMessage( /* uploading== */ FALSE))	noteMessage(0, ERROR);


    putRoom(LOGROOM, &roomBuf);
    noteRoom();
    getRoom(ourRoom, &roomBuf);
}

/************************************************************************/
/* modIn() toplevel modem-input function				*/
/*   If DCD status has changed since the last access, reports		*/
/*   carrier present or absent and sets flags as appropriate.		*/
/*   In case of a carrier loss, waits 20 ticks and rechecks		*/
/*   carrier to make sure it was not a temporary glitch.		*/
/*   If carrier is newly received, returns newCarrier = TRUE;  if	*/
/*   carrier lost returns 0.  If carrier is present and state		*/
/*   has not changed, gets a character if present and			*/
/*   returns it.  If a character is typed at the console,		*/
/*   checks to see if it is keyboard interrupt character.  If		*/
/*   so, prints short-form console menu and awaits next 		*/
/*   keyboard character.						*/
/* Globals modified:	carrierDetect	modStat 	haveCarrier	*/
/*			justLostCarrier whichIO 	exitToCpm	*/
/*			visibleMode					*/
/* Returns:	modem or console input character,			*/
/*		or above special values 				*/
/*	1984 Kerry Kyes & Ed Clark add baud detect patch		*/
/************************************************************************/
char modIn() {
    char	getMod(), getCh(), interpret(), KBReady();
    char	c;
    unsigned	hi, lo;

    hi	= (HITIMEOUT * megaHz);
    lo	= 0xFF;
    while (TRUE) {
	if ((whichIO==MODEM) && (c=interpret(pCarrDetect)) != modStat) {
	    /* carrier changed	 */
	    if (c)  {	   /* carrier present	*/
		call(0xC800,0,0);    /* baud detect patch */
	  	printf("CD\n ");
		haveCarrier = TRUE;
                modStat     = c;
                newCarrier  = TRUE;
                return(0);
	    } else {
		pause(200);		    /* confirm it's not a glitch */
		if (!interpret(pCarrDetect)) {	  /* check again */
		    printf("No CD\n ");
		    haveCarrier     = FALSE;
		    modStat	    = FALSE;
		    justLostCarrier = TRUE;
		    interpret(pHangUp);
		    while(interpret(pMIReady)) {
			getMod();   /* eat garbage */
		    }
/*		    getCall();
*/		    return(0);
		}
	      }
	}
	if (interpret(pMIReady)) {
	    if (haveCarrier) {
		c = getMod();
		if (whichIO == MODEM)	return(c);
	    }
	}

	if (KBReady()) {
	    c = getCh();
	    if (whichIO == CONSOLE) return(c);
	    else {
		if (c == SPECIAL) {
/*		    mprintf("\n hi\n ");
*/		    whichIO = CONSOLE;
		    setUp(FALSE);
		    return(0);
		}
	    }
	}

	/* check for no input.	(Short-circuit evaluation, remember!) */
	if (whichIO==MODEM  &&	haveCarrier  &&  !--lo	&&  !--hi) {
	    interpret(pHangUp);
	}
    }
}

/************************************************************************/
/*	oChar() is the top-level user-output function			*/
/*	  sends to modem port and console both				*/
/*	  does conversion to upper-case etc as necessary		*/
/*	  in "debug" mode, converts control chars to uppercase letters	*/
/*	Globals modified:	prevChar				*/
/************************************************************************/
oChar(c)
char c;
{
    prevChar = c;			/* for end-of-paragraph code	*/
    if (outFlag) return;		/* s(kip) mode			*/

    if (termUpper)	c = toupper(c);
    if (debug)		c = visible(c);
    if (c == NEWLINE)	c = ' ';	/* doCR() handles real newlines */

    /* show on console		    */
    if (visibleMode || whichIO==CONSOLE || (thisRoom!=1 && echo!=CALLER))
    putCh(c);

    if (haveCarrier)  {
	if (!usingWCprotocol) {
	    outMod(c);			/* show on modem		*/
	} else {
	    sendWCChar(c);
	}
    } /*else {
	if (usingWCprotocol) {  /* why if no carrier?  the wake up bit? */
	    sendWCChar(c);
	}
    } */
}


/************************************************************************/
/*	outMod stuffs a char out the modem port 			*/
/************************************************************************/
outMod(c)
char c;
{
     /* printf("\n%x-%c",c,c); */
	while(!interpret(pMOReady));
	outp(mData, c);
}

/************************************************************************/
/*	pause() busy-waits N/100 seconds				*/
/************************************************************************/
pause(i)
int i;
{
    int j;

#define SECONDSFACTOR 55
    for (;  i;	i--) {
	for (j=(SECONDSFACTOR*megaHz);	j;  j--);
    }
}

/************************************************************************/
/*	upause() busy-waits N/1000 seconds				*/
/************************************************************************/
upause(i)
int i;
{
    int j;

#define USECONDSFACTOR 6
    for (;  i;	i--) {
	for (j=(USECONDSFACTOR*megaHz);	j;  j--);
    }
}

/************************************************************************/
/*	putChar()							*/
/************************************************************************/
putChar(c)
char c;
{
  if (whichIO==CONSOLE || thisRoom!=1 || visibleMode)
    putCh(c);
}

/************************************************************************/
/*	receive() gets a modem character, or times out ...		*/
/*	Returns:	char on success else ERROR			*/
/************************************************************************/
int receive(seconds)	/* sec must be less than 65 */
int  seconds;
{
    unsigned  count;
    count = seconds * 1000;
    while (!interpret(pMIReady)  &&  --count)  upause(1);
    if (count)	return inp(mData);

    return(ERROR);
}

/************************************************************************/
/*	readFile() accepts a file from modem using Ward Christensen's	*/
/*	protocol.  (ie, compatable with xModem, modem7, yam, modem2...) */
/*	Returns:	TRUE on successful transfer, else FALSE 	*/
/*      28feb87 .bp. added the freeSpace check				*/
/************************************************************************/
char readFile(pc)
int  (*pc)();	/* pc will accept the file one character at a time.	*/
		/* returns ERROR on any problem, and closes the file	*/
		/* when handed ERROR as an argument.			*/
{
    int  i, firstchar, lastSector, thisSector, thisComplement, tries;
    int  toterr, checksum;
    char badSector, writeError, seCount;
    char sectBuf[SECTSIZE];
    char *nextChar;

    if (!getYesNo("CHECKSUM upload, ok"))   return FALSE;
	
    lastSector	= 0;
    tries	= 0;
    toterr	= 0;
    writeError	= FALSE;
    seCount     = 0;

    while (interpret(pMIReady))   inp(mData);	/* clear garbage	*/

    printf("? #0 (Try=0, Errs=0)  \r");

    do {
	badSector = FALSE;

	/* get synchronized: */
	do {
	    firstchar = receive(4);
	} while (
	    firstchar != SOH &&
	    firstchar != EOT &&
	    firstchar != ERROR
	);

	if (firstchar == SOH)  {
	    /* found StartOfHeader -- read sector# in: */
	    thisSector		= receive (1);
	    thisComplement	= receive (1);	/* 1's comp of thisSector */

	    if ((thisSector + thisComplement) != 0xFF)	badSector = TRUE;
	    else {
		if ((thisSect == lastSector +1) || (thisSect==0)) {
		    /* right sector... let's read it in */
		    checksum	= 0;
		    nextChar	= sectBuf;
		    for (i=SECTSIZE;  i;  i--) {

			*nextChar	= receive (1);
			checksum	= (checksum + *nextChar++) & 0xFF;
		    }

		    if (checksum != receive (1))  badSector = TRUE;
		    else {
			tries		= 0;
			lastSector	= thisSector;

			printf("? #%d (Try=0, Errs=%d)  \r",
			    thisSector, toterr
			);

			if (tries && toterr) putchar('\n');

			/* write sector to where-ever: */
			nextChar = sectBuf;
			for (i=SECTSIZE;  i;  i--) {
        		     writeError &= (*pc)(*nextChar++) == ERROR ;
			}
			if (!writeError) outMod(ACK); /* else break; */
			if(!textDownload){
				if (++seCount > 7) {
						seCount = 0;
						if (! --freeSpace) {
						   writeError = TRUE;
						   break;
						}
				}
			}
		    }			
		} else	{
		    /* not expected sector... */
		    if (thisSector != lastSector)  badSector = TRUE;
		    else {
			/* aha -- sender missed an ACK and resent last: */
			do;  while (receive(1) != ERROR);   /* eat it */
			outMod(ACK);	/* back in synch! */
		    }
		}
	    }	/* end of "if (thisSector + thisComplement == 255"	*/
	}	/* end of "if (firstChar == SOH)"			*/


	if (firstchar == ERROR)   badSector = TRUE;

	if (badSector)	{
	    tries++;
	    if (lastSector != 0)  toterr++;

	    while (receive (1) != ERROR);
	    printf("? #%d (Try=%d, Errs=%d)  \r",
		lastSector, tries, toterr);
	    if (tries && toterr) putchar('\n');
	    outMod(NAK);
	}
    } while (
	firstchar != EOT       &&
	tries	  <  ERRORMAX  &&
	!writeError
    );

    if (  firstchar != EOT
		||
          tries >= ERRORMAX
		||
	  writeError) {
	return FALSE;
    } else {
	outMod(ACK);
	printf("\nDone\n");
	return TRUE;
    }
}

/************************************************************************/
/*	sendWCChar() sends a file using Ward Christensen's protocol.	*/
/*	(i.e., compatable with xModem, modem7, modem2, YAM, ... )	*/
/*									*/
/* C is an old, tired language which does not support coroutines	*/
/* adequately.	SendWCChar() has suffered as a result.	SendWCChar()	*/
/* and the disk-read routines pass control back and forth during	*/
/* transmission.  Being smaller, sendWCChar() is the one which gets to	*/
/* stash all its variables as globals and play at subroutine.  The	*/
/* ugliest part is finding our place again each time we are called.	*/
/* SFRunning is TRUE normally and FALSE while we're finding our place.	*/
/* The usual indentation rules are deliberately suppressed in the case	*/
/* of SFRunning, to leave the "real" program structure as untouched as	*/
/* possible.  Ignore the righthand SFRunning stuff and it will look ok. */
/*   Returns: FALSE for another char, TRUE on success, ERROR on abort	*/
/************************************************************************/
int sendWCChar(c)
int c;	       /* character to output to MODEM, or ERROR on EOF */
{
/*  Declared globally:						*/
/*  char SFcheckSum, SFeofSeen, SFRunning;			*/
/*  int  SFi, SFthisChar, SFthisSector, SFerrorCount, SFtries;	*/
						if (outFlag) return ERROR;
						if (SFRunning) {
    while (interpret(pMIReady))  inp(mData);	/* clear garbage off line */
    SFtries	= 0;
    SFerrorCount= 0;

    printf("\r> #0 (Try=0 Errs=0)\r");

    while ((receive (4) != NAK)  &&  (SFtries < RETRYMAX)) {
	SFtries++;
	printf("\r> #0 (Try=%d Errs=0)\r", SFtries);
    }

    if (SFtries  >= RETRYMAX)  {
	outFlag = OUTSKIP;
	return ERROR;
    }

    SFtries	= 0;
    SFthisSector= 1;
    SFthisChar	= c;
    SFeofSeen	= (c == ERROR);

    /* send the file: */			} /* SFRunning block */
    while (!SFeofSeen) {
						if (SFRunning) {
	SFtries = 0;
						} /* SFRunning block */
	/* send sector and  look for ACK: */
	do {
						if (SFRunning) {
	    printf("\r> #%d (Try=%d Errs=%d)\r",
		    SFthisSector, SFtries, SFerrorCount
	    );
	    if (SFtries && SFerrorCount) putchar('\n');

	    /* send one sector: */

	    /* maybe read next sector into SFBuf: */
	    SFi =SECTSIZE;			} /* SFRunning block	*/
	    if (!SFtries) {
		for (;	SFRunning ? SFi-- : TRUE;  ) {
						    if (SFRunning) {
							SFRunning  = FALSE; /*
		    SFthisChar = nextIn();		*/ return FALSE;
						    }
						    SFthisChar = c;
						    SFRunning = TRUE;

		    if (SFthisChar == ERROR) {
			SFeofSeen   = TRUE;
			SFthisChar  = CPMEOF;
			/* if EOF is first char in block, don't send it: */
			if (SFi == (SECTSIZE-1))   break;
		    }
		    SFBuf[SFi]	    = SFthisChar;
                    if(SFeofSeen && (SFi != (SECTSIZE-1)) && textDownload)
                    /* fill out block */ 
                    {
                       for(;SFi > 0;SFi--)
                            SFBuf[SFi]=SFthisChar;
                    }
		}
	    }

	    if (SFi == (SECTSIZE-1))   {
		/* don't send empty sector just for EOF: */
		break;
	    } else {
		/* mail sector out: */
		outMod(SOH	    );
		outMod( SFthisSector);
		outMod(~SFthisSector);

		for (SFi=SECTSIZE, SFcheckSum=0;  SFi--;  ) {
		    SFcheckSum	    = (SFcheckSum + SFBuf[SFi]) & 0xFF;
		    outMod( SFBuf[SFi] );
		}
		outMod(SFcheckSum);

		while (interpret(pMIReady))  inp(mData);  /* clear off line */

		SFtries++;
		SFerrorCount++;
	    }
	} while ((receive(4) != ACK)  &&  (SFtries < RETRYMAX));
	SFthisSector++;
	SFerrorCount--;

	if (SFtries >= RETRYMAX)   break;
    }

    /* file sent, or not, as the case may be: */
    if (SFtries >= RETRYMAX)  {
	outFlag = OUTSKIP;
	return ERROR;
    } else {
	/* tell recipient we're all finished: */
	SFtries = 0;
	do {
	    outMod(EOT);
	    while (interpret(pMIReady))  inp(mData);	/* clear off line */
	    SFtries++;
	} while ((receive(4) != ACK)  &&  (SFtries < RETRYMAX));

	if (SFtries < RETRYMAX)  {
	    return TRUE;
	} else {
	    printf("No ACK on EOT\n ");
	    outFlag = OUTSKIP;
	    return ERROR;
	}
    }
}

