
; HBBSHDR.INS  v1		500 USERS		      17 Apr 88
;
; By Irv Hoff, based on Russ Pencin's PBBS, based on Simon Ewin's EMX.
;
;-----------------------------------------------------------------------
;
; General equates and macro definitions
; DO NOT change unless you know what you are doing!
;
NO	EQU	0
YES	EQU	NOT NO
;
;
TIMZON:	DEFB	'PDT'		; Change to your area, such as 'EST' and
				;   update as needed for daylight time
				;   such as 'EDT', etc.
;
; MACRO to null-fill the area names, ignored if MULTIPLE is NO
;
GENSTR	 MACRO	X
	LOCAL	A
A:	DEFB	X
	DEFS	(A+11)-$
	 ENDM
;
;-----------------------------------------------------------------------
;
; Constant equates
;
BDOS	EQU	5		; BDOS call location
BEL	EQU	7		; ASCII bell
BS	EQU	8		; Backspace
TAB	EQU	9		; Tab char
LF	EQU	10		; Linefeed
CR	EQU	13		; Carriage return
ESC	EQU	27		; Escape character
;
ASCII	EQU	30H		; ASCII offset
DMA	EQU	80H		; Default DMA buffer
EOF	EQU	1AH		; CP/M end-of-file character
FCB	EQU	5CH		; Default FCB
RET	EQU	0C9H		; Return opcode
TBUFF	EQU	DMA		; Type buffer
;
; BDOS calls
;
RDCON	EQU	1		; Get character from console
WRCON	EQU	2		; Write character on console
LSTOUT	EQU	5		; List output
DIRCON	EQU	6		; Direct console input/output
STRING	EQU	9		; Print string function
CONST	EQU	11		; Get the console status
SELDSK	EQU	14		; Select drive
OPENF	EQU	15		; Open a file
CLOSEF	EQU	16		; Close a file
DELET	EQU	19		; Delete a file
READSEQ	EQU	20		; Read next sequential
MAKE	EQU	22		; Make (create) a new file
RENAME	EQU	23		; Rename a file
CURDRV	EQU	25		; Get current drive
SETDMA	EQU	26		; Set DMA pointer
SETUSR	EQU	32		; Set user area
RRDM	EQU	33		; Read random record
CFSIZE	EQU	35		; Compute file size
WRDM	EQU	40		; Write random record
CHAIN	EQU	47		; Chain to program (for CP/M+)
;
; Extended BDOS calls, special to BYE5
;
MDCARCK	EQU	65		; Get modem carrier status
RCONOT	EQU	68		; Send character to the console
RMXDRV	EQU	69		; Set/get maximum drive
RMXUSR	EQU	70		; Set/get maximum user area
RMTOUT	EQU	71		; Set/get timeout value
RMNULL	EQU	72		; Set/get nulls
RMWRT	EQU	75		; Set/get WRTLOC flag
RMHDR	EQU	76		; Set/get hard copy flag
RMBELL	EQU	78		; Set/get console bell flag
RMRTC	EQU	79		; Call TCHECK, return TON & RTC addresses
RMLCBF	EQU	80		; Return LC buffer address
RMMXT	EQU	81		; Set/get maximum time on system
RMTOS	EQU	83		; Print TOS message to caller/Sysop
LOGST	EQU	86		; Set/get disk log open status
IMDONE	EQU	88		; Hangup phone and return to caller
;
; HBBS file structures - DO NOT CHANGE
;
MSGLEN	EQU	64		; Characters in a record
MSGLIN	EQU	100		; Maximum lines per message
MNDXLEN	EQU	100
NAMLEN	EQU	25		; Maximum name length, includes 0 at end
NDXLEN	EQU	100
SYSLEN	EQU	100
USRLEN	EQU	100
;
;-----------------------------------------------------------------------
;
; Edit this file as you desire, set switches and rework messages to suit
; your system. This should be the only file that you need to edit to
; assemble and link HBBS.
;
;
;	There is an assembly time option available with this
;	system which MUST be set in the following EQUate.
;	This option is:
;
;	1.  TCAP-- If TCAP is YES, and your system supports
;	    an external SYSENV segment you may optionally
;	    make use of ZCPR3's ability to customize the
;	    terminal type via the ZCPR3 TCAP entry.
;
;-----------------------------------------------------------------------
;
; The following addresses and control bytes are tabled at the head of
; the Signon file starting at 103h and may be patched as required.  The
; area currently used is the 8085 interrupt vectors which are unused in
; any known Z-80 system.  If this conflicts with your system configura-
; tion you will need to determine an area in memory that is untouched by
; any program.
;
; NOTE: if you don't want to use one of the following then enter:
;
;		LABEL	EQU	JUNK
;		as the address required...
;
; the label JUNK MUST be a 'DW 2' byte storage space since HBBSUBS uses
; it as a temporary storage area/ work space....
;
;-----------------------------------------------------------------------
;
JUNK:	DEFW	JUNK		; Address for unwanted options below
;
REENTR	EQU	20H		; Signon re-entry flag address
LOGSTR	EQU	21H		; ASCII logon-time string address (8 bytes)
LOCK	EQU	2AH		; Address of lock (access) byte
TRMCD	EQU	2BH		; Terminal identifier code
USREC	EQU	2CH		; User record # storage address (2 bytes)
MXUSR	EQU	3FH		; BYE5's maximum user number address
WHEEL	EQU	3EH		; ZCPR2 wheel byte, if used
MXDRV	EQU	3DH		; BYE5's maximum drive address
MSPEED	EQU	3CH		; BYE5's baudrate indicator address
DSKFLG	EQU	3BH		; Flag for DISK LOG on/off
PATH	EQU	40H		; Path location, for SETPATH and SYSPATH
UPLOADS	EQU	54H		; Count of uploads
DNLOADS	EQU	55H		; Count of downloads
ASCACC	EQU	JUNK		; Access: in ASCII (access level same as
				;   LOCK).  If this location is set to
				;   other than JUNK, HBYE will update
				;   the user's access level with the
				;   ASCII value from this location.
				;   Useful if you use MBASIC utilities
				;   to modify the user's status.  (Twit
				;   Traps).
USRMAP	EQU	JUNK		; User area map (2 bytes)
DRVMAP	EQU	JUNK		; Drive map (2 bytes)
;
;
; Most systems upload new  CP/M files to B0:  Many systems now allocate
; a special drive for new MS-DOS files.  If yours is such a system, set
; MSDOS to YES and then select the drive you use for MS-DOS files.  As
; a new user signs in and he is asked his name, password, phone number,
; etc., he will also be asked if he is primarily CP/M or MS-DOS.  When
; going from HBBS to CP/M it will then automatically place him on the
; drive that has his favored files i.e., CP/M or MS-DOS upload area.
; In conjunction with KMD20 and above, uploads go to separate drives as
; well as having independent "FOR" and "NEW" files.  This will help ease
; the Sysop's job in moving MS-DOS files to the special area as the user
; will normally do that automatically, rather than have everything go to
; B0: etc.
;
CPMDU	EQU	'B'	; Drive for CP/M new file uploads
NCPMDR	EQU	'A'	; Drive to store the CPM 'FOR' and KMD.LOG on
NCPMUS	EQU	14	; Users area to store the CPM 'FOR' and KMD.LOG
;
MSDOS	EQU	YES	; No will not ask "CP/M or MS-DOS" ?
			; Yes asks which of those you prefer
IBMDRV	EQU	'D'	; Drive for MS-DOS new file uploads
NIBMDR	EQU	'A'	; Drive to store the IBM 'FOR' and KMD.LOG on
NIBMUS	EQU	13	; User area to store the IBM 'FOR' and KMD.LOG
;
;-----------------------------------------------------------------------
; Access table byte order is:  Max drive, max user, minutes online, days
; to deletion (0=no autodelete), KMD D/L ratio allowed
;
; NOTE: Drive A=1, B=2, C=3, etc.  User areas are normal 0-15.
;
ACC2:	DEFB	2,1,30,10,10	; Drive, user, time on system,
ACC3:	DEFB	5,9,45,60,20	;    days to delete, KMD ratio
ACC4:	DEFB	6,9,60,75,20	; New user (almost normal)
ACC5:	DEFB	6,10,60,90,30	; Normal user
ACC6:	DEFB	6,11,60,180,30	; Club members
ACC7:	DEFB	6,12,90,240,40	; Special Users, unlimited time
ACC8:	DEFB	6,15,0,0,0	; Co-SYSOP, unlimited time
ACC9:	DEFB	6,15,0,0,0	; SYSOP, unlimited time
;
;
; Following are not used directly by HBBS, for other programs
;
USMP2:	DEFW	0000000011111111B ; Initial user area map
DRMP2:	DEFW	0000000011111111B ; Initial drive map
USMP3:	DEFW	0000000011111111B ; Level 3 user area map
DRMP3:	DEFW	0000000011111111B ; Level 3 drive map
;
;-----------------------------------------------------------------------
; General control bytes used as option switches and variable values.
; Any new features added should be switched so that others may or may
; not use the feature as they desire.  Commonly use: 1=yes, 0=no
;-----------------------------------------------------------------------
;
VERSION	EQU	YES		; 1=show version numbers, 0=no
;
;-----------------------------------------------------------------------
;
; These equates allow the Sysop to display a text file or run a .COM
; file if his system is a PRIVATE system.  Set either PRVTXT or PRVCOM
; to 1, but not both.  The PLOGUSR determines whether the user is added
; to the USERS file or not.
;
PRVATE	EQU	NO		; Yes..this is the master switch to
				;   allow the following private actions
				;   to function
PLOGUSR	EQU	NO		; Yes, add user information to User file
				;   before displaying PRIVATE system
				;   information.
PRVTXT	EQU	NO		; Yes, displays text file at PRVTFL then
				;   logs new user off via BYE.	User is
				;   not added to user file if PLOGUSR is
				;   No.
PRVCOM	EQU	NO		; Yes, runs a ".COM" file at PRVTCM then
				;   logs user off via BYE.  User is not
				;   added to user file if PLOGUSR is No.
;
;-----------------------------------------------------------------------
;
TOT	EQU	YES		; Yes, to activate total time per day.
WELON	EQU	YES		; Yes, WELCOME.BBS to be displayed at
				;   logon.
WELCUM	EQU	YES		; Yes, WELCOM#.BBS file for each access
				;   level.  HBBS will insert the user
				;   level instead of the E in WELCOME.BBS
				;   for users between 2 and 7.	Thus, an
				;   user level 2 will see WELCOM2.BBS,
				;   3 sees WELCOM3.BBS, etc.  These are
				;   are standard text files ending with
				;   CR,LF.
;
;-----------------------------------------------------------------------
;
DOBUMP	EQU	YES		; Yes, auto bump users access level 2
				;   through BUMPHI.
BUMPHI	EQU	4		; Highest level you want users to be
				;   bumped automatically.
;
;-----------------------------------------------------------------------
;
SPON	EQU	YES		; Yes run special (7+) user file on
				;   CP/M entry
ALTON	EQU	NO		; Yes, use alternate file when entering
				;   CP/M a second time
SETPATH	EQU	YES		; Sets different path for Sysop upon
				;   exit to CPM
;
;-----------------------------------------------------------------------
; This area is the selection for the type of CCP you are using.
; Select only one, and if it is followed by an equate you will need
; to set the value for the equate as well.
;
EXTCL	EQU	0		; 1=yes, using ZCPRx external command
				; Line
MCLBUF	EQU	0FBF0H		; Address of external command buffer for
				;   your ZCPR use for any version of
				;   ZCPR with external command buffer
ZCMD	EQU	1		; 1=yes, using ZCMD or ZCPR with an
				;   internal buffer starting at CCP+8.
SETCCP	EQU	0		; 1=yes, using a CCP which cannot be
				;   found or calculated from the BIOS
				;   entry.
CCPLOC	EQU	0C800H		; Determine the location of CCP from
				; SYSTEM.COM or CCPLOC.COM if SETCCP = 1
CPLUS	EQU	0		; 1=yes if you are running CPM+, this
				;   allows entry of CP/M files to work
				;   with your CCP.
				;
; NOTE: if both EXTCL,ZCMD,and SETCCP are 0, HBBS assumes that you are
; using Standard release version of CP/M, and envokes exit files via
; AutoExecute Buffer at CCP+7
;
;		   END of CCP selection area
;-----------------------------------------------------------------------
;
; Values used by HBBS for counting and access-protected routines
;
ALLLV	EQU	4		; Minimum access for leaving public msgs
CMMNT	EQU	NO		; Yes asks user for comments at signoff
DAYS	EQU	30		; Days to delete messages that were read
ERASE	EQU	NO		; Allows user to erase all his messages
HDRSTP	EQU	NO		; Yes stops after message headers
LINNOS	EQU	YES		; Yes shows line numbers when writing msgs
MAXU	EQU	500		; Set to the maximum number of users
				;   allowed - be generous, 500 is a good
				;   number. (52k file) Min=50, max = 999
PRIVATE	EQU	NO		; Yes allows private messages between
				;   users
PRVSYS	EQU	NO		; Yes allows private to the Sysop
RSTKON	EQU	NO		; Yes, restrict new users from entering
				;   CP/M
RSTKLV	EQU	2		; Minimum level to enter CP/M if restricted
SAVBAK	EQU	NO		; Save .BAK files?  (Not needed with HSAVE)
SKPMSG	EQU	30		; Skips message maintenance if not at
;				;   least this minimum number to delete
TRIES	EQU	3		; Number of tries to sign on
;
;-----------------------------------------------------------------------
;
; In order to provide the capability for HBBS to handle multiple message
; bases (up to 9), you MUST assign a number to NMAREAS.  If you want the
; standard HBBS (single message base) NMAREAS MUST be set to 1, if on
; the other hand, you want to implement multiple message bases, set
; NMAREAS for any value from 2 thru 9.
;
NMAREAS	EQU	7		; Number of areas active with a maxi-
;				; imum of 9 areas.  YOU MUST UPDATE
;				; AREA NAMES BELOW, AT LABEL ANAMES,
;				; AND SET THE VALUES IN MAILTBL BELOW
;
	 IF	(NMAREAS GT 9)
ERMSG	EQU	ERRORX		; NMAREAS TOO LARGE, RE-CHECK YOUR CODE
	 ENDIF			; (NMAREAS GT 9)
;
	 IF	(NMAREAS LT 1)
ERMSG	EQU	ERRORX		; NMAREAS TOO SMALL, RE-CHECK YOUR CODE
	 ENDIF			; (NMAREAS LT 1)
;
;-----------------------------------------------------------------------
;
; If you have implemented the MULTIPLE area option, then you MUST pro-
; vide the external names of your MESSAGE areas below.	Each name MUST
; be 10 bytes in length OR LESS.  The GENSTR MACRO will pad each name
; with the proper nulls.  The code at ANAMCHK will generate an assembly
; error message if the areas are not the correct length.
;
	 IF	(NMAREAS GT 1)
ANAMES:	DEFB	'0. (all areas)',0 ; Area 0 name
;
;	NOTE!!! DO NOT CHANGE THE ABOVE LINE OF CODE...
;
;	NOTE:  The GENSTR MACRO will create the required string for this
;	       table.  If you change the names, the string after the
;	       GENSTR MACRO command mult be at least 1 character long,
;	       and less than 11 characters in LENGTH.
;
ANAME1:	GENSTR	'Computers'	; Area 1 name
ANAME2:	GENSTR	'Chit-chat'	; Area 2 name
ANAME3:	GENSTR	'CP/M'		; Area 3 name
ANAME4:	GENSTR	'MS-DOS'	; Area 4 name
ANAME5:	GENSTR	'Club'		; Area 5 name
ANAME6:	GENSTR	'Special'	; Area 6 name
ANAME7:	GENSTR	'Private'	; Area 7 name
ANAME8:	GENSTR	'unused'	; Area 8 name
ANAME9:	GENSTR	'unused'	; Area 9 name
;
;   NOTE DO NOT CHANGE THE NUMBER OF ENTRIES IN THE FOLLOWING TABLE
;   EVEN IF YOU ARE NOT RUNNING WITH MULTIPLE MAIL AREAS, CHANGE
;   ONLY THE INDIVIDUAL DB VALUES. IF YOU CHANGE THE TABLE LENGTH
;   OR BASIC DEFINITION THE MAIL FUNCTIONS WILL PROBABLY NOT WORK...
;
MAILTBL:DEFB	2	; Lowest user value to mail area-2
	DEFB	6	; Lowest user value to mail area-3
	DEFB	6	; Lowest user value to mail area-4
	DEFB	7	; Lowest user value to mail area-5
	DEFB	8	; Lowest user value to mail area-6
	DEFB	9	; Lowest user value to mail area-7
	DEFB	9	; Lowest user value to mail area-8
	DEFB	9	; Lowest user value to mail area-9
	 ENDIF		; (MAREAS GT 1)
;
;-----------------------------------------------------------------------
; If you are using ZCPR3 with the TCAP option set the TCAP to YES and
; edit equate at SYSENV to match your system.
;
TCAP	EQU	NO		; If ZCPR3 is implemented and you have
				;   implemented a SYSENV and want auto
				;   terminal setting
;
Z3SET	EQU	NO		; if Yes, HBBS will set the max drive,
				;   max user, and wheel Byte in ZCPR3's
				;   environment descriptor.
	 IF	TCAP
SYSENV	EQU	0FE00H		; Set to ZCPR3's Environment buffer
TCPNAM:	DEFB	'Z3TCAP.TCP',0	; Name of your ZCPR3 TCAP file
				; (must end with a null)
TCPDRV	EQU	0		; Drive for the Z3TCAP.TCP file
				; (0=A, 1=B, etc)
TCPUSR	EQU	0		; User area for the Z3TCAP.TCP file
	 ENDIF			; TCAP
;
	 IF	TCAP AND Z3SET
ZUSR	EQU	SYSENV+45
ZDRV	EQU	SYSENV+44
ZWHL	EQU	SYSENV+41
	 ENDIF			; TCAP AND Z3SET
;
;-----------------------------------------------------------------------
;			FILE INFORMATION
; Drive/userarea where your files will be... HBBS logs to this area as
; soon as it runs....but will load the 'BYE' from errdrv/usr in an error
; condition.
;-----------------------------------------------------------------------
;
SYSUSR	EQU	14		; System file user area
SYSDRV	EQU	'A'-41H		; System file drive (a:=0, b:=1, etc.)
ERRUSR:	DEFB	0		; Error file user area for lost carrier
				;   or
ERRDRV:	DEFB	0		; TWIT disconnect, usually BYE5 on A0:
				; System file drive (a:=0, b:=1, etc.)
;
;----------------------------------------------------------------------
; System filenames (each filename must end with a null)
;-----------------------------------------------------------------------
;
	   IF	PRVATE AND PRVTXT
PRVTFIL:  DEFB	'PRIVATE.BBS',0	 ; Private system exit file (text)
	   ENDIF		 ; PRVATE AND PRVTXT
;
LASTCAL:  DEFB	'LASTCALR.   ',0 ; Spaces ok if no file type
CALLRS:	  DEFB	'CALLERS',0	 ; Callers list
COMMENTS: DEFB	'COMMENTS',0	 ; Feedback to sysop
MSGINDEX: DEFB	'MSGINDEX.BBS',0 ; Message index
MESSAGES: DEFB	'MESSAGES.BBS',0 ; Message file
WELCOM:	  DEFB	'WELCOME.BBS',0	 ; Welcome file (text)
BULLETIN: DEFB	'BULLETIN.BBS',0 ; Bulletin file (text)
BBSMENU:  DEFB	'BBSMENU.BBS',0	 ; Mail menu (text)
;
FOR:	  DEFB	'FOR',0		; KMD file descriptions
				; Edit name to match you file name
KMD:	  DEFB	'KMD.LOG',0	; KMD log file for new files
				; Edit name to match your file name
INFO:	  DEFB	'INFO'		; Info/help/news menu (text)
INFOEXT:  DEFB	0,0		; News files A-Z may be used for
				;   storage for selecting news file
INFOERR:  DEFB	'INFOERR.BBS',0	; File not found report (text)
INDEX:	  DEFB	'INDEX.BBS',0	; Main system counters
USERS:	  DEFB	'USERS.BBS',0	; Users file
CPMTXT:	  DEFB	'CP/M.BBS',0	; All users diskmap, etc.
;
;-----------------------------------------------------------------------
; The next value defines the maximum size in bytes of a message.  Since
; each record is defined as being msglen bytes long then the next value
; should be defined as MSGLEN * MSGLIN.... hence a 1k maximum message
; size would be set out as MSGLEN * 16.....  size MUST be a multiple of
; 64.
;-----------------------------------------------------------------------
;
MSGBUF	EQU	MSGLEN * MSGLIN	; 125 records with 64 bytes each = 7.8k
;
;-----------------------------------------------------------------------
; The following are the names of external .COM files that are chained to
; when a jump to CPM is done by any HBBS programs that use PBSSUBS.REL.
; The 'DE' register is loaded with the address of one of these names and
; a chain then takes place... is is very important that each of these be
; structured as the one at ENTRY:  is (10 bytes total each).
;
; This is the name of a .CPM file to run on entry to CP/M when the user
; types "J" command.
;
;	NOTE:	You could as readily use other .COM files such as "MAP",
;		"SYSMAP", "HELP", etc. in place of "DIR".  If you don't
;		want anything for some of these following automatic dis-
;		plays, put a 0 in front of the string, to terminate it
;		immediately, example:
;					DEFB   0,3,'DIR',0
;
;		That way, you can easily replace it at any time.
;
ENTRY:	DEFB	3,'DIR',0	; For CP/M entry
;		^    ^	^
;		|    |	|
;		|    |	|---------------> terminating zero (must be there)
;		|    +------------------> file name 8 characters max.
;		+-----------------------> number of bytes in file name
;					  'COM' extension not needed
;
; This is run only if/when the caller is a new user.
;
NENTRY:	 DEFB	3,'MAP',0	; For CP/M entry if new user
;
;
; This file runs if the user is a 'special' user i.e., ACESS >= 7 if the
; SPON flag is set to 1.
;
	   IF	SPON
SPENTRY: DEFB	3,'DIR',0	; For special users
	   ENDIF		; SPON
;
; Alternate file for exit from HBBS when HBBS is re-entered after sign-
; ing on if the ALTON flag is set.
;
	   IF	ALTON
ALTFILE: DEFB	3,'DIR',0	; For re-entry to CPM
	   ENDIF		; ALTON
;
; This is the ".COM" file that is run if PRVCOM = 1.  This program must
; exit through BYE5 by seting 00h to CD.
;
	   IF	PRVATE AND PRVCOM
PRVTCM:	DEFB	5,'NOACC',0
	   ENDIF		; PRVATE AND PRVCOM
;
; This is the name of file to run in the event of error or to disconnect
; caller.  Be certain to set the proper drv and user area above.
;
ERRFIL:	DEFB	3,'BYE',0	; For error exit
;
;-----------------------------------------------------------------------
;
; System strings and such....
;
SYSOK	EQU	YES		; Yes, Sysop can sign on with SYSOP, No
				;   requires his normal first-last name.
SYSOP:	DEFB	'YOUR NAME'	; Up to NAMLEN-1 bytes for Sysop name
				;   (MUST BE ALL CAPITAL LETTERS)
ENDSYS	EQU	$
	DEFS	NAMLEN-(ENDSYS-SYSOP) ; Auto pad zeroes via M80/M option
;
	  IF	SETPATH
SYSPATH: DEFB	1,0		; 'A' drive, user 0
	 DEFB	10,15		; 'J' drive, user 15
	 DEFB	0		; End of path
;
PATHLEN	 EQU	($-SYSPATH)	; Length of path
	  ENDIF			; SETPATH
;
ALLMSG:	DEFB	'ALL',0,0,0,0,0,0,0 ; Up to 10 characters total
				; This is the 'TO' name that is used
				;   for public messages
RSTMSG:	DEFB	CR,LF,CR,LF
	DEFB	'Users must be validated before access to CP/M '
	DEFB	'is allowed'
	DEFB	0		; This string must end with a null
;
;
; The following numbers are checked for twits using bogus phone numbers
; all zeros are checked in the system, but you can modify these to your
; own requirements.
;
CHK555:	DEFB	'555'		; Only the phone company uses this
;
CHK800:	DEFB	'800'		; Twits might use some 800 number
;
TWITMSG:DEFB	CR,LF,CR,LF
	DEFB	'The information you have provided is unsuitable'
	DEFB	CR,LF,0
;
LOCSTR:	DEFB	'the Technical RCPM, ',0 ; String used on log-off
;				    ;must end with a null
PADSTR:	DEFB	'                '  ; Used to keep names aligned
	DEFB	'                ',0
;
CRLFSTR:DEFB	CR,LF,0
;
;
;-----------------------------------------------------------------------
;
; The following are chat flags and values and the string that is printed
; if the Sysop is not available.
;
;	Chat mode can be used after midnight, set equates in to
;	whatever you want for CHAT0 (beginning time) and CHAT1
;	(ending time).	Set both the same for "always available".
;	(Can use things like 7 PM through midnight to 2 AM.)
;
CHTBYE	EQU	1		; 1=use BYE's bell flag to allow Chat
ALERT	EQU	30		; Number of times to ring
CHAT0	EQU	18		; Beginning hour of chat (24 hour clock)
CHAT1	EQU	22		; Ending hour of chat (24 hour clock)
;
NOCHAT:	DEFB	CR,LF
	DEFB	'Sorry, the Sysop is usually available between'
	DEFB	' 6:00 PM and 10:00 PM.'
	DEFB	CR,LF
	DEFB	'Use NOTE to leave your message.'
	DEFB	CR,LF,0
;
;-----------------------------------------------------------------------
;
; The following area is used if KMACC is set to 1. This allows the Sysop
; to control whether a user can download using KMD if he has has enabled
; the ACESS check in KMD.
;
BYEACC	EQU	21		; Offset from boot to ACESS byte in BYE
KMACC	EQU	YES		; Yes to set access levels for KMD usage
KMLVL	EQU	2		; Level at which user can use KMD
KMNO	EQU	64		; 0=no access, 32=download only,
				;   64=upload only, 96=both upload and
				;   download.
KMOK	EQU	96		; See above for values
KMRATIO	DEFS	1		; Ratio of Uploads to downloads that
				;   will restict the user from down-
				;   loading. Set from ACCTABLE.
;
;-----------------------------------------------------------------------
;
; This area allows setting your "real" 25th status line if you have one.
; If SET25 is "1", then define your IN25 (select 25th status line) and
; your OUT25 (deselect 25th status line) strings below.  Strings MUST be
; ended with a zero.
;
SET25	EQU	NO		; YES if you have a terminal with a real
				;   25th line
IN25:	DEFB	CR,LF,0		; Your string to select the 25th line
OUT25:	DEFB	CR,LF,0		; Your de-select string
;
;=======================================================================
;-----------------------------------------------------------------------
;=======================================================================
;
;		  MAKE NO CHANGES FROM HERE DOWN
;		if you do - the system won't work!
;
;-----------------------------------------------------------------------
; This is the random file buffer.  Change the size only with extreme
; caution since future releases of HBBS from the original author will
; definitely use the entire buffer for multi-file handling capabilities.
;
RNDBUF:	DEFS	128+1		; Random record buffer length, the
;				;   extra 1 is for safety
;-----------------------------------------------------------------------
;
; The next section defines the fields in the random file buffer for each
; of the records in each of the .BBS files... changes to this and the
; following sections could result in total incompatability with future
; releases of HBBS... change with caution.  This next section and the
; one following MUST match byte for byte and in sequence EXACTLY...
;
;NOTE:	If you are messing around with the disk I/O or writing other
;	programs that use the random file I/O in HBBSUBS.REL bear in
;	mind that the maximum length for any single record in a file
;	is 512 bytes.
;
;-----------------------------------------------------------------------
;
ACTBLEN	EQU	5		; Number of bytes per user level
;					 in access table
;
;-----------------------------------------------------------------------
; Index file fields
;-----------------------------------------------------------------------
;
IDATEF	EQU	RNDBUF		; Current date
IMRNMF	EQU	IDATEF+3	; Next message record number
IMNXTF	EQU	IMRNMF+2	; Next message number field
IMNDXF	EQU	IMNXTF+2	; # entries in message index
ICALLF	EQU	IMNDXF+2	; # callers field
IUSERF	EQU	ICALLF+2	; # users
IUSRCF	EQU	IUSERF+2	; Not used in current release
SPAREF	EQU	IUSRCF+2	; Update interval not currentl used
HRDLGF	EQU	SPAREF+1	; Hard-copy log switch
MUSRDF	EQU	HRDLGF+1	; Last date user file maintained
MUSRTF	EQU	MUSRDF+3	; Last time user file maintained
MMSGDF	EQU	MUSRTF+3	; Last date messages maintained
MMSGTF	EQU	MMSGDF+3	; Last time messages maintained
;
;
;-----------------------------------------------------------------------
; User's file fields
;-----------------------------------------------------------------------
;
AVAILF	EQU	RNDBUF		; Empty record switch 00= free record
UNAMEF	EQU	AVAILF+1	; User's name field
CITSTF	EQU	UNAMEF+30	; City and province/state
PSWRDF	EQU	CITSTF+20	; Password
PHONEF	EQU	PSWRDF+10	; Phone #
TMSONF	EQU	PHONEF+12	; # times on
LSTONF	EQU	TMSONF+2	; Last date on
ACESSF	EQU	LSTONF+3	; Access level
MAILF	EQU	ACESSF+1	; Mail waiting flag
INTARF	EQU	MAILF+1		; Area to bump user to after signon
NNULLF	EQU	INTARF+1	; Number of nulls needed
BDCDEF	EQU	NNULLF+1	; Baudrate code (last signon)
UPLDSF	EQU	BDCDEF+1	; Upload count
DNLDSF	EQU	UPLDSF+2	; Download count
USRMPF	EQU	DNLDSF+2	; Userarea map
DRVMPF	EQU	USRMPF+2	; Drive map
TCODEF	EQU	DRVMPF+2	; Terminal identifier code
TOTMEF	EQU	TCODEF+1	; Total time on-line on day basis
HIMSGF	EQU	TOTMEF+1	; Highest message read area-1
UFACCF	EQU	HIMSGF+2	; Mail area access bytes SEE UFACC
				; Below for a detailed definition.
LENGF	EQU	UFACCF+2	; Terminal line length
;
;-----------------------------------------------------------------------
; Message index file fields
;-----------------------------------------------------------------------
;
MTOF	EQU	RNDBUF		; Message 'to' name field
MTIMF	EQU	MTOF+25		; Time message was entered
MNUMF	EQU	MTIMF+5		; Message number field
MDATF	EQU	MNUMF+2		; Date message left
MBLKF	EQU	MDATF+3		; Number of 250 byte blocks used
MSTRF	EQU	MBLKF+1		; Number of starting block
MRECF	EQU	MSTRF+2		; Actual index record
MSUBF	EQU	MRECF+2		; Message subject
MFROMF	EQU	MSUBF+26	; Message 'from' name field
MPUBF	EQU	MFROMF+30	; Public/private switch 0=public
MANUMF	EQU	MPUBF+1		; Area number for this message
MREAD	EQU	MANUMF+1	; Read/deleted flag
MTABLEN	EQU	MREAD+1-MNUMF	; Length of info for message table
;
;-----------------------------------------------------------------------
; Message file field
;-----------------------------------------------------------------------
;
MSGF	EQU	RNDBUF		; Message block
;
;-----------------------------------------------------------------------
; Last caller field
;-----------------------------------------------------------------------
;
LSTCALF	EQU	RNDBUF		; Structured as:
LSTLEN	EQU	MSGLEN		; Firstname,lastname,<crlf><nulls>
;
; BYE5's last caller buffer is used to build the above structure
;-----------------------------------------------------------------------
; The next section is the buffer areas that are used to make it easier
; to find information from one field instead of having to offset from
; the base of the disk buffer each time...... as with the above field
; information changing this area means the possibility of total file and
; program incompatability with future releases.... change with care and
; caution.  These areas MUST match exactly the fields defined above.
;-----------------------------------------------------------------------
; User information for mail and system infomation:  a user's record from
; USERS.BBS loads here
;-----------------------------------------------------------------------
;
AVAIL:	DEFS	1		; Record available flag for maintenance
UNAME:	DEFS	25		; User's first and last name
MTIME:	DEFS	5		; Reserved for message's time of entry
CITST:	DEFS	20		; Location
PSWRD:	DEFS	10		; Password
PHONE:	DEFS	12		; Phone number '###-###-####'
TMSON:	DEFS	2		; Times on system
LASTON:	DEFS	3		; Binary date last on
ACESS:	DEFS	1		; Access level
MFLAG:	DEFS	1		; Mail wating flag
INTAR:	DEFS	1		; Area to bump user to after signon
NNULL:	DEFS	1		; Number of nulls needed
BDCDE:	DEFS	1		; Last baudrate used
UPLDS:	DEFS	2		; Upload count
DNLDS:	DEFS	2		; Download count
USRMP:	DEFS	2		; User area map
DRVMP:	DEFS	2		; Drive map
TCODE:	DEFS	1		; Terminal identifier code
TOTME:	DEFS	1		; Total time on-line on day basis
HIMSG:	DEFS	2		; Highest mesage read
UFACC:	DEFS	2		; Reserved for mail area access.  The
				;   first byte is for the access blocked
				;   flag bits, where bit 0 is for area
				;   2 and bit 7 is for area 9; if the
				;   bit is set, then the SYSOP has set
				;   The corresponding area access to
				;   No.  The next byte is also for fold-
				;   er access, and the bits correspond
				;   to the previous byte.  In this byte,
				;   however, a set bit indicates the
				;   user has access to a area.	A bit
				;   may be set by either the SYSOP using
				;   HBBSMNT, or by the auto bump of the
				;   user's access at each sign-on in
				;   combination with the MAILTBL defined
				;   earlier in this file.  NOTE:  That
				;   area 0 (global) and area 1 are
				;   always available to all valid users.
;
LENG:	DEFS	1		; User-selected terminal line length
;
UXTRA:	DEFS	USRLEN-(LENG+1-UNAME) ; Extra storage for expansion
;
;
;-----------------------------------------------------------------------
; System index area:  The INDEX.BBS file gets loaded here
;-----------------------------------------------------------------------
;
IDATE:	DEFB	0,0,0		; Can be updated by hardware clock
IMRNM:	DEFB	0,0		; Next message record
IMNXT:	DEFB	0,0		; Next message number
IMNDX:	DEFB	0,0		; # records in message index
ICALL:	DEFB	0,0		; # callers to system
IUSER:	DEFB	0,0		; # users of system
IUSRC:	DEFB	0,0		; # records in users file (reaches USRS max)
SPARE:	DEFB	0		; Spare byte for future
HRDLOG:	DEFB	0		; Hard-copy log switch
MUSRD:	DEFB	0,0,0		; Last date user file maintained
MUSRT:	DEFB	0,0,0		; Last time user file maintained
MMSGD:	DEFB	0,0,0		; Last date messages maintained
MMSGT:	DEFB	0,0,0		; Last time messages maintained
IXTRA:	DEFS	SYSLEN-(MMSGT+3-IDATE) ; Extra storage for expansion
;
;
;***********************************************************************
;
;	TABLE:	HSHTBL
;     PURPOSE:	Table of entries to USERS.BBS
;		(Based on USRS and statistical percentages)
;
;***********************************************************************
;
US	EQU	(MAXU)/10	; Maximum users to closest 100/100
HSHA	EQU	(4*US)/10	; Number of last names 'A'
HSHB	EQU	(8*US)/10	; Number of last names 'B'
HSHC	EQU	(7*US)/10	; etc.
HSHD	EQU	(5*US)/10
HSHE	EQU	(2*US)/10
HSHF	EQU	(4*US)/10
HSHG	EQU	(4*US)/10
HSHH	EQU	(7*US)/10
HSHI	EQU	(1*US)/10
HSHJ	EQU	(2*US)/10
HSHK	EQU	(4*US)/10
HSHL	EQU	(5*US)/10
HSHM	EQU	(9*US)/10
HSHN	EQU	(2*US)/10
HSHO	EQU	(1*US)/10
HSHP	EQU	(4*US)/10	; Could be '6' but following is 'Q'
HSHQ	EQU	(1*US)/10	;   which rarely gets an entry
HSHR	EQU	(5*US)/10
HSHS	EQU	(10*US)/10
HSHT	EQU	(4*US)/10
HSHU	EQU	(1*US)/10
HSHV	EQU	(2*US)/10
HSHW	EQU	(5*US)/10
HSHX	EQU	(1*US)/10
HSHY	EQU	(1*US)/10
HSHZ	EQU	(1*US)/10
;
HSHTBL:	DEFW	0
HSHTOT	ASET	HSHA
HSHTB:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHB
HSHTC:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHC
HSHTD:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHD
HSHTE:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHE
HSHTF:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHF
HSHTG:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHG
HSHTH:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHH
HSHTI:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHI
HSHTJ:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHJ
HSHTK:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHK
HSHTL:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHL
HSHTM:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHM
HSHTN:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHN
HSHTO:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHO
HSHTP:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHP
HSHTQ:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHQ
HSHTR:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHR
HSHTS:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHS
HSHTT:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHT
HSHTU:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHU
HSHTV:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHV
HSHTW:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHW
HSHTX:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHX
HSHTY:	DEFW	HSHTOT
HSHTOT	ASET	HSHTOT+HSHY
HSHTZ:	DEFW	HSHTOT
;
;			end of header file
;-----------------------------------------------------------------------
