/*
  ANSICON.c - ANSI escape sequence console driver.

  Jason Hood, 21 to 23 October, 2005.

  Injection code derived from Console Manager by Sergey Oblomov (hoopoepg).
  Additional information from "Process-wide API spying - an ultimate hack" By
  Anton Bassov's article in "The Code Project" (use of OpenThread).

  v1.01, 11 & 12 March, 2006:
    -m option to set "monochrome" (grey on black);
    restore original color on exit.
*/

#define PVERS "1.01"
#define PDATE "12 March, 2006"


#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <tlhelp32.h>
#include <ctype.h>

#ifndef offsetof
# define offsetof(type, member) (size_t)(&(((type*)0)->member))
#endif

#ifdef __MINGW32__
int _CRT_glob = 0;
#endif


void help( void );

BOOL find_proc_id( HANDLE snap, DWORD id, LPPROCESSENTRY32 pe );
BOOL GetParentProcessInfo( LPPROCESS_INFORMATION pInfo );


struct InjectData
{
  DWORD retaddr;		// original EIP to return to
  DWORD dlladdr;		// address of DLL filename
  DWORD funaddr;		// address of LoadLibraryA
  char	code[27];		// the actual code to load the library
  char	dllname[MAX_PATH];	// DLL filename
};

static struct InjectData inj = { 0, 0, 0, {
  0x50, 			// push eax
  0x53, 			// push ebx
  0x51, 			// push ecx
  0x52, 			// push edx
  0x56, 			// push esi
  0x57, 			// push edi
  0x55, 			// push ebp
  0x9c, 			// pushfd
  0xff, 0x74, 0x24, 0x24,	// push [esp + 8]
  0xff, 0x54, 0x24, 0x2c,	// call [esp + c]
  0x9d, 			// popfd
  0x5d, 			// pop	ebp
  0x5f, 			// pop	edi
  0x5e, 			// pop	esi
  0x5a, 			// pop	edx
  0x59, 			// pop	ecx
  0x5b, 			// pop	ebx
  0x58, 			// pop	eax
  0xc2, 0x08, 0x00		// ret	8
}, { 0 } };


// Inject code into the target process to load our DLL.  The target thread
// should be suspended on entry; it is restarted on exit.
void Inject( LPPROCESS_INFORMATION pinfo )
{
  CONTEXT context;
  char*   name;
  char*   path;
  DWORD   size;

  context.ContextFlags = CONTEXT_FULL;
  GetThreadContext( pinfo->hThread, &context );

  GetModuleFileNameA( NULL, inj.dllname, sizeof(inj.dllname) );
  for (name = path = inj.dllname; *path; ++path)
    if (*path == '\\')
      name = path + 1;
  lstrcpyA( name, "ANSI.dll" );

  size = (sizeof(inj)-sizeof(inj.dllname) + lstrlenA(inj.dllname) + 1 + 3) & ~3;
  *(unsigned short*)(inj.code+sizeof(inj.code)-2) = (unsigned short)(size-4);

  context.Esp -= size;
  inj.funaddr = (DWORD)GetProcAddress( GetModuleHandle( "kernel32.dll" ),
							"LoadLibraryA" );
  inj.dlladdr = context.Esp + offsetof(struct InjectData,dllname);
  inj.retaddr = context.Eip;
  WriteProcessMemory( pinfo->hProcess, (void*)context.Esp, &inj, size, NULL );

  context.Eip = context.Esp + offsetof(struct InjectData,code);
  SetThreadContext( pinfo->hThread, &context );
  ResumeThread( pinfo->hThread );
}


static HANDLE hConOut;
static CONSOLE_SCREEN_BUFFER_INFO csbi;

void get_original_attr( void )
{

  hConOut = CreateFile( "CONOUT$", GENERIC_READ | GENERIC_WRITE,
                                   FILE_SHARE_READ | FILE_SHARE_WRITE,
				   NULL, OPEN_EXISTING, 0, 0 );
  GetConsoleScreenBufferInfo( hConOut, &csbi );
}


void set_original_attr( void )
{
  SetConsoleTextAttribute( hConOut, csbi.wAttributes );
  CloseHandle( hConOut );
}


int main( void )
{
  STARTUPINFO sinfo;
  PROCESS_INFORMATION pinfo;
  char* cmd;
  char* name;
  char	term;
  int	rc = 0;

  cmd = GetCommandLine();
  // Skip over our own name.
  while ((*cmd == ' ' || *cmd == '\t') && *cmd)
    ++cmd;
  term = (*cmd == '"') ? ++cmd, '"' : ' ';
  // Should really process tabs here, too, but never mind.
  while (*cmd != term && *cmd)
    ++cmd;
  if (*cmd == '"')
    ++cmd;
  while ((*cmd == ' ' || *cmd == '\t') && *cmd)
    ++cmd;
  if (lstrcmp( cmd, "--help" ) == 0 ||
      (cmd[0] == '-' && (cmd[1] == '?' || cmd[1] == 'h')) ||
      (cmd[0] == '/' && cmd[1] == '?'))
  {
    help();
    return rc;
  }

  get_original_attr();

  if (cmd[0] == '-' && cmd[1] == 'm')
  {
    WORD attr = 7;
    cmd += 2;
    if (isxdigit( *cmd ))
    {
      attr = isdigit( *cmd ) ? *cmd - '0' : (*cmd | 0x20) - 'a' + 10;
      if (isxdigit( *++cmd))
      {
	attr *= 16;
	attr += isdigit( *cmd ) ? *cmd - '0' : (*cmd | 0x20) - 'a' + 10;
	++cmd;
      }
    }
    SetConsoleTextAttribute( hConOut, attr );

    while ((*cmd == ' ' || *cmd == '\t') && *cmd)
      ++cmd;
  }

  if (cmd[0] == '-' && cmd[1] == 'p')
  {
    if (GetParentProcessInfo( &pinfo ))
    {
      pinfo.hProcess = OpenProcess( PROCESS_ALL_ACCESS, FALSE,
				    pinfo.dwProcessId );
      typedef HANDLE (__stdcall *func)( DWORD, BOOL, DWORD );
      func OpenThread = (func)GetProcAddress( GetModuleHandle( "KERNEL32.dll" ),
							       "OpenThread" );
      pinfo.hThread = OpenThread( THREAD_SUSPEND_RESUME | THREAD_GET_CONTEXT |
				  THREAD_SET_CONTEXT, FALSE, pinfo.dwThreadId );
      SuspendThread( pinfo.hThread );
      Inject( &pinfo );
      CloseHandle( pinfo.hThread );
      CloseHandle( pinfo.hProcess );
    }
    else
    {
      puts( "Could not obtain parent process." );       // yeah, right
      rc = 1;
    }
  }
  else
  {
    if (*cmd == '\0')
    {
      cmd = getenv( "ComSpec" );
      if (cmd == NULL)
	cmd = "cmd";
    }

    ZeroMemory( &sinfo, sizeof(sinfo) );
    sinfo.cb = sizeof(sinfo);
    if (CreateProcess( NULL, cmd, NULL, NULL, TRUE, CREATE_SUSPENDED,
		       NULL, NULL, &sinfo, &pinfo ))
    {
      Inject( &pinfo );
      WaitForSingleObject( pinfo.hProcess, INFINITE );
    }
    else
    {
      term = (*cmd == '"') ? ++cmd, '"' : ' ';
      name = cmd;
      while (*cmd != term && *cmd)
	++cmd;
      *cmd = '\0';
      printf( "`%s' could not be executed.\n", name );
      rc = 1;
    }
  }

  set_original_attr();
  return rc;
}


// Search each process in the snapshot for id.
BOOL find_proc_id( HANDLE snap, DWORD id, LPPROCESSENTRY32 pe )
{
  BOOL fOk;

  pe->dwSize = sizeof(PROCESSENTRY32);
  for (fOk = Process32First( snap, pe ); fOk; fOk = Process32Next( snap, pe ))
    if (pe->th32ProcessID == id)
      break;

  return fOk;
}


// Obtain the process and thread identifiers of the parent process.
BOOL GetParentProcessInfo( LPPROCESS_INFORMATION pInfo )
{
  HANDLE hModuleSnap = NULL;
  PROCESSENTRY32 pe;
  THREADENTRY32  te;
  DWORD  id = GetCurrentProcessId();
  BOOL	 fOk;

  hModuleSnap = CreateToolhelp32Snapshot( TH32CS_SNAPPROCESS|TH32CS_SNAPTHREAD,
					  id );

  if (hModuleSnap == (HANDLE)-1)
  {
    puts( "Unable to obtain process snapshot." );
    exit( 1 );
  }

  find_proc_id( hModuleSnap, id, &pe );
  find_proc_id( hModuleSnap, pe.th32ParentProcessID, &pe );

  te.dwSize = sizeof(te);
  for (fOk = Thread32First( hModuleSnap, &te ); fOk;
       fOk = Thread32Next( hModuleSnap, &te ))
    if (te.th32OwnerProcessID == pe.th32ProcessID)
      break;

  CloseHandle( hModuleSnap );

  if (fOk)
  {
    pInfo->dwThreadId  = te.th32ThreadID;
    pInfo->dwProcessId = pe.th32ProcessID;
  }

  return fOk;
}


void help( void )
{
  puts( "ANSICON by Jason Hood <jadoxa@yahoo.com.au>.\n"
	"Version "PVERS" ("PDATE").  Freeware.\n"
	"http://ansicon.adoxa.cjb.net/\n"
	"\n"
	"Process ANSI escape sequences in a Win32 console program.\n"
	"\n"
	"ansicon [-m[<attr>]] [-p | program [args]]\n"
	"\n"
	"  -m\t\tuse grey on black (\"monochrome\") or <attr> as default color\n"
	"  -p\t\thook into the parent process\n"
	"  program\trun the specified program\n"
	"  nothing\trun a new command processor\n"
	"\n"
	"Only the specified program will process the sequences;\n"
	" any programs started by it will not.\n"
	"<attr> is one or two hexadecimal digits; please see `COLOR /?'."
      );
}
