 REM CheckDCD v1.1a: Modem port DCD utility;

 DEFINT A-Z
 REM $DYNAMIC

 ON ERROR GOTO Error.Routine

 Var$ = COMMAND$
 IF Var$ = "" THEN
    GOTO BootUsage
 END IF
 Var = INSTR(Var$, " ")
 IF Var THEN
    Var2$ = MID$(COMMAND$, Var + 1)
    Var$ = LEFT$(COMMAND$, Var - 1)
 END IF
 Port = INT(VAL(Var$))
 IF Port < 1 OR Port > 8 THEN
    GOTO BootUsage
 END IF
 Port = Port - 1
 COLOR 15, 0
 PRINT "CheckDCD v1.1: Modem port DCD utility;"
 GOSUB CheckPortDCD
 COLOR 14, 0
 SELECT CASE Carrier
 CASE 0
    PRINT "Comm"; Port + 1; "(port "; MID$(STR$(Port), 2); ") DCD low"
 CASE -1
    PRINT "Comm"; Port + 1; "(port "; MID$(STR$(Port), 2); ") DCD high"
 CASE -2
    PRINT "Comm"; Port + 1; "(port "; MID$(STR$(Port), 2); ") DCD <n/a>"
 END SELECT
 COLOR 7, 0
 END

BootUsage:
 COLOR 15, 0
 PRINT "CheckDCD v1.1: Modem port DCD utility;"
 COLOR 14, 0
 PRINT "Usage:"
 PRINT "   CheckDCD <comm port> <port address>"
 PRINT "Where:"
 PRINT "   Comm port=1 to 8"
 PRINT "   Optional MSR port address in hex."
 COLOR 7, 0
 END

CheckPortDCD:
 ' get modem status register (MSR)
 IF Var2$ = "" THEN
    SELECT CASE Port
    CASE 0
       PortAddress = &H3FE
    CASE 1
       PortAddress = &H2FE
    CASE 2
       PortAddress = &H3EE
    CASE 3
       PortAddress = &H2EE
    CASE 4
       PortAddress = &H3E6
    CASE 5
       PortAddress = &H2E6
    CASE 6
       PortAddress = &H33E
    CASE 7
       PortAddress = &H23E
    END SELECT
 ELSE
    PortAddress = INT(VAL("&H" + Var2$))
 END IF
 V = INP(PortAddress)
 IF (V AND &HFF) = &HFF THEN
    Carrier = -2
 ELSE
    IF (V AND &H80) = &H80 THEN
       Carrier = -1
    ELSE
       Carrier = 0
    END IF
 END IF
 RETURN

Error.Routine:
 PRINT "Critical error "; ERR
 END

