 REM CheckDTR v1.1a: Modem port DTR utility;

 DEFINT A-Z
 REM $DYNAMIC

 ON ERROR GOTO Error.Routine

 Var$ = COMMAND$
 IF Var$ = "" THEN
    GOTO BootUsage
 END IF
 Var = INSTR(Var$, " ")
 IF Var THEN
    Var2$ = MID$(COMMAND$, Var + 1)
    Var$ = LEFT$(COMMAND$, Var - 1)
 END IF
 Port = INT(VAL(Var$))
 IF Port < 1 OR Port > 8 THEN
    GOTO BootUsage
 END IF
 Port = Port - 1
 COLOR 15, 0
 PRINT "CheckDTR v1.1: Modem port DTR utility;"
 GOSUB CheckPortDTR
 COLOR 14, 0
 SELECT CASE Carrier
 CASE 0
    PRINT "Comm"; Port + 1; "(port "; MID$(STR$(Port), 2); ") DTR low"
 CASE -1
    PRINT "Comm"; Port + 1; "(port "; MID$(STR$(Port), 2); ") DTR high"
 CASE -2
    PRINT "Comm"; Port + 1; "(port "; MID$(STR$(Port), 2); ") DTR <n/a>"
 END SELECT
 COLOR 7, 0
 END

BootUsage:
 COLOR 15, 0
 PRINT "CheckDTR v1.1: Modem port DTR utility;"
 COLOR 14, 0
 PRINT "Usage:"
 PRINT "   CheckDTR <comm port> <port address>"
 PRINT "Where:"
 PRINT "   Comm port=1 to 8"
 PRINT "   Optional MCR port address in hex."
 COLOR 7, 0
 END

CheckPortDTR:
 ' get modem control register (MCR)
 IF Var2$ = "" THEN
    SELECT CASE Port
    CASE 0
       PortAddress = &H3FC
    CASE 1
       PortAddress = &H2FC
    CASE 2
       PortAddress = &H3EC
    CASE 3
       PortAddress = &H2EC
    CASE 4
       PortAddress = &H3E4
    CASE 5
       PortAddress = &H2E4
    CASE 6
       PortAddress = &H33C
    CASE 7
       PortAddress = &H23C
    END SELECT
 ELSE
    PortAddress = INT(VAL("&H" + Var2$))
 END IF
 V = INP(PortAddress)
 IF (V AND &HFF) = &HFF THEN
    Carrier = -2
 ELSE
    IF (V AND &H1) = &H1 THEN
       Carrier = -1
    ELSE
       Carrier = 0
    END IF
 END IF
 RETURN

Error.Routine:
 PRINT "Critical error "; ERR
 END

