REM File: Program Dndcnvt for Dndbbs Version v5.0a Release r2.0

REM Converts Dnddoor v5.0a r1.0a data to Dndbbs.

DEFINT A-Z
REM $DYNAMIC

TYPE BankType
 UserIndex AS SINGLE
 DatePost AS STRING * 10
 TimePost AS STRING * 8
 Balance AS DOUBLE
 Balance2 AS DOUBLE
 Deleted As INTEGER
 PostAmount AS DOUBLE
 PostType AS STRING * 1
 PostSubType AS STRING * 1
 PostSubType2 As Integer
 From As String*30
 To As String*30
END TYPE

TYPE OldTableType ' msgtable.dat/messages.dat
 ClassType AS INTEGER
 Clock AS STRING * 21
 Date AS STRING * 10
 Flags AS INTEGER
 From AS STRING * 30
 Killed AS INTEGER
 Length AS INTEGER
 Private AS INTEGER
 Received AS INTEGER
 Reply AS INTEGER
 Start AS SINGLE
 Subject AS STRING * 20
 Thread AS INTEGER
 Time AS STRING * 10
 Timer AS SINGLE
 TimesRead AS INTEGER
 To AS STRING * 30
END TYPE

TYPE NewTableType
 ClassType AS INTEGER
 Clock AS STRING * 21
 Date AS STRING * 10
 Flags AS INTEGER
 From AS STRING * 30
 Killed AS INTEGER
 Length AS INTEGER
 Private AS INTEGER
 Received AS INTEGER
 Reply AS INTEGER
 Start AS SINGLE
 Subject AS STRING * 20
 Thread AS SINGLE
 Time AS STRING * 8
 Timer AS SINGLE
 TimesRead AS DOUBLE
 To AS STRING * 30
END TYPE

TYPE WeaponType
 Index AS SINGLE
 Charges AS INTEGER
 Plus AS INTEGER
END TYPE

TYPE OldContainerType
 Closed AS INTEGER
 ContainerName AS STRING * 30
 Locked AS INTEGER
 Keyed AS INTEGER
 ShortName AS STRING * 30
 Charges(1 TO 5) AS INTEGER
 Inventory(1 TO 5) AS INTEGER
 Invisible(1 TO 5) AS INTEGER
 TreasureName(1 TO 5) AS STRING * 30
 Permanent AS INTEGER
END TYPE

TYPE NewUserType
 CodeName AS STRING * 30
 Password AS STRING * 20
 PassWord2 AS STRING * 20
 Question AS STRING * 80
 Answer AS STRING * 20
 PassWord3 AS STRING * 20
 ClassName AS STRING * 20
 ClassType AS INTEGER
 Stats(1 TO 7) AS INTEGER
 Weapon(1 TO 10) AS WeaponType
 Weapons(1 TO 4) AS INTEGER
 Room AS SINGLE
 Level AS INTEGER
 Experience AS DOUBLE
 Gold AS DOUBLE
 NumCalls AS INTEGER
 Fatigue AS INTEGER
 FatigueMax AS INTEGER
 Vitality AS INTEGER
 VitalityMax AS INTEGER
 Magic AS INTEGER
 MagicMax AS INTEGER
 Poison AS INTEGER
 Borrow AS DOUBLE
 Invisible AS INTEGER
 Race AS INTEGER
 Proficiency AS INTEGER
 Bank AS DOUBLE
 PlayersKilled AS DOUBLE
 MonstersKilled AS DOUBLE
 Permanentkilled AS DOUBLE
 Brief AS INTEGER
 DateOn AS STRING * 10
 SysNews AS STRING * 10
 Beauty AS INTEGER
 Glamour AS INTEGER
 Psionic AS INTEGER
 PsionicMax AS INTEGER
 Align1 AS INTEGER
 Align2 AS INTEGER
 Flags AS INTEGER
 Flags2 AS INTEGER
 MaxCalls AS INTEGER
 FromHour AS INTEGER
 FromMin AS INTEGER
 ToHour AS INTEGER
 ToMin AS INTEGER
 SortInv AS INTEGER
 TimeUsed AS SINGLE
 TimeLimit AS SINGLE
 Hidden AS INTEGER
 Encumbrance AS INTEGER
 TimesLogon As Double
 TimesDied As Double
 Prefix1 As String*8
 Prefix2 As String*8
 First AS SINGLE
 Last AS SINGLE
 First2 AS SINGLE
 Last2 AS SINGLE
 NodeList As String*127
 NodeList2 As Single
 EditList As Single
 StatusVar As Integer
 Prefix3 As String*8
 ShortcutKey1(1 To 8) As String*8
 ShortcutKey2(1 To 8) As String*32
 FunctionKeys(1 To 10) As String*20
 StatusLineString As String*80
 ActionLineString As String*80
 ObjectsCreated(1 To 10) As Double
 WishsLeft As Integer
 Block1 As Integer
 Block2 As Integer
 Buffer22 As Single
 Buffer23 As Single
 Buffer24 As Double
 Buffer25 As Double
END TYPE

TYPE OldUserType
 CodeName AS STRING * 30
 Password AS STRING * 20
 ClassName AS STRING * 20
 ClassType AS INTEGER
 Container(1 TO 3) AS OldContainerType
 Inv(1 TO 20) AS INTEGER
 Charges(1 TO 20) AS INTEGER
 Object(1 TO 20) AS INTEGER
 ObjCharges(1 TO 20) AS INTEGER
 Stats(1 TO 7) AS INTEGER
 Weapons(1 TO 4) AS INTEGER
 Room AS SINGLE
 Level AS INTEGER
 Experience AS DOUBLE
 Gold AS DOUBLE
 NumCalls AS INTEGER
 Fatigue AS INTEGER
 FatigueMax AS INTEGER
 Vitality AS INTEGER
 VitalityMax AS INTEGER
 Magic AS INTEGER
 MagicMax AS INTEGER
 Poison AS INTEGER
 Borrow AS DOUBLE
 Invisible AS INTEGER
 Race AS INTEGER
 Proficiency AS INTEGER
 Bank AS DOUBLE
 Sort AS INTEGER
 MonstersKilled AS SINGLE
 Brief AS INTEGER
 DateOn AS STRING * 10
 Beauty AS INTEGER
 Glamour AS INTEGER
 Psionic AS INTEGER
 PsionicMax AS INTEGER
 Align1 AS INTEGER
 Align2 AS INTEGER
 Flags AS INTEGER
 MaxCalls AS INTEGER
 FromHour AS INTEGER
 FromMin AS INTEGER
 ToHour AS INTEGER
 ToMin AS INTEGER
 Echo AS INTEGER
 LastMessage AS INTEGER
 Linefeeds AS INTEGER
 Linelength AS INTEGER
 Pagelength AS INTEGER
 Wordwrap AS INTEGER
END TYPE

TYPE NewContainerType
 ContainerName AS STRING * 30
 ContainerShort AS STRING * 30
 NamePrefix AS STRING * 15
 ContainerMax AS INTEGER
 Closed AS INTEGER
 Locked AS INTEGER
 KeyNumber AS Single
 UserNumber AS SINGLE
 RoomNumber AS SINGLE
 DeletedContainer AS INTEGER
 InvisibleContainer AS INTEGER
 Weight AS INTEGER
 WithinContainer AS SINGLE
 Disappears AS SINGLE
 ContainerIndex AS SINGLE
 Size AS INTEGER
 Material As Integer
 Permanent AS INTEGER
 SelfImplodes AS INTEGER
 RestrictItem(1 TO 3) AS SINGLE
 TrapType AS INTEGER
 TrapHits AS INTEGER
 TrapItem AS SINGLE
 Prefix1 As String*8
 Damaged As Integer
 SwapFlag As Integer
 Scanned As Integer
 First2 AS SINGLE ' within list
 Last2 AS SINGLE ' within list
 First AS SINGLE ' link to inventory
 Last AS SINGLE ' link to inventory
 Prev AS SINGLE ' doubly linked list
 Next AS SINGLE ' doubly linked list
END TYPE

TYPE NewActionType
 Attribute1 AS INTEGER
 Attribute2 AS INTEGER
 AttackMonster(1 TO 3) AS SINGLE
 EncounterRate AS INTEGER
 Fumble AS INTEGER
 HealthRate AS INTEGER
 HitPoints AS INTEGER
 Inventory AS INTEGER
 InvPercent AS INTEGER
 InvNumber AS INTEGER
 Level AS INTEGER
 MonsterTalk(1 TO 3) AS SINGLE
 MonsterTrigger(1 TO 3) AS SINGLE
 Restrictions AS INTEGER
 RustRate AS INTEGER
 SpellTrigger AS SINGLE
 StealRate AS INTEGER
 Teleport(1 TO 5) AS SINGLE
 TelePercent AS INTEGER
 Hidden AS INTEGER
 ItemForSale As Single
 WishPercent As Integer
 PoisonPercent As Integer
END TYPE

TYPE OldActionType
 Attribute1 AS INTEGER
 Attribute2 AS INTEGER
 EncounterRate AS INTEGER
 Fumble AS INTEGER
 HealthRate AS INTEGER
 HitPoints AS INTEGER
 Inventory AS INTEGER
 Level AS INTEGER
 MonsterTalk AS INTEGER
 MonsterTrigger AS INTEGER
 Restrictions AS INTEGER
 RustRate AS INTEGER
 SpellTrigger AS INTEGER
 StealRate AS INTEGER
 Teleport AS SINGLE
END TYPE

TYPE BufferType
 Buffer AS STRING * 80
END TYPE

TYPE MessType
 Index AS SINGLE
 User AS SINGLE
 Charges AS INTEGER
 Plus AS INTEGER
 Room AS SINGLE
 Prev AS SINGLE
 Next AS SINGLE
 Temp(1 To 4) AS SINGLE
 Desc(1 To 4) AS SINGLE
 Time1 As Single
 Time2 As Single
END TYPE

TYPE OldRoomType
 Action AS INTEGER
 Direct(1 TO 12) AS SINGLE
 Flags(1 TO 20) AS INTEGER
 LongDesc(1 TO 5) AS STRING * 80
 MonsterClass AS INTEGER
 Object(1 TO 20) AS INTEGER
 HiddenObj(1 TO 20) AS INTEGER
 ShortDesc AS STRING * 80
 Treasure(1 TO 20) AS INTEGER
 TreCharges(1 TO 20) AS INTEGER
 Container AS OldContainerType
END TYPE

TYPE NewRoomType
 Action AS SINGLE
 Custom1 As String*12
 Custom2 As String*12
 Direct(1 TO 14) AS SINGLE
 LongDesc(1 TO 19) AS SINGLE
 MonClass AS SINGLE
 ShortDesc AS STRING * 80
 First AS SINGLE
 Last AS SINGLE
 First2 AS SINGLE
 Last2 AS SINGLE
END TYPE

TYPE OldObjectType
 ObjectName AS STRING * 30
 ShortName AS STRING * 30
 RoomLink AS SINGLE
 Invisible AS INTEGER
 JailTrap AS INTEGER
 DoorLock AS INTEGER
 Destination AS INTEGER
 Permanent AS INTEGER
 Hidden AS INTEGER
 Closed AS INTEGER
 Keyed AS INTEGER
 Relocks AS INTEGER
 LongDesc AS STRING * 80
 FromHour AS INTEGER
 FromMin AS INTEGER
 ToHour AS INTEGER
 ToMin AS INTEGER
 LightRoom AS INTEGER
 LightTime AS INTEGER
 ShortDesc AS STRING * 80
 Trap AS INTEGER
 Teleport AS SINGLE
END TYPE

TYPE OldTreasureType
 TreasureName AS STRING * 30
 ShortName AS STRING * 30
 Weight AS INTEGER
 Gold AS INTEGER
 Spell AS INTEGER
 Plus AS INTEGER
 Coin AS INTEGER
 Keyed AS INTEGER
 Scroll AS INTEGER
 Charges AS INTEGER
 Potion AS INTEGER
 Armor AS INTEGER
 Shield AS INTEGER
 Weapon AS INTEGER
 Container AS INTEGER
 Type AS INTEGER
 Locked AS INTEGER
 Closed AS INTEGER
 Loadable AS INTEGER
 Ammunition AS INTEGER
 AmmoLoads AS INTEGER
 Invisible AS INTEGER
 Permanent AS INTEGER
 Proficiency AS INTEGER
 RingType AS INTEGER
 RingSpell AS INTEGER
 Edible AS INTEGER
 Rustable AS INTEGER
 RustPercent AS INTEGER
 Stealable AS INTEGER
 StealPercent AS INTEGER
 Launchable AS INTEGER
 LaunchLoads AS INTEGER
 LaunchAmmo AS INTEGER
 Movable AS INTEGER
 Vehicle AS INTEGER
 VehicleHits AS INTEGER
 VehicleType AS INTEGER
 LightType AS INTEGER
 LightCharges AS INTEGER
 FuelType AS INTEGER
 FuelCharges AS INTEGER
END TYPE

TYPE OldSpellType
 SpellName AS STRING * 30
 Chant AS STRING * 80
 Level AS INTEGER
 SpellType AS INTEGER
 Teleport AS SINGLE
 Psionic AS INTEGER
 PsionicMode AS INTEGER
 ClassType AS INTEGER
 Desc AS STRING * 80
 Ingred(1 TO 5) AS INTEGER
 SpellFlag AS INTEGER
END TYPE

TYPE OldMonsterType
 MonsterName AS STRING * 30
 PluralName AS STRING * 30
 Treasure(1 TO 5) AS INTEGER
 Experience AS DOUBLE
 Gold AS DOUBLE
 NumberAppearing AS INTEGER
 Level AS INTEGER
 Hits AS INTEGER
 Poison AS INTEGER
 LevelDrain AS INTEGER
 Spell AS INTEGER
 Block AS INTEGER
 Prevent AS INTEGER
 Follow AS INTEGER
 Magic AS INTEGER
 Jail AS INTEGER
 Teleport AS SINGLE
 FollowPercent AS INTEGER
 BlockPercent AS INTEGER
 PreventPercent AS INTEGER
 SpellPercent AS INTEGER
 PoisonPercent AS INTEGER
 DrainPercent AS INTEGER
 Rate AS INTEGER
 RatePercent AS INTEGER
 Permanent AS INTEGER
 Talk(1 TO 5) AS INTEGER
 Psionic AS INTEGER
 PsionicSpell AS INTEGER
END TYPE

TYPE OldMonClassType
 Monsters(1 TO 10) AS INTEGER
END TYPE

TYPE NewObjectType
 ObjectName AS STRING * 30
 ShortName AS STRING * 30
 RoomLink1 AS SINGLE
 RoomLink2 AS SINGLE
 Invisible AS INTEGER
 JailTrap AS INTEGER
 DoorLock AS INTEGER
 Destination AS INTEGER
 Permanent AS INTEGER
 Hidden AS INTEGER
 Closed AS INTEGER
 KeyNumber AS Single
 Relocks AS INTEGER
 LongDesc AS STRING * 80
 FromHour AS INTEGER
 FromMin AS INTEGER
 ToHour AS INTEGER
 ToMin AS INTEGER
 LightRoom AS INTEGER
 LightTime AS INTEGER
 ShortDesc AS STRING * 80
 Trap AS INTEGER
 Teleport AS SINGLE
 SwitchType AS INTEGER
 SwitchRoom AS SINGLE
 SwitchLight AS INTEGER
 SwitchLockRoom AS INTEGER
 Prefix1 AS STRING*8
 PortalPassword As String*8
 ObjDesc(1 To 19) As Single
 Buffer5 AS INTEGER
 Buffer6 AS INTEGER
 InitRoom AS SINGLE
 InitRoom2 AS SINGLE
END TYPE

TYPE NewTreasureType
 TreasureName AS STRING * 30
 ShortName AS STRING * 30
 Weight AS INTEGER
 Gold AS Double
 Spell AS SINGLE
 Plus AS INTEGER
 Coin AS INTEGER
 Locked AS INTEGER
 KeyNumber AS Single
 Scroll AS INTEGER
 Charges AS INTEGER
 Potion AS INTEGER
 Loadable AS INTEGER
 Ammunition AS INTEGER
 AmmoLoads AS SINGLE
 Invisible AS INTEGER
 Permanent AS INTEGER
 Proficiency AS INTEGER
 WeaponNumber AS INTEGER
 RingType AS INTEGER
 RingSpell AS SINGLE
 Edible AS INTEGER
 Rustable AS INTEGER
 RustPercent AS INTEGER
 Stealable AS INTEGER
 StealPercent AS INTEGER
 Launchable AS INTEGER
 LaunchLoads AS SINGLE
 LaunchAmmo AS INTEGER
 Movable AS INTEGER
 Vehicle AS INTEGER
 VehicleType AS INTEGER
 LightType AS INTEGER
 LightCharges AS INTEGER
 FuelType AS INTEGER
 FuelCharges AS INTEGER
 Container AS INTEGER
 ContainerMax AS INTEGER
 ContainerPrefix AS STRING * 15
 ContainerDisappears AS SINGLE
 ContainerSize AS INTEGER
 ContainerMaterial As Integer
 ContainerSelfImplodes As Integer
 PotionType AS SINGLE
 NewPotion AS SINGLE
 MixPotion AS INTEGER
 TwoHanded AS INTEGER
 RequireStr AS INTEGER
 RequireDex AS INTEGER
 RequireInt AS INTEGER
 RestrictItem(1 TO 3) AS SINGLE
 TrapType AS INTEGER
 TrapHits AS INTEGER
 TrapItem AS SINGLE
 MasterKey AS INTEGER
 Liquid AS INTEGER
 LiquidType AS INTEGER
 LiquidFlags AS INTEGER
 Prefix1 As String*8
 StaysInRoom As Integer
 Occupants As Integer
 BindType As Integer
 TimesCursed As Integer
 TimesBlessed As Integer
 Persistent AS INTEGER
 MaxPersistCharges AS INTEGER
 PersistTime AS SINGLE
 DischargePersist AS SINGLE
 ProperName As String*20
END TYPE

TYPE NewSpellType
 SpellName AS STRING * 30
 Chant AS STRING * 80
 Level AS INTEGER
 SpellType AS INTEGER
 Teleport AS SINGLE
 Psionic AS INTEGER
 PsionicMode AS INTEGER
 ClassType AS INTEGER
 Desc AS STRING * 80
 Ingred(1 TO 5) AS SINGLE
 SpellFlag AS INTEGER
 SpellEquate AS STRING * 40
 Equation AS INTEGER
 Prefix1 As String*8
 Buffer9 AS INTEGER
 Buffer10 AS INTEGER
 Buffer11 AS SINGLE
 Buffer12 AS SINGLE
END TYPE

TYPE NewMonsterType
 MonsterName AS STRING * 30
 PluralName AS STRING * 30
 Experience AS DOUBLE
 Gold AS DOUBLE
 NumberAppearing AS INTEGER
 Level AS INTEGER
 Hits AS INTEGER
 Poison AS INTEGER
 LevelDrain AS INTEGER
 Spell AS SINGLE
 Block AS INTEGER
 Prevent AS INTEGER
 Follow AS INTEGER
 Magic AS INTEGER
 Jail AS INTEGER
 TeleportPercent AS INTEGER
 FollowPercent AS INTEGER
 BlockPercent AS INTEGER
 PreventPercent AS INTEGER
 SpellPercent AS INTEGER
 PoisonPercent AS INTEGER
 DrainPercent AS INTEGER
 Rate AS INTEGER
 RatePercent AS INTEGER
 Permanent AS INTEGER
 Talk(1 TO 5) AS INTEGER
 Psionic AS INTEGER
 PsionicSpell AS SINGLE
 Equation AS INTEGER
 MonsterEquate AS STRING * 40
 MonsterSurprise As String*40
 MonsterSavingThrow As String*40
 Prefix1 As String*8
 First AS SINGLE
 Last AS SINGLE
 Weapon As Single
 Shield As Single
 Armor As Single
 PerMonster As Integer
 TalkGold As Double
 TalkGoldTimes As Integer
 TalkGoldPercent As Integer
 TalkItem As Single
 TalkItemTimes As Integer
 TalkItemPercent As Integer
 TalkMoveDirection As Integer
 Invisible AS INTEGER
 RemainsInRoom AS INTEGER
 Buffer15 AS SINGLE
 Buffer16 AS SINGLE
END TYPE

TYPE NewMonClassType
 Monsters(1 TO 10) AS SINGLE
END TYPE

Common Shared BankRecord As BankType
Common Shared BankRecLen As Integer

COMMON SHARED OldTableRecord AS OldTableType
COMMON SHARED OldTableRecLen AS INTEGER

COMMON SHARED NewTableRecord AS NewTableType
COMMON SHARED NewTableRecLen AS INTEGER

COMMON SHARED OldContainerRecord AS OldContainerType
COMMON SHARED OldContainerRecLen AS INTEGER

COMMON SHARED NewContainerRecord AS NewContainerType
COMMON SHARED NewContainerRecLen AS INTEGER

COMMON SHARED OldUserRecord AS OldUserType
COMMON SHARED NewUserRecord AS NewUserType

COMMON SHARED OldUserRecLen AS INTEGER
COMMON SHARED NewUserRecLen AS INTEGER

COMMON SHARED BufferRecord AS BufferType
COMMON SHARED BufferRecLen AS INTEGER

COMMON SHARED MessWorkRecord AS MessType
COMMON SHARED MessWorkRecLen AS INTEGER

COMMON SHARED OldRoomRecord AS OldRoomType
COMMON SHARED NewRoomRecord AS NewRoomType

COMMON SHARED OldRoomRecLen AS INTEGER
COMMON SHARED NewRoomRecLen AS INTEGER

COMMON SHARED OldObjectRecord AS OldObjectType
COMMON SHARED NewObjectRecord AS NewObjectType

COMMON SHARED OldObjectRecLen AS INTEGER
COMMON SHARED NewObjectRecLen AS INTEGER

COMMON SHARED OldTreasureRecord AS OldTreasureType
COMMON SHARED NewTreasureRecord AS NewTreasureType

COMMON SHARED OldTreasureRecLen AS INTEGER
COMMON SHARED NewTreasureRecLen AS INTEGER

COMMON SHARED OldSpellRecord AS OldSpellType
COMMON SHARED NewSpellRecord AS NewSpellType

COMMON SHARED OldSpellRecLen AS INTEGER
COMMON SHARED NewSpellRecLen AS INTEGER

COMMON SHARED OldMonsterRecord AS OldMonsterType
COMMON SHARED NewMonsterRecord AS NewMonsterType

COMMON SHARED OldMonsterRecLen AS INTEGER
COMMON SHARED NewMonsterRecLen AS INTEGER

COMMON SHARED OldMonClassRecord AS OldMonClassType
COMMON SHARED NewMonClassRecord AS NewMonClassType

COMMON SHARED OldMonClassRecLen AS INTEGER
COMMON SHARED NewMonClassRecLen AS INTEGER

COMMON SHARED OldActionRecord AS OldActionType
COMMON SHARED NewActionRecord AS NewActionType

COMMON SHARED OldActionRecLen AS INTEGER
COMMON SHARED NewActionRecLen AS INTEGER

COMMON SHARED Filename1 AS STRING
COMMON SHARED Filename2 AS STRING
COMMON SHARED Filename3 AS STRING
COMMON SHARED Filename4 AS STRING
COMMON SHARED Filename5 AS STRING
COMMON SHARED Filename6 AS STRING

Common Shared TotalBank As Double

Common Shared Strng3 As String

CONST PrimeKey = 29

REM $INCLUDE: 'const.inc'

Function DateS$
 DateS$=Format$(Now,"mm-dd-yyyy")
End Function

BankRecLen = Len(BankRecord)

BufferRecLen = LEN(BufferRecord)

OldActionRecLen = LEN(OldActionRecord)
NewActionRecLen = LEN(NewActionRecord)

OldTableRecLen = LEN(OldTableRecord)
NewTableRecLen = LEN(NewTableRecord)

OldContainerRecLen = LEN(OldContainerRecord)
NewContainerRecLen = LEN(NewContainerRecord)

MessWorkRecLen = LEN(MessWorkRecord)

OldUserRecLen = LEN(OldUserRecord)
NewUserRecLen = LEN(NewUserRecord)

OldRoomRecLen = LEN(OldRoomRecord)
NewRoomRecLen = LEN(NewRoomRecord)

OldObjectRecLen = LEN(OldObjectRecord)
NewObjectRecLen = LEN(NewObjectRecord)

OldTreasureRecLen = LEN(OldTreasureRecord)
NewTreasureRecLen = LEN(NewTreasureRecord)

OldSpellRecLen = LEN(OldSpellRecord)
NewSpellRecLen = LEN(NewSpellRecord)

OldMonsterRecLen = LEN(OldMonsterRecord)
NewMonsterRecLen = LEN(NewMonsterRecord)

OldMonClassRecLen = LEN(OldMonClassRecord)
NewMonClassRecLen = LEN(NewMonClassRecord)

ON ERROR GOTO Error.Routine
CALL Passwrd1(Var)
IF Var = False THEN
   PRINT "Illegal password!"
   COLOR 7, 0
   END
END IF
Var$ = COMMAND$
Var=INSTR(Var$,"/A")
IF Var THEN
   Ignore.User=-1
   Var$ = LEFT$(Var$, -1) + MID$(Var$, Var + 1)
END IF
IF LEN(Var$) THEN
   Node$ = UCASE$(Var$)
END IF
COLOR 15, 0
PRINT "Dndcnvt utility for Dndbbs;"
COLOR 14, 0
PRINT "This utility converts Dnddoor v5.0a files to Dndbbs Version v5.0a";
IF LEN(Node$) THEN
   PRINT "(Node:"; Node$; ")";
END IF
PRINT
PRINT "Dndcnvt will now create new data files. Continue(y/n)? ";
LOCATE , , 1
DO
   Var$ = INKEY$
   IF LEN(Var$) THEN
      Var$ = LCASE$(Var$)
      SELECT CASE Var$
      CASE "y"
         PRINT "y"
         EXIT DO
      CASE "n"
         PRINT "n"
         COLOR 7, 0
         PRINT "Exiting to system:"
         END
      END SELECT
   END IF
LOOP
' get pathnames
PRINT "Enter path for Dnddoor";
INPUT Var1$
PRINT "Enter path to Dndbbs";
INPUT Var2$
Var3$ = CURDIR$

' check pathnames
IF RIGHT$(Var1$, 1) = "\" THEN
   Var1$ = LEFT$(Var1$, LEN(Var1$) - 1)
END IF
IF RIGHT$(Var2$, 1) = "\" THEN
   Var2$ = LEFT$(Var2$, LEN(Var2$) - 1)
END IF

' verify pathnames
CHDIR Var1$
CHDIR Var2$
CHDIR Var3$

GOSUB Read.Config2
Var2$ = DataPath1$
' convert actions
CLOSE
Filename1 = Var1$ + "\ACTIONS.DAT"
Filename2 = Var2$ + "\" + ActionFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldActionRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewActionRecLen
IF LOF(1) / OldActionRecLen > False THEN
Temp! = LOF(1) / OldActionRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad action file record length."
   Temp! = SFalse
   GOTO EndLoop1
END IF
FOR Temp! = 1! TO LOF(1) / OldActionRecLen
   GET 1, Temp!, OldActionRecord
   NewActionRecord.Attribute1 = OldActionRecord.Attribute1
   NewActionRecord.Attribute2 = OldActionRecord.Attribute2
   NewActionRecord.EncounterRate = OldActionRecord.EncounterRate
   NewActionRecord.Fumble = OldActionRecord.Fumble
   NewActionRecord.HealthRate = OldActionRecord.HealthRate
   NewActionRecord.HitPoints = OldActionRecord.HitPoints
   NewActionRecord.Inventory = OldActionRecord.Inventory
   NewActionRecord.InvPercent = False
   NewActionRecord.InvNumber = False
   NewActionRecord.Level = OldActionRecord.Level
   NewActionRecord.Restrictions = OldActionRecord.Restrictions
   NewActionRecord.RustRate = OldActionRecord.RustRate
   NewActionRecord.SpellTrigger = OldActionRecord.SpellTrigger
   NewActionRecord.StealRate = OldActionRecord.StealRate
   NewActionRecord.TelePercent = False
   NewActionRecord.Hidden = False
   FOR Temp2 = 1 TO 3
      NewActionRecord.AttackMonster(Temp2) = SFalse
      NewActionRecord.MonsterTalk(Temp2) = SFalse
      NewActionRecord.MonsterTrigger(Temp2) = SFalse
   NEXT
   FOR Temp2 = 1 TO 5
      NewActionRecord.Teleport(Temp2) = SFalse
   NEXT
   PUT 2, Temp!, NewActionRecord
NEXT
PRINT "Actions:"; Temp! - 1!
END IF
EndLoop1:
' convert objects
CLOSE
Filename1 = Var1$ + "\OBJECTS.DAT"
Filename2 = Var2$ + "\" + ObjectFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldObjectRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewObjectRecLen
IF LOF(1) / OldObjectRecLen > False THEN
Temp! = LOF(1) / OldObjectRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad object file record length."
   Temp! = SFalse
   GOTO EndLoop2
END IF
FOR Temp! = 1! TO LOF(1) / OldObjectRecLen
   GET 1, Temp!, OldObjectRecord
   NewObjectRecord.ObjectName = OldObjectRecord.ObjectName
   NewObjectRecord.ShortName = OldObjectRecord.ShortName
   NewObjectRecord.RoomLink1 = OldObjectRecord.RoomLink
   NewObjectRecord.RoomLink2 = SFalse
   NewObjectRecord.Invisible = OldObjectRecord.Invisible
   NewObjectRecord.JailTrap = OldObjectRecord.JailTrap
   NewObjectRecord.DoorLock = OldObjectRecord.DoorLock
   NewObjectRecord.Destination = OldObjectRecord.Destination
   NewObjectRecord.Permanent = OldObjectRecord.Permanent
   NewObjectRecord.Hidden = OldObjectRecord.Hidden
   NewObjectRecord.Closed = OldObjectRecord.Closed
   NewObjectRecord.KeyNumber = Csng(OldObjectRecord.Keyed)
   NewObjectRecord.Relocks = OldObjectRecord.Relocks
   NewObjectRecord.LongDesc = OldObjectRecord.LongDesc
   NewObjectRecord.FromHour = OldObjectRecord.FromHour
   NewObjectRecord.FromMin = OldObjectRecord.FromMin
   NewObjectRecord.ToHour = OldObjectRecord.ToHour
   NewObjectRecord.ToMin = OldObjectRecord.ToMin
   NewObjectRecord.LightRoom = OldObjectRecord.LightRoom
   NewObjectRecord.LightTime = OldObjectRecord.LightTime
   NewObjectRecord.ShortDesc = OldObjectRecord.ShortDesc
   NewObjectRecord.Trap = OldObjectRecord.Trap
   NewObjectRecord.Teleport = OldObjectRecord.Teleport
   NewObjectRecord.SwitchType = False
   NewObjectRecord.SwitchRoom = SFalse
   NewObjectRecord.SwitchLight = False
   NewObjectRecord.SwitchLockRoom = False
   NewObjectRecord.Prefix1 = Nul
   NewObjectRecord.PortalPassword = Nul
   For VarQ=1 To 19
      NewObjectRecord.ObjDesc(VarQ)=0!
   Next
   If NewObjectRecord.DoorLock Then
      NewObjectRecord.Prefix1 = Strng3 + "FE"
      If NewObjectRecord.KeyNumber Then
         NewObjectRecord.Prefix1 = Strng3 + "FD"
      Endif
   Else
      If NewObjectRecord.RoomLink1 Then
         NewObjectRecord.Prefix1 = Strng3 + "FE"
         If NewObjectRecord.KeyNumber Then
            NewObjectRecord.Prefix1 = Strng3 + "FD"
         Endif
      Else
         If NewObjectRecord.LightRoom Then
            NewObjectRecord.Prefix1 = Strng3 + "FC"
         Else
            If NewObjectRecord.SwitchType Then
               NewObjectRecord.Prefix1 = Strng3 + "FB"
            Else
               If NewObjectRecord.JailTrap Then
                  NewObjectRecord.Prefix1 = Strng3 + "FA"
               Else
                  NewObjectRecord.Prefix1 = Strng3 + "F9"
               Endif
            Endif
         Endif
      Endif
   Endif
   PUT 2, Temp!, NewObjectRecord
NEXT
PRINT "Objects:"; Temp! - 1!
END IF
EndLoop2:
' convert treasure
CLOSE
Filename1 = Var1$ + "\TREASURE.DAT"
Filename2 = Var2$ + "\" + TreasureFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldTreasureRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewTreasureRecLen
IF LOF(1) / OldTreasureRecLen > False THEN
Temp! = LOF(1) / OldTreasureRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad treasure file record length."
   Temp! = SFalse
   GOTO EndLoop3
END IF
FOR Temp! = 1! TO LOF(1) / OldTreasureRecLen
   GET 1, Temp!, OldTreasureRecord
   NewTreasureRecord.TreasureName = OldTreasureRecord.TreasureName
   NewTreasureRecord.ShortName = OldTreasureRecord.ShortName
   NewTreasureRecord.Weight = OldTreasureRecord.Weight
   NewTreasureRecord.Gold = OldTreasureRecord.Gold
   NewTreasureRecord.Spell = OldTreasureRecord.Spell
   NewTreasureRecord.Plus = OldTreasureRecord.Plus
   NewTreasureRecord.Coin = OldTreasureRecord.Coin
   NewTreasureRecord.Locked = OldTreasureRecord.Locked
   NewTreasureRecord.KeyNumber = Csng(OldTreasureRecord.Keyed)
   If OldTreasureRecord.Scroll Then
      NewTreasureRecord.Scroll = True
   Else
      NewTreasureRecord.Scroll = False
   Endif
   NewTreasureRecord.Charges = OldTreasureRecord.Charges
   NewTreasureRecord.Potion = OldTreasureRecord.Potion
   NewTreasureRecord.Loadable = OldTreasureRecord.Loadable
   NewTreasureRecord.Ammunition = OldTreasureRecord.Ammunition
   NewTreasureRecord.AmmoLoads = OldTreasureRecord.AmmoLoads
   NewTreasureRecord.Invisible = OldTreasureRecord.Invisible
   NewTreasureRecord.Permanent = False
   NewTreasureRecord.StaysInRoom = False
   NewTreasureRecord.Proficiency = False
   NewTreasureRecord.WeaponNumber = False
   IF OldTreasureRecord.RingType THEN
      NewTreasureRecord.WeaponNumber = 4
   ELSE
      IF OldTreasureRecord.Loadable = False THEN
         IF OldTreasureRecord.Launchable = False THEN
            SELECT CASE OldTreasureRecord.Type
            CASE False
               IF OldTreasureRecord.Plus > False THEN ' weapon
                  NewTreasureRecord.WeaponNumber = 7
                  NewTreasureRecord.Proficiency = OldTreasureRecord.Proficiency
                  IF NewTreasureRecord.Proficiency = False THEN
                     NewTreasureRecord.Proficiency = 3
                  END IF
               END IF
            CASE IS < False ' shield
               NewTreasureRecord.WeaponNumber = 5
            CASE IS > False ' armor
               NewTreasureRecord.WeaponNumber = 1
            END SELECT
         END IF
      END IF
   END IF
   NewTreasureRecord.RingType = OldTreasureRecord.RingType
   NewTreasureRecord.RingSpell = OldTreasureRecord.RingSpell
   NewTreasureRecord.Edible = OldTreasureRecord.Edible
   NewTreasureRecord.Rustable = OldTreasureRecord.Rustable
   NewTreasureRecord.RustPercent = OldTreasureRecord.RustPercent
   NewTreasureRecord.Stealable = OldTreasureRecord.Stealable
   NewTreasureRecord.StealPercent = OldTreasureRecord.StealPercent
   NewTreasureRecord.Launchable = OldTreasureRecord.Launchable
   NewTreasureRecord.LaunchLoads = OldTreasureRecord.LaunchLoads
   NewTreasureRecord.LaunchAmmo = OldTreasureRecord.LaunchAmmo
   NewTreasureRecord.Movable = OldTreasureRecord.Movable
   NewTreasureRecord.Vehicle = False
   NewTreasureRecord.VehicleType = False
   IF OldTreasureRecord.Vehicle THEN
      NewTreasureRecord.WeaponNumber = False
      NewTreasureRecord.Vehicle = True
      SELECT CASE OldTreasureRecord.VehicleType
      CASE 0, 1, 2, 3
         NewTreasureRecord.VehicleType = OldTreasureRecord.VehicleType
      CASE ELSE
         NewTreasureRecord.VehicleType = 3
      END SELECT
      NewTreasureRecord.Proficiency = False
      NewTreasureRecord.Permanent = True
   END IF
   If OldTreasureRecord.Launchable Then
      NewTreasureRecord.Permanent = True
   Endif
   IF OldTreasureRecord.VehicleHits > False THEN
      NewTreasureRecord.Charges = OldTreasureRecord.VehicleHits
   END IF
   NewTreasureRecord.LightType = OldTreasureRecord.LightType
   NewTreasureRecord.LightCharges = OldTreasureRecord.LightCharges
   NewTreasureRecord.FuelType = OldTreasureRecord.FuelType
   NewTreasureRecord.FuelCharges = OldTreasureRecord.FuelCharges
   NewTreasureRecord.Container = False
   NewTreasureRecord.ContainerMax = False
   NewTreasureRecord.ContainerPrefix = Nul
   NewTreasureRecord.ContainerDisappears = False
   NewTreasureRecord.ContainerSelfImplodes=False
   NewTreasureRecord.ContainerSize = False
   NewTreasureRecord.ContainerMaterial = False
   IF OldTreasureRecord.Container THEN
      NewTreasureRecord.Container = True
      NewTreasureRecord.ContainerMax = 10
      NewTreasureRecord.ContainerPrefix = "in it"
      NewTreasureRecord.ContainerDisappears = False
      NewTreasureRecord.ContainerSelfImplodes=False
      NewTreasureRecord.ContainerSize = False
      NewTreasureRecord.ContainerMaterial = False
   END IF
   NewTreasureRecord.PotionType = False
   NewTreasureRecord.NewPotion = False
   NewTreasureRecord.MixPotion = False
   NewTreasureRecord.TwoHanded = False
   NewTreasureRecord.RequireStr = False
   NewTreasureRecord.RequireDex = False
   NewTreasureRecord.RequireInt = False
   For Var=1 To 3
      NewTreasureRecord.RestrictItem(Var)=SFalse
   Next
   NewTreasureRecord.TrapType=False
   NewTreasureRecord.TrapHits=False
   NewTreasureRecord.TrapItem=SFalse
   NewTreasureRecord.MasterKey=False
   NewTreasureRecord.Liquid=False
   NewTreasureRecord.LiquidType=False
   NewTreasureRecord.LiquidFlags=False
   NewTreasureRecord.Prefix1=Nul
   NewTreasureRecord.StaysInRoom=0
   NewTreasureRecord.Occupants=0
   NewTreasureRecord.BindType=0
   NewTreasureRecord.TimesCursed=0
   NewTreasureRecord.TimesBlessed=0
   NewTreasureRecord.Persistent=0
   NewTreasureRecord.MaxPersistCharges=0
   NewTreasureRecord.PersistTime=0!
   NewTreasureRecord.DischargePersist=0!
   NewTreasureRecord.ProperName=""
   Select Case NewTreasureRecord.WeaponNumber
   Case 0 ' treasure
      If NewTreasureRecord.Container Then
         NewTreasureRecord.Prefix1 = Strng3 + "FE"
      Else
         If NewTreasureRecord.Spell Then
            NewTreasureRecord.Prefix1 = Strng3 + "F5"
         Else
            If NewTreasureRecord.Coin Then
               NewTreasureRecord.Prefix1 = Strng3 + "F5"
            Else
               If NewTreasureRecord.Vehicle Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.Loadable Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.Ammunition Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.AmmoLoads Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.Launchable Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.LaunchLoads Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
               If NewTreasureRecord.LaunchAmmo Then
                  NewTreasureRecord.Prefix1 = Strng3 + "F6"
               Endif
            Endif
         Endif
      Endif
   Case 1 ' armor
      NewTreasureRecord.Prefix1 = Strng3 + "F9"
   Case 2 ' boots
      NewTreasureRecord.Prefix1 = Strng3 + "F1"
   Case 3 ' helmet
      NewTreasureRecord.Prefix1 = Strng3 + "F2"
   Case 4 ' ring(left)
      NewTreasureRecord.Prefix1 = Strng3 + "F3"
   Case 5 ' shield
      NewTreasureRecord.Prefix1 = Strng3 + "FA"
   Case 6 ' bracers
      NewTreasureRecord.Prefix1 = Strng3 + "F4"
   Case 7 ' weapon
      NewTreasureRecord.Prefix1 = Strng3 + "FB"
   Case 8 ' cloak
      NewTreasureRecord.Prefix1 = Strng3 + "FC"
   Case 9 ' ring(right)
      NewTreasureRecord.Prefix1 = Strng3 + "F3"
   Case 10 ' amulet
      NewTreasureRecord.Prefix1 = Strng3 + "FD"
   Case Else
      NewTreasureRecord.Prefix1 = Strng3 + "FF"
   End Select
   PUT 2, Temp!, NewTreasureRecord
NEXT
PRINT "Treasure:"; Temp! - 1!
END IF
EndLoop3:
' convert spells
CLOSE
Filename1 = Var1$ + "\SPELLS.DAT"
Filename2 = Var2$ + "\" + SpellsFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldSpellRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewSpellRecLen
IF LOF(1) / OldSpellRecLen > False THEN
Temp! = LOF(1) / OldSpellRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad spell file record length."
   Temp! = SFalse
   GOTO EndLoop4
END IF
FOR Temp! = 1! TO LOF(1) / OldSpellRecLen
   GET 1, Temp!, OldSpellRecord
   NewSpellRecord.SpellName = OldSpellRecord.SpellName
   NewSpellRecord.Chant = OldSpellRecord.Chant
   NewSpellRecord.Level = OldSpellRecord.Level
   NewSpellRecord.SpellType = OldSpellRecord.SpellType
   NewSpellRecord.Teleport = OldSpellRecord.Teleport
   NewSpellRecord.Psionic = OldSpellRecord.Psionic
   NewSpellRecord.PsionicMode = OldSpellRecord.PsionicMode
   NewSpellRecord.ClassType = OldSpellRecord.ClassType
   NewSpellRecord.Desc = OldSpellRecord.Desc
   FOR Temp2 = 1 TO 5
      NewSpellRecord.Ingred(Temp2) = OldSpellRecord.Ingred(Temp2)
   NEXT
   NewSpellRecord.SpellFlag = OldSpellRecord.SpellFlag
   NewSpellRecord.SpellEquate = Nul
   NewSpellRecord.Equation = False
   NewSpellRecord.Prefix1 = ""
   Select Case NewSpellRecord.SpellType
   Case 1
      NewSpellRecord.Prefix1="{F9"
   Case 2
      NewSpellRecord.Prefix1="{FA"
   Case 3
      NewSpellRecord.Prefix1="{FF"
   Case 4
      NewSpellRecord.Prefix1="{FF"
   Case 5
      NewSpellRecord.Prefix1="{F5"
   Case 6
      NewSpellRecord.Prefix1="{FB"
   Case 7
      NewSpellRecord.Prefix1="{FC"
   Case 8
      NewSpellRecord.Prefix1="{FF"
   Case 9
      NewSpellRecord.Prefix1="{FD"
   Case 10
      NewSpellRecord.Prefix1="{FE"
   Case 11
      NewSpellRecord.Prefix1="{F6"
   Case 12
      NewSpellRecord.Prefix1="{FD"
   Case 13
      NewSpellRecord.Prefix1="{FE"
   Case 14
      NewSpellRecord.Prefix1="{F5"
   Case 15
      NewSpellRecord.Prefix1="{FA"
   Case 16
      NewSpellRecord.Prefix1="{F1"
   Case 17
      NewSpellRecord.Prefix1="{F1"
   Case 18
      NewSpellRecord.Prefix1="{F1"
   Case 19
      NewSpellRecord.Prefix1="{FA"
   Case 20
      NewSpellRecord.Prefix1="{F2"
   Case 21
      NewSpellRecord.Prefix1="{F2"
   Case 22
      NewSpellRecord.Prefix1="{F2"
   Case 23
      NewSpellRecord.Prefix1="{F3"
   Case 24
      NewSpellRecord.Prefix1="{F4"
   Case 25
      NewSpellRecord.Prefix1="{F4"
   Case 26
      NewSpellRecord.Prefix1="{F4"
   Case 27
      NewSpellRecord.Prefix1="{FA"
   Case 28
      NewSpellRecord.Prefix1="{FE"
   Case Else
      NewSpellRecord.Prefix1="{FF"
   End Select
   PUT 2, Temp!, NewSpellRecord
NEXT
PRINT "Spells:"; Temp! - 1!
END IF
EndLoop4:
' convert monsters
CLOSE
Filename1 = Var1$ + "\MONSTERS.DAT"
Filename2 = Var2$ + "\" + MonstersFilename2$
Filename3 = Var2$ + "\" + MonInvFilename2$
Filename4 = Var1$ + "\TREASURE.DAT"
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonsterRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonsterRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = OldTreasureRecLen
IF LOF(1) / OldMonsterRecLen > False THEN
Temp! = LOF(1) / OldMonsterRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad monster file record length."
   Temp! = SFalse
   GOTO EndLoop5
END IF
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen
   GET 1, Temp!, OldMonsterRecord
   NewMonsterRecord.MonsterName = OldMonsterRecord.MonsterName
   NewMonsterRecord.PluralName = OldMonsterRecord.PluralName
   NewMonsterRecord.Experience = OldMonsterRecord.Experience
   If OldMonsterRecord.Gold=0 Then
      NewMonsterRecord.Gold = 10
   Else
      NewMonsterRecord.Gold = OldMonsterRecord.Gold
   Endif
   NewMonsterRecord.NumberAppearing = OldMonsterRecord.NumberAppearing
   NewMonsterRecord.Level = OldMonsterRecord.Level
   NewMonsterRecord.Hits = OldMonsterRecord.Hits
   NewMonsterRecord.Poison = OldMonsterRecord.Poison
   NewMonsterRecord.LevelDrain = OldMonsterRecord.LevelDrain
   NewMonsterRecord.Spell = OldMonsterRecord.Spell
   NewMonsterRecord.Block = OldMonsterRecord.Block
   NewMonsterRecord.Prevent = OldMonsterRecord.Prevent
   NewMonsterRecord.Follow = OldMonsterRecord.Follow
   NewMonsterRecord.Magic = OldMonsterRecord.Magic
   NewMonsterRecord.Jail = OldMonsterRecord.Jail
   NewMonsterRecord.TeleportPercent = False
   NewMonsterRecord.FollowPercent = OldMonsterRecord.FollowPercent
   NewMonsterRecord.BlockPercent = OldMonsterRecord.BlockPercent
   NewMonsterRecord.PreventPercent = OldMonsterRecord.PreventPercent
   NewMonsterRecord.SpellPercent = OldMonsterRecord.SpellPercent
   NewMonsterRecord.PoisonPercent = OldMonsterRecord.PoisonPercent
   NewMonsterRecord.DrainPercent = OldMonsterRecord.DrainPercent
   NewMonsterRecord.Rate = OldMonsterRecord.Rate
   NewMonsterRecord.RatePercent = OldMonsterRecord.RatePercent
   NewMonsterRecord.Permanent = OldMonsterRecord.Permanent
   FOR Temp2 = 1 TO 5
      NewMonsterRecord.Talk(Temp2) = OldMonsterRecord.Talk(Temp2)
   NEXT
   NewMonsterRecord.Psionic = OldMonsterRecord.Psionic
   NewMonsterRecord.PsionicSpell = OldMonsterRecord.PsionicSpell
   NewMonsterRecord.Equation = False
   NewMonsterRecord.MonsterEquate = Nul
   NewMonsterRecord.MonsterSurprise = Nul
   NewMOnsterRecord.MonsterSavingThrow = Nul
   NewMonsterRecord.Prefix1 = Nul
   If NewMonsterRecord.Level>=10 Then
      NewMonsterRecord.Prefix1 = Strng3 + "FE"
   Else
      If NewMonsterRecord.Spell Then
         NewMonsterRecord.Prefix1 = Strng3 + "FD"
      Else
         NewMonsterRecord.Prefix1 = Strng3 + "FC"
      Endif
   Endif
   NewMonsterRecord.First = SFalse
   NewMonsterRecord.Last = SFalse
   NewMonsterRecord.Weapon = SFalse
   NewMonsterRecord.Shield = SFalse
   NewMonsterRecord.Armor = Sfalse
   NewMonsterRecord.PerMonster=0
   NewMonsterRecord.TalkGold=0
   NewMonsterRecord.TalkGoldTimes=0
   NewMonsterRecord.TalkGoldPercent=0
   NewMonsterRecord.TalkItem=0
   NewMonsterRecord.TalkItemTimes=0
   NewMonsterRecord.TalkItemPercent=0
   NewMonsterRecord.TalkMoveDirection=0
   PUT 2, Temp!, NewMonsterRecord
NEXT
' convert monster inventory
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen
   GET 1, Temp!, OldMonsterRecord
   FOR Temp2 = 1 TO 5
      Var = OldMonsterRecord.Treasure(Temp2)
      IF Var > False THEN
         GET 4, Var, OldTreasureRecord
         Var2 = OldTreasureRecord.Charges
         MessWorkRecord.Index = Temp!
         MessWorkRecord.User = Var
         MessWorkRecord.Charges = Var2
         MessWorkRecord.Plus = False
         MessWorkRecord.Room = SFalse
         GET 2, Temp!, NewMonsterRecord
         VarZ! = LOF(3) / MessWorkRecLen + 1!
         IF NewMonsterRecord.First = SFalse THEN
            NewMonsterRecord.First = VarZ!
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
            MessWorkRecord.Prev = SFalse
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
         ELSE
            MessWorkRecord.Prev = NewMonsterRecord.Last
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
            GET 3, NewMonsterRecord.Last, MessWorkRecord
            MessWorkRecord.Next = VarZ!
            PUT 3, NewMonsterRecord.Last, MessWorkRecord
            GET 3, VarZ!, MessWorkRecord
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
         END IF
      END IF
   NEXT
NEXT
PRINT "Monsters:"; Temp! - 1!
END IF
EndLoop5:
' convert monster talk strings
CLOSE
Filename1 = Var1$ + "\MONTALK.DAT"
Filename2 = Var2$ + "\" + MontalkFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = BufferRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = BufferRecLen
IF LOF(1) / BufferRecLen > False THEN
FOR Temp1 = 1 TO LOF(1) / BufferRecLen
   GET 1, Temp1, BufferRecord
   PUT 2, Temp1, BufferRecord
NEXT
END IF
' convert nonplayers
CLOSE
Filename1 = Var1$ + "\NONPLYRS.DAT"
Filename2 = Var2$ + "\" + NonplyrsFilename2$
Filename3 = Var2$ + "\" + MonInvFilename2$
Filename4 = Var1$ + "\TREASURE.DAT"
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonsterRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonsterRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = OldTreasureRecLen
IF LOF(1) / OldMonsterRecLen > False THEN
Temp! = LOF(1) / OldMonsterRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad nonplayer file record length."
   Temp! = SFalse
   GOTO EndLoop6
END IF
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen
   GET 1, Temp!, OldMonsterRecord
   NewMonsterRecord.MonsterName = OldMonsterRecord.MonsterName
   NewMonsterRecord.PluralName = OldMonsterRecord.PluralName
   NewMonsterRecord.Experience = OldMonsterRecord.Experience
   If OldMonsterRecord.Gold=0 Then
      NewMonsterRecord.Gold = 10
   Else
      NewMonsterRecord.Gold = OldMonsterRecord.Gold
   Endif
   NewMonsterRecord.NumberAppearing = OldMonsterRecord.NumberAppearing
   NewMonsterRecord.Level = OldMonsterRecord.Level
   NewMonsterRecord.Hits = OldMonsterRecord.Hits
   NewMonsterRecord.Poison = OldMonsterRecord.Poison
   NewMonsterRecord.LevelDrain = OldMonsterRecord.LevelDrain
   NewMonsterRecord.Spell = OldMonsterRecord.Spell
   NewMonsterRecord.Block = OldMonsterRecord.Block
   NewMonsterRecord.Prevent = OldMonsterRecord.Prevent
   NewMonsterRecord.Follow = OldMonsterRecord.Follow
   NewMonsterRecord.Magic = OldMonsterRecord.Magic
   NewMonsterRecord.Jail = OldMonsterRecord.Jail
   NewMonsterRecord.TeleportPercent = False
   NewMonsterRecord.FollowPercent = OldMonsterRecord.FollowPercent
   NewMonsterRecord.BlockPercent = OldMonsterRecord.BlockPercent
   NewMonsterRecord.PreventPercent = OldMonsterRecord.PreventPercent
   NewMonsterRecord.SpellPercent = OldMonsterRecord.SpellPercent
   NewMonsterRecord.PoisonPercent = OldMonsterRecord.PoisonPercent
   NewMonsterRecord.DrainPercent = OldMonsterRecord.DrainPercent
   NewMonsterRecord.Rate = OldMonsterRecord.Rate
   NewMonsterRecord.RatePercent = OldMonsterRecord.RatePercent
   NewMonsterRecord.Permanent = OldMonsterRecord.Permanent
   FOR Temp2 = 1 TO 5
      NewMonsterRecord.Talk(Temp2) = OldMonsterRecord.Talk(Temp2)
   NEXT
   NewMonsterRecord.Psionic = OldMonsterRecord.Psionic
   NewMonsterRecord.PsionicSpell = OldMonsterRecord.PsionicSpell
   NewMonsterRecord.Equation = False
   NewMonsterRecord.MonsterEquate = Nul
   NewMonsterRecord.MonsterSurprise = Nul
   NewMonsterRecord.MonsterSavingThrow = Nul
   NewMonsterRecord.Prefix1 = Nul
   If NewMonsterRecord.Level>=10 Then
      NewMonsterRecord.Prefix1 = Strng3 + "FB"
   Else
      If NewMonsterRecord.Spell Then
         NewMonsterRecord.Prefix1 = Strng3 + "FA"
      Else
         NewMonsterRecord.Prefix1 = Strng3 + "F9"
      Endif
   Endif
   NewMonsterRecord.First = SFalse
   NewMonsterRecord.Last = SFalse
   NewMonsterRecord.Weapon = SFalse
   NewMonsterRecord.Shield = SFalse
   NewMonsterRecord.Armor = Sfalse
   NewMonsterRecord.PerMonster=0
   NewMonsterRecord.TalkGold=0
   NewMonsterRecord.TalkGoldTimes=0
   NewMonsterRecord.TalkGoldPercent=0
   NewMonsterRecord.TalkItem=0
   NewMonsterRecord.TalkItemTimes=0
   NewMonsterRecord.TalkItemPercent=0
   NewMonsterRecord.TalkMoveDirection=0
   PUT 2, Temp!, NewMonsterRecord
NEXT
' convert nonplayer inventory
FOR Temp! = 1! TO LOF(1) / OldMonsterRecLen
   GET 1, Temp!, OldMonsterRecord
   FOR Temp2 = 1 TO 5
      Var = OldMonsterRecord.Treasure(Temp2)
      IF Var > False THEN
         GET 4, Var, OldTreasureRecord
         Var2 = OldTreasureRecord.Charges
         MessWorkRecord.Index = -Temp!
         MessWorkRecord.User = Var
         MessWorkRecord.Charges = Var2
         MessWorkRecord.Plus = False
         MessWorkRecord.Room = SFalse
         GET 2, Temp!, NewMonsterRecord
         VarZ! = LOF(3) / MessWorkRecLen + 1!
         IF NewMonsterRecord.First = SFalse THEN
            NewMonsterRecord.First = VarZ!
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
            MessWorkRecord.Prev = SFalse
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
         ELSE
            MessWorkRecord.Prev = NewMonsterRecord.Last
            MessWorkRecord.Next = SFalse
            PUT 3, VarZ!, MessWorkRecord
            GET 3, NewMonsterRecord.Last, MessWorkRecord
            MessWorkRecord.Next = VarZ!
            PUT 3, NewMonsterRecord.Last, MessWorkRecord
            GET 3, VarZ!, MessWorkRecord
            NewMonsterRecord.Last = VarZ!
            PUT 2, Temp!, NewMonsterRecord
         END IF
      END IF
   NEXT
NEXT
PRINT "Nonplayers:"; Temp! - 1!
END IF
EndLoop6:
' convert monster classes
CLOSE
Filename1 = Var1$ + "\MONCLASS.DAT"
Filename2 = Var2$ + "\" + MonclassFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldMonClassRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonClassRecLen
IF LOF(1) / OldMonClassRecLen > False THEN
Temp! = LOF(1) / OldMonClassRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad monclass file record length."
   Temp! = SFalse
   GOTO EndLoop7
END IF
FOR Temp! = 1! TO LOF(1) / OldMonClassRecLen
   GET 1, Temp!, OldMonClassRecord
   FOR Temp2 = 1 TO 10
      NewMonClassRecord.Monsters(Temp2) = OldMonClassRecord.Monsters(Temp2)
   NEXT
   PUT 2, Temp!, NewMonClassRecord
NEXT
PRINT "Monclass:"; Temp! - 1!
END IF
EndLoop7:
' convert rooms
CLOSE
Filename1 = Var1$ + "\ROOMS.DAT"
Filename2 = Var2$ + "\" + RoomFilename2$
Filename3 = Var2$ + "\" + RoomInvFilename2$
Filename4 = Var2$ + "\" + RoomDescFilename2$
Filename5 = Var2$ + "\" + ObjectFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
IF DIR$(Filename4) <> Nul THEN
   KILL Filename4
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldRoomRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewRoomRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = BufferRecLen
OPEN Filename5 FOR RANDOM SHARED AS #5 LEN = NewObjectRecLen
IF LOF(1) / OldRoomRecLen > False THEN
Temp! = LOF(1) / OldRoomRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad room file record length."
   Temp! = SFalse
   GOTO EndLoop8
END IF
FOR Temp! = 1! TO LOF(1) / OldRoomRecLen
   GET 1, Temp!, OldRoomRecord
   NewRoomRecord.Action = OldRoomRecord.Action
   NewRoomRecord.Custom1 = Nul
   NewRoomRecord.Custom2 = Nul
   FOR Temp2 = 1 TO 12
      NewRoomRecord.Direct(Temp2) = OldRoomRecord.Direct(Temp2)
   NEXT
   NewRoomRecord.Direct(13) = SFalse
   NewRoomRecord.Direct(14) = SFalse
   FOR Temp2 = 1 TO 19
      NewRoomRecord.LongDesc(Temp2) = SFalse
   NEXT
   FOR Temp2 = 1 TO 5
      Var$ = OldRoomRecord.LongDesc(Temp2)
      Var$ = LTRIM$(Var$)
      Var$ = RTRIM$(Var$)
      IF LEN(Var$) THEN
         Temp3! = LOF(4) / BufferRecLen + 1
         BufferRecord.Buffer = Var$
         PUT 4, Temp3!, BufferRecord
         NewRoomRecord.LongDesc(Temp2) = Temp3!
      END IF
   NEXT
   IF Temp! = 1! THEN
      NewRoomRecord.MonClass = False
   ELSE
      NewRoomRecord.MonClass = OldRoomRecord.MonsterClass
   END IF
   NewRoomRecord.ShortDesc = OldRoomRecord.ShortDesc
   NewRoomRecord.First = SFalse
   NewRoomRecord.Last = SFalse
   NewRoomRecord.First2 = SFalse
   NewRoomRecord.Last2 = SFalse
   PUT 2, Temp!, NewRoomRecord
   ' convert room inventory
   FOR Temp2 = 1 TO 20
      Var1 = OldRoomRecord.Object(Temp2)
      VarY = False' no object charges
      VarY2 = False' no hidden objects
      IF Var1 THEN
         VarX! = -ABS(Var1)
         GOSUB Add.List.Item
         ' store object room number
         VarX! = ABS(Var1)
         GET 5, VarX!, NewObjectRecord
         If NewObjectRecord.InitRoom = 0! Then
            NewObjectRecord.InitRoom = Temp!
         Else
            If NewObjectRecord.InitRoom2 = 0! Then
               NewObjectRecord.InitRoom2 = Temp!
            Endif
         Endif
         PUT 5, VarX!, NewObjectRecord
      END IF
   NEXT
   FOR Temp2 = 1 TO 20
      Var1 = OldRoomRecord.Treasure(Temp2)
      VarY = OldRoomRecord.TreCharges(Temp2)
      VarY2 = OldRoomRecord.Flags(Temp2)
      IF Var1 THEN
         VarX! = ABS(Var1)
         GOSUB Add.List.Item
      END IF
   NEXT
NEXT
PRINT "Rooms:"; Temp! - 1!
END IF
EndLoop8:
' convert users
IF Ignore.User THEN
   GOTO EndLoop9
END IF
CLOSE
Filename1 = Var1$ + "\USERS.DAT"
Filename2 = Var2$ + "\" + UsersFilename2$
Filename3 = Var2$ + "\" + CtnInvFilename2$
Filename4 = Var2$ + "\" + UserInvFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
IF DIR$(Filename4) <> Nul THEN
   KILL Filename4
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldUserRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewUserRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = MessWorkRecLen
IF LOF(1) / OldUserRecLen > False THEN
Temp! = LOF(1) / OldUserRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad user file record length."
   Temp! = SFalse
   GOTO EndLoop9
END IF
FOR Temp! = 1! TO LOF(1) / OldUserRecLen
   GET 1, Temp!, OldUserRecord
   Var$ = OldUserRecord.CodeName
   CALL Decrypt(Var$)
   Var$=Rtrim$(Var$)
   Do
      Var=Instr(Var$," ")
      If Var=0 Then
         Exit Do
      Endif
      Mid$(Var$,Var,1)="_"
   Loop
   NewUserRecord.CodeName = Var$
   Var$ = OldUserRecord.Password
   CALL Decrypt(Var$)
   Var$ = LTRIM$(Var$)
   Var$ = RTRIM$(Var$)
   Var$ = UCASE$(Var$)
   CALL Cryptograph(Var$)
   NewUserRecord.Password = Var$
   Var$ = OldUserRecord.ClassName
   CALL Decrypt(Var$)
   NewUserRecord.ClassName = Var$
   NewUserRecord.PassWord2 = Nul
   NewUserRecord.Question = Nul
   NewUserRecord.Answer = Nul
   NewUserRecord.PassWord3 = Nul
   NewUserRecord.DateOn = DATES$
   NewUserRecord.ClassType = OldUserRecord.ClassType
   FOR Temp2 = 1 TO 7
      NewUserRecord.Stats(Temp2) = OldUserRecord.Stats(Temp2)
   NEXT
   FOR Temp2 = 1 TO 10
      NewUserRecord.Weapon(Temp2).Index = SFalse
      NewUserRecord.Weapon(Temp2).Charges = False
      NewUserRecord.Weapon(Temp2).Plus = False
   NEXT
   FOR Temp2 = 1 TO 4
      NewUserRecord.Weapons(Temp2) = OldUserRecord.Weapons(Temp2)
   NEXT
   NewUserRecord.Room = OldUserRecord.Room
   NewUserRecord.Level = OldUserRecord.Level
   NewUserRecord.Experience = OldUserRecord.Experience
   NewUserRecord.Gold = OldUserRecord.Gold
   NewUserRecord.NumCalls = OldUserRecord.NumCalls
   NewUserRecord.Fatigue = OldUserRecord.Fatigue
   NewUserRecord.FatigueMax = OldUserRecord.FatigueMax
   NewUserRecord.Vitality = OldUserRecord.Vitality
   NewUserRecord.VitalityMax = OldUserRecord.VitalityMax
   NewUserRecord.Magic = OldUserRecord.Magic
   NewUserRecord.MagicMax = OldUserRecord.MagicMax
   NewUserRecord.Poison = OldUserRecord.Poison
   NewUserRecord.Borrow = False
   NewUserRecord.Invisible = OldUserRecord.Invisible
   NewUserRecord.Race = OldUserRecord.Race
   NewUserRecord.Proficiency = OldUserRecord.Proficiency
   NewUserRecord.Bank = OldUserRecord.Bank
   TotalBank = TotalBank + OldUserRecord.Bank
   NewUserRecord.PlayersKilled = False
   NewUserRecord.MonstersKilled = OldUserRecord.MonstersKilled
   NewUserRecord.Brief = OldUserRecord.Brief
   NewUserRecord.Beauty = OldUserRecord.Beauty
   NewUserRecord.Glamour = OldUserRecord.Glamour
   NewUserRecord.Psionic = OldUserRecord.Psionic
   NewUserRecord.PsionicMax = OldUserRecord.PsionicMax
   NewUserRecord.Align1 = OldUserRecord.Align1
   NewUserRecord.Align2 = OldUserRecord.Align2
   NewUserRecord.Flags = OldUserRecord.Flags
   NewUserRecord.Flags2 = False
   NewUserRecord.MaxCalls = OldUserRecord.MaxCalls
   NewUserRecord.FromHour = OldUserRecord.FromHour
   NewUserRecord.FromMin = OldUserRecord.FromMin
   NewUserRecord.ToHour = OldUserRecord.ToHour
   NewUserRecord.ToMin = OldUserRecord.ToMin
   NewUserRecord.SortInv = False
   NewUserRecord.TimeUsed = SFalse
   NewUserRecord.TimeLimit = SFalse
   NewUserRecord.Hidden = False
   NewUserRecord.Encumbrance = 10
   NewUserRecord.TimesLogon = 0#
   NewUserRecord.TimesDied = 0#
   NewUserRecord.Prefix1 = ""
   NewUserRecord.Prefix2 = ""
   NewUserRecord.Prefix3 = ""
   For Temp2=1 to 8
      NewUserRecord.ShortcutKey1(Temp2)=""
      NewUserRecord.ShortcutKey2(Temp2)=""
   Next
   For Temp2=1 To 10
      NewUserRecord.FunctionKeys(Temp2)=""
   Next
   NewUserRecord.ActionLineString = ""
   NewUserRecord.StatusLineString = ""
   NewUserRecord.StatusVar = 0
   NewUserRecord.First = SFalse
   NewUserRecord.Last = SFalse
   NewUserRecord.First2 = SFalse
   NewUserRecord.Last2 = SFalse
   NewUserRecord.NodeList=String$(127,"1")
   NewUserRecord.NodeList2=0!
   NewUserRecord.EditList=0!
   PUT 2, Temp!, NewUserRecord
   ' convert user inventory
   FOR Temp2 = 1 TO 20
      Var1 = OldUserRecord.Inv(Temp2)
      VarY = OldUserRecord.Charges(Temp2)
      IF Var1 THEN
         VarX! = ABS(Var1)
         GOSUB Add.List.Item2
      END IF
   NEXT
   FOR Temp2 = 1 TO 20
      Var1 = OldUserRecord.Object(Temp2)
      VarY = OldUserRecord.ObjCharges(Temp2)
      IF Var1 THEN
         VarX! = -ABS(Var1)
         GOSUB Add.List.Item2
      END IF
   NEXT
NEXT
PRINT "Users:"; Temp! - 1!
END IF
EndLoop9:
TempX! = SFalse
' convert room containers
CLOSE
Filename1 = Var1$ + "\ROOMS.DAT"
Filename2 = Var2$ + "\" + ContainerFilename2$
Filename3 = Var2$ + "\" + CtnInvFilename2$
Filename4 = Var2$ + "\" + RoomFilename2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldRoomRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewContainerRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = NewRoomRecLen
IF LOF(1) / OldRoomRecLen > False THEN
Temp! = LOF(1) / OldRoomRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad room file for containers record length."
   Temp! = SFalse
   GOTO EndLoop10
END IF
FOR Temp! = 1! TO LOF(1) / OldRoomRecLen
   GET 4, Temp!, NewRoomRecord
   NewRoomRecord.First2 = SFalse
   NewRoomRecord.Last2 = SFalse
   PUT 4, Temp!, NewRoomRecord
   GET 1, Temp!, OldRoomRecord
   OldContainerRecord = OldRoomRecord.Container
   Var$ = OldContainerRecord.ContainerName
   Var$ = RTRIM$(Var$)
   IF LEN(Var$) THEN
      TempX! = TempX! + 1!
      NewContainerRecord.ContainerName = OldContainerRecord.ContainerName
      NewContainerRecord.ContainerShort = OldContainerRecord.ShortName
      NewContainerRecord.NamePrefix = "in it"
      NewContainerRecord.ContainerMax = 10
      NewContainerRecord.Closed = OldContainerRecord.Closed
      NewContainerRecord.Locked = OldContainerRecord.Locked
      NewContainerRecord.KeyNumber = Csng(OldContainerRecord.Keyed)
      NewContainerRecord.UserNumber = SFalse
      NewContainerRecord.RoomNumber = Temp!
      NewContainerRecord.DeletedContainer = False
      NewContainerRecord.InvisibleContainer = False
      NewContainerRecord.Weight = 1
      NewContainerRecord.WithinContainer = SFalse
      NewContainerRecord.Disappears = SFalse
      NewContainerRecord.ContainerIndex = SFalse
      NewContainerRecord.Size = False
      NewContainerRecord.Material = False
      NewContainerRecord.Permanent = False
      NewContainerRecord.SelfImplodes = False
      NewContainerRecord.Prefix1 = Strng3 + "FE"
      NewContainerRecord.SwapFlag = False
      NewContainerRecord.Damaged = False
      NewContainerRecord.First2 = SFalse
      NewContainerRecord.Last2 = SFalse
      NewContainerRecord.First = SFalse
      NewContainerRecord.Last = SFalse
      Temp3! = LOF(2) / NewContainerRecLen + 1!
      ' add container to rooms.dat list
      IF NewRoomRecord.First2 = SFalse THEN
         NewRoomRecord.First2 = Temp3!
         NewRoomRecord.Last2 = Temp3!
         PUT 4, Temp!, NewRoomRecord
         NewContainerRecord.Prev = SFalse
         NewContainerRecord.Next = SFalse
         PUT 2, Temp3!, NewContainerRecord
      ELSE
         NewContainerRecord.Prev = NewRoomRecord.Last2
         NewContainerRecord.Next = SFalse
         PUT 2, Temp3!, NewContainerRecord
         GET 2, NewRoomRecord.Last2, NewContainerRecord
         NewContainerRecord.Next = Temp3!
         PUT 2, NewRoomRecord.Last2, NewContainerRecord
         GET 2, Temp3!, NewContainerRecord
         NewRoomRecord.Last2 = Temp3!
         PUT 4, Temp!, NewRoomRecord
      END IF
      ' convert all inventory
      FOR Temp4 = 1 TO 5
         Var1 = OldContainerRecord.Inventory(Temp4)
         Var2 = OldContainerRecord.Charges(Temp4)
         IF Var1 THEN
            GOSUB Add.List.Item3
         END IF
      NEXT
   END IF
NEXT
PRINT "Room containers:"; TempX!
END IF
EndLoop10:
TempX! = SFalse
' convert user containers
IF Ignore.User THEN
   GOTO EndLoop11
END IF
CLOSE
Filename1 = Var1$ + "\USERS.DAT"
Filename2 = Var2$ + "\" + ContainerFilename2$
Filename3 = Var2$ + "\" + CtnInvFilename2$
Filename4 = Var2$ + "\" + UsersFilename2$
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldUserRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewContainerRecLen
OPEN Filename3 FOR RANDOM SHARED AS #3 LEN = MessWorkRecLen
OPEN Filename4 FOR RANDOM SHARED AS #4 LEN = NewUserRecLen
IF LOF(1) / OldUserRecLen > False THEN
Temp! = LOF(1) / OldUserRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad user file for containers record length."
   Temp! = SFalse
   GOTO EndLoop11
END IF
FOR Temp! = 1! TO LOF(1) / OldUserRecLen
   GET 4, Temp!, NewUserRecord
   NewUserRecord.First2 = SFalse
   NewUserRecord.Last2 = SFalse
   PUT 4, Temp!, NewUserRecord
   GET 1, Temp!, OldUserRecord
   FOR Temp2 = 1 TO 3
      OldContainerRecord = OldUserRecord.Container(Temp2)
      Var$ = OldContainerRecord.ContainerName
      Var$ = RTRIM$(Var$)
      IF LEN(Var$) THEN
         TempX! = TempX! + 1!
         NewContainerRecord.ContainerName = OldContainerRecord.ContainerName
         NewContainerRecord.ContainerShort = OldContainerRecord.ShortName
         NewContainerRecord.NamePrefix = "in it"
         NewContainerRecord.ContainerMax = 10
         NewContainerRecord.Closed = OldContainerRecord.Closed
         NewContainerRecord.Locked = OldContainerRecord.Locked
         NewContainerRecord.KeyNumber = Csng(OldContainerRecord.Keyed)
         NewContainerRecord.UserNumber = Temp!
         NewContainerRecord.RoomNumber = SFalse
         NewContainerRecord.DeletedContainer = False
         NewContainerRecord.InvisibleContainer = False
         NewContainerRecord.Weight = 1
         NewContainerRecord.WithinContainer = SFalse
         NewContainerRecord.Disappears = SFalse
         NewContainerRecord.ContainerIndex = SFalse
         NewContainerRecord.Size = False
         NewContainerRecord.Material = False
         NewContainerRecord.Permanent = False
         NewContainerRecord.SelfImplodes = False
         NewContainerRecord.Prefix1 = Strng3 + "FE"
         NewContainerRecord.SwapFlag = False
         NewContainerRecord.Damaged = False
         NewContainerRecord.First2 = SFalse
         NewContainerRecord.Last2 = SFalse
         NewContainerRecord.First = SFalse
         NewContainerRecord.Last = SFalse
         Temp3! = LOF(2) / NewContainerRecLen + 1!
         ' add container to users.dat list
         IF NewUserRecord.First2 = SFalse THEN
            NewUserRecord.First2 = Temp3!
            NewUserRecord.Last2 = Temp3!
            PUT 4, Temp!, NewUserRecord
            NewContainerRecord.Prev = SFalse
            NewContainerRecord.Next = SFalse
            PUT 2, Temp3!, NewContainerRecord
         ELSE
            NewContainerRecord.Prev = NewUserRecord.Last2
            NewContainerRecord.Next = SFalse
            PUT 2, Temp3!, NewContainerRecord
            GET 2, NewUserRecord.Last2, NewContainerRecord
            NewContainerRecord.Next = Temp3!
            PUT 2, NewUserRecord.Last2, NewContainerRecord
            GET 2, Temp3!, NewContainerRecord
            NewUserRecord.Last2 = Temp3!
            PUT 4, Temp!, NewUserRecord
         END IF
         ' convert all inventory
         FOR Temp4 = 1 TO 5
            Var1 = OldContainerRecord.Inventory(Temp4)
            Var2 = OldContainerRecord.Charges(Temp4)
            IF Var1 THEN
               GOSUB Add.List.Item3
            END IF
         NEXT
      END IF
   NEXT
NEXT
PRINT "User containers:"; TempX!
END IF
EndLoop11:
' convert messages
Var2$ = DataPath2$
CLOSE
Filename1 = Var1$ + "\MESSAGES.DAT"
Filename2 = Var2$ + "\" + PublicFilename2$ + ".DAT"
Filename3 = Var2$ + "\" + PublicFilename2$ + ".NEW"
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
IF DIR$(Filename3) <> Nul THEN
   KILL Filename3
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = BufferRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = BufferRecLen
IF LOF(1) / BufferRecLen > False THEN
Temp! = LOF(1) / BufferRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad message file record length."
   Temp! = SFalse
   GOTO EndLoop12
END IF
FOR Temp! = 1! TO LOF(1) / BufferRecLen
   GET 1, Temp!, BufferRecord
   Var$ = BufferRecord.Buffer
   CALL Decrypt(Var$)
   CALL Valid(Var$, 80)
   CALL Crypto(Var$)
   BufferRecord.Buffer = Var$
   PUT 2, Temp!, BufferRecord
NEXT
END IF
EndLoop12:
' convert message table
CLOSE
Filename1 = Var1$ + "\MSGTABLE.DAT"
Filename2 = Var2$ + "\" + PublicFilename2$ + ".TBL"
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = OldTableRecLen
OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewTableRecLen
IF LOF(1) / OldTableRecLen > False THEN
Temp! = LOF(1) / OldTableRecLen
IF INT(Temp!) <> Temp! THEN
   PRINT "Bad message file record length."
   Temp! = SFalse
   GOTO EndLoop13
END IF
FOR Temp! = 1! TO LOF(1) / OldTableRecLen
   GET 1, Temp!, OldTableRecord
   NewTableRecord.ClassType = OldTableRecord.ClassType
   NewTableRecord.Clock = OldTableRecord.Clock
   NewTableRecord.Date = OldTableRecord.Date
   NewTableRecord.Flags = OldTableRecord.Flags
   NewTableRecord.From = OldTableRecord.From
   NewTableRecord.Killed = OldTableRecord.Killed
   NewTableRecord.Length = OldTableRecord.Length
   NewTableRecord.Private = OldTableRecord.Private
   NewTableRecord.Received = OldTableRecord.Received
   NewTableRecord.Reply = OldTableRecord.Reply
   NewTableRecord.Start = OldTableRecord.Start
   NewTableRecord.Subject = OldTableRecord.Subject
   NewTableRecord.Thread = OldTableRecord.Thread
   NewTableRecord.Time = OldTableRecord.Time
   NewTableRecord.Timer = OldTableRecord.Timer
   NewTableRecord.TimesRead = OldTableRecord.TimesRead
   NewTableRecord.To = OldTableRecord.To
   PUT 2, Temp!, NewTableRecord
NEXT
PRINT "Messages:"; Temp! - 1!
END IF
EndLoop13:
' delete remaining data files
Var2$ = DataPath1$
Filename2 = Var2$ + "\" + TeamFileName2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
Filename2 = Var2$ + "\" + TeamInvFileName2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF
Filename2 = Var2$ + "\" + BankFileName2$
IF DIR$(Filename2) <> Nul THEN
   KILL Filename2
END IF

' write bank balance
Close #1
Open FileName2 For Random Shared As #1 Len=BankRecLen
BankRecord.UserIndex = -1
BankRecord.DatePost = DateS$
BankRecord.TimePost = Format$(Now,"hh:mm:ss")
BankRecord.Balance = TotalBank
BankRecord.PostAmount = 0#
BankRecord.PostType = "A"
BankRecord.PostSubType = "A"
BankRecord.PostSubType2 = 0
BankRecord.From = ""
BankRecord.To = ""
Put 1, 1, BankRecord
Close #1

' calculate monster armament
Var2$ = DataPath1$
Filename1 = Var2$ + "\" + TreasureFilename2$
Filename2 = Var2$ + "\" + MonstersFilename2$
Call MonsterArms

' end conversion process
Color 15, 0
Print "Conversion successful."
COLOR 7, 0
PRINT "Exiting to system:"
END

Add.List.Item:
 ' dnddoor has invisible objects & treasure in room.
 ' dndbbs only has invisible treasure.
 VarZ! = LOF(3) / MessWorkRecLen + 1!
 MessWorkRecord.Room = Temp!
 MessWorkRecord.User = SFalse
 MessWorkRecord.Index = VarX!
 MessWorkRecord.Charges = VarY
 MessWorkRecord.Plus = VarY2
 IF NewRoomRecord.First = SFalse THEN
    NewRoomRecord.First = VarZ!
    NewRoomRecord.Last = VarZ!
    PUT 2, Temp!, NewRoomRecord
    MessWorkRecord.Prev = SFalse
    MessWorkRecord.Next = SFalse
    PUT 3, VarZ!, MessWorkRecord
    RETURN
 END IF
 MessWorkRecord.Prev = NewRoomRecord.Last
 MessWorkRecord.Next = SFalse
 PUT 3, VarZ!, MessWorkRecord
 GET 3, NewRoomRecord.Last, MessWorkRecord
 MessWorkRecord.Next = VarZ!
 PUT 3, NewRoomRecord.Last, MessWorkRecord
 GET 3, VarZ!, MessWorkRecord
 NewRoomRecord.Last = VarZ!
 PUT 2, Temp!, NewRoomRecord
 RETURN

Add.List.Item2:
 ' neither dnddoor or dndbbs has invisible user inventory.
 VarZ! = LOF(4) / MessWorkRecLen + 1!
 MessWorkRecord.Room = SFalse
 MessWorkRecord.User = Temp!
 MessWorkRecord.Index = VarX!
 MessWorkRecord.Charges = VarY
 MessWorkRecord.Plus = False
 IF NewUserRecord.First = SFalse THEN
    NewUserRecord.First = VarZ!
    NewUserRecord.Last = VarZ!
    PUT 2, Temp!, NewUserRecord
    MessWorkRecord.Prev = SFalse
    MessWorkRecord.Next = SFalse
    PUT 4, VarZ!, MessWorkRecord
    RETURN
 END IF
 MessWorkRecord.Prev = NewUserRecord.Last
 MessWorkRecord.Next = SFalse
 PUT 4, VarZ!, MessWorkRecord
 GET 4, NewUserRecord.Last, MessWorkRecord
 MessWorkRecord.Next = VarZ!
 PUT 4, NewUserRecord.Last, MessWorkRecord
 GET 4, VarZ!, MessWorkRecord
 NewUserRecord.Last = VarZ!
 PUT 2, Temp!, NewUserRecord
 RETURN

Add.List.Item3:
 ' dnddoor has no invisible containers.
 VarZ! = LOF(3) / MessWorkRecLen + 1!
 MessWorkRecord.Room = SFalse
 MessWorkRecord.User = Var1
 MessWorkRecord.Index = Temp3!
 MessWorkRecord.Charges = Var2
 MessWorkRecord.Plus = False
 IF NewContainerRecord.First = SFalse THEN
    NewContainerRecord.First = VarZ!
    NewContainerRecord.Last = VarZ!
    PUT 2, Temp3!, NewContainerRecord
    MessWorkRecord.Prev = SFalse
    MessWorkRecord.Next = SFalse
    PUT 3, VarZ!, MessWorkRecord
    RETURN
 END IF
 MessWorkRecord.Prev = NewContainerRecord.Last
 MessWorkRecord.Next = SFalse
 PUT 3, VarZ!, MessWorkRecord
 GET 3, NewContainerRecord.Last, MessWorkRecord
 MessWorkRecord.Next = VarZ!
 PUT 3, NewContainerRecord.Last, MessWorkRecord
 GET 3, VarZ!, MessWorkRecord
 NewContainerRecord.Last = VarZ!
 PUT 2, Temp3!, NewContainerRecord
 RETURN

' reads filenames and datapaths from .cfg file for dest. files
Read.Config2:
 IF Node$ = "" THEN
    ConfigFilename$ = Var2$ + "\DND.CFG"
 ELSE
    ConfigFilename$ = Var2$ + "\DND" + Node$ + ".CFG"
 END IF
 IF DIR$(ConfigFilename$) = Nul THEN
    PRINT "Unable to open: "; ConfigFilename$
    PRINT "Exiting to system.."
    COLOR 7, 0
    END
 END IF

 ' dnddoor v5.0a .cfg file
 Strng3 = Nul
 CLOSE
 OPEN ConfigFilename$ FOR INPUT AS #1
 INPUT #1, Var$
 FOR Temp = 1 TO 30
    INPUT #1, Var!
 NEXT
 FOR Temp = 1 TO 160
    INPUT #1, Var
 NEXT
 FOR Temp = 1 TO 100
    LINE INPUT #1, Var$
    Var$ = Ltrim$(Rtrim$(Var$))
    SELECT CASE Temp
    CASE 11 ' datapath1
       DataPath1$ = Var$
       IF RIGHT$(DataPath1$, 1) = "\" THEN
          DataPath1$ = LEFT$(DataPath1$, LEN(DataPath1$) - 1)
       END IF
    CASE 12 ' monclass
       MonclassFilename2$ = Var$
    CASE 13 ' montalk
       MontalkFilename2$ = Var$
    CASE 15 ' .dat
       DataExt2$ = Var$
    CASE 16 ' rooms
       RoomFilename2$ = Var$
    CASE 17 ' objects
       ObjectFilename2$ = Var$
    CASE 18 ' monsters
       MonstersFilename2$ = Var$
    CASE 19 ' treasure
       TreasureFilename2$ = Var$
    CASE 20 ' spells
       SpellsFilename2$ = Var$
    CASE 21 ' users
       UsersFilename2$ = Var$
    CASE 22 ' nonplyrs
       NonplyrsFilename2$ = Var$
    CASE 54 ' mess datapath
       DataPath2$ = Var$
       IF RIGHT$(DataPath2$, 1) = "\" THEN
          DataPath2$ = LEFT$(DataPath2$, LEN(DataPath2$) - 1)
       END IF
    CASE 57 ' teamuser
       TeamFileName2$ = Var$
    CASE 58 ' public
       PublicFilename2$ = Var$
    CASE 59 ' messbase
       MessbaseFilename2$ = Var$
    CASE 60 ' private
       PrivateFilename2$ = Var$
    CASE 71 ' actions
       ActionFilename2$ = Var$
    CASE 80 ' containr
       ContainerFilename2$ = Var$
    CASE 85 ' ansi prefix
       Strng3 = Var$
       If Strng3 = "" Then Strng3 = "{"
    CASE 86 ' userinv
       UserInvFilename2$ = Var$
    CASE 87 ' ctninv
       CtnInvFilename2$ = Var$
    CASE 88 ' teaminv
       TeamInvFileName2$ = Var$
    CASE 89 ' roominv
       RoomInvFilename2$ = Var$
    CASE 90 ' moninv
       MonInvFilename2$ = Var$
    CASE 93 ' roomdesc
       RoomDescFilename2$ = Var$
    CASE 96 ' bank
       BankFileName2$ = Var$
    END SELECT
 NEXT
 ActionFilename2$ = ActionFilename2$ + DataExt2$
 BankFileName2$ = BankFileName2$ + DataExt2$
 MonclassFilename2$ = MonclassFilename2$ + DataExt2$
 MontalkFilename2$ = MontalkFilename2$ + DataExt2$
 RoomFilename2$ = RoomFilename2$ + DataExt2$
 ObjectFilename2$ = ObjectFilename2$ + DataExt2$
 MonstersFilename2$ = MonstersFilename2$ + DataExt2$
 TreasureFilename2$ = TreasureFilename2$ + DataExt2$
 SpellsFilename2$ = SpellsFilename2$ + DataExt2$
 UsersFilename2$ = UsersFilename2$ + DataExt2$
 NonplyrsFilename2$ = NonplyrsFilename2$ + DataExt2$
 MessbaseFilename2$ = MessbaseFilename2$ + DataExt2$
 ContainerFilename2$ = ContainerFilename2$ + DataExt2$
 UserInvFilename2$ = UserInvFilename2$ + DataExt2$
 CtnInvFilename2$ = CtnInvFilename2$ + DataExt2$
 RoomInvFilename2$ = RoomInvFilename2$ + DataExt2$
 MonInvFilename2$ = MonInvFilename2$ + DataExt2$
 RoomDescFilename2$ = RoomDescFilename2$ + DataExt2$
 TeamFileName2$ = TeamFileName2$ + DataExt2$
 TeamInvFileName2$ = TeamInvFileName2$ + DataExt2$
 RETURN

Error.Resume:
 CHDIR Var3$
 COLOR 7, 0
 PRINT "Exiting to system:"
 END

Error.Routine:
 COLOR 15, 0
 SELECT CASE ERR
 CASE 53
    PRINT "File not found."
 CASE 55
    PRINT "File already open."
 CASE 57
    PRINT "Device I/O error."
 CASE 61
    PRINT "Disk full."
 CASE 62
    PRINT "Input past eof."
 CASE 67
    PRINT "Not enough file handles."
 CASE 68
    PRINT "Device unavailable."
 CASE 70
    PRINT "Permission denied."
 CASE 71
    PRINT "Disk not ready."
 CASE 76
    PRINT "Pathname not found."
 CASE ELSE
    PRINT "Untrapped error" + STR$(ERR) + "."
 END SELECT
 RESUME Error.Resume

Sub MonsterArms
 On Local Error Goto ArmsErr
 DIM TempArray1(10, 10) AS Single
 CLOSE
 OPEN Filename1 FOR RANDOM SHARED AS #1 LEN = NewTreasureRecLen
 OPEN Filename2 FOR RANDOM SHARED AS #2 LEN = NewMonsterRecLen
 ' process weapons
 For X = 1 To 10
    For Y = 1 To 10
       TempArray1(X, Y) = 0!
    Next
 Next
 ' store treasure weapons of plus 1-10 in array
 For Z! = 1! To Lof(1)/NewTreasureRecLen
    Get 1, Z!, NewTreasureRecord
    V = NewTreasureRecord.Plus
    If V>0 And V<=10 Then
       IF NewTreasureRecord.WeaponNumber = 7 THEN
          IF NewTreasureRecord.Spell = 0 THEN
             IF NewTreasureRecord.Loadable = 0 THEN
                For L = 1 To 10
                   If TempArray1(V, L) = 0! Then
                      TempArray1(V, L) = Z!
                      Exit For
                   Endif
                Next
             Endif
          Endif
       Endif
    Endif
 Next
 ' check array for blank rows
 For X = 1 To 10
    Z = 0
    For Y = 1 To 10
       If TempArray1(X, Y) > 0! Then
          Z = -1
          Exit For
       Endif
    Next
    If Z = 0 Then ' blank row
       If X = 10 Then
          For Y = 1 To 10
             TempArray1(X, Y) = TempArray1(X - 1, Y)
          Next
       Else
          If X < 10 Then
             For X2 = X + 1 To 10
                Z = 0
                For Y = 1 To 10
                   TempArray1(X, Y) = TempArray1(X2, Y)
                   If TempArray1(X2, Y) > 0! Then
                      Z = -1
                   Endif
                Next
                If Z Then
                   Exit For
                Endif
             Next
          Endif
       Endif
    Endif
 Next
 ' add monster weapons
 For Z! = 1! To Lof(2)/NewMonsterRecLen
    Get 2, Z!, NewMonsterRecord
    V = NewMonsterRecord.Level
    If V > 0 Then
       If V > 10 Then
          V = 10
       Endif
       ' check blank row
       Z = 0
       For Y = 1 To 10
          If TempArray1(V, Y) > 0! Then
             Z = -1
             Exit For
          Endif
       Next
       If Z Then
          ' get random weapon
          NewMonsterRecord.Weapon = 0!
          DO
             Y = INT(RND * 10 + 1)
             IF TempArray1(V, Y) > 0! THEN
                NewMonsterRecord.Weapon = TempArray1(V, Y)
                Put 2, Z!, NewMonsterRecord
                EXIT DO
             END IF
          LOOP
       Endif
    Endif
 Next          
 ' process shields
 For X = 1 To 10
    For Y = 1 To 10
       TempArray1(X, Y) = 0!
    Next
 Next
 ' store treasure shields of plus 1-10 in array
 For Z! = 1! To Lof(1)/NewTreasureRecLen
    Get 1, Z!, NewTreasureRecord
    V = NewTreasureRecord.Plus
    If V>0 And V<=10 Then
       IF NewTreasureRecord.WeaponNumber = 5 THEN
          IF NewTreasureRecord.Spell = 0 THEN
             IF NewTreasureRecord.Loadable = 0 THEN
                For L = 1 To 10
                   If TempArray1(V, L) = 0! Then
                      TempArray1(V, L) = Z!
                      Exit For
                   Endif
                Next
             Endif
          Endif
       Endif
    Endif
 Next
 ' check array for blank rows
 For X = 1 To 10
    Z = 0
    For Y = 1 To 10
       If TempArray1(X, Y) > 0! Then
          Z = -1
          Exit For
       Endif
    Next
    If Z = 0 Then ' blank row
       If X = 10 Then
          For Y = 1 To 10
             TempArray1(X, Y) = TempArray1(X - 1, Y)
          Next
       Else
          If X < 10 Then
             For X2 = X + 1 To 10
                Z = 0
                For Y = 1 To 10
                   TempArray1(X, Y) = TempArray1(X2, Y)
                   If TempArray1(X2, Y) > 0! Then
                      Z = -1
                   Endif
                Next
                If Z Then
                   Exit For
                Endif
             Next
          Endif
       Endif
    Endif
 Next
 ' add monster weapons
 For Z! = 1! To Lof(2)/NewMonsterRecLen
    Get 2, Z!, NewMonsterRecord
    V = NewMonsterRecord.Level
    If V > 0 Then
       If V > 10 Then
          V = 10
       Endif
       ' check blank row
       Z = 0
       For Y = 1 To 10
          If TempArray1(V, Y) > 0! Then
             Z = -1
             Exit For
          Endif
       Next
       If Z Then
          ' get random weapon
          NewMonsterRecord.Shield = 0!
          DO
             Y = INT(RND * 10 + 1)
             IF TempArray1(V, Y) > 0! THEN
                NewMonsterRecord.Shield = TempArray1(V, Y)
                Put 2, Z!, NewMonsterRecord
                EXIT DO
             END IF
          LOOP
       Endif
    Endif
 Next          
 ' process armor
 For X = 1 To 10
    For Y = 1 To 10
       TempArray1(X, Y) = 0!
    Next
 Next
 ' store treasure armor of plus 1-10 in array
 For Z! = 1! To Lof(1)/NewTreasureRecLen
    Get 1, Z!, NewTreasureRecord
    V = NewTreasureRecord.Plus
    If V>0 And V<=10 Then
       IF NewTreasureRecord.WeaponNumber = 1 THEN
          IF NewTreasureRecord.Spell = 0 THEN
             IF NewTreasureRecord.Loadable = 0 THEN
                For L = 1 To 10
                   If TempArray1(V, L) = 0! Then
                      TempArray1(V, L) = Z!
                      Exit For
                   Endif
                Next
             Endif
          Endif
       Endif
    Endif
 Next
 ' check array for blank rows
 For X = 1 To 10
    Z = 0
    For Y = 1 To 10
       If TempArray1(X, Y) > 0! Then
          Z = -1
          Exit For
       Endif
    Next
    If Z = 0 Then ' blank row
       If X = 10 Then
          For Y = 1 To 10
             TempArray1(X, Y) = TempArray1(X - 1, Y)
          Next
       Else
          If X < 10 Then
             For X2 = X + 1 To 10
                Z = 0
                For Y = 1 To 10
                   TempArray1(X, Y) = TempArray1(X2, Y)
                   If TempArray1(X2, Y) > 0! Then
                      Z = -1
                   Endif
                Next
                If Z Then
                   Exit For
                Endif
             Next
          Endif
       Endif
    Endif
 Next
 ' add monster weapons
 For Z! = 1! To Lof(2)/NewMonsterRecLen
    Get 2, Z!, NewMonsterRecord
    V = NewMonsterRecord.Level
    If V > 0 Then
       If V > 10 Then
          V = 10
       Endif
       ' check blank row
       Z = 0
       For Y = 1 To 10
          If TempArray1(V, Y) > 0! Then
             Z = -1
             Exit For
          Endif
       Next
       If Z Then
          ' get random weapon
          NewMonsterRecord.Armor = 0!
          DO
             Y = INT(RND * 10 + 1)
             IF TempArray1(V, Y) > 0! THEN
                NewMonsterRecord.Armor = TempArray1(V, Y)
                Put 2, Z!, NewMonsterRecord
                EXIT DO
             END IF
          LOOP
       Endif
    Endif
 Next          
ArmsResume:
 Exit Sub
ArmsErr:
 Print "MonsterArms() Error";Err
 Resume ArmsResume
End Sub
