REM File: Dndsic4 for Dndbbs Version v5.0a Release r2.0

' get include files
REM $INCLUDE: 'DNDSIC.INC'

Function Form$(Var#)
 Form$=Format$(Var#,"#,##0")
End Function

' Timing functions
Function Timeit!
 t1$ = Format$(Now, "hh:mm:ss") ' seconds past midnight
 t1! = CSNG(INT(VAL(MID$(t1$, 1, 2)))) * 3600! + CSNG(INT(VAL(MID$(t1$, 4, 2)))) * 60! + CSNG(INT(VAL(MID$(t1$, 7, 2))))
 Timeit!=t1!
End Function

Function Time.Elapsed(Start.Time!,Wait.Time!)
 On Local Error Goto Error.Trap8
 Elapsed.Time!=Timeit!-Start.Time!
 If Elapsed.Time!<SFalse Then
    Elapsed.Time!=Elapsed.Time!+86400!
 Endif
 If Elapsed.Time!>=Wait.Time! Then
    Time.Elapsed=True
 Else
    Time.Elapsed=False
 Endif
Error.Resume8:
 Exit Function
Error.Trap8:
 Resume Error.Resume8
End Function

Function FClock$
 FClock$=Format$(Now,"ddd dd mmm yyyy\, hh:mma/p")
End Function

' tests if bytes to store in account exceed account byte limit
FUNCTION AccountLimit (Size#)
 On Local Error Goto Error.Trap11

 ' get total bytes in catalog account
 Program.Data$ = Current.Directory + Account + ".SIC\*.*"
 Bytes# = AsciizCount# (Program.Data$)

 ' compare total bytes in account to bytes to add to account
 IF Bytes# + Size# > CDBL(Max.Limit) * 1024# THEN
    AccountLimit = True
 ELSE
    AccountLimit = False
 END IF
Error.Resume11:
 Exit Function
Error.Trap11:
 Resume Error.Resume11
END FUNCTION

'Metric Suffixes:
'================
'Byte  (B)  - 10^0  '  00x - FFx
'Deka  (DA) - 10^1    Deci  (d)  - 10^-1
'Hecto (H)  - 10^2    Centi (c)  - 10^-2
'Kilo  (K)  - 10^3    Milli (m)  - 10^-3
'Myria (my) - 10^4    Myril (ml) - 10^-4
'Mega  (M)  - 10^6    Micro (mu) - 10^-6
'Giga  (G)  - 10^9    Nano  (n)  - 10^-9
'Tera  (T)  - 10^12   Pico  (p)  - 10^-12
'Peta  (P)  - 10^15   Femto (f)  - 10^-15
'Exa   (E)  - 10^18   Atto  (a)  - 10^-18
'Zetta (Z)  - 10^21   Zepto (z)  - 10^-21
'Yotta (Y)  - 10^24   Yocto (y)  - 10^-24

' formats bytes to a string
FUNCTION ParseSize$ (Temp#)
 On Local Error Goto Error.Trap12
 ' store bytes
 Temp2# = Temp#
 IF Temp2# <= 0# THEN
    ParseSize$ = "0 B."
    EXIT FUNCTION
 END IF

 ' reset type counter
 TempA = False
 ' divide by 1024 until less
 DO
    IF Temp2# >= 1024 THEN
       Temp2# = Temp2# / 1024#
       ' count type
       TempA = TempA + 1
       IF TempA = 8 THEN
          EXIT DO
       END IF
    ELSE
       EXIT DO
    END IF
 LOOP

 ' store type
 Strng2 = Nul
 If TempA>=1 And TempA<=8 Then ' powers of 1024
    Strng2=Mid$("KMGTPEZY",TempA,1)
 Endif

 ' return formatted string
 ParseSize$ = FORMAT$(Temp2#, "#,##0.00") + " " + Strng2 + "B."
Error.Resume12:
 Exit Function
Error.Trap12:
 Resume Error.Resume12
END FUNCTION

' replaces white spaces with blanks,
'   var=true skip blanks in quotes.
FUNCTION TTRIM$(Var$, Var)
 On Local Error Goto Error.Trap13
 VarX$ = Var$
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    FOR Blanks = 1 TO LEN(White.Space)
       IF MID$(VarX$, Temp, 1) = MID$(White.Space, Blanks, 1) THEN
          MID$(VarX$, Temp, 1) = " "
       END IF
    NEXT
 LOOP
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    IF MID$(VarX$, Temp, 2) = "  " THEN
       VarX$ = LEFT$(VarX$, Temp) + MID$(VarX$, Temp + 2)
       Temp = Temp - 1
    END IF
 LOOP
 TTRIM$ = VarX$
Error.Resume13:
 Exit Function
Error.Trap13:
 Resume Error.Resume13
END FUNCTION

' trim whitespaces from string
FUNCTION STRIM$ (Var$)
 On Local Error Goto Error.Trap14
 XVar$ = Var$
 DO
    Blanks = False
    FOR Count = 1 TO LEN(White.Space)
       IF LEFT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
          XVar$ = MID$(XVar$, 2)
          Blanks = True
       END IF
    NEXT
    IF Blanks = False THEN
       EXIT DO
    END IF
 LOOP
 DO
    Blanks = False
    FOR Count = 1 TO LEN(White.Space)
       IF RIGHT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
	  XVar$ = LEFT$(XVar$, LEN(XVar$) - 1)
          Blanks = True
       END IF
    NEXT
    IF Blanks = False THEN
       EXIT DO
    END IF
 LOOP
 STRIM$ = XVar$
Error.Resume14:
 Exit Function
Error.Trap14:
 Resume Error.Resume14
END FUNCTION

' replaces white spaces with nul,
' var = true; skip blanks in quotes
FUNCTION XTRIM$(Var$, Var)
 VarX$ = Var$
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    FOR Blanks = 1 TO LEN(White.Space)
       IF MID$(VarX$, Temp, 1) = MID$(White.Space, Blanks, 1) THEN
          VarX$ = LEFT$(VarX$, Temp - 1) + MID$(VarX$, Temp + 1)
          Temp = Temp - 1
          EXIT FOR
       END IF
    NEXT
 LOOP
 XTRIM$ = VarX$
END FUNCTION

' returns a randomized temporary filename.
' could be constructed from Date/Time.
FUNCTION TempName$
 On Local Error Goto Error.Trap15
 Var$ = Nul
 FOR Temp = 1 TO 8
    Var$ = Var$ + LTRIM$(STR$(INT(RND*9+1)))
 NEXT
 TempName$ = Var$
Error.Resume15:
 Exit Function
Error.Trap15:
 Resume Error.Resume15
END FUNCTION

' prepares program for analyze/run command
SUB Prepare.Program(Var%)
 ' check for storage
 IF Var% Then
    ' find temporary filename
    DO
       Temp.Filename$ = TempName$
       Filename = Temp.Filename$ + ".sc2"
       IF DIR$(Filename) = Nul THEN
          EXIT DO
       END IF
    LOOP
    ' write out current program
    Prepare.Filename = Filename
    CALL Store.Program
 Endif

 ' remove remark at end of line,
 '   search for end of matching double quotes
 '   which might contain a left apostrophe.
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    Out2 = STRIM$(Program(Program.Line))
    IF LEN(Out2) THEN
       Start.Char = 1
       DO
          Quote.Start = False
          FOR Temp = Start.Char TO LEN(Out2)
             IF MID$(Out2, Temp, 1) = CHR$(34) THEN
                Quote.Start = Temp
                EXIT FOR
             END IF
          NEXT
          IF Quote.Start = False THEN
             EXIT DO
          END IF
          Quote.Stop = False
          FOR Temp2 = Quote.Start + 1 TO LEN(Out2)
             IF MID$(Out2, Temp2, 1) = CHR$(34) THEN
                Quote.Stop = Temp2
                EXIT FOR
             END IF
          NEXT
          IF Quote.Stop = False THEN
             EXIT DO
          END IF
          Start.Char = Quote.Stop + 1
       LOOP
       FOR Temp = Start.Char TO LEN(Out2)
          IF MID$(Out2, Temp, 1) = "'" THEN
             Out2 = LEFT$(Out2, Temp - 1)
             EXIT FOR
          END IF
       NEXT
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
          Program(Program.Line) = Out2
       ELSE
          Program(Program.Line) = "REM"
       END IF
    END IF
 NEXT

 ' concatenate line continuation statements,
 '   replace continued lines with REM.
 Program.Line = False
 CALL Count.Lines(Last.Line)
 DO
    Program.Line = Program.Line + 1
    IF Program.Line > Last.Line THEN
       EXIT DO
    END IF
    IF Program.Line > Max.Lines THEN
       EXIT DO
    END IF
    First.Line = Program.Line
    Out2 = STRIM$(Program(Program.Line))
    IF LEN(Out2) THEN
       DO
          IF RIGHT$(Out2, 1) = "_" THEN
             WHILE RIGHT$(Out2, 1) = "_"
                Out2 = LEFT$(Out2, LEN(Out2) - 1)
                Out2 = RTRIM$(Out2)
             WEND
             FOR Next.Line = Program.Line + 1 TO Last.Line
                Out3 = STRIM$(Program(Next.Line))
                IF LEN(Out3) THEN
                   Out2 = Out2 + Out3
                   Program.Line = Next.Line
                   Program(Next.Line) = "REM"
                   EXIT FOR
                END IF
             NEXT
          ELSE
             EXIT DO
          END IF
          Out2 = STRIM$(Out2)
       LOOP
       Program(First.Line) = Out2
    END IF
 LOOP

 ' compress program array,
 '   replaces all white spaces with single space,
 '   replaces all double spaces with single space.
 Program.Line = False
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    Out2 = STRIM$(Program(Program.Line))
    IF LEN(Out2) THEN
       Program(Program.Line) = TTRIM$(Out2, True)
    ELSE
       Program(Program.Line) = Nul
    END IF
 NEXT
END SUB

' indents current .sic program
SUB Indent.Program
 On Local Error Goto Error.Trap15a
 DO While Lost.Carrier=False
    CALL More.Prompt("Indent with tabs or spaces(t/s/q)", "tsq", Output.Char$, "q")
    SELECT CASE Output.Char$
    CASE "t"
       Tabs = True
    CASE "s"
       Tabs = False
    CASE "q"
       EXIT SUB
    END SELECT
    Call Modem.ANSI(4,37,15)
    Call ScreenANSI(4,37,15)
    IF Tabs THEN
       Strng3 = "Enter number of tabs to indent?"
    ELSE
       Strng3 = "Enter number of spaces to indent?"
    END IF
    Call IO.I
    Increment = INT(VAL(Out9))
    IF Increment > False Then
       EXIT DO
    END IF
 LOOP
 IF Lost.Carrier THEN
    EXIT SUB
 END IF
 Indent = False
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    IF Tabs THEN
       Number$ = CHR$(9)
    ELSE
       Number$ = SPACE$(6 - LEN(STR$(Program.Line)))
    END IF
    Out2 = Program(Program.Line)
    Out2 = STRIM$(Out2)
    IF LEN(Out2) THEN
       Temp1$ = STRIM$(Out2)
       Temp1$ = UCASE$(Temp1$)
       Temp1$ = TTRIM$(Temp1$, False)
       Next.Indent = False
       RESTORE Indent.Data
       DO
	  READ Keyword$, KeyIndent
	  IF Keyword$ = "EOF" THEN
	     EXIT DO
	  END IF
	  IF LEFT$(Temp1$, LEN(Keyword$)) = Keyword$ THEN
	     Next.Indent = KeyIndent
	     EXIT DO
	  END IF
       LOOP
       SELECT CASE Next.Indent
       CASE 1
	  Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
	  Indent = Indent + 1
       CASE -1
	  Indent = Indent - 1
	  IF Indent < False THEN
             Strng3 = "Indent error: Line:" + STR$(Program.Line)
             Call IO.O
	     EXIT FOR
	  END IF
	  Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
       CASE -2
	  Indent = Indent - 1
	  IF Indent < False THEN
             Strng3 = "Indent error: Line:" + STR$(Program.Line)
             Call IO.O
	     EXIT FOR
	  END IF
	  Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
	  Indent = Indent + 1
       CASE ELSE
	  Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
       END SELECT
       Out2 = Number$ + Out2
       Program(Program.Line) = Out2
    END IF
 NEXT
 IF Indent <> False THEN
    Strng3 = "Indent error: Line:"+Str$(Program.Line)+"."
 ELSE
    Strng3 = "Program indented."
 END IF
 Call IO.O
Error.Resume15a:
 Exit Sub
Error.Trap15a:
 Resume Error.Resume15a
END SUB

' renumbers current .sic program
SUB Renumber.Program
 On Local Error Goto Error.Trap15b
 DO While Lost.Carrier=False
    Call Modem.ANSI(4,37,15)
    Call ScreenANSI(4,37,15)
    Strng3 = "Starting line number(1-"+Mid$(Str$(Max.Lines),2)+")? "
    Call IO.I
    IF Out9=Nul THEN
       EXIT SUB
    END IF
    Start.Line = INT(VAL(Out9))
    IF Start.Line <= False OR Start.Line > Max.Lines THEN
       Call Modem.ANSI(4,33,14)
       Call ScreenANSI(4,33,14)
       Strng3 = "Bad start line value."
       Call IO.O
    ELSE
       EXIT DO
    END IF
 LOOP
 DO While Lost.Carrier=False
    Call Modem.ANSI(4,37,15)
    Call ScreenANSI(4,37,15)
    Strng3 = "Increment value(1-"+Mid$(Str$(Int(Max.Lines/2)),2)+")? "
    Call IO.I
    IF Out9=Nul THEN
       EXIT SUB
    END IF
    Increment = INT(VAL(Out9))
    IF Increment <= False OR Increment > INT(Max.Lines / 2) THEN
       Call Modem.ANSI(4,33,14)
       Call ScreenANSI(4,33,14)
       Strng3 = "Bad increment value."
       Call IO.O
    ELSE
       EXIT DO
    END IF
 LOOP
 IF Lost.Carrier THEN
    EXIT SUB
 END IF
 CALL Count.Lines(Last.Line)
 Running.Program = Program.Name
 REDIM Renumber.List(1 TO Max.Lines) AS INTEGER
 Filename = "renumber.sc1"
 CALL Store.Program
 New.Line.Number = Start.Line
 FOR Line.Number = 1 TO Last.Line
    ProgramLine$ = Program(Line.Number)
    IF STRIM$(ProgramLine$) <> Nul THEN
       IF New.Line.Number > Max.Lines THEN
          Call Modem.ANSI(4,37,15)
          Call ScreenANSI(4,37,15)
          Strng3 = "Renumber list exceeds " + Form$(Cdbl(Max.Lines)) + " lines."
          Call IO.O
	  ERASE Renumber.List
          CLOSE #TempFile2
          Filename="renumber.sc1"
          If Dir$(Filename)<>"" Then
             Kill Filename
          Endif
	  EXIT SUB
       END IF
       Renumber.List(New.Line.Number) = Line.Number
       New.Line.Number = New.Line.Number + Increment
    END IF
 NEXT
 Strng3 = "Renumbering program."
 Call IO.O
 FOR Line.Number = 1 TO Last.Line
    New.Program.Line$ = Program(Line.Number)
    Old.Program.Line$ = Program(Line.Number)
    Old.Program.Line$ = STRIM$(Old.Program.Line$)
    Old.Program.Line$ = TTRIM$(Old.Program.Line$, True)
    IF Old.Program.Line$ <> Nul THEN
       Line.Renumbered = True
       IF UCASE$(LEFT$(Old.Program.Line$, 7)) = "RESTORE" THEN
          V$ = RTRIM$(MID$(Old.Program.Line$, 8))
          IF LEN(V$) THEN
             IF INT(VAL(V$)) > 0 THEN
                Line.Renumbered = False
                Imbedded = INSTR(UCASE$(New.Program.Line$), "RESTORE") + 7
                GOSUB Next.Space
                Number$ = MID$(Old.Program.Line$, 8)
                Number$ = STRIM$(Number$)
                Old.Line.Number = INT(VAL(Number$))
                IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                   FOR New.Line.Number = 1 TO Max.Lines
                      IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                         Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                         Line.Renumbered = True
                         EXIT FOR
                      END IF
                   NEXT
                END IF
             END IF
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 4)) = "GOTO" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 5)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 13)) = "ON ERROR GOTO" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 14)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 6)) = "RESUME" THEN
	  IF UCASE$(LEFT$(Old.Program.Line$, 15)) <> "RESUME PREVIOUS" THEN
	     IF UCASE$(LEFT$(Old.Program.Line$, 11)) <> "RESUME SAME" THEN
		IF UCASE$(LEFT$(Old.Program.Line$, 11)) <> "RESUME NEXT" THEN
		   Line.Renumbered = False
                   Imbedded = INSTR(UCASE$(New.Program.Line$), "RESUME") + 6
                   GOSUB Next.Space
		   Number$ = MID$(Old.Program.Line$, 7)
		   Number$ = STRIM$(Number$)
		   Old.Line.Number = INT(VAL(Number$))
                   IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                      FOR New.Line.Number = 1 TO Max.Lines
                         IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                            Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                            Line.Renumbered = True
                            EXIT FOR
                         END IF
                      NEXT
                   END IF
		END IF
	     END IF
	  END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 5)) = "GOSUB" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOSUB") + 5
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 6)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 2)) = "ON" THEN
	  IF UCASE$(LEFT$(Old.Program.Line$, 8)) <> "ON ERROR" THEN
	     Line.Renumbered = False
             IF INSTR(UCASE$(Old.Program.Line$), "GOTO") THEN
                Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
                Old.Number1$ = LTRIM$(MID$(New.Program.Line$, Imbedded))
                GOSUB Next.Space
                New.Program.Line1$ = Next.Program.Line$
                Imbedded2 = INSTR(UCASE$(Old.Program.Line$), "GOTO")
                Old.Number2$ = MID$(Old.Program.Line$, Imbedded2 + 4)
		DO
                   Imbedded1 = INSTR(Old.Number1$, ",")
                   IF Imbedded1 THEN
                      New.Number1$ = LEFT$(Old.Number1$, Imbedded1 - 1)
                      Old.Number1$ = MID$(Old.Number1$, Imbedded1 + 1)
		   ELSE
                      New.Number1$ = Old.Number1$
                      Old.Number1$ = Nul
		   END IF
                   IF INSTR(White.Space, MID$(New.Number1$, 1, 1)) THEN
                      Imbedded = 1
                      New.Program.Line$ = New.Number1$
                      GOSUB Next.Space
                      New.Number1$ = Next.Program.Line$
                   ELSE
                      New.Number1$ = Nul
                   END IF
                   Imbedded2 = INSTR(Old.Number2$, ",")
                   IF Imbedded2 THEN
                      New.Number2$ = LEFT$(Old.Number2$, Imbedded2 - 1)
                      Old.Number2$ = MID$(Old.Number2$, Imbedded2 + 1)
		   ELSE
                      New.Number2$ = Old.Number2$
                      Old.Number2$ = Nul
		   END IF
		   Line.Renumbered = False
                   Old.Line.Number = INT(VAL(New.Number2$))
                   IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                      FOR New.Line.Number = 1 TO Max.Lines
                         IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                            New.Program.Line1$ = New.Program.Line1$ + New.Number1$ + LTRIM$(STR$(New.Line.Number)) + ","
                            Line.Renumbered = True
                            EXIT FOR
                         END IF
                      NEXT
                   END IF
                   IF Old.Number2$ = Nul THEN
		      EXIT DO
		   END IF
		   IF Line.Renumbered = False THEN
		      EXIT DO
		   END IF
		LOOP
                IF RIGHT$(New.Program.Line1$, 1) = "," THEN
                   New.Program.Line1$ = LEFT$(New.Program.Line1$, LEN(New.Program.Line1$) - 1)
                END IF
                Program(Line.Number) = New.Program.Line1$
	     ELSE
                IF INSTR(UCASE$(Old.Program.Line$), "GOSUB") THEN
                   Imbedded = INSTR(UCASE$(New.Program.Line$), "GOSUB") + 5
                   Old.Number1$ = LTRIM$(MID$(New.Program.Line$, Imbedded))
                   GOSUB Next.Space
                   New.Program.Line1$ = Next.Program.Line$
                   Imbedded2 = INSTR(UCASE$(Old.Program.Line$), "GOSUB")
                   Old.Number2$ = MID$(Old.Program.Line$, Imbedded2 + 5)
                   DO
                      Imbedded1 = INSTR(Old.Number1$, ",")
                      IF Imbedded1 THEN
                         New.Number1$ = LEFT$(Old.Number1$, Imbedded1 - 1)
                         Old.Number1$ = MID$(Old.Number1$, Imbedded1 + 1)
                      ELSE
                         New.Number1$ = Old.Number1$
                         Old.Number1$ = Nul
                      END IF
                      IF INSTR(White.Space, MID$(New.Number1$, 1, 1)) THEN
                         Imbedded = 1
                         New.Program.Line$ = New.Number1$
                         GOSUB Next.Space
                         New.Number1$ = Next.Program.Line$
                      ELSE
                         New.Number1$ = Nul
                      END IF
                      Imbedded2 = INSTR(Old.Number2$, ",")
                      IF Imbedded2 THEN
                         New.Number2$ = LEFT$(Old.Number2$, Imbedded2 - 1)
                         Old.Number2$ = MID$(Old.Number2$, Imbedded2 + 1)
                      ELSE
                         New.Number2$ = Old.Number2$
                         Old.Number2$ = Nul
                      END IF
                      Line.Renumbered = False
                      Old.Line.Number = INT(VAL(New.Number2$))
                      IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                         FOR New.Line.Number = 1 TO Max.Lines
                            IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                               New.Program.Line1$ = New.Program.Line1$ + New.Number1$ + LTRIM$(STR$(New.Line.Number)) + ","
                               Line.Renumbered = True
                               EXIT FOR
                            END IF
                         NEXT
                      END IF
                      IF Old.Number2$ = Nul THEN
                         EXIT DO
                      END IF
                      IF Line.Renumbered = False THEN
                         EXIT DO
                      END IF
                   LOOP
                   IF RIGHT$(New.Program.Line1$, 1) = "," THEN
                      New.Program.Line1$ = LEFT$(New.Program.Line1$, LEN(New.Program.Line1$) - 1)
                   END IF
                   Program(Line.Number) = New.Program.Line1$
                END IF
	     END IF
	  END IF
       END IF
       IF Line.Renumbered = False THEN
          Call Modem.ANSI(4,37,15)
          Call ScreenANSI(4,37,15)
          Strng3 = "Error renumbering program."
          Call IO.O
	  Filename = "renumber.sc1"
          CALL Read.Program(Var)
          Program.Name = Running.Program
          Call Modem.ANSI(4,37,15)
          Call ScreenANSI(4,37,15)
          Strng3 = "Program reloaded."
          Call IO.O
	  ERASE Renumber.List
          Close
          Filename="renumber.sc1"
          If Dir$(Filename)<>"" Then
             Kill Filename
          Endif
	  EXIT SUB
       END IF
    END IF
 NEXT
 Strng3 = "Resequencing line numbers."
 Call IO.O
 Filename = "renumber.sc1"
 CALL Store.Program
 CLOSE #TempFile2
 OPEN "renumber.sc1" FOR INPUT AS #TempFile2
 CALL New.Program
 WHILE NOT EOF(TempFile2)
    LINE INPUT #TempFile2, New.Program.Line$
    FOR Blanks = 1 TO LEN(White.Space)
       Imbedded = INSTR(New.Program.Line$, MID$(White.Space, Blanks, 1))
       IF Imbedded THEN
          EXIT FOR
       END IF
    NEXT
    Old.Line.Number = INT(VAL(LEFT$(New.Program.Line$, Imbedded - 1)))
    FOR New.Program.Line = 1 TO Max.Lines
       IF Renumber.List(New.Program.Line) = Old.Line.Number THEN
          Program(New.Program.Line) = MID$(New.Program.Line$, Imbedded)
	  EXIT FOR
       END IF
    NEXT
 WEND
 CLOSE
 Filename="renumber.sc1"
 If Dir$(Filename)<>"" Then
    Kill Filename
 Endif
 Program.Name = Running.Program
 Call Modem.ANSI(4,37,15)
 Call ScreenANSI(4,37,15)
 Strng3 = "Program renumbered."
 Call IO.O
 ERASE Renumber.List
 EXIT SUB

' locates string with following white spaces
Next.Space:
 Next.Program.Line$ = New.Program.Line$
 DO
    IF Imbedded >= LEN(Next.Program.Line$) THEN
       EXIT DO
    END IF
    IF INSTR(White.Space, MID$(Next.Program.Line$, Imbedded + 1, 1)) THEN
       Imbedded = Imbedded + 1
    ELSE
       EXIT DO
    END IF
 LOOP
 Next.Program.Line$ = LEFT$(Next.Program.Line$, Imbedded)
 RETURN
Error.Resume15b:
 Exit Sub
Error.Trap15b:
 Strng3="Err:"+Str$(Err)
 Call IO.O
 Resume Error.Resume15b
END SUB

' declares indent structure types
Indent.Data:
 ' 1=indent right
 DATA "SELECTIF CASE", 1
 DATA "DO WHILE", 1
 DATA "DO", 1
 DATA "IF", 1
 DATA "SELECT CASE", 1
 DATA "DO UNTIL", 1
 DATA "FORIF", 1
 DATA "FOR", 1
 DATA "WHILE", 1
 DATA "LOOPIF", 1
 ' -1=indent left
 DATA "ENDIF", -1
 DATA "END IF", -1
 DATA "NEXTIF", -1
 DATA "NEXT", -1
 DATA "LOOP UNTIL", -1
 DATA "LOOP WHILE", -1
 DATA "END SELECT", -1
 DATA "WEND", -1
 DATA "END LOOPIF", -1
 DATA "LOOP", -1
 DATA "END SELECTIF", -1
 ' -2=indent left, then right
 DATA "ELSE", -2
 DATA "CASE", -2
 DATA "EOF", 0

' check validity of program
SUB Analyze.Program
 On Local Error Goto Error.Trap15c
 Call Modem.ANSI(4,37,15)
 Call ScreenANSI(4,37,15)
 CALL Count.Lines(Last.Line)
 Strng3 = "Pass 1: counting matching structures."
 Call IO.O
 RESTORE Analyze.Data1
 FOR Data.Count = 1 TO 8
    READ Start.Structure$, Stop.Structure$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
	  END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
	     Nested.Count = Nested.Count + 1
          END IF
	  IF Start.Structure$ = "IF" THEN
	     IF LEFT$(Temp1$, 6) = "END IF" THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
                   Strng3 = "Analyze error, pass 1: Incomplete " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                   Call IO.O
		   EXIT SUB
		END IF
	     END IF
	  END IF
          IF Stop.Structure$ = "LOOP" THEN
             IF LEFT$(Temp1$, 6) <> "LOOPIF" THEN
                Temp1$ = LEFT$(Temp1$, 4)
             END IF
          END IF
          IF Stop.Structure$ = "NEXT" THEN
             IF LEFT$(Temp1$, 6) <> "NEXTIF" THEN
                Temp1$ = LEFT$(Temp1$, 4)
             END IF
          END IF
          IF Stop.Structure$ = "END SELECT" THEN
             IF LEFT$(Temp1$, 12) <> "END SELECTIF" THEN
                Temp1$ = LEFT$(Temp1$, 10)
             END IF
          END IF
          IF Temp1$ = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
                Strng3 = "Analyze error, pass 1: Incomplete " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                Call IO.O
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 Strng3 = "Pass 2: counting matching imbedded structures."
 Call IO.O
 RESTORE Analyze.Data2
 FOR Data.Count = 1 TO 3
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Nested.Count = Nested.Count + 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded1$)) = Imbedded1$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
                Strng3 =  "Analyze error, pass 2: Incomplete " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                Call IO.O
		EXIT SUB
	     END IF
	     Nested.Count = Nested.Count + 1
	  ELSE
             Temp2$ = Temp1$
             IF Imbedded2$ <> "ELSEIF" THEN
                IF LEFT$(Temp1$, LEN(Imbedded2$)) = Imbedded2$ THEN
                   Imbedded3 = INSTR(Temp1$, " ")
                   IF Imbedded3 = False THEN
                      Strng3 = "Analyze error, pass 2: Bad " + Imbedded2$ + ": Line:" + Str$(Program.Line)
                      Call IO.O
                      EXIT SUB
                   END IF
                   Temp2$ = LEFT$(Temp1$, Imbedded3 - 1)
                END IF
             END IF
             IF Temp2$ = Imbedded2$ THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
                   Strng3 = "Analyze error, pass 2: Incomplete " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                   Call IO.O
		   EXIT SUB
		END IF
		Nested.Count = Nested.Count + 1
	     END IF
	  END IF
	  IF Start.Structure$ = "IF" THEN
	     IF LEFT$(Temp1$, 6) = "END IF" THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
                   Strng3 = "Analyze error, pass 2: Incomplete " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                   Call IO.O
		   EXIT SUB
		END IF
	     END IF
	  END IF
          IF Temp1$ = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
                Strng3 = "Analyze error, pass 2: Incomplete " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                Call IO.O
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 Strng3 = "Pass 3: multipass structure match."
 Call IO.O
 RESTORE Analyze.Data1
 FOR Data.Count = 1 TO 8
    READ Start.Structure$, Stop.Structure$
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
          END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
	     Nested.Count = 1
	     FOR Nested.Lines = Program.Line + 1 TO Last.Line
		Temp2$ = Program(Nested.Lines)
		Temp2$ = STRIM$(Temp2$)
		IF LEN(Temp2$) THEN
		   Temp2$ = STRIM$(Temp2$)
		   Temp2$ = UCASE$(Temp2$)
                   Count.Data2 = False
		   IF LEFT$(Temp2$, LEN(Start.Structure$)) = Start.Structure$ THEN
                      Count.Data2 = True
                   END IF
                   IF Start.Structure$ = "FOR" THEN
                      IF LEFT$(Temp2$, 5) = "FORIF" THEN
                         Count.Data2 = False
                      END IF
                   END IF
                   IF Count.Data2 THEN
		      Nested.Count = Nested.Count + 1
		   END IF
                   IF Stop.Structure$ = "LOOP" THEN
                      IF LEFT$(Temp2$, 6) <> "LOOPIF" THEN
                         Temp2$ = LEFT$(Temp2$, 4)
                      END IF
                   END IF
                   IF Stop.Structure$ = "NEXT" THEN
                      IF LEFT$(Temp2$, 6) <> "NEXTIF" THEN
                         Temp2$ = LEFT$(Temp2$, 4)
                      END IF
                   END IF
                   IF Stop.Structure$ = "END SELECT" THEN
                      IF LEFT$(Temp1$, 12) <> "END SELECTIF" THEN
                         Temp1$ = LEFT$(Temp1$, 10)
                      END IF
                   END IF
                   IF Temp2$ = Stop.Structure$ THEN
		      Nested.Count = Nested.Count - 1
		      IF Nested.Count = False THEN
			 EXIT FOR
		      END IF
		   END IF
		   IF Start.Structure$ = "IF" THEN
		      IF LEFT$(Temp2$, 6) = "END IF" THEN
			 Nested.Count = Nested.Count - 1
			 IF Nested.Count = False THEN
			    EXIT FOR
			 END IF
		      END IF
		   END IF
		END IF
	     NEXT
	     IF Nested.Count <> False THEN
                Strng3 = "Analyze error, pass 3: Mismatched " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                Call IO.O
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 Strng3 = "Pass 4: multipass imbedded struture match."
 Call IO.O
 RESTORE Analyze.Data2
 FOR Data.Count = 1 TO 3
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Total.Nested1 = 1
             Total.Nested2 = False
	     Nested.Count1 = 1
             Nested.Count2 = False
	     FOR Nested.Lines = Program.Line + 1 TO Last.Line
		Temp2$ = Program(Nested.Lines)
		Temp2$ = STRIM$(Temp2$)
		IF LEN(Temp2$) THEN
		   Temp2$ = STRIM$(Temp2$)
		   Temp2$ = UCASE$(Temp2$)
		   IF LEFT$(Temp2$, LEN(Start.Structure$)) = Start.Structure$ THEN
		      Total.Nested1 = Total.Nested1 + 1
		      Nested.Count1 = Nested.Count1 + 1
		   END IF
                   IF Temp2$ = Stop.Structure$ THEN
		      Total.Nested2 = Total.Nested2 - 1
		      Nested.Count1 = Nested.Count1 - 1
                      IF Nested.Count1 = False THEN
			 EXIT FOR
		      END IF
		   END IF
		   IF Start.Structure$ = "IF" THEN
		      IF LEFT$(Temp2$, 6) = "END IF" THEN
			 Nested.Count1 = Nested.Count1 - 1
                         IF Nested.Count1 = False THEN
			    EXIT FOR
			 END IF
		      END IF
		   END IF
		   IF LEFT$(Temp2$, LEN(Imbedded1$)) = Imbedded1$ THEN
		      Nested.Count2 = Nested.Count2 + 1
		      IF Nested.Count2 > Nested.Count1 THEN
                         Strng3 = "Analyze error, pass 4: Mismatched " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                         Call IO.O
			 EXIT SUB
		      END IF
		      Nested.Count2 = Nested.Count2 - 1
		   ELSE
                      Temp3$ = Temp2$
                      IF Imbedded2$ <> "ELSEIF" THEN
                         IF LEFT$(Temp2$, LEN(Imbedded2$)) = Imbedded2$ THEN
                            Imbedded3 = INSTR(Temp2$, " ")
                            IF Imbedded3 = False THEN
                               Strng3 = "Analyze error, pass 4: Bad "+ Imbedded2$ + ": Line:" + Str$(Program.Line)
                               Call IO.O
                               EXIT SUB
                            END IF
                            Temp3$ = LEFT$(Temp2$, Imbedded3 - 1)
                         END IF
                      END IF
                      IF Temp3$ = Imbedded2$ THEN
			 Nested.Count2 = Nested.Count2 + 1
			 IF Nested.Count2 > Nested.Count1 THEN
                            Strng3 = "Analyze error, pass 4: Mismatched "+ Start.Structure$ + ": Line:" + Str$(Program.Line)
                            Call IO.O
			    EXIT SUB
			 END IF
			 Nested.Count2 = Nested.Count2 - 1
		      END IF
		   END IF
		END IF
	     NEXT
	     IF Total.Nested2 > Total.Nested1 THEN
                Strng3 = "Analyze error, pass 4: Mismatched " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                Call IO.O
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 Strng3 = "Pass 5: single pass imbedded control structure match."
 Call IO.O
 RESTORE Analyze.Data3
 FOR Data.Count = 1 TO 5
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
          END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
	     Nested.Count = Nested.Count + 1
	  END IF
          Count.Data2 = False
	  IF LEFT$(Temp1$, LEN(Stop.Structure$)) = Stop.Structure$ THEN
             Count.Data2 = True
          END IF
          IF Stop.Structure$ = "LOOP" THEN
             IF LEFT$(Temp1$, 6) = "LOOPIF" THEN
                Count.Data2 = False
             END IF
          END IF
          IF Stop.Structure$ = "NEXT" THEN
             IF LEFT$(Temp1$, 6) = "NEXTIF" THEN
                Count.Data2 = False
             END IF
          END IF
          IF Count.Data2 THEN
             Nested.Count = Nested.Count - 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded1$)) = Imbedded1$ THEN
	     IF Nested.Count <= False THEN
                Strng3 = "Analyze error, pass 5: Badly nested " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                Call IO.O
		EXIT SUB
	     END IF
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded2$)) = Imbedded2$ THEN
	     IF Nested.Count <= False THEN
                Strng3 = "Analyze error, pass 5: Badly nested " + Start.Structure$ + ": Line:" + Str$(Program.Line)
                Call IO.O
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 Strng3 = "Analysis completed. Program syntax correct."
 Call IO.O
Error.Resume15c:
 Exit Sub
Error.Trap15c:
 Resume Error.Resume15c
END SUB

Analyze.Data1:
 DATA "IF", "ENDIF"
 DATA "DO", "LOOP"
 DATA "FOR", "NEXT"
 DATA "WHILE", "WEND"
 DATA "FORIF", "NEXTIF"
 DATA "LOOPIF", "END LOOPIF"
 DATA "SELECT CASE", "END SELECT"
 DATA "SELECTIF CASE", "END SELECTIF"

Analyze.Data2:
 DATA "IF", "ENDIF", "ELSE", "ELSEIF"
 DATA "SELECT CASE", "END SELECT", "CASE ELSE", "CASE"
 DATA "SELECTIF CASE", "END SELECTIF", "CASEIF ELSE", "CASEIF"

Analyze.Data3:
 DATA "DO", "LOOP", "EXIT DO", "CONTINUE DO"
 DATA "FOR", "NEXT", "EXIT FOR", "CONTINUE FOR"
 DATA "WHILE", "WEND", "EXIT WHILE", "CONTINUE WHILE"
 DATA "FORIF","NEXTIF", "EXIT FORIF", "CONTINUE FORIF"
 DATA "LOOPIF", "END LOOPIF", "EXIT LOOPIF", "CONTINUE LOOPIF"

Sub Sic.Status.Line
 On Local Error Goto Error.Trap58
 Temp$="DNDSIC Interpreter <timeon: "+Fclock$+">"
 Temp$=Left$(Temp$,79)
 Temp$=Temp$+Space$(79-Len(Temp$))
 Call Display.Status.Line(True)
Error.Resume58:
 Exit Sub
Error.Trap58:
 Resume Error.Resume58
End Sub

Sub Clear.Status.Line
 On Local Error Goto Error.Trap58
 Temp$=Space$(79)
 Call Display.Status.Line(False)
Error.Resume58a:
 Exit Sub
Error.Trap58a:
 Resume Error.Resume58a
End Sub

Sub Display.Status.Line(Var)
 On Local Error Goto Error.Trap29
 Call Cursor(False)
 If Var Then
    Color 14,1
 Else
    Color 15,0
 Endif
 Locate Max.Row,1,0
 Print Temp$;
 Locate Max.Row,80
 If Var Then
    Color 0, 1
 Else
    Color 7, 0
 Endif
 Print " ";
 Locate Max.Row-1,1,1
 Call Cursor(True)
 Call Restore.Color
Error.Resume29:
 Exit Sub
Error.Trap29:
 Resume Error.Resume29
End Sub

Sub Cursor(Var)
 On Local Error Goto Error.Trap42
 If Local.ANSI.Color Or Local.Avatar.Color Then
    Select Case Var
    Case False
       Call VideoInt(3,0)
       Cursor.Position=OutregsX.DX
    Case True
       Call VideoInt(2,Cursor.Position)
    End Select
 Else
    Select Case Var
    Case False
       CursorX=Csrlin
       CursorY=Pos(0)
    Case True
       Locate CursorX,CursorY,1
    End Select
 Endif
Error.Resume42:
 Exit Sub
Error.Trap42:
 Resume Error.Resume42
End Sub

Sub Restore.Color
 On Local Error Goto Error.Trap43
 Call ScreenANSI(1,37,15)
 If Graphics.Off Then
    Call ScreenANSI(4,37,15)
 Else
    Call ScreenANSI(4,Color.Code,Avatar.Code)
 Endif
Error.Resume43:
 Exit Sub
Error.Trap43:
 Resume Error.Resume43
End Sub

Sub Cryptograph(Var$)
 On Local Error Goto Error.Trap54
 Var1=Len(Var$)
 If Var1=False Then
    Exit Sub
 Endif
 For Var2=False To Var1-1
    VarZ=Asc(Mid$(Var$,Var2+1,1))
    VarZ=VarZ Xor Var1
    If Var2=False Then
       VarZ=VarZ Xor PrimeKey
    Else
       VarZ=VarZ Xor Var2
       VarZ=VarZ Xor Asc(Mid$(Var$,Var2,1))
    Endif
    Mid$(Var$,Var2+1,1)=Chr$(VarZ)
 Next
 If Var1=1 Then
    Exit Sub
 Endif
 For Var2=Var1-1 To 0 Step -1
    VarZ=Asc(Mid$(Var$,Var2+1,1))
    VarZ=VarZ Xor Var1
    If Var2=Var1-1 Then
       VarZ=VarZ Xor PrimeKey
    Else
       VarZ=VarZ Xor Var2
       VarZ=VarZ Xor Asc(Mid$(Var$,Var2+2,1))
    Endif
    Mid$(Var$,Var2+1,1)=Chr$(VarZ)
 Next
Error.Resume54:
 Exit Sub
Error.Trap54:
 Resume Error.Resume54
End Sub

' immediate debugging prompt.
SUB Debug.Command
 ControlBreak = False
 Call ScreenANSI(4,37,15)
 Strng3 = "Type 'Quit' to exit Debug mode."
 Call IO.O
 Strng3 = "Or type ? for brief command list."
 Call IO.O
 DO
    Call Check.Carrier
    If Lost.Carrier Then
       Exit Sub
    Endif
    Allow.Break=True
    Break = False
    Call Modem.ANSI(4,37,15)
    Call ScreenANSI(4,37,15)
    If Len(NodeX) Then
       Strng3 = NodeX + "?"
    Else
       Strng3 = "#?"
    Endif
    Temp0=3
    Line.Length=255
    CALL IO.I
    Temp0=0
    Allow.Break=False
    VarX = Break
    Break = False
    IF VarX THEN
       Call Modem.ANSI(4,31,12)
       Call ScreenANSI(4,31,12)
       CALL IO.O
       Strng3 = "*break*"
       CALL IO.O
       Call Modem.ANSI(4,33,14)
       Call ScreenANSI(4,33,14)
       EXIT DO
    END IF
    Out9 = UCASE$(Out9)
    IF Out9 = "QUIT" THEN
       EXIT DO
    END IF
    Out2 = Out9

    ' list commands
    IF Out2 = "?" THEN
       Call Modem.ANSI(4,33,14)
       Call ScreenANSI(4,33,14)
       Strng3 = "Brief list of Debug commands:"
       Call IO.O
       Strng3 = "<command>           <shortcut>"
       Call IO.O
       Call ScreenANSI(4,37,15)
       Strng3 = "LISTLINES           --  LL"
       Call IO.O
       Strng3 = "SETBREAK <l>        --  SB <l>"
       Call IO.O
       Strng3 = "CLEARBREAK <l>      --  CB <l>"
       Call IO.O
       Strng3 = "LISTBREAKS          --  LB"
       Call IO.O
       Strng3 = "CLEARALLBREAKS      --  CA"
       Call IO.O
       Strng3 = "SETVARIABLE <x>, n  --  SV <x>, n"
       Call IO.O
       Strng3 = "CLEARVARIABLE <x>   --  CV <x>"
       Call IO.O
       Strng3 = "TOGGLEVARIABLE <x>  --  TV <x>"
       Call IO.O
       Strng3 = "LISTVARIABLES       --  LV"
       Call IO.O
       Strng3 = "CLEARALLVARIABLES   --  AV"
       Call IO.O
    END IF

    ' parse debug commands
    IF LEFT$(Out2,8) = "LISTLINES" THEN ' LL
       Out2 = "LL"
    END IF
    IF LEFT$(Out2,8) = "SETBREAK" THEN ' SB
       Out2 = "SB" + Mid$(Out2, 9)
    END IF
    IF LEFT$(Out2,10) = "CLEARBREAK" THEN ' CB
       Out2 = "CB" + Mid$(Out2, 11)
    END IF
    IF Out2 = "LISTBREAKS" THEN ' LB
       Out2 = "LB"
    END IF
    IF Out2 = "CLEARALLVARIABLES" THEN ' CA
       Out2 = "CA"
    END IF
    IF LEFT$(Out2,11) = "SETVARIABLE" THEN ' SV
       Out2 = "SV" + Mid$(Out2, 12)
    END IF
    IF LEFT$(Out2,13) = "CLEARVARIABLE" THEN ' CV
       Out2 = "CV" + Mid$(Out2, 14)
    END IF
    IF LEFT$(Out2,14) = "TOGGLEVARIABLE" THEN ' TV
       Out2 = "TV" + Mid$(Out2, 15)
    END IF
    IF Out2 = "LISTVARIABLES" THEN ' LV
       Out2 = "LV"
    END IF
    IF Out2 = "CLEARALLBREAKS" THEN ' AV
       Out2 = "AV"
    END IF

    ' test shortcuts
    SELECT CASE LEFT$(Out2, 2)
    CASE "LL"
       ListLines = NOT ListLines
       If ListLines Then
          Strng3 = "Debug: List lines on."
       Else
          Strng3 = "Debug: List lines off."
       Endif
       Call IO.O
    CASE "SB"
       GOSUB Set.Break
    CASE "CB"
       GOSUB Clear.Break
    CASE "LB"
       GOSUB Display.Breaks
    CASE "CA"
       GOSUB Clear.All.Variables
    CASE "SV"
       GOSUB Set.Variable
    CASE "CV"
       GOSUB Clear.Variable
    CASE "TV"
       GOSUB Toggle.Variable
    CASE "LV"
       GOSUB Display.Variables
    CASE "AV"
       GOSUB Clear.All.Breaks
    CASE ELSE
       IF Out2 = "?" THEN
          Eat$ = Nul
       ELSE
          ' parse whatis
          IF Out2 <> Nul THEN
             COLOR Plain, Black
             Out2 = TTRIM$(Out2, True)
             Allow.Break=True
             Break=False
             Recurse = 0
             Program.Start!=Timeit!
             CALL Enter.Equate
             Allow.Break=False
             VarX = Break
             Break = False
             IF VarX THEN
                Call Modem.ANSI(4,31,12)
                Call ScreenANSI(4,31,12)
                Strng3 = "*break*"
                CALL IO.O
                Call Modem.ANSI(4,33,14)
                Call ScreenANSI(4,33,14)
             ELSE
                IF LineFeed THEN
                   Call Line.Return
                END IF
             END IF
          END IF
       END IF
    END SELECT
 LOOP
 Call Modem.ANSI(4,33,14)
 Call ScreenANSI(4,33,14)
 Strng3 = "Debug mode ended."
 Call IO.O
 EXIT SUB

Set.Break:
 BreakLine = INT(VAL(MID$(Out2,3)))
 IF BreakLine > False AND BreakLine <= Max.Lines THEN
    LineBreak(BreakLine) = True
    Call ScreenANSI(4,37,15)
    Strng3 = "Break line" + STR$(BreakLine) + " set."
    Call IO.O
    RETURN
 END IF
 Call ScreenANSI(4,37,15)
 Strng3 = "Unknown line."
 Call IO.O
 RETURN

Clear.Break:
 BreakLine = INT(VAL(MID$(Out2,3)))
 IF BreakLine > False AND BreakLine <= Max.Lines THEN
    LineBreak(BreakLine) = False
    Call ScreenANSI(4,37,15)
    Strng3 = "Break line" + STR$(BreakLine) + " cleared."
    Call IO.O
    RETURN
 END IF
 Call ScreenANSI(4,37,15)
 Strng3 = "Unknown line."
 Call IO.O
 RETURN

Display.Breaks:
 Continuous.Display = False
 Line.Count = False
 Line.Flag = False
 FOR Var = 1 TO Max.Lines
    ' display line break variables 
    IF LineBreak(Var) THEN
       ' check page length
       Line.Count = Line.Count + 1
       IF Continuous.Display = False THEN
          IF Line.Count = 1 THEN
             Call ScreenANSI(4,37,15)
             Strng3 = "Line Number"
             Call IO.O
             Strng3 = "-----------"
             Call IO.O
          END IF
       END IF
       Call ScreenANSI(4,33,14)
       Strng3 = " " + Form$(Cdbl(Var))
       Call IO.O
       Line.Flag = True
    END IF

    ' check page length
    IF Line.Count = PageLength - 2 THEN
       GOSUB Check.Page
       SELECT CASE Output.Char$
       CASE "n"
          RETURN
       CASE "c"
          Continuous.Display = True
       END SELECT
    END IF
 NEXT
 IF Line.Flag = False THEN
    Call ScreenANSI(4,37,15)
    Strng3 = "No line breaks set."
    Call IO.O
 END IF
 RETURN

Set.Variable:
 Var$ = MID$(Out2,3)
 Var$ = LTRIM$(Var$)
 Var2$ = LEFT$(Var$, 1)
 Var2$ = UCASE$(Var2$)
 IF Var2$>="A" AND Var2$<="Z" THEN
    BreakVar = ASC(Var2$)-64
    Var$ = MID$(Var$, 2)
    Var$ = LTRIM$(Var$)
    IF LEFT$(Var$, 1) = "(" THEN
       Imbedded = INSTR(Var$, ")")
       IF Imbedded THEN
          Var2$ = LEFT$(Var$, Imbedded - 1)
          Var2$ = MID$(Var2$, 2)
          BreakVar2 = INT(VAL(Var2$))
          IF BreakVar2 >= 1 AND BreakVar2 <= MaxArrays THEN
             Var$ = MID$(Var$, Imbedded + 1)
             Var$ = LTRIM$(Var$)
             IF LEFT$(Var$, 1) = "," THEN
                BreakVar3# = VAL(MID$(Var$, 2))
                VariableBreak3(BreakVar, BreakVar2) = True
                VariableValue3(BreakVar, BreakVar2) = BreakVar3#
                Call ScreenANSI(4,37,15)
                Strng3 = "Break variable " + CHR$(BreakVar+64) + "(" + MID$(STR$(BreakVar2),2)+") set to " + LTRIM$(STR$(BreakVar3#))+"."
                Call IO.O
                RETURN
             END IF
          END IF
       END IF
    ELSE
       IF LEFT$(Var$, 1) = "$" THEN
          Var$ = MID$(Var$, 2)
          Var$ = LTRIM$(Var$)
          IF LEFT$(Var$, 1) = "," THEN
             BreakVar2$ = MID$(Var$, 2)
             VariableBreak2(BreakVar) = True
             VariableValue2(BreakVar) = BreakVar2$
             Call ScreenANSI(4,37,15)
             Strng3 = "Break variable " + CHR$(BreakVar+64)+"$ set to " + Quote$ + BreakVar2$ + Quote$ + "."
             Call IO.O
             RETURN
          END IF
       ELSE
          IF LEFT$(Var$, 1) = "," THEN
             BreakVar2# = VAL(MID$(Var$, 2))
             VariableBreak(BreakVar) = True
             VariableValue(BreakVar) = BreakVar2#
             Call ScreenANSI(4,37,15)
             Strng3 = "Break variable " + CHR$(BreakVar+64) + " set to " + LTRIM$(STR$(BreakVar2#))+"."
             Call IO.O
             RETURN
          END IF
       END IF
    END IF
 END IF
 Call ScreenANSI(4,37,15)
 Strng3 = "Unknown variable."
 Call IO.O
 RETURN

Clear.Variable:
 Var$ = MID$(Out2,3)
 Var$ = UCASE$(Var$)
 Var$ = RTRIM$(Var$)
 Var$ = LTRIM$(Var$)
 Var2$ = LEFT$(Var$, 1)
 IF Var2$>="A" AND Var2$<="Z" THEN
    BreakVar=ASC(Var2$)-64
    IF LEN(Var$) = 1 THEN
       VariableBreak(BreakVar) = False
       VariableValue(BreakVar) = DFalse
       Call ScreenANSI(4,37,15)
       Strng3 = "Break variable "+CHR$(BreakVar+64)+" cleared."
       Call IO.O
       RETURN
    ELSE
       IF LEN(Var$) = 2 THEN
          Var2$ = MID$(Var$, 2)
          IF Var2$ = "$" THEN
             VariableBreak2(BreakVar) = False
             VariableValue2(BreakVar) = Nul
             Call ScreenANSI(4,37,15)
             Strng3 = "Break variable "+CHR$(BreakVar+64)+"$ cleared."
             Call IO.O
             RETURN
          END IF
       ELSE
          Var$ = MID$(Var$, 2)
          IF LEFT$(Var$, 1) = "(" THEN
             Imbedded = INSTR(Var$, ")")
             IF Imbedded THEN
                Var$ = LEFT$(Var$, Imbedded - 1)
                Var$ = MID$(Var$, 2)
                BreakVar2 = VAL(Var$)
                IF BreakVar2>=1 AND BreakVar2<=MaxArrays THEN
                   VariableBreak3(BreakVar, BreakVar2) = False
                   VariableValue3(BreakVar, BreakVar2) = DFalse
                   Call ScreenANSI(4,37,15)
                   Strng3 = "Break variable "+CHR$(BreakVar+64)+"("+MID$(STR$(BreakVar2),2)+") cleared."
                   Call IO.O
                   RETURN
                END IF
             END IF
          END IF
       END IF
    END IF
 END IF
 Call ScreenANSI(4,37,15)
 Strng3 ="Unknown variable."
 Call IO.O
 RETURN

Toggle.Variable:
 Var$ = MID$(Out2,3)
 Var$ = UCASE$(Var$)
 Var$ = RTRIM$(Var$)
 Var$ = LTRIM$(Var$)
 Var2$ = LEFT$(Var$, 1)
 IF Var2$>="A" AND Var2$<="Z" THEN
    BreakVar=ASC(Var2$)-64
    IF LEN(Var$) = 1 THEN
       IF VariableBreak(BreakVar) THEN
          NewBreak = VariableBreak(BreakVar)
          GOSUB Next.Break
          VariableBreak(BreakVar) = NewBreak
          Call ScreenANSI(4,37,15)
          Strng3 = "Break variable "+CHR$(BreakVar+64)+" toggled to "+ Symbol$+ "."
          Call IO.O
          RETURN
       END IF
    ELSE
       IF LEN(Var$) = 2 THEN
          Var2$ = MID$(Var$, 2)
          IF Var2$ = "$" THEN
             IF VariableBreak2(BreakVar) THEN
                NewBreak = VariableBreak2(BreakVar)
                GOSUB Next.Break
                VariableBreak2(BreakVar) = NewBreak
                Call ScreenANSI(4,37,15)
                Strng3 = "Break variable "+CHR$(BreakVar+64)+"$ toggled to "+ Symbol$+ "."
                Call IO.O
                RETURN
             END IF
          END IF
       ELSE
          Var$ = MID$(Var$, 2)
          IF LEFT$(Var$, 1) = "(" THEN
             Imbedded = INSTR(Var$, ")")
             IF Imbedded THEN
                Var$ = LEFT$(Var$, Imbedded - 1)
                Var$ = MID$(Var$, 2)
                BreakVar2 = VAL(Var$)
                IF BreakVar2>=1 AND BreakVar2<=MaxArrays THEN
                   IF VariableBreak3(BreakVar, BreakVar2) THEN
                      NewBreak = VariableBreak3(BreakVar, BreakVar2)
                      GOSUB Next.Break
                      VariableBreak3(BreakVar, BreakVar2) = NewBreak
                      Call ScreenANSI(4,37,15)
                      Strng3 = "Break variable "+CHR$(BreakVar+64)+"("+MID$(STR$(BreakVar2),2)+") toggled to "+ Symbol$+ "."
                      Call IO.O
                      RETURN
                   END IF
                END IF
             END IF
          END IF
       END IF
    END IF
 END IF
 Call ScreenANSI(4,37,15)
 Strng3 = "Unknown variable."
 Call IO.O
 RETURN

Display.Variables:
 Line.Count = False
 Line.Flag = False
 FOR Var = 1 TO 26
    ' display break variables 
    IF VariableBreak(Var) THEN
       ' check page length
       GOSUB Check.Title
       Call ScreenANSI(4,33,14)
       Strng3 = " " + CHR$(Var + 64) + "        "
       BreakSign = VariableBreak(Var)
       GOSUB Get.Sign
       Strng3 = Strng3 + Symbol$ + "   "
       Strng3 = Strng3 + STR$(VariableValue(Var))
       Call IO.O
       Line.Flag = True
    END IF

    ' check page length
    IF Line.Count = PageLength - 2 THEN
       GOSUB Check.Page
       SELECT CASE Output.Char$
       CASE "n"
          RETURN
       CASE "c"
          Continuous.Display = True
       END SELECT
    END IF
 NEXT
 FOR Var = 1 TO 26
    ' display break variables 
    IF VariableBreak2(Var) THEN
       ' check page length
       GOSUB Check.Title
       Call ScreenANSI(4,33,14)
       Strng3 = " " + CHR$(Var + 64) + "$       "
       BreakSign = VariableBreak2(Var)
       GOSUB Get.Sign
       Strng3 = Strng3 + Symbol$ + "   "
       IF LEN(VariableValue2(Var)) > 40 THEN
          Strng3 = Strng3 + Quote$ + LEFT$(VariableValue2(Var), 40) + "..."
       ELSE
          Strng3 = Strng3 + Quote$ + VariableValue2(Var) + Quote$
       END IF
       Call IO.O
       Line.FLag = True
    END IF

    ' check page length
    IF Line.Count = PageLength - 2 THEN
       GOSUB Check.Page
       SELECT CASE Output.Char$
       CASE "n"
          RETURN
       CASE "c"
          Continuous.Display = True
       END SELECT
    END IF
 NEXT

 FOR Var = 1 TO 26
    FOR Var2 = 1 TO MaxArrays
       ' display break variables 
       IF VariableBreak3(Var, Var2) THEN
          ' check page length
          GOSUB Check.Title
          Call ScreenANSI(4,33,14)
          VarL = Len(Mid$(Str$(Var2), 2))
          Strng3 = " " + CHR$(Var + 64) + "(" + MID$(STR$(Var2), 2)+ ")"
          If VarL = 3 Then Strng3 = Strng3 + "   "
          If VarL = 2 Then Strng3 = Strng3 + "    "
          If VarL = 1 Then Strng3 = Strng3 + "     "
          BreakSign = VariableBreak3(Var, Var2)
          GOSUB Get.Sign
          Strng3 = Strng3 + Symbol$ + "   " + STR$(VariableValue3(Var, Var2))
          Call IO.O
          Line.Flag = True
       END IF

       ' check page length
       IF Line.Count = PageLength - 2 THEN
          GOSUB Check.Page
          SELECT CASE Output.Char$
          CASE "n"
             RETURN
          CASE "c"
             Continuous.Display = True
          END SELECT
       END IF
    NEXT
 NEXT
 IF Line.Flag = False THEN
    Call ScreenANSI(4,37,15)
    Strng3 = "No variable breaks set."
    Call IO.O
 END IF
 RETURN

Check.Page:
 Line.Count = False
 IF Continuous.Display = False THEN
    CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$, "n")
 END IF
 RETURN

Check.Title:
 Line.Count = Line.Count + 1
 IF Continuous.Display = False THEN
    IF Line.Count = 1 THEN
       Call ScreenANSI(4,37,15)
       Strng3 = "Variable  Sign Value"
       Call IO.O
       Strng3 = "--------------------"
       Call IO.O
    END IF
 END IF
 RETURN

Get.Sign:
 SELECT CASE BreakSign
 CASE -1
    Symbol$ = "= "
 CASE 1
    Symbol$ = "<>"
 CASE 2
    Symbol$ = "> "
 CASE 3
    Symbol$ = ">="
 CASE 4
    Symbol$ = "< "
 CASE 5
    Symbol$ = "<="
 END SELECT
 RETURN

Next.Break:
 SELECT CASE NewBreak
 CASE -1 ' =
    NewBreak = 1
    Symbol$ = "<>"
 CASE 1  ' <>
    NewBreak = 2
    Symbol$ = ">"
 CASE 2  ' >
    NewBreak = 3
    Symbol$ = ">="
 CASE 3  ' >=
    NewBreak = 4
    Symbol$ = "<"
 CASE 4  ' <
    NewBreak = 5
    Symbol$ = "<="
 CASE 5  ' <=
    NewBreak = -1
    Symbol$ = "="
 END SELECT
 RETURN

Clear.All.Breaks:
 REDIM LineBreak(1 TO Max.Lines) AS INTEGER
 Call ScreenANSI(4,37,15)
 Strng3 = "All line breaks cleared."
 Call IO.O
 RETURN

Clear.All.Variables:
 Call Clear.All.Arrays
 Call ScreenANSI(4,37,15)
 Strng3 = "All variable breaks cleared."
 Call IO.O
 RETURN
END SUB

Sub Clear.All.Arrays
 Redim VariableBreak(1 TO 26) AS INTEGER, _
 VariableBreak2(1 TO 26) AS INTEGER, _
 VariableBreak3(0 TO 26, 0 TO MaxArrays) AS INTEGER, _
 VariableValue(1 TO 26) AS DOUBLE, _
 VariableValue3(0 TO 26, 0 TO MaxArrays) AS DOUBLE
 FOR BreakVar = 1 TO 26
    VariableValue2(BreakVar) = Nul
 NEXT
End Sub

' lists all drives
SUB ListDrives
DIM BPBfile AS BPBtype
DIM DTAfile AS DTAtype
h = 3
l = 0
GOSUB DriveHeader
FOR c = 1 TO 26
    GOSUB DisplayDrive
    IF h = 20 THEN
        h = 0
        CALL More.Prompt("-more-","y"+chr$(13),Output.Char$,"y")
        GOSUB DriveHeader
    END IF
NEXT
IF q = 0 THEN
    Strng3="<none>"
    Call io.o
ELSE
    Strng3="Total drives"+str$(l)
    Call io.o
END IF
EXIT SUB

DisplayDrive:
c$ = CHR$(c + 64)
Out3 = c$
CALL Check.Drive(c, Temp#)
IF Temp# THEN
    h = h + 1
    l = l + 1
    q = -1

    ' display drive letter
    z$ = c$ + ":    "

    ' display volume label
    Out3 = c$
    gosub Vlabel
    IF RTRIM$(Out3) = "" THEN
        q$ = ""
    ELSE
        q$ = LEFT$(Out3, 12)
    END IF
    z$ = z$ + q$ + SPACE$(13 - LEN(q$))

    ' display volume serial number
    Out3 = c$
    gosub Vserial
    q$ = LEFT$(Out3, 12)
    z$ = z$ + q$ + SPACE$(13 - LEN(q$))

    ' display volume file system type
    Out3 = c$
    gosub Vtype
    q$ = LEFT$(Out3, 8)
    z$ = z$ + q$ + SPACE$(9 - LEN(q$))

    ' display volume total disk space
    Out3 = c$
    CALL TotalSpace(Out3)
    x# = INT(VAL(Out3))
    x1# = x#
    IF x# > 0# THEN
        CALL Suffix(x#, S$) ' 1,024.0 KB
        z$ = z$ + SPACE$(11 - LEN(S$)) + S$
    ELSE
        z$ = z$ + "      <n/a>"
    END IF

    ' display volume free disk space
    Out3 = c$
    CALL FreeSpace(Out3)
    y# = INT(VAL(Out3))
    y1# = y#
    IF y# > 0# THEN
        CALL Suffix(y#, S$) ' 1,024.0 KB
        z$ = z$ + SPACE$(11 - LEN(S$)) + S$
    ELSE
        z$ = z$ + "       <n/a>"
    END IF

    ' display volume used disk space
    IF x1# > 0# OR y1# > 0# THEN
        z# = x1# - y1#
        CALL Suffix(z#, S$) ' 1,024.0 KB
        z$ = z$ + SPACE$(11 - LEN(S$)) + S$
    ELSE
        z$ = z$ + "      <n/a>"
    END IF
    carriage.return=false
    Strng3 = z$
    CALL IO.O
    strng3=nul
    Call io.o
END IF
RETURN

DriveHeader:
h = 2
Strng3 = "Drive Label        Serial       Type           Total       Free       Used"
Call io.o
Strng3 = "--------------------------------------------------------------------------"
Call io.o
RETURN

vlabel:
    ASCIIZ = CHR$(c + 64) + ":\*.*" + CHR$(0)
    Out3 = Nul
    ' restore directory search dta
    InregsX.AX = &H1A00
    InregsX.DS = VARSEG(DTAfile)
    InregsX.DX = VARPTR(DTAfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    ' find volume label
    InregsX.AX = &H4E00
    InregsX.CX = &H8
    InregsX.DS = VARSEG(ASCIIZ)
    InregsX.DX = VARPTR(ASCIIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
    ' check findfirst error
    IF (OutregsX.Flags AND &H1) = &H0 THEN
       Out3 = DTAfile.ASCIIZfilename
       Out3 = LEFT$(Out3, INSTR(Out3, CHR$(0)) - 1)
       Out3 = RTRIM$(Out3)
    END IF
    ' restore basic dta
    InregsX.AX = &H1A00
    InregsX.DS = BASIC.DTA.SEG
    InregsX.DX = BASIC.DTA.OFF
    CALL InterruptX(&H21, InregsX, OutregsX)
return

vserial:
    Out3 = Nul
    ' get volume info
    InregsX.AX = &H6900
    InregsX.BX = c
    InregsX.DS = VARSEG(BPBfile)
    InregsX.DX = VARPTR(BPBfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    ' check flag error
    IF (OutregsX.Flags AND &H1) = &H0 THEN
       ' store volume serial number
       FOR Serial.Digit = 4 TO 1 STEP -1
	  IF Serial.Digit = 2 THEN
	     Out3 = Out3 + "-"
	  END IF
          Digit = ASC(MID$(BPBfile.Serial, Serial.Digit, 1))
          Out3 = Out3 + RIGHT$(HEX$(Digit + &H100), 2)
       NEXT
    END IF
return

vtype:
    Out3 = Nul
    ' get volume info
    InregsX.AX = &H6900
    InregsX.BX = c
    InregsX.DS = VARSEG(BPBfile)
    InregsX.DX = VARPTR(BPBfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    ' check flag error
    IF (OutregsX.Flags AND &H1) = &H0 THEN
       ' store volume file system type
       Out3 = RTRIM$(BPBfile.System)
    END IF
return
END SUB

