Rem File: Dndsub10 for Dndbbs Version v5.0a Release r1.0
Rem $Include: 'dndbbs.inc'

Rem Plays .wav files for blind people.

Rem This code was adapted from Dma.zip written by Mike Huff (1996).
Rem Which was modified By Martin Rampersad. Thanks guys! ejo-)
Rem Program downloaded from http://www.ocf.berkeley.edu/~horie

COMMON SHARED BasePort%
COMMON SHARED Channel%

SUB Playwav(Tmp1$)
 On Local Error Goto Play.Error
   ' get playwav config variables
   Gosub Get.Config1

   ' check disabled config variable
   If option1=false then
      exit sub
   Endif

   ' Parses BLASTER environment
   Call GetBLASTER
   If option3 Then
      BasePort% = option3
   Endif
   If option4 Then
      Channel% = option4
   Endif
   If BasePort% = 0% Then
      Exit Sub
   Endif

   ' Resets DSP
   FOR Tmp1 = 1 TO 3
      Call ResetDSP(Var)
      If Var Then
         Exit For
      Endif
   NEXT
   If Var = 0 Then
      Exit Sub
   Endif

   ' Turn the speaker on
   Call SpeakerState (1)

   ' Put the mixer volumes in Right% and Left%
   Call MasterVolume (Right%, Left%, -1)

   ' 15,15,0 cranks the master volume all the way up.
   Call MasterVolume (option2, option2, 0)

   ' open input file
   Close #TempFile1
   Close #TempFile2
   X = FREEFILE
   IF X = 0 THEN
      EXIT SUB
   END IF
   Tmp2$ = DND.Path + Tmp1$
   IF DIR$(Tmp2$) = "" THEN
      EXIT SUB
   END IF
   OPEN Tmp2$ FOR BINARY AS #X

   ' create buffer for file.
   DIM WavBuffer(1 TO 1) AS STRING * 16384

   ' Get buffer from file skipping header
   GET #X, 44, WavBuffer(1)

   ' Adjust length
   Length& = LOF(X) - 44
   IF Length& > 16384 THEN
      Length& = 16384
   END IF

   ' call sound output loop
   Segment& = VARSEG(WavBuffer(1))
   Offset& = VARPTR(WavBuffer(1))
   Call DMAPlay (Segment&, Offset&, Length&)

   ' pause after DMA transfer
   x!=timer
   DO
      If Time.Elapsed(x!,.5!) Then
         Exit do
      Endif
   LOOP

   ' close, erase, and exit
   Close #X
   Erase WavBuffer
   EXIT SUB
Get.Config1:
 option1=true
 option2=13
 option3=0
 option4=0
 VarX=0
 Do
    VarX=VarX+1
    If VarX>Options.Lines Then
       Exit Do
    Endif
    Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
    If Ucase$(Var$)="[DNDBBS]" Then
       Do
          VarX=VarX+1
          If VarX>Options.Lines Then
             Return
          Endif
          Var$=Ltrim$(Rtrim$(Options.Array(VarX)))
          If Ucase$(Var$)="[END]" Then
             Return
          Endif
          Var=Instr(Var$,"=")
          If Var Then
             Var2$=Ltrim$(Rtrim$(Left$(Var$,Var-1)))
             Var3$=Ltrim$(Rtrim$(Mid$(Var$,Var+1)))
             Select Case Lcase$(Var2$)
             Case "playwav"
                Select Case Lcase$(Var3$)
                Case "0", "false", "off"
                   option1=0
                End Select
             Case "volume"
                Var4=Int(Val(Var3$))
                Select Case Var4
                Case 1 to 15
                   option2=Var4
                End Select
             Case "baseport"
                option3=Int(Val("&H"+Var3$))
             Case "dmachannel"
                Var4=Int(Val(Var3$))
                Select Case Var4
                Case 0 to 3
                   option4=Var4
                End Select
             End Select
          Endif
       Loop
    Endif
 Loop
 Return
Play.Resume:
 Exit Sub
Play.Error:
 Resume Play.Resume
END SUB

' Transfers and plays the contents of the buffer.
SUB DMAPlay (Segment&, Offset&, Length&)
   Freq& = 10000
   Length& = Length& - 1
   Page% = 0
   MemLoc& = Segment& * 16 + Offset&
   SELECT CASE Channel%
   CASE 0
      PgPort% = &H87
      AddPort% = &H0
      LenPort% = &H1
      ModeReg% = &H48
   CASE 1
      PgPort% = &H83
      AddPort% = &H2
      LenPort% = &H3
      ModeReg% = &H49
   CASE 2
      PgPort% = &H81
      AddPort% = &H4
      LenPort% = &H5
      ModeReg% = &H4A
   CASE 3
      PgPort% = &H82
      AddPort% = &H6
      LenPort% = &H7
      ModeReg% = &H4B
   CASE ELSE
      EXIT SUB
   END SELECT
   OUT &HA, &H4 + Channel%
   OUT &HC, &H0
   OUT &HB, ModeReg%
   OUT AddPort%, MemLoc& AND &HFF
   OUT AddPort%, (MemLoc& AND &HFFFF&) \ &H100
   IF (MemLoc& AND 65536) THEN Page% = Page% + 1
   IF (MemLoc& AND 131072) THEN Page% = Page% + 2
   IF (MemLoc& AND 262144) THEN Page% = Page% + 4
   IF (MemLoc& AND 524288) THEN Page% = Page% + 8
   OUT PgPort%, Page%
   OUT LenPort%, Length& AND &HFF
   OUT LenPort%, (Length& AND &HFFFF&) \ &H100
   OUT &HA, Channel%
   TimeConst% = 256 - 1000000 \ Freq&
   V% = &H40: Call WriteDSP (V%)
   V% = TimeConst%: Call WriteDSP (V%)
   V% = &H14: Call WriteDSP (V%)
   V% = Cint(Length& AND &HFF): Call WriteDSP (V%)
   V% = Cint((Length& AND &HFFFF&) \ &H100): Call WriteDSP (V%)
END SUB

' parse the BLASTER environment string and returns settings.
SUB GetBlaster
   Var$ = Environ$("BLASTER")
   IF Var$ = "" THEN
      EXIT SUB
   END IF
   FOR Length% = 1 TO LEN(Var$)
      SELECT CASE MID$(Var$, Length%, 1)
      CASE "A" ' base IO port
         BasePort% = VAL("&H" + MID$(Var$, Length% + 1, 3))
      CASE "D" ' DMA channel
         Channel% = VAL(MID$(Var$, Length% + 1, 1))
      END SELECT
   NEXT
END SUB

SUB MasterVolume (Right%, Left%, Getvol%)
   OUT BasePort% + 4, &H22
   IF Getvol% THEN
      Left% = INP(BasePort% + 5) \ 16
      Right% = INP(BasePort% + 5) AND &HF
   ELSE
      OUT BasePort% + 5, (Right% + Left% * 16) AND &HFF
   END IF
END SUB

' Resets the DSP
SUB ResetDSP(Var)
   Var = 0
   OUT BasePort% + 6, 1
   FOR CountX% = 1 TO 4
      Eat% = INP(BasePort% + 6)
   NEXT
   OUT BasePort% + 6, 0
   IF INP(BasePort% + 14) AND &H80 = &H80 THEN
      IF INP(BasePort% + 10) = &HAA THEN
         Var = -1
      END IF
   END IF
END SUB

' Turns speaker on or off.
SUB SpeakerState (OnOff%)
   IF OnOff% THEN
      V% = &HD1: Call WriteDSP (V%)
   ELSE
      V% = &HD3: Call WriteDSP (V%)
   END IF
END SUB

' Writes a byte to the DSP
SUB WriteDSP (byte2%)
   x!=timer
   DO
      If Time.Elapsed(x!,2!) Then
         Exit do
      Endif
   LOOP WHILE INP(BasePort% + 12) AND &H80
   OUT BasePort% + 12, byte2%
END SUB
