 REM Reboot utility for Dndbbs Version v5.0a Release r2.0
 REM $INCLUDE: 'qbx.bi'

 REM Compile:
 REM   BC Reboot/ah/s/e/g3/o;
 REM   LINK Reboot,,,QBX/e;

 REM Works on any DOS/Windows system.

 ' declare int regs
 COMMON SHARED InRegsX As RegTypeX, OutRegsX As RegTypeX

 ' declare max rows
 COMMON SHARED Max.Row AS INTEGER

 ' declare error trap
 ON ERROR GOTO Error.Routine

 ' get max rows
 CALL Read.Rows(Max.Row)

 ' parse command line
 Var$ = COMMAND$
 IF LEN(Var$) THEN
    SELECT CASE Var$

    ' reboot all computers on LAN
    CASE "/ALL"
       VarZ = 0
       Strng2$ = "restart"
       GOTO Reboot.All

    ' shutdown all computers on LAN
    CASE "/ALLX"
       VarZ = -1
       Strng2$ = "shutdown"
       GOTO Reboot.All

    ' abort shutdown
    CASE "/ABORT"
       GOTO Abort

    ' abort all shutdown
    CASE "/ABORTALL"
       GOTO Abort.All

    ' warm reboot for DOS
    CASE "/WARM"
       ' warm boot
       OUT &H64, &HF0
       Strng3$ = "DOS restarted."
       GOTO Terminate.Program

    ' cold reboot for DOS
    CASE "/COLD"
       Locate Max.Row-1,,1
       Color 15, 0
       Print "DOS restarted."
       Print
       COLOR 7, 0
       PRINT "Exiting utility."
       Call Pause.Second

       ' cold boot
       DEF SEG = &HFFFF
       CALL Absolute(0)
       DEF SEG
       End

    ' list nets
    CASE "/LIST"
       GOTO List.Nets

    ' display boot usage
    CASE "/HELP"
       GOTO Boot.Usage

    ' unknown switch
    CASE ELSE
       COLOR 15, 0
       Locate Max.Row-1,,1
       PRINT "Unknown switch. Type REBOOT /HELP"
       GOTO Terminate.Program
    END SELECT
 END IF

 ' reboot for windows
 LOCATE Max.Row-1, , 1
 COLOR 15, 0
 PRINT "Reboot selection:"
 DO
    LOCATE Max.Row-1, , 1
    COLOR 14, 0
    PRINT "Enter (R)estart, (S)hutdown, (Q)uit? ";
    LOCATE , , 1
    DO
       Out2$ = INKEY$
       IF LEN(Out2$) THEN
          IF Out2$ = CHR$(13) THEN
             Print "q"
             Out2$ = "q"
             Exit Do
          Else
             PRINT Out2$
             EXIT DO
          Endif
       END IF
    LOOP
    Var$ = LCASE$(Out2$)
    SELECT CASE Var$
    CASE "r" ' reboot
       VarX = 0
       Strng2$ = "reboot"
       EXIT DO
    CASE "s" ' shutdown
       VarX = 1
       Strng2$ = "shutdown"
       EXIT DO
    CASE "q"
       GOTO Terminate.Program
    END SELECT
 LOOP
 DO
    COLOR 14, 0
    PRINT "Enter (L)ocal, (R)emote computer, (Q)uit? ";
    LOCATE , , 1
    DO
       Out2$ = INKEY$
       IF Out2$ = CHR$(13) THEN
          Print "q"
          Out2$ = "q"
          Exit Do
       Else
          IF LEN(Out2$) THEN
             PRINT Out2$
             EXIT DO
          Endif
       END IF
    LOOP
    SELECT CASE LCASE$(Out2$)
    CASE "l"
       VarZ = 0
       EXIT DO
    CASE "r"
       VarZ = -1
       EXIT DO
    CASE "q"
       GOTO Terminate.Program
    END SELECT
 LOOP

 ' reboot/shutdown remote computer
 IF VarZ THEN
    COLOR 14, 0
    LINE INPUT "Enter remote computer name? ", Out2$
    IF LEN(Out2$) = 0 THEN
       GOTO Terminate.Program
    END IF
    VarZ$ = UCASE$(Out2$)

    ' shutdown remote computer
    DO
       COLOR 14, 0
       PRINT "Are you sure you want to " + Strng2$ + " remote computer(y/n)? ";
       LOCATE , , 1
       DO
          Out2$ = INKEY$
          IF LEN(Out2$) THEN
             PRINT Out2$
             EXIT DO
          END IF
       LOOP
       IF LCASE$(Out2$) = "n" THEN
          GOTO Terminate.Program
       END IF
       IF LCASE$(Out2$) = "y" THEN
          EXIT DO
       END IF
    LOOP

    ' get shutdown time
    GOSUB Shutdown.Time

    ' remote windows reboot/shutdown
    IF VarX = 0 THEN
       ' reboot remote
       Var$ = "shutdown /r /m \\" + VarZ$ + " /t" + STR$(VarQ)
    ELSE
       ' shutdown remote
       Var$ = "shutdown /s /m \\" + VarZ$ + " /t" + STR$(VarQ)
    END IF
    SHELL Var$
    COLOR 15, 0
    PRINT "Remote " + Strng2$ + " message sent."
    GOTO Terminate.Program
 END IF

 ' reboot/shutdown local computer
 DO
    COLOR 14, 0
    PRINT "Are you sure you want to " + Strng2$ + " local computer(y/n)? ";
    LOCATE , , 1
    DO
       Out2$ = INKEY$
       IF LEN(Out2$) THEN
          PRINT Out2$
          EXIT DO
       END IF
    LOOP
    IF LCASE$(Out2$) = "n" THEN
       GOTO Terminate.Program
    END IF
    IF LCASE$(Out2$) = "y" THEN
       EXIT DO
    END IF
 LOOP

 ' get shutdown time
 GOSUB Shutdown.Time

 ' local windows reboot/shutdown
 IF VarX = 0 THEN
    ' reboot
    Var$ = "shutdown /r /t" + STR$(VarQ)
 ELSE
    ' shutdown
    Var$ = "shutdown /s /t" + STR$(VarQ)
 END IF
 SHELL Var$
 COLOR 15, 0
 PRINT "Local " + Strng2$ + " message sent."
 GOTO Terminate.Program

' get restart/shutdown time
Shutdown.Time:
 VarQ = 1
 COLOR 14, 0
 IF VarX = False THEN
    LINE INPUT "Enter restart time delay(0-600)? ", Out2$
 ELSE
    LINE INPUT "Enter shutdown time delay(0-600)? ", Out2$
 END IF
 IF LEN(Out2$) THEN
    Var = INT(VAL(Out2$))
    IF Var >= 0  AND Var <= 600 then
       VarQ = Var
    END if
 END IF
 RETURN

List.Nets:
 ' get list of computer names
 GOSUB Make.Shell

 ' get local computer name
 Call Get.Machine.Name(VarQ$)

 ' get IP address of local computer
 COLOR 15, 0
 VarX = 0
 Close #1
 If Dir$(Filename1$)<>"" Then
    Open Filename1$ For Input As 1
    If Eof(1)=0 Then
       Line Input #1,VarX$
       Var1=Instr(VarX$,":")
       If Var1 Then
          VarX$=Mid$(VarX$,Var1+1)
          If VarQ$="" Then
             Strng$="This computer:"+VarX$
             Var = Var + 1
             Print Strng$
          Endif
       Endif
    Endif
 Endif

 ' read all netpaths
 COLOR 15, 0
 PRINT "The following net paths were found:"
 PRINT "Server Name            Remark"
 PRINT STRING$(40, "-")
 COLOR 14, 0
 CLOSE
 OPEN Filename2$ FOR INPUT AS 1
 DO
    IF EOF(1) THEN
       EXIT DO
    END IF
    LINE INPUT #1, Var$
    IF LEFT$(Var$, 2) = "\\" THEN
       COLOR 14, 0
       PRINT Var$
       VarX = -1
       Var = Var + 1
       If Rtrim$(Left$(Var$, 23)) = "\\" + VarQ$ Then
          If Len(VarX$) Then
             Strng$ = "   ("+Ltrim$(VarX$)+")"
             Var = Var + 1
             Print Strng$
          Endif
       Endif
       IF Var >= Max.Row THEN
          Var = False
          GOSUB More.Prompt
          IF Quit THEN
             EXIT DO
          END IF
       END IF
    END IF
 LOOP
 IF VarX = 0 THEN
    COLOR 14, 0
    PRINT "No nets found."
 END IF
 IF Var THEN
    GOSUB More.Prompt
 END IF
 GOTO Terminate.Program

Reboot.All:
 ' shutdown all remote computers
 DO
    COLOR 14, 0
    PRINT "Are you sure you want to " + Strng2$ + " all remote computers(y/n)? ";
    LOCATE , , 1
    DO
       Out2$ = INKEY$
       IF LEN(Out2$) THEN
          PRINT Out2$
          EXIT DO
       END IF
    LOOP
    IF LCASE$(Out2$) = "n" THEN
       GOTO Terminate.Program
    END IF
    IF LCASE$(Out2$) = "y" THEN
       EXIT DO
    END IF
 LOOP

 ' get shutdown time
 GOSUB Shutdown.Time

 ' get list of computer names
 GOSUB Make.Shell

 ' read all netpaths
 CLOSE
 OPEN Filename2$ FOR INPUT AS 1
 DO
    IF EOF(1) THEN
       EXIT DO
    END IF
    LINE INPUT #1, Var$
    IF LEFT$(Var$, 2) = "\\" THEN
       VarZ$ = RTRIM$(LEFT$(Var$, 23))
       IF VarZ = 0 THEN
          VarQ$ = "shutdown /r /m " + VarZ$ + " /t" + STR$(VarQ)
       ELSE
          VarQ$ = "shutdown /s /m " + VarZ$ + " /t" + STR$(VarQ)
       END IF
       SHELL VarQ$
    END IF
 LOOP
 GOTO Terminate.Program

Abort:
 Locate Max.Row-1,1,1
 COLOR 14, 0
 Print "Enter remote computer name? ";
 Line Input Out2$
 VarZ$ = UCASE$(Out2$)
 COLOR 15, 0
 CLOSE
 Filename1$="REBOOT.BAT"
 OPEN Filename1$ FOR OUTPUT AS #1
 PRINT #1, "@echo off"
 Var$ = "shutdown /a"
 IF LEN(VarZ$) THEN
    Var$ = Var$ + " /m \\" + VarZ$
 END IF
 Var$ = Var$ + " > reboot.out"
 PRINT #1, Var$
 PRINT #1, "EXIT"
 CLOSE
 SHELL Filename1$
 GOTO Terminate.Program

Abort.All:
 ' get list of computer names
 GOSUB Make.Shell

 ' read all netpaths
 Locate Max.Row-1,,1
 COLOR 15, 0
 PRINT "Abort all netpaths."
 COLOR 14, 0
 CLOSE
 OPEN Filename2$ FOR INPUT AS 1
 DO
    IF EOF(1) THEN
       EXIT DO
    END IF
    LINE INPUT #1, Var$
    IF LEFT$(Var$, 2) = "\\" THEN
       VarZ$ = RTRIM$(LEFT$(Var$, 23))
       VarQ$ = "shutdown /a /m " + VarZ$
       SHELL VarQ$
    END IF
 LOOP
 GOTO Terminate.Program

' simple more prompt
More.Prompt:
 COLOR 15, 0
 PRINT "-more(y/n)-";
 LOCATE , , 1
 DO
    X$ = INKEY$
    SELECT CASE LCASE$(X$)
    CASE CHR$(13), "y", " "
       PRINT
       EXIT DO
    CASE "n"
       PRINT
       Quit = -1
       EXIT DO
    END SELECT
 LOOP
 RETURN

' get list of computer names
Make.Shell:
 ' make filenames for shell
 CLOSE
 Filename$ = "reboot.bat"
 Filename1$ = "reboot.txt"
 Filename2$ = "reboot.lst"
 OPEN Filename$ FOR OUTPUT AS #1
 PRINT #1, "@echo off"
 PRINT #1, "ipconfig | find "+Chr$(34)+"IPv4"+Chr$(34)+" > "+Filename1$
 PRINT #1, "net view > " + Filename2$
 PRINT #1, "exit"

 ' perform shell
 CLOSE
 COLOR 15, 0
 SHELL Filename$
 RETURN

' simple error trap
Error.Routine:
 PRINT "Error:"; ERR
 COLOR 7, 0
 END

Boot.Usage:
 Locate Max.Row-1,,1
 PRINT
 COLOR 15, 0
 PRINT "Reboot usage:"
 COLOR 14, 0
 PRINT "  Reboot [/ABORT???]|[/ALL?]|[/WARM]|[/COLD]|[/LIST]|[/HELP]"
 COLOR 15, 0
 PRINT "Where:"
 COLOR 14, 0
 PRINT "  /ABORT - abort current reboot."
 PRINT "    /ABORTALL - abort all current reboots."
 PRINT "  /ALL - reboot all computers on LAN."
 PRINT "    /ALLX - shutdown all computers on LAN."
 PRINT "  /WARM - warmboot in DOS ignoring Windows reboot."
 PRINT "  /COLD - coldboot in DOS ignoring Windows reboot."
 PRINT "  /LIST - display list of all computers on LAN."
 PRINT "  /HELP - display this boot usage."
 COLOR 15, 0
 PRINT "   (no switch starts local/remote reboot computer prompts)."

' end program
Terminate.Program:
 Locate Max.Row-1,,1
 If Len(Strng3$) Then
    Color 15, 0
    Print Strng3$
    Print
 Endif
 COLOR 7, 0
 PRINT "Exiting utility."
 END

' store default server name
Sub Get.Machine.Name(VarX$)
 On Local Error Goto ErrorTrap19z
 DIM Default.Net AS STRING * 16
 VarX$ = ""
 Default.Net = ""
 InregsX.AX = &H5E00
 InregsX.DS = VARSEG(Default.Net)
 InregsX.DX = VARPTR(Default.Net)
 CALL InterruptX(&H21, InregsX, OutregsX)
 ' check error flag.
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    ' read CH
    VarS = (OutregsX.CX AND &HFF00) / 256
    IF VarS > 0 THEN ' valid name.
       VarX$ = Default.Net
       Imbedded = INSTR(VarX$, CHR$(0))
       IF Imbedded THEN
          VarX$ = LEFT$(VarX$, Imbedded - 1)
       END IF
       VarX$ = UCASE$(RTRIM$(VarX$))
       EXIT SUB
    END IF
 END IF
 ' check net path.
 If VarX$ = "" Then
    Var$ = Environ$("COMPUTERNAME")
    If Len(Var$) Then
       VarX$ = Var$
    Endif
 Endif
ErrorResume19z:
 Exit Sub
ErrorTrap19z:
 Resume ErrorResume19z
End Sub

SUB Read.Rows (Var%)
 ON LOCAL ERROR GOTO Error.Trap62x
 Temp1 = 50
 LOCATE 50, 1, 0
 Var% = 50
 EXIT SUB
Next.Trap1:
 Temp1 = 43
 LOCATE 43, 1, 0
 Var% = 43
 EXIT SUB
Next.Trap2:
 Temp1 = 25
 LOCATE 25, 1, 0
 Var% = 25
 EXIT SUB
Next.Trap3:
 Var% = 12
Error.Resume62x:
 EXIT SUB
Error.Trap62x:
 IF Temp1 = 50 THEN
    RESUME Next.Trap1
 END IF
 IF Temp1 = 43 THEN
    RESUME Next.Trap2
 END IF
 IF Temp1 = 25 THEN
    RESUME Next.Trap3
 END IF
 RESUME Error.Resume62x
END SUB

Sub Pause.Second
 On Local Error Goto Error.Trap4
 Gosub Get.Time
 Timer.Temp!=t1!
 Do
    Gosub Get.Time
    Elapsed.Time!=t1!-Timer.Temp!
    If Elapsed.Time!<SFalse Then
       Elapsed.Time!=Elapsed.Time!+86400! ' adjust for midnight
    Endif
    If Elapsed.Time!>=1! Then
       Exit Do
    Endif
 Loop
 Exit Sub
Get.Time:
 t1$ = Format$(Now, "hh:mm:ss") ' seconds past midnight
 t1! = CSNG(INT(VAL(MID$(t1$, 1, 2)))) * 3600! + CSNG(INT(VAL(MID$(t1$, 4, 2)))) * 60! + CSNG(INT(VAL(MID$(t1$, 7, 2))))
 Return
Error.Resume4:
 Exit Sub
Error.Trap4:
 Resume Error.Resume4
End Sub
