Rem Setup program for Dndbbs v5.0a r1.0a

' startup variables
Rem $Dynamic
Defint A-Z

' startup include file
REM $INCLUDE: 'io9.inc'

' declare error routine
On Error Goto Error.Routine

' parse stdin and quit.
Do
   X$ = Inkey$
   If X$ = Nul Then
      Exit Do
   End If
Loop

' clear Control-Break flag
DEF SEG = &H40
POKE &H71, &H0
DEF SEG

' store command line
Command.Line$=Command$
Command.Line$=Ltrim$(Command.Line$)
Command.Line$=Rtrim$(Command.Line$)

' check boot usage command line
Select Case Command.Line$
Case "-?","/?","/HELP"
   Goto Boot.Usage
End Select

' check for quiet mode switch
TempB$=Nul ' default is C
Var1=Instr(Command.Line$,"/Q:")
If Var1 Then
   Quiet.Mode=True
   Var$=Mid$(Command.Line$,Var1+3,1)
   Var2=3
   If Var$>="A" And Var$<="Z" Then
      TempB$=Var$ ' drive letter
      Var2=4
   Endif
   Command.Line$=Left$(Command.Line$,Var1-1)+Mid$(Command.Line$,Var1+Var2)
Endif
Command.Line$=Ltrim$(Command.Line$)
Command.Line$=Rtrim$(Command.Line$)

' check to over-ride specific node number
TempA$=Nul
If Len(Command.Line$) Then
   If Left$(Command.Line$,3)="/N:" Then
      Var$=Mid$(Command.Line$,4)
      Select Case Len(Var$)
      Case 0
         Eat$=Nul
      Case 1
         Select Case Var$
         Case "0" To "9"
            TempA$=Var$
         Case "A" To "Z"
            TempA$=Var$
         Case Else
            Goto Bad.Node
         End Select
      Case 2
         Var1=Int(Val(Var$))
         If Var1>=10 And Var1<=99 Then
            TempA$=Var$
         Else
            Goto Bad.Node
         Endif
      Case Else
         Goto Bad.Node
      End Select
   Else
      Goto Bad.Node
   Endif
Endif

If Quiet.Mode=False Then
   Color 15,0
   Print "Welcome to the Dndbbs setup program."
   Print
   Print "This routine assumes all the Dndbbs files have been uncompressed into"
   Print "this directory. Setup will now write the default configure file."
   Color 14,0
   Print "Press 'Q' to quit or any key to continue:"
   Input.Char$=Nul
   While Input.Char$=Nul
      Input.Char$=Inkey$
      CALL Release.Time(1)
   Wend
   If Lcase$(Input.Char$)="q" Then
      Color 14,0
      Print "Now exiting Setup.."
      Color 7,0
      End
   Endif
   Color 14,0
   Print "Now writing the default configure files."
Endif
Filename2$="makecnfg.exe"
If Quiet.Mode=False Then
   Filename$="makecnfg.exe /y/n:"+TempA$
Else
   Filename$="makecnfg.exe /y/z/n:"+TempA$+"/d:"+TempB$
Endif
Gosub Shell.Prog
Filename2$="makesys.exe"
If Quiet.Mode=False Then
   Filename$="makesys.exe"
Else
   Filename$="makesys.exe /q"
Endif
Gosub Shell.Prog
If Quiet.Mode=False Then
   Color 15,0
   Print "This directory now contains the complete Dndbbs adventure system. If you"
   Print "did not specify any Ram drive letter, you should install one and restart"
   Print "makecnfg again before starting Dndbbs. Read additional information about"
   Print "Dndbbs in the files Sysop.doc, and Dndbbs.doc."
Endif
Color 7,0
Print "Setup files created."
End

Shell.Prog:
 Current.Directory$=Curdir$
 If Dir$(Filename2$)="" Then
    Print "Can't find: "+Filename2$
 Else
    Shell Filename$
 Endif
 Chdrive Current.Directory$
 Chdir Current.Directory$
 Return

Boot.Usage:
 Color 15,0
 Print "Setup program for Dndbbs:"
 Color 14,0
 Print "Usage:"
 Color 15,0
 Print "   Setup [/N:<node>][/Q:D]"
 Color 14,0
 Print "Where:"
 Color 15,0
 Print "   /N:<node> overrides node (0-9, A-Z, 10-99)."
 Print "   /Q:<D>  quiet mode bypassing prompts,"
 Print "     'D' specifies Ram drive letter."
 Print "     (if D is omitted the current drive letter is used)"
 Color 14,0
 Print "Example:"
 Color 15,0
 Print "   Setup /N:2 /Q:F"
 Color 7,0
 End

Bad.Node:
 Color 15,0
 Print "Bad node. Type 'Setup /?' for usage."
 Color 7,0
 End

Error.Routine:
 Color 15,0
 Error.Number=Err
 Select Case Error.Number
 Case 53
    Print "File not found."
 Case 57
    Print "Device I/O error."
 Case 61
    Print "Disk full."
 Case 62
    Print "Input past eof."
 Case 64
    Print "Bad file name."
 Case 67
    Print "Not enough file handles."
 Case 68
    Print "Device unavailable."
 Case 70
    Print "Permission denied."
 Case 71
    Print "Disk not ready."
 Case Else
    Print "Error";Error.Number;"writing configure files."
 End Select
 Color 7,0
 End

Sub Release.Time(Var)
 On Local Error Goto Error.Trap6a
 If Supported.Call=False Then
    For Var1=1 To Var
       InregsX.AX=&H1680
       InregsX.BX=&H0000
       Call InterruptX(&H2F,InregsX,OutregsX)
       If (OutregsX.AX And &HFF)=&H80 Then
          Supported.Call=True
          Exit For
       Endif
    Next
 Endif
Error.Resume6a:
 Exit Sub
Error.Trap6a:
 Resume Error.Resume6a
End Sub
