REM TEE pipe redirection program v1.2a PD 2015.

' default integer variables
DEFINT A-Z
REM $DYNAMIC

' declare include files
REM $INCLUDE: 'qbx.bi'

' declare registers
COMMON SHARED InregsX AS RegtypeX, OutregsX AS RegtypeX

' declare stdin buffer
COMMON SHARED Pipe.Buffer AS STRING * 1

' declare linefeed format
CONST LINUX=0

' open screen output file
OPEN "SCRN:" FOR OUTPUT AS #1

' check pipe length
InregsX.AX = &H4202 ' eof
InregsX.BX = 0 ' stdin
InregsX.CX = 0
InregsX.DX = 0
Call InterruptX(&H21, InregsX, OutregsX)

' check stdin length
If OutregsX.AX > 0 Then

   ' reset pointer to start of file
   InregsX.AX = &H4200
   InregsX.BX = 0 ' stdin
   InregsX.CX = 0
   InregsX.DX = 0
   Call InterruptX(&H21, InregsX, OutregsX)

   ' start input loop
   DO
      ' read from device
      InregsX.AX = &H3F00
      InregsX.BX = 0 ' stdin
      InregsX.CX = 1 ' char
      InregsX.DS = VARSEG(Pipe.Buffer)
      InregsX.DX = VARPTR(Pipe.Buffer)
      Call InterruptX(&H21, InregsX, OutregsX)

      ' check flag error
      If (OutregsX.Flags AND &H1) = &H1 Then
         Exit Do
      Endif

      ' check length of input
      If OutregsX.AX = 0 Then
         Exit Do
      Endif

      ' store character
      Char$ = Pipe.Buffer

      ' check linebreak character ('C' or DOS).
      IF (ASC(Char$)=10 AND LINUX) OR (ASC(Char$)=13 AND LINUX=0) THEN
         ' send string to screen
         Print #1, Line.Input$

         ' send string to stdout
         Line.Input$ = Line.Input$ + Chr$(13) + Chr$(10)
         For Var = 1 To Len(Line.Input$)
            InregsX.AX = &H0200
            InregsX.DX = ASC(Mid$(Line.Input$, Var, 1))
            CALL InterruptX(&H21,InregsX,OutregsX)
         Next
         Line.Input$ = ""
      ELSE ' store char
         IF (ASC(Char$)=10 AND LINUX=0) THEN
            Eat$=""
         ELSE
            Line.Input$ = Line.Input$ + Char$
         END IF
      END IF
   LOOP
END IF
CLOSE #1
END
