REM Test the difference between linux clock and qb time after midnight.

REM This utility and source are public domain released on 09/15/2019.
REM   Release v1.1a adds timer loop.

REM Compile:
REM   BC Testtime/x/v/o/g3;
REM   LINK Testtime,,,vbdos/e;

'INT 1A - TIME - GET SYSTEM TIME
'        AH = 00h
'Return: CX:DX = number of clock ticks since midnight
'        AL = midnight flag, nonzero if midnight passed since time last read
'Notes:  There are approximately 18.2 clock ticks per second,
'         or 1800B0h per 24 hours.
'
'Notes:  Clock ticks are actually at 18.20648 per second single-precision.

DEFINT A-Z
REM $DYNAMIC

TYPE RegTypeX
 AX AS INTEGER
 BX AS INTEGER
 CX AS INTEGER
 DX AS INTEGER
 BP AS INTEGER
 SI AS INTEGER
 DI AS INTEGER
 Flags AS INTEGER
 DS AS INTEGER
 ES AS INTEGER
END TYPE

DIM InregsX AS RegTypeX, OutregsX AS RegTypeX
DECLARE SUB InterruptX (N AS INTEGER, I AS RegTypeX, O AS RegTypeX)
ON ERROR GOTO ErrorRoutine

If Command$="" Then
   Gosub DisplayTime
   End
Endif

C$ = Command$
If Left$(C$,2)="/R" Then
   C$ = Mid$(C$, 3)
   If Len(C$) Then
      R = Int(Val(C$))
      If R>=1 And R<=86400 Then
         E$=""
      Else
         R=1
      Endif
   Else
      R = 1
   Endif
   Gosub DisplayTime
   On Timer(R) Gosub DisplayTime
   Timer On
   Do
      If Inkey$<>"" Then
         Timer Off
         End
      Endif
   Loop
Endif

color 15
print "Testtime utility v1.1a"
print "Usage:"
color 14
print "  Testtime [/r##]"
color 15
print "Where:"
color 14
print "  /r  realtime display loop."
print "  ##  optional timer override in seconds."
color 7
End

DisplayTime:
t2$ = TIME$ ' linux hour might not be 00-23
t2! = CSNG(INT(VAL(MID$(t2$, 1, 2)))) * 3600! + CSNG(INT(VAL(MID$(t2$, 4, 2)))) * 60! + CSNG(INT(VAL(MID$(t2$, 7, 2))))

t! = TIMER ' system timer (might be beyond 86,400)

' read timer from bios
InregsX.AX = &H0
CALL InterruptX(&H1A, InregsX, OutregsX)
Byte1! = CSNG(OutregsX.CX)
Byte2! = CSNG(OutregsX.DX)
IF Byte1! < 0! THEN Byte1! = Byte1! + 65536! ' adjust signed-integer
IF Byte2! < 0! THEN Byte2! = Byte2! + 65536!
Byte! = Byte1! * 65536! + Byte2!

color 15
PRINT "-----------------"
PRINT "Ticks per second="

color 14

' actual precision: 18.206481481481#
x$ = Str$(&H1800B0 / 86400!) ' per 24 hours
x$ = Left$(x$, len(x$) - 1)
PRINT x$; " (calculated)"
PRINT Byte! / t!; "(realtime)"

Byte! = Byte! / 18.20648!

color 15
PRINT
PRINT "clock date: "; DATE$ ' linux date
PRINT "qb format$ clock: "; Format$(Now,"mm-dd-yyyy") ' dos date
PRINT
PRINT "clock time: "; TIME$
color 14
PRINT " BIOS:  "; Byte!
PRINT " QB:    "; t!
PRINT " TIME$: "; t2!

t1$ = Format$(Now, "hh:mm:ss") ' get dos time
t1! = CSNG(INT(VAL(MID$(t1$, 1, 2)))) * 3600! + CSNG(INT(VAL(MID$(t1$, 4, 2)))) * 60! + CSNG(INT(VAL(MID$(t1$, 7, 2))))
color 15
PRINT "qb format$ clock: ";t1$; " seconds: ";Format$(CDBL(t1!), "#,##0;;0")
T#=24#*60#*60# ' calculate seconds in a day
PRINT "midnight: "; Format$(T#,"#,##0;;0") ;" seconds."
PRINT "midnight difference: ";Format$(CDBL(86400!-t1!), "#,##0;;0");" seconds."
Return
END

ErrorRoutine:
 Print "Error";Err
 End

