REM file: Zsort2.bas - Public Domain DOS Utility

REM specialized function for dndbbs to sort subl.tmp file.

' default integer variables
DEFINT A-Z
REM $DYNAMIC

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' max array
CONST MaxArray = 8192

' declare include files
REM $INCLUDE: 'qbx.bi'

' declare functions
DECLARE FUNCTION ParseLine (S$)
DECLARE FUNCTION BreakIS()
DECLARE FUNCTION ClearBreak()
DECLARE FUNCTION KeyIS()
DECLARE FUNCTION MakeHex$(T%)
DECLARE FUNCTION MakeQBerr$(V2%)
DECLARE FUNCTION LastSwitch(V%)

' declare registers
COMMON SHARED InregsX AS RegtypeX, OutregsX AS RegtypeX
COMMON SHARED InregsX2 AS RegTypeX, InregsX3 AS RegTypeX

' declare work variables
COMMON SHARED Reverse.Sort AS INTEGER, Sort.Column AS INTEGER
COMMON SHARED Lines.Counted AS INTEGER, Max.Lines AS INTEGER
COMMON SHARED Ignore.Case AS INTEGER, Continuous.Display AS INTEGER
COMMON SHARED Strip.Blanks AS INTEGER, Sort.Swaps AS SINGLE
COMMON SHARED Control.Break AS INTEGER, Last.Switch AS INTEGER
COMMON SHARED Windows.Detected AS INTEGER, Pipe.Buffer AS STRING * 1
COMMON SHARED Node AS INTEGER

' declare command line work variables
COMMON SHARED Command.Line AS STRING, Redirected.Input AS INTEGER

' declare external procedures
DECLARE SUB SetInt
DECLARE SUB RestInt

' install new interrupt service routine
CALL SetInt

' declare standard error trap
ON ERROR GOTO Error.Routine

' reset count variables
Max.Lines = MaxArray

' command line switch position function.
FUNCTION LastSwitch(Var)
 If Last.Switch = 0 Then
    Last.Switch = Var - 1
 Else
    If Var < Last.Switch Then
       Last.Switch = Var - 1
    Endif
 Endif
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
 Imbedded = INSTR(Command.Line, LCASE$(X$))
 IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Var = LastSwitch(Imbedded)
    ParseLine = True
 ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
       Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
       Var = LastSwitch(Imbedded)
       ParseLine = True
    ELSE
       ParseLine = False
    END IF
 END IF
END FUNCTION 

' check windows
Windows.Detected = False
IF INSTR(COMMAND$, "/_") THEN
   Windows.Detected = True
END IF

' check command line
SELECT CASE COMMAND$
CASE "/?"
   GOTO Boot.Usage
END SELECT

' read command line from PSP
Command.line = NUL
InregsX.AX = &H6200
CALL InterruptX(&H21, InregsX, OutregsX)
PSPsegment = OutregsX.BX
PSPoffset = 128
DEF SEG = PSPsegment
FOR Count = 1 TO 127
   Command.Char = PEEK(PSPoffset + Count)
   SELECT CASE Command.Char
   CASE 0, 10, 13
      EXIT FOR
   CASE ELSE
      Command.line = Command.line + CHR$(Command.Char)
   END SELECT
NEXT
DEF SEG
IF Command.Line = NUL THEN
   Command.Line = ENVIRON$("ZSORT2")
END IF
Command.Line = RTRIM$(Command.Line)
Command.Line = UCASE$(Command.Line)

' check command line switches
Continuous.Display = True
IF INSTR(COMMAND$, "/C") THEN
   Continuous.Display = False
END IF
Ignore.Case = ParseLine ("/I")
Reverse.Sort = ParseLine ("/R")
Strip.Blanks = ParseLine ("/T")
Control.Break = ParseLine ("/~")
Var = ParseLine("/_")
Var = ParseLine("/C")

' get sort column
Sort.Column = 1
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
   Var = LastSwitch(Imbedded)
   Imbedded2 = Imbedded + 2
   DO
      Switch$ = MID$(Command.Line, Imbedded2, 1)
      IF Switch$ >= "0" AND Switch$ <= "9" THEN
         Column$ = Column$ + Switch$
      ELSE
         EXIT DO
      END IF
      Imbedded2 = Imbedded2 + 1
   LOOP
   IF Column$ = Nul THEN
      GOTO Boot.Error
   END IF
   Sort.Column = INT(VAL(Column$))
   IF Sort.Column = False THEN
      GOTO Boot.Error
   END IF
   Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded2)
END IF

' get sort node
Node = 0
Imbedded = INSTR(UCASE$(Command.Line), "/X")
IF Imbedded THEN
   Var = LastSwitch(Imbedded)
   Imbedded2 = Imbedded + 2
   DO
      Switch$ = MID$(Command.Line, Imbedded2, 1)
      IF Switch$ >= "0" AND Switch$ <= "9" THEN
         Column$ = Column$ + Switch$
      ELSE
         EXIT DO
      END IF
      Imbedded2 = Imbedded2 + 1
   LOOP
   IF Column$ = Nul THEN
      GOTO Boot.Error
   END IF
   V! = INT(VAL(Column$))
   IF V! = False THEN
      GOTO Boot.Error
   END IF
   IF V! > 9999 THEN
      GOTO Boot.Error
   END IF
   Node=Cint(V!)
   Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded2)
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
   GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Last.Switch THEN
   IF LEN(Command.Line) > Last.Switch THEN
      GOTO Boot.Error
   END IF
END IF
IF Command.Line <> Nul THEN
   GOTO Boot.Error
END IF

Filename$ = "subl.tmp"

' check break flag override
IF Control.Break THEN
   Var = ClearBreak
END IF

' search through all redirected input
Lines.Counted = False
Redirected.Input = False

If Dir$(Filename$)="" Then
   Goto Boot.Error2
Endif
Color 15,0
Print "Reading subl.tmp.."
Close #1
Open Filename$ For Input As #1

If Node=0 Then
   Filename2$="sort.swp"
Else
   Filename2$="sort"+Mid$(Str$(Node),2)+".swp"
Endif
Open Filename2$ For Random As #2 Len=128
Field #2, 128 As z$

Do While Not Eof(1)
   Line Input #1,Line1$
   Flag = True
   IF Strip.Blanks THEN
      IF Line1$ = NUL THEN
         Flag = False
      END IF
   END IF
   IF Flag THEN
      Lines.Counted = Lines.Counted + 1
      If Lines.Counted > Max.Lines Then
         Exit Do
      Endif
      Lset z$ = Line1$
      Put #2, Lines.Counted
   END IF
LOOP

' check control break
IF BreakIS THEN
   GOTO End.Zsort
END IF

' shell sort
Print "Sorting ";Filename2$;".."
Color 14,0
Print " ";Format$(Cdbl(Lines.Counted),"#,##0;;");" elements."
Color 15,0
Sort.Swaps = False
Num = Lines.Counted
Span = INT(Num / 2)
DO WHILE Span > False
   IF BreakIS THEN
      EXIT DO
   END IF
   FOR Start = Span TO Num - 1
      FOR Element = (Start - Span + 1) TO 1 STEP -Span
         Get #2, Element
         Sort.Column1$ = MID$(z$, Sort.Column)
         Get #2, Element + Span
         Sort.Column2$ = MID$(z$, Sort.Column)

         Var1$=Sort.Column1$
         Var2$=Sort.Column2$

	 IF Ignore.Case THEN
	    Sort.Column1$ = UCASE$(Sort.Column1$)
	    Sort.Column2$ = UCASE$(Sort.Column2$)
	 END IF
         IF Reverse.Sort THEN
             IF Sort.Column2$ = "" THEN
                 EXIT FOR
             ELSE
                 IF Sort.Column2$ <= Sort.Column1$ THEN
                     EXIT FOR
                 END IF
             END IF
         ELSE
             IF Sort.Column1$ = "" THEN
                 EXIT FOR
             ELSE
                 IF Sort.Column1$ <= Sort.Column2$ THEN
                     EXIT FOR
                 END IF
             END IF
         END IF
         Lset z$=Var1$
         Put #2,Element+Span
         Lset z$=Var2$
         Put #2,Element
	 Sort.Swaps = Sort.Swaps + 1
      NEXT
   NEXT
   Span = INT(Span / 2)
LOOP

' check break
IF BreakIS THEN
   GOTO End.Zsort
END IF

' output array
Print "Writing subl.srt.."
Filename$="subl.srt"
Close #1
Open Filename$ For Output As #1

FOR Array.Line = 1 TO Lines.Counted
   Get #2,Array.Line
   Var$=z$
   Var$=Rtrim$(Var$)
   PRINT #1,Var$
   Bytes.Written!=Bytes.Written!+Len(Var$)+2!
NEXT
Close
Kill Filename2$
End.Zsort:

' display counters
IF Continuous.Display = False THEN
   COLOR Yellow, Black
   PRINT "Lines counted: "; Format$(Cdbl(Lines.Counted),"#,##0;;")
   PRINT "Sort swaps made: "; Format$(Cdbl(Sort.Swaps),"#,##0;;")
   Print "Bytes written: "; Format$(Cdbl(Bytes.Written!),"#,##0;;")
   Prompt$ = "Press <enter> to exit to DOS:"
   CALL MorePrompt(Prompt$, CHR$(13), Outpt$)
END IF

' restore key trapping
CALL RestInt
COLOR Plain, Black
END

Boot.Usage:
 ' restore key trapping
 CALL RestInt
 Var$=Inkey$
 ' make header
 COLOR White, Black
 PRINT "Zsort2 v1.0a: Dndbbs sort utility; "
 Print "  Sorts subl.tmp and writes to subl.srt."
 COLOR Yellow, Black
 PRINT "Usage:"
 PRINT "   Zsort2 [/cinrtx]"
 PRINT "Where:"
 PRINT "   /c  display filecount"
 PRINT "   /i  ignore case"
 PRINT "   /n###  sort at column"
 PRINT "   /r  reverse order"
 PRINT "   /t  strip blank lines"
 PRINT "   /x###  sort swap node"
 COLOR Plain, Black
 END

Boot.Error:
 CALL RestInt
 Var$=Inkey$
 COLOR White, Black
 PRINT "Command line error. Type Zsort2 /? for help."
 COLOR Plain, Black
 END

Boot.Error2:
 CALL RestInt
 Var$=Inkey$
 COLOR White, Black
 PRINT "Subl.tmp not found. Run Countlbl."
 COLOR Plain, Black
 END

' critical error trap
Error.Routine:
 Data.Error = ERR
 COLOR Green, Black
 SELECT CASE Data.Error
 CASE 9
    PRINT "Subscript out of range."
    Color 7,0
    END
 CASE 14
    PRINT "Out of string space."
    Color 7,0
    END
 CASE ELSE
    Temp.Outpt$ = "Critical error: '" + MakeQBerr$(Data.Error) + "' in Zsort2."
 END SELECT
 PRINT Temp.Outpt$
 Prompt$ = "Press R to retry, Q to quit, C to continue:"
 CALL MorePrompt(Prompt$, "rqc", Outpt$)
 IF BreakIS THEN
    Outpt$ = "q"
 END IF
 SELECT CASE Outpt$
 CASE "r"
    RESUME
 CASE "q"
    Error.Level = True
    RESUME End.Zsort
 CASE "c"
    OutregsX.Flags = &H1
    RESUME NEXT
 END SELECT
 COLOR Plain, Black
 ' restore key trapping
 CALL RestInt
 END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$ + " ";
 Input.Char$ = NUL
 DO
    LOCATE , , 1
    InregsX2 = InregsX
    DO
       IF BreakIS THEN
          EXIT DO
       END IF
       IF KeyIS THEN
          IF OutregsX.AX <> 0 THEN
             InregsX.AX = &H0000
             CALL InterruptX(&H16, InregsX, OutregsX)
             Input.Char$=CHR$(OutregsX.AX AND &HFF)
             EXIT DO
          END IF
       END IF
       ' release time slice.
       InregsX.AX = &H1680
       InregsX.BX = &H0000
       CALL InterruptX(&H2F, InregsX, OutregsX)
    LOOP
    InregsX = InregsX2
    IF BreakIS THEN
       EXIT DO
    END IF
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' clears Control-Break flag
FUNCTION ClearBreak
 DEF SEG = &H40
 POKE &H71, &H0
 DEF SEG
 ClearBreak = True
END FUNCTION

' checks Control-Break
FUNCTION BreakIS
 STATIC Var AS INTEGER
 IF Redirected.Input THEN
    DEF SEG = &H40
    X = PEEK(&H71)
    DEF SEG
    IF X = 64 THEN
       Var = True
    END IF
 END IF
 IF KeyIS THEN
    IF OutregsX.AX = 0 THEN
       Var = True
       DEF SEG = &H40
       POKE &H71, 64
       DEF SEG
    END IF
 END IF
 IF Var THEN
    Continuous.Display = True
 END IF
 BreakIS = Var
END FUNCTION

' checks keyboard buffer
FUNCTION KeyIS
 InregsX3 = InregsX
 InregsX.AX = &H0100
 CALL InterruptX(&H16, InregsX, OutregsX)
 InregsX = InregsX3
 IF (OutregsX.Flags AND &H40) = &H40 THEN
    KeyIS = False
 ELSE
    KeyIS = True
 END IF
END FUNCTION
