/***************************************************************************\
*                                                                           *
*   CID.C       Copyright 1992-1993 Sequiter Software Inc.                       *
*                                                                           *
*                                                                           *
*****************************************************************************
*                                                                           *
*       This program allows the user to quickly use all of the main         *
*   functions of CodeBase 4.5.                                              *
*                                                                           *
\***************************************************************************/

#include    <conio.h>
#include    <dos.h>
#include    "d4all.h"
#include    "w4.h"
#include    "cid.h"
#include    "g4char.h"


CODE4  CodeBase;
LIST4   RelList;
struct  DATALIST    *FirstData = NULL;
int     Aborted = FALSE,FuctionType = 0;
char    DefaultPath[80];
extern  CB_WINDOW  *v4window;
int     DataRef=-1,LastEntry = 0,DataEntry = 0,LastError=0;

long    BackGroundColor,NormalBord,NormalText,WarningBord,
        WarningText,ReturnBord,ReturnText,MenuText,
        MenuSelected,PopUpText,GetColor,TitleBarColor,SelectedColor;

#ifdef __TURBOC__
    extern  unsigned    _stklen = 10000;
#endif
void FreeRel( void )
{
   struct RELATELIST  *current;

   while( (current = (struct RELATELIST *) l4pop(&RelList)) != NULL)
      u4free(current);
}

/***************************************************************************\
\***************************************************************************/

int     FileNameWindow(char *Title,char *Usage,char *Extension,char *FileName,int Code)
{

    int     Win1,Choice,Ret,count;
    char    Dir[60],NamePart[10],ExtPart[5];

    memset(Dir,0,59);
    strcpy(Dir,DefaultPath);
    strcpy(NamePart,"        \0");
    strcpy(ExtPart,Extension);
    strcpy(Usage," DATA4 *d4create(CODE4 *cb,char *name ... )");
    Win1 = EntryWindow(Title);

    if(Win1)
    {
	w4(1,2,CID_USA);
	w4(3,2,CID_DCT);
	w4(3,45,CID_FIL);
	switch(Code)
	{
	    case 1:
		w4(5,1,"FIELD4INFO");
		w4box(SINGLE,6,1,18,26);
		w4(5,28,"TAG4INFO");
		w4box(SINGLE,6,28,18,70);
		break;
	    case 2:
		w4(5,14,"TAG4INFO");
		w4box(SINGLE,6,14,18,56);
		break;
	}
	w4attribute(NormalText);
	w4(1,9,Usage);
	w4attribute(GetColor);
	w4(3,50,"        .   ");
	g4attribute(GetColor);

        Choice = 27;
        while(Choice != 13 && !Aborted)
        {
            g4(3,13,Dir);
            g4width(40,30);
            g4valid(CheckDir);
            g4(3,50,NamePart);
            g4picture("!!!!!!!!");
            g4valid(CheckFileName);
            g4(3,59,ExtPart);
            g4picture("!!!");

            Choice = g4read();
            if(Choice == 27)
            {
                Ret = Continue("",CID_AOP,"","",CID_CON,CID_ABO);
                if(Ret == 0)
                Aborted = TRUE;
            }
        }
    }
    if(Aborted)
    {
        Aborted = FALSE;
        w4deactivate(Win1);
        w4close(Win1);
        return(0);
    }
    else
    {
        count = 0;
        while(NamePart[count] == ' ')
	    count++;

        strcpy(DefaultPath,Dir);
        if(NamePart[count] == '0')
            strcpy(FileName,"0");
        else
        {
            c4trim_n(Dir,strlen(Dir)+1);
            strcpy(FileName,Dir);
            strcat(FileName,&(NamePart[count]));
            strcat(FileName,".");
            strcat(FileName,ExtPart);
        }
        return(Win1);
    }
}
/***************************************************************************\
\***************************************************************************/


int     FileRequesterWindow(char *Title,char *Usage,char *Extension,char *FilePathName)
{
    int     Win,Choice,FileWin,NotDone,count=0,Ret;
    char    Dir[42],Path[60],FileNames[13*30],FileName[13],NewName[13];

    strcpy(Dir,"                                        ");
    strcpy(Dir,FilePathName);
    Win = EntryWindow(Title);

    w4(1,2,CID_USA);
    w4(3,2,CID_DCT);
    w4(5,34,CID_FIL);
    w4box(SINGLE,5,9,18,24);
    w4attribute(NormalText);
    w4(1,9,Usage);
    w4attribute(GetColor);
    w4(5,40,"             ");

    g4attribute(GetColor);

    Choice = 27;
    while(Choice == 27 && !Aborted)
    {
        g4(3,13,Dir);
        g4width(40,40);
        g4valid(CheckDir);
        Choice = g4read();
        if(Choice == 27)
        {
            Ret = Continue("",CID_AOP,"","",CID_CON,CID_ABO);
            if(Ret == 0)
            Aborted = TRUE;
        }
    }

    if(!Aborted)
    {
        strcpy(DefaultPath,Dir);
        FileWin = w4define(8,13,21,28);
        w4border(SINGLE,NormalBord);
        w4attribute(NormalBord);
        w4popup();
        w4title(0,5,CID_SEL,NormalBord);

        n4attribute(PopUpText,MenuSelected);
        n4item_width(12);

        strcpy(Path,Dir);
        strcat(Path,Extension);
        NotDone = u4file_first(Path,NewName);
        if(!NotDone)
            while(!NotDone && count < 20)
            {
                strcpy(&(FileNames[count*13]),NewName);
                n4(&(FileNames[count*13]));
                n4parm(count);
                count ++;
                NotDone = u4file_next(NewName);
            }

        if(count == 0)
        {
            Message(CID_NOF,Extension,CID_DIR,"",CID_ABO);
            Aborted = TRUE;
        }
        else
        {
            Choice =27;
            while(Choice == 27 && !Aborted)
            {
                Choice = n4activate(FileWin);
                if(Choice == 27)
                {
                    Ret = Continue("",CID_AOP,"","",CID_CON,CID_ABO);
                    if(Ret == 0)
                        Aborted = TRUE;
                }
                else
                    strcpy(FileName,&(FileNames[Choice*13]));
            }
        }
        w4close(FileWin);

    }
    w4select(Win);
    if(!Aborted)
    {
        w4attribute(GetColor);
        w4(5,40,FileName);
        strcpy(FilePathName,Dir);
        strcat(FilePathName,FileName);

        return(Win);
    }
    else
    {
        Aborted = FALSE;
        w4deactivate(Win);
        w4close(Win);
        return(0);
    }
}

/***************************************************************************\
\***************************************************************************/

int     GetDataWindow(DATA4 **DataParm,char *Title,char *Usage,char *Parm1,
                        char *Result1,int Extra,int GetType)
{
    int Win,Menu,Count,Choice,Ret,GetInt=0;
    long    GetLong = 0;
    double  GetDouble = 0.0;
    struct  DATALIST *Current;
    DATA4  *Data;

    if(FirstData == NULL)
        Message("",CID_DBF, CID_PRI,"",CID_CON);
    else
    {
    Win = EntryWindow(Title);
    w4(1,2,CID_USA);
    w4(3,2,CID_DBS);
    if(Extra == 1)
    {
        w4(6,31,Parm1);
        w4box(SINGLE,5,29,8,69);

    }
    else if(Extra == 2)
        w4box(SINGLE,5,28,18,69);
    else if(Extra == 3)
    {
        w4box(SINGLE,5,28,18,43);
        w4(5,30,CID_SLF);
        Extra = 0;
    }

    w4box(SINGLE,5,2,18,26);
    w4attribute(GetColor);
    if(Extra)
        w4(7,31,Result1);
    w4(3,13,"                    ");
    w4attribute(NormalText);
    w4(1,9,Usage);

    Menu = w4define(8,6,21,30);
    w4border(SINGLE,NormalBord);
    w4attribute(NormalBord);
    w4popup();
    w4title(0,5,CID_SLD,NormalBord);

    n4attribute(PopUpText,MenuSelected);

    Current = FirstData;
    Count = 0;
    while(Current != NULL)
    {
        Count++;
        Data = Current->Data;
        Current->Item = Count;
        strcpy(Current->Alias,d4alias(Data));

        n4(Current->Alias);
        n4item_width(20);
        n4parm(Count);
        Current = Current->Next;
    }

    Choice = 27;
    while(Choice == 27 && !Aborted)
    {
        Choice = n4activate(Menu);
        if(Choice == 27)
        {
            Ret = Continue("",CID_AOP,"","",CID_CON,CID_ABO);
            if(Ret == 0)
            Aborted = TRUE;
        }
    }
    w4close(Menu);
    if(!Aborted)
    {
        Current = FirstData;
        Ret = FALSE;
        Data = NULL;
        while(Current != NULL && !Ret)
        {
            if(Current->Item == Choice)
            {
                Data = Current->Data;
                *DataParm = Data;
                Ret = TRUE;
            }
            else
                Current = Current->Next;
        }
        if(!Ret || Data == NULL)
            e4severe( e4info, "GetDataWindow()");
        w4select(Win);

        w4attribute(GetColor);
        w4(3,13,d4alias(Data));

        if(Extra)
        {
            Choice = 27;
            while(Choice == 27 && !Aborted)
            {
                g4attribute(GetColor);
                switch(GetType)
                {
                    case INTTYPE:
                        g4int(7,31,&GetInt);
                        g4picture("#######");
                        break;
                    case LONGTYPE:
                        g4long(7,31,&GetLong);
                        g4picture("#######");
                        break;
                    case DOUBLETYPE:
                        g4double(7,31,&GetDouble);
                        g4picture("#####.##");
                        break;
                    case CHARTYPE:
                        g4(7,31,Result1);
                        break;
                }
                Choice = g4read();
                if(Choice == 27)
                {
                    Ret = Continue("",CID_AOP,"","",CID_CON,CID_ABO);
                    if(Ret == 0)
                    Aborted = TRUE;
                }
            }
            if(!Aborted)
            {
                switch(GetType)
                {
                    case INTTYPE:
                        sprintf(Result1," %d ",GetInt);
                        break;
                    case LONGTYPE:
                        sprintf(Result1," %ld ",GetLong);
                        break;
                    case DOUBLETYPE:
                        sprintf(Result1," %lf ",GetDouble);
                        break;

                }
            }

        }
    }
    if(Aborted)
    {
        Aborted = FALSE;
        w4deactivate(Win);
        w4close(Win);
        return(0);
    }
    else
        return(Win);
    }
    return(0);
}

/***************************************************************************\
*                                                                           *
*   Get Field Window                                                        *
*                                                                           *
\***************************************************************************/

int     GetFieldWindow(DATA4 **Data,FIELD4 **Field,char *Title,char *Usage)
{
    int     Win,FieldMenu,Selection,Aborted = 0,Ret;

    Win = GetDataWindow(Data,Title,Usage,"","",3,0);
    if(Win)
    {

        Selection = 27;
        while(Selection == 27 && !Aborted)
        {
            FieldMenu = w4define(8,32,21,47);
            w4border(SINGLE,NormalBord);
            w4attribute(NormalBord);
            w4popup();
            w4title(0,2,CID_SLF,NormalBord);
            n4attribute(PopUpText,MenuSelected);
            for(Selection = 1;Selection <= d4num_fields(*Data);Selection++)
            {
                *Field = d4field_j(*Data,Selection);
                n4(f4name(*Field));
                n4parm(Selection);
            }
            Selection = n4activate(FieldMenu);
            if(Selection == 27)
            {
                Ret = Continue("",CID_AOP,"","",CID_CON,CID_ABO);
                if(Ret == 0)
                    Aborted = TRUE;
            }
            w4deactivate(FieldMenu);
            w4close(FieldMenu);
        }
        if(!Aborted)
            *Field = d4field_j(*Data,Selection);
        else
        {
            *Field = 0;
            *Data = 0;
            w4deactivate(Win);
            w4close(Win);
            Win = 0;
        }
    }
    return(Win);
}


/***************************************************************************\
*                                                                           *
*   Data Functions                                                          *
*                                                                           *
\***************************************************************************/

/***************************************************************************\
\***************************************************************************/

void    d4closeallFunct( void )
{
    char Title[20],Usage[60],ReturnChar[40];
    int ReturnInt;

    ReturnInt = d4close_all(&CodeBase);
    FreeData(); /* Free linked list of data aliases */
    FreeRel();
    strcpy(Title," d4close_all ");
    strcpy(Usage," int d4close_all(CODE4 *code_base) ");
    ReturnCode(ReturnChar,ReturnInt);
    FunctionReturn(Title,Usage,0,ReturnChar);
}

void    d4optFunct( void )
{
    char Title[20],Usage[60],ReturnChar[40];
    int ReturnInt;

    ReturnInt = d4opt_start(&CodeBase);

    strcpy(Title," d4opt_start ");
    strcpy(Usage," int d4opt_start(CODE4 *code_base) ");
    ReturnCode(ReturnChar,ReturnInt);
    FunctionReturn(Title,Usage,0,ReturnChar);
}

void    d4optSuspendFunct( void )
{
    char Title[20],Usage[60],ReturnChar[40];
    int ReturnInt;

    ReturnInt = d4opt_suspend(&CodeBase);

    strcpy(Title," d4opt_suspend ");
    strcpy(Usage," int d4opt_suspend(CODE4 *code_base) ");
    ReturnCode(ReturnChar,ReturnInt);
    FunctionReturn(Title,Usage,0,ReturnChar);
}

/***************************************************************************\
*                                                                           *
*       Function    d4createFunct                                           *
*                                                                           *
\***************************************************************************/

void    GetFieldInfo(struct FIELDLIST **Field,int Row,int Col,int *Entries)
{
    char    Name[12],Type[4],Length[6],Decimals[6];
    int     Ret = 0;

    if(*Field == NULL)
    {
        *Field =(struct FIELDLIST *) u4alloc(sizeof(struct FIELDLIST));
        (*Field)->Next = NULL;
        strcpy(Name,"          ");
        strcpy(Type,"C");
        strcpy(Length,"  20");
        strcpy(Decimals,"   0");
        (*Entries) ++;
    }
    else
    {
        strcpy(Name,((*Field)->Name));
        sprintf(Type,"%c",((*Field)->Type));
        sprintf(Length,"%4d",((*Field)->Len));
        sprintf(Decimals,"%4d",((*Field)->Dec));
    }

    w4attribute(NormalBord);
    w4(Row  ,Col,"NAME     TYPE LEN  DEC");
    w4attribute(GetColor);
    w4(Row+1,Col,"                   ");
    while(Ret != 13)
    {
        g4(Row+1,Col,Name);
        g4picture("!!!!!!!!!!");
        g4valid(CheckBlank);
        g4(Row+1,Col+11,Type);
        g4picture("!");
        g4valid(CheckType);
        g4(Row+1,Col+13,Length);
        g4valid(CheckBlank);
        g4picture("9999");
        g4valid(CheckBlank);
        g4(Row+1,Col+18,Decimals);
        g4picture("9999");
        Ret = 27;
        while(Ret == 27)
            Ret = g4read();
    }

    strcpy(((*Field)->Name),Name);
    (*Field)->Type = Type[0];
    (*Field)->Len = c4atoi(Length,strlen(Length));
    (*Field)->Dec = c4atoi(Decimals,strlen(Decimals));
    strcpy((*Field)->FieldStr,Name);
    strcat((*Field)->FieldStr,"");
    strcat((*Field)->FieldStr,Type);
    strcat((*Field)->FieldStr,"");
    strcat((*Field)->FieldStr,Length);
    strcat((*Field)->FieldStr,"");
    strcat((*Field)->FieldStr,Decimals);
}

void    GetTagInfo(struct TAGLIST **Field,int Row,int Col,int *Entries)
{
    char    Name[12],Expr[62],Filter[62],Unique[6],Descending[6];
    int     Ret = 0;

    if(*Field == NULL)
    {
        *Field =(struct TAGLIST *) u4alloc(sizeof(struct TAGLIST));
        (*Field)->Next = NULL;
        strcpy(Name,"          ");
        strcpy(Expr,"                                                            ");
        strcpy(Filter,"                                                            ");
        strcpy(Unique,"   0");
        strcpy(Descending,"   0");
        (*Entries) ++;
    }
    else
    {
        strcpy(Name,((*Field)->Name));
        strcpy(Expr,((*Field)->Expr));
        strcpy(Filter,((*Field)->Filter));

        sprintf(Unique,"%4d",((*Field)->Unique));
        sprintf(Descending,"%4d",((*Field)->Descending));
    }

    w4attribute(NormalBord);
    w4(Row  ,Col,"NAME     KEY EXPR  FILTER    UNIQ DECND");
    w4attribute(GetColor);
    w4(Row+1,Col,"                                   ");
    while(Ret != 13)
    {
        g4attribute(GetColor);
        g4(Row+1,Col,Name);
        g4picture("!!!!!!!!!!");
        g4width(10,9);
        g4valid(CheckBlank);
        g4(Row+1,Col+10,Expr);
        g4picture("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        g4valid(CheckBlank);
        g4width(60,9);
        g4(Row+1,Col+20,Filter);
        g4picture("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        g4width(60,9);
        g4(Row+1,Col+30,Unique);
        g4picture("9999");
        g4valid(CheckBlank);
        g4(Row+1,Col+35,Descending);
        g4picture("9999");
        Ret = 27;
        while(Ret == 27)
            Ret = g4read();
    }

    strcpy(((*Field)->Name),Name);
    strcpy(((*Field)->Expr),Expr);
    strcpy(((*Field)->Filter),Filter);
    (*Field)->Unique = c4atoi(Unique,strlen(Unique));
    (*Field)->Descending = c4atoi(Descending,strlen(Descending));
    Name[9] =0;
    strcpy((*Field)->FieldStr,Name);
    strcat((*Field)->FieldStr,"");
    Expr[9] = 0;
    strcat((*Field)->FieldStr,Expr);
    strcat((*Field)->FieldStr,"");
    Filter[9] = 0;
    strcat((*Field)->FieldStr,Filter);
    strcat((*Field)->FieldStr,"");
    strcat((*Field)->FieldStr,Unique);
    strcat((*Field)->FieldStr,"");
    strcat((*Field)->FieldStr,Descending);
}


FIELD4INFO    *EnterFields(struct FIELDLIST *First,int Row,int Col,int *Entries)
{
    struct FIELDLIST *Field;
    int OldWindow,FieldMenu,Selection = 0,count;
    FIELD4INFO    *FieldInfo;

    OldWindow = w4select(-1);

    while(Selection != 2000)
    {
        FieldMenu=w4define(Row,Col,Row+12,Col+25);
        w4border(SINGLE,NormalBord);
        w4attribute(NormalBord);
        n4attribute(PopUpText,MenuSelected);
        Field = First;
        for(count = 0;count < *Entries;count ++)
        {
            n4(Field->FieldStr);
            n4parm(count);
            Field = Field->Next;
        }
        Selection = n4(CID_ADD);
        n4parm(1000);
        n4start_item(Selection);
        n4(CID_DON);
        n4parm(2000);
        Selection = 27;
        while(Selection == 27)
            Selection = n4activate(FieldMenu);
        w4close(FieldMenu);
        w4select(OldWindow);
        w4attribute(NormalBord);
        w4box(SINGLE,6,1,18,26);
        if(Selection == 1000)
        {
            Field = First;
            while(Field->Next != NULL)
                Field = Field->Next;
            GetFieldInfo(&Field->Next,7,3,Entries);
        }
        else if(Selection != 2000)
        {
            Field = First;
            for(count = 0;count < Selection;count ++)
                Field = Field->Next;
            GetFieldInfo(&Field,7,3,Entries);
        }

    }
    FieldInfo = (FIELD4INFO *) u4alloc((*Entries+1) * sizeof(FIELD4INFO));
    Field = First;
    for(count = 0;count < *Entries;count ++)
    {
        FieldInfo[count].name = Field->Name;
        FieldInfo[count].len = Field->Len;
        FieldInfo[count].type = Field->Type;
        FieldInfo[count].dec = Field->Dec;
        Field = Field->Next;
    }
    FieldInfo[count].name = 0;
    FieldInfo[count].len = 0;
    FieldInfo[count].dec = 0;
    FieldInfo[count].type = 0;

    return(FieldInfo);
}

TAG4INFO  *EnterTags(struct TAGLIST **FirstField,int Row,int Col,int *Entries)
{
    struct TAGLIST *Field,*First;
    int OldWindow,FieldMenu,Selection = 0,count;
    TAG4INFO  *TagInfo;

    First = NULL;
    OldWindow = w4select(-1);

    while(Selection != 2000)
    {
        FieldMenu=w4define(Row,Col,Row+12,Col+42);
        w4border(SINGLE,NormalBord);
        w4attribute(NormalBord);
        n4attribute(PopUpText,MenuSelected);
        Field = First;
        for(count = 0;count < *Entries;count ++)
        {
            n4(Field->FieldStr);
            n4parm(count);
            Field = Field->Next;
        }
        Selection = n4(CID_TAG);
        n4parm(1000);
        n4start_item(Selection);
        n4(CID_DNE);
        n4parm(2000);

        Selection = 27;
        while(Selection == 27)
            Selection = n4activate(FieldMenu);
        w4close(FieldMenu);
        w4select(OldWindow);
        w4attribute(NormalBord);
        w4box(SINGLE,6,Col- 4,18,Col + 38);
        if(Selection == 1000 )
        {
            if(*Entries == 0)
            {
                GetTagInfo(FirstField,Row-2,Col-2,Entries);
                First = *FirstField;
            }
            else
            {
                Field = First;
                while(Field->Next != NULL)
                    Field = Field->Next;

                GetTagInfo(&Field->Next,Row-2,Col-2,Entries);
            }
        }
        else if(Selection != 2000 && *Entries > 0)
        {
            Field = First;
            for(count = 0;count < Selection;count ++)
                Field = Field->Next;
            GetTagInfo(&Field,Row-2,Col-2,Entries);
        }

    }
    if(*Entries > 0)
    {
        TagInfo = (TAG4INFO *) u4alloc((*Entries+1)* sizeof(TAG4INFO));
        Field = First;
        for(count = 0;count < *Entries;count ++)
        {
            TagInfo[count].name = Field->Name;
            TagInfo[count].expression = Field->Expr;
            if(EmptyStr(Field->Filter))
                TagInfo[count].filter = 0;
            else
                TagInfo[count].filter = Field->Filter;
            TagInfo[count].unique = Field->Unique;
            TagInfo[count].descending = Field->Descending;
            Field = Field->Next;
        }
        TagInfo[count].name = 0;
        TagInfo[count].expression = 0;
        TagInfo[count].filter = 0;
        TagInfo[count].unique = 0;
        TagInfo[count].descending = 0;
    }
    else
        TagInfo = NULL;

    return(TagInfo);
}

void    d4createFunct( void )
{
    int     Win1,Entries = 0,TagEntries = 0;
    char    FileName[70],Usage[60],ReturnStr[60];
    DATA4  *Data;
    struct  FIELDLIST *First = NULL;
    struct  TAGLIST   *FirstTag = NULL;
    FIELD4INFO    *Fields;
    TAG4INFO      *Tags;

    strcpy(Usage," DATA4 *d4create(CODE4 *cb,char *name ... )");
    Win1 = FileNameWindow(" d4create ",Usage,"DBF",FileName,1);

    if(Win1)
    {
        GetFieldInfo(&First,7,3,&Entries);
        Fields = EnterFields(First,9,5,&Entries);
        Tags = EnterTags(&FirstTag,9,32,&TagEntries);
        Data = d4create(&CodeBase,FileName,Fields,Tags);

        if(Fields)
            u4free(Fields);
        if(Tags)
            u4free(Tags);
        FreeFields(First);
        FreeTags(FirstTag);
        w4deactivate(Win1);
        w4close(Win1);

        if(Data)
        {
            sprintf(ReturnStr,"Valid DATA4 Pointer");
            AddData(Data);
            FunctionReturn(" d4create ",Usage,Data,ReturnStr);
        }
        else
        {
            sprintf(ReturnStr,CID_ERR,CodeBase.error_code);
            FunctionReturn(" d4create ",Usage,0,ReturnStr);
        }
        e4set(&CodeBase,0);


    }
}

/***************************************************************************\
*                                                                           *
*   Function    d4openFunct                                                 *
*                                                                           *
\***************************************************************************/

void    d4openFunct( void )
{
    int     Win1;
    char    FileName[70],Usage[60],ReturnStr[60];
    DATA4  *Data;

    strcpy(FileName,DefaultPath);
    strcpy(Usage," DATA4 *d4open(CODE4 *code_base, char *name)");

    Win1 = FileRequesterWindow(" d4open ",Usage,"*.DBF",FileName);

    if(Win1)
    {
        Data = d4open(&CodeBase,FileName);

        w4deactivate(Win1);
        w4close(Win1);

        if(Data)
        {
            sprintf(ReturnStr,"Valid DATA4 Pointer ");
            AddData(Data);
            FunctionReturn(" d4open ",Usage,Data,ReturnStr);
        }
        else
        {
            sprintf(ReturnStr,CID_ERR,CodeBase.error_code);
            FunctionReturn(" d4open ",Usage,0,ReturnStr);
        }
    }
}

/***************************************************************************\
*                                                                           *
*   FUNCTION:   d4tag_selectFunct                                           *
*                                                                           *
\***************************************************************************/

TAG4    *TagSelect(DATA4 *Data,int row,int col,int dono_select)
{
    TAG4   *FirstTag,*Tag;
    int     TagNumber,TagMenu,Selection;

    TagMenu = w4define(row,col,row +13,col+ 28);
    if(TagMenu)
    {
        w4border(SINGLE,NormalBord);
        w4attribute(NormalBord);
        w4title(0,5,CID_SLT,NormalBord);
        w4popup();
        n4attribute(PopUpText,MenuSelected);
        n4item_width(13);
        n4(CID_NAT);
        n4parm(0);

        d4tag_select(Data,0);
        FirstTag = d4tag_default(Data);
        TagNumber = 1;
        Tag = FirstTag;
        while(Tag != NULL)
        {
            n4(Tag->alias);
            n4parm(TagNumber);
            n4item_width(13);
            TagNumber ++;
            Tag = d4tag_next(Data,Tag);
        }
        Selection = n4activate(TagMenu);
        if(Selection == 0)
            Tag = NULL;
        else
        {
            Tag = FirstTag;
            for(TagNumber = 1;TagNumber < Selection;TagNumber ++)
                Tag = d4tag_next(Data,Tag);
        }
        if(!dono_select)
           d4tag_select(Data,Tag);
        w4deactivate(TagMenu);
        w4close(TagMenu);
        return Tag;
    }
}

void    d4tag_selectFunct( void )
{
    int     Win1;
    char    FileName[70],Usage[60];
    DATA4  *Data;

    strcpy(FileName,DefaultPath);
    strcpy(Usage," TAG4 *d4tag_select(DATA4 *data, TAG4 *tag)");

    Win1 = GetDataWindow(&Data," d4tag_select ",Usage,"","",0,0);
    if(Win1)
    {
        TagSelect(Data,8,32,0);
        w4deactivate(Win1);
        w4close(Win1);
        FunctionReturn(" d4tag_select ",Usage,Data,"N/A");
    }

}


/***************************************************************************\
*                                                                           *
*   Function:   d4zapFunct()                                                *
*                                                                           *
\***************************************************************************/


void    d4zapFunct( void )
{
    int     Win1,Win3,Ret;
    char    FileName[70],Usage[60],ReturnStr[40];
    DATA4  *Data;
    long    StartRec=0,EndRec=0;

    strcpy(FileName,DefaultPath);
    strcpy(Usage," DATA4 *d4zap(DATA4 *data,long start_rec,long end_rec)");
    Win1 = GetDataWindow(&Data," d4zap ",Usage,"","",0,0);
    if(Win1)
    {
        w4attribute(NormalBord);
        w4(6,31,"Starting  Record");
        w4box(SINGLE,5,29,8,69);
        w4(10,31,"Ending     Record");
        w4box(SINGLE,9,29,12,69);
        g4attribute(GetColor);
        g4long(7,31,&StartRec);
        g4picture("#######");
        g4long(11,31,&EndRec);
        g4picture("#######");
        g4read();

        Win3 = Busy(CID_ZAP,"",CID_WAI,"");
        Ret = d4zap(Data,StartRec,EndRec);
        ClearBusy(Win3);
        w4deactivate(Win1);
        w4close(Win1);
        ReturnCode(ReturnStr,Ret);
        FunctionReturn(" d4zap ",Usage,Data,ReturnStr);
    }
}

void    d4update_headerFunct( void )
{
    int     Win1,Ret;
    char    FileName[70],Usage[60],ReturnStr[40];
    DATA4  *Data;
    int StartRec=0,EndRec=0;

    strcpy(FileName,DefaultPath);
    strcpy(Usage," int *d4update_header(DATA4 *data,int do_time,int do_count)");
    Win1 = GetDataWindow(&Data," d4update_header ",Usage,"","",0,0);
    if(Win1)
    {
        w4attribute(NormalBord);
        w4(6,31,"Do Time Stamp");
        w4box(SINGLE,5,29,8,69);
        w4(10,31,"Do Record Count");
        w4box(SINGLE,9,29,12,69);
        g4attribute(GetColor);
        g4int(7,31,&StartRec);
        g4picture("#####");
        g4int(11,31,&EndRec);
        g4picture("#####");
        g4read();
        Ret = d4update_header(Data,StartRec,EndRec);

        w4deactivate(Win1);
        w4close(Win1);
        ReturnCode(ReturnStr,Ret);
        FunctionReturn(" d4update_header ",Usage,Data,ReturnStr);
    }
}

/***************************************************************************\
*                                                                           *
*   Browser Functions                                                       *
*                                                                           *
\***************************************************************************/

long    GetGo( void )
{
    int     Win;
    long    Ret;
    char    ReturnStr[128];

    Win = w4define(1,22,3,32);
    w4popup();
    w4attribute(NormalBord);
    w4activate(Win);
    Aborted = SingleGet(0,0,LONGTYPE,9,9,ReturnStr);
    if(Aborted)
        Ret = -1;
    else
        Ret = atol(ReturnStr);
    w4deactivate(Win);
    w4close(Win);
    return(Ret);
}

void    GetSeek(char *Seek )
{
    int     Win;

    Win = w4define(1,28,3,54);
    w4popup();
    w4attribute(NormalBord);
    w4activate(Win);
    Aborted = SingleGet(0,0,CHARTYPE,126,25,Seek);
    c4trim_n(Seek,125);
    if(Aborted)
        Seek[0] = 0;
    w4deactivate(Win);
    w4close(Win);
}




int     Browser(int item_ref)
{
    DATA4  *Data;
    BROW4BROWSE  *Browse;
    int Win,Selection=0,MenuBar,Ret;
    long    Recno;
    char    SeekStr[128];

    Win = GetDataWindow(&Data,CID_BRO,CID_SLD,"","",0,0);
    if(Win)
    {
        w4deactivate(Win);
        w4close(Win);

        Win = w4define(0,0,0,MAXCOL);
        w4popup();
        w4attribute(NormalBord);
        w4activate(Win);

        w4attribute(MenuText);
        w4(0,0," BROWSE  d4tag_select  d4go  d4seek  d4top  d4bottom               QUIT BROWSER");

        if(d4reccount(Data) < 1)
            d4append_blank(Data);
        MenuBar = w4define(0,0,0,MAXCOL);
        w4attribute(NormalBord);
        w4popup();
        n4horizontal();
        n4attribute(MenuText,MenuSelected);
        n4item(0,0 ," BROWSE ");n4key('B',1,1);n4parm(7);
        n4item(0,8 ," d4tag_select ");n4key('T',1,3);n4parm(1);
        n4item(0,22," d4go ")        ;n4key('G',1,3);n4parm(2);
        n4item(0,28," d4seek ")      ;n4key('S',1,3);n4parm(3);
        n4item(0,36," d4top ")       ;n4key('P',1,3);n4parm(4);
        n4item(0,43," d4bottom ")    ;n4key('B',1,3);n4parm(5);
        n4item(0,66,CID_QBR)         ;n4key('Q',1,1);n4parm(6);

        d4top(Data);
        Browse = brow4define(2,1,22,78);
        brow4attribute(Browse,MenuText,MenuText,NormalBord,MenuSelected,GetColor);
        brow4activate(Data,Browse);
        brow4browse(Browse,1,0);

        while(Selection != ESC && Selection != 6)
        {
            Selection = n4activate(MenuBar);
            switch(Selection)
            {
                case 1:
                    TagSelect(Data,1,8,0);
                    d4top(Data);
                    brow4resize(&Browse,2,1,22,78);
                    Browse->CurrentRecord = 1;
                    break;
                case 2:
                    Recno = GetGo();
                    if(Recno >= 0)
                    {
                        d4go(Data,Recno);
                        Browse->CurrentRecord = 1;
                        brow4browse(Browse,0,1);
                    }
                    break;
                case 3:
                    GetSeek(SeekStr);
                    if(SeekStr[0] != 0)
                    {
                        Ret = d4seek(Data,SeekStr);
                        if(Ret == r4eof)
                            d4bottom(Data);

                        brow4browse(Browse,0,1);
                    }
                    break;
                case 4:
                    d4top(Data);
                    Browse->CurrentRecord = 1;
                    brow4browse(Browse,0,1);
                    break;
                case 5:
                    d4bottom(Data);
                    brow4browse(Browse,0,1);
                    break;
                case 7:
                    brow4browse(Browse,1,0);
                    break;
            }

        }
        brow4free_browse(Browse);
        w4deactivate(MenuBar);
        w4close(MenuBar);
        w4deactivate(Win);
        w4close(Win);
    }
    return(0);
}


/***************************************************************************\
*                                                                           *
*   Date Functions                                                          *
*                                                                           *
\***************************************************************************/

/***************************************************************************\
*                                                                           *
*   Function    date4formatFunct                                               *
*                                                                           *
\***************************************************************************/

void    date4formatFunct( void )
{
    int     Win,Aborted;
    char    ReturnChar[40],Picture[15],DateChar[10];

    Win = EntryWindowSmall(" date4format ");
    if(Win)
    {
        w4(1,2,"Usage:");
        w4attribute(NormalText);
        w4(1,9," void date4format(char *date,char *result,char *picture) ");
        w4attribute(NormalBord);
        w4(4,2," Date String (CCYYMMDD):");
        w4(4,38," Picture :");
        Aborted = DoubleGet(3,27,CHARTYPE,8,8,DateChar,3,50,CHARTYPE,14,14,Picture);
        Picture[14] = 0;
        DateChar[9] = 0;
        w4deactivate(Win);
        w4close(Win);
        if(!Aborted)
        {
            date4format(DateChar,ReturnChar,Picture);
            FunctionReturn(" date4format "," void date4format(char *date,char *result,char *picture) ",0,ReturnChar);
        }
    }
}

/***************************************************************************\
*                                                                           *
*   Function    date4initFunct                                                 *
*                                                                           *
\***************************************************************************/

void    date4initFunct( void )
{
    int     Win,Aborted;
    char    ReturnChar[40],Picture[40],DateChar[10];

    Win = EntryWindowSmall(" date4init ");
    if(Win)
    {
        w4(1,2,"Usage:");
        w4attribute(NormalText);
        w4(1,9," void date4init(char *date,char *value,char *picture) ");
        w4attribute(NormalBord);
        w4(4,2," Value :");
        w4(4,38," Picture :");
        Aborted = DoubleGet(3,13,CHARTYPE,14,14,ReturnChar,3,50,CHARTYPE,14,14,Picture);
        w4deactivate(Win);
        w4close(Win);
        if(!Aborted)
        {
            date4init(DateChar,ReturnChar,Picture);
            FunctionReturn(" date4init "," void date4init(char *date,char *value,char *picture) ",0,DateChar);
        }
    }
}

/***************************************************************************\
*                                                                           *
*   Function    date4time_nowFunct                                             *
*                                                                           *
\***************************************************************************/

void    date4time_nowFunct( void )
{
    char    ReturnChar[10];

    memset(ReturnChar,0,10);
    date4time_now(ReturnChar);
    FunctionReturn(" date4time_now "," void date4time_now(char *time) ",0,ReturnChar);
}

/***************************************************************************\
*                                                                           *
*   Function    date4todayFunct                                                *
*                                                                           *
\***************************************************************************/

void    date4todayFunct( void )
{
    char    ReturnChar[10];

    memset(ReturnChar,0,10);
    date4today(ReturnChar);
    FunctionReturn(" date4today "," void date4today(char *date) ",0,ReturnChar);
}
/***************************************************************************\
*                                                                           *
*   Expression Functions                                                        *
*                                                                           *
\***************************************************************************/

int     e4exprFunct(int item_ref )
{
    int     Win,Aborted = 0,FunctMenu,NewData = 1
            ,OutPut = 0,NewExpr = 1,Selection,Ret;
    double  ReturnDouble;

    char    ExprString[90],* Result,ReturnStr2[25],ReturnStr[25],Usage[50];
    DATA4  *Data;
    EXPR4  *Expr;

    while(!Aborted)
    {
        if(NewData)
        {
            Win = GetDataWindow(&Data," expr4parse ","EXPR4 *expr4parse(DATA4 *data,char *expr_ptr)","","",0,0);
            if(Win)
            {
                NewExpr = 1;
                NewData = 0;
                w4attribute(NormalBord);
                w4(5,28,CID_EXP);
                w4(9,28,CID_USA);
                w4(11,28,CID_RES);
                w4(13,28,CID_RTV);
            }
            else
                Aborted = 1;

        }
        if(NewExpr && !Aborted)
        {
            w4select(Win);
            w4attribute(NormalBord);
            Aborted = SingleGet(6,28,CHARTYPE,80,40,ExprString);
            if(!Aborted)
            {
                NewExpr = 0;
                Expr = expr4parse(Data,ExprString);
            }
        }
        if(Expr && !Aborted)
        {
            FunctMenu = w4define(8,6,21,30);
            w4border(SINGLE,NormalBord);
            w4attribute(NormalBord);
            w4popup();
            w4title(0,5,CID_SLU,NormalBord);
            n4attribute(PopUpText,MenuSelected);
            n4item(0 ,1,CID_NWD                );n4parm(1);n4key(' ',0,2);
            n4item(1 ,1,CID_NWE                );n4parm(2);n4key(' ',0,2);
            n4item(3 ,1,"      expr4double()     ");n4parm(3);n4key('d',1,3);
            n4item(4 ,1,"      expr4key()        ");n4parm(4);n4key('k',1,3);
            n4item(5 ,1,"      expr4source()     ");n4parm(5);n4key('s',1,3);
            n4item(6 ,1,"      expr4true()       ");n4parm(6);n4key('t',1,3);
            n4item(7 ,1,"      expr4type()       ");n4parm(7);n4key('y',1,4);
            n4item(8 ,1,"      expr4vary()       ");n4parm(8);n4key('v',1,3);
            n4item(11,1,CID_EXI                );n4parm(9);n4key(' ',0,2);
            Selection = n4activate(FunctMenu);
            switch(Selection)
            {
                case 1:
                    NewData = 1;
                    w4deactivate(Win);
                    w4close(Win);
                    break;
                case 2:
                    NewExpr = 1;
                    break;
                case 3:
                    strcpy(Usage,"double expr4double(EXPR4 *expr)");
                    ReturnDouble = expr4double(Expr);
                    sprintf(ReturnStr2,"%lf",ReturnDouble);
                    Result = ReturnStr2;
                    sprintf(ReturnStr,"CODE4.error_code = %d",CodeBase.error_code);
                    OutPut = 1;
                    break;
                case 4:
                    strcpy(Usage,"int expr4key(EXPR4 *expr,char **result) ");
                    Ret = expr4key(Expr,&Result);
                    sprintf(ReturnStr,"%d",Ret);
                    OutPut = 1;
                    break;
                case 5:
                    strcpy(Usage,"char *expr4source(EXPR4 *expr)");
                    Result = expr4source(Expr);
                    strcpy(ReturnStr,"N/A ");
                    OutPut = 1;
                    break;
                case 6:
                    strcpy(Usage,"int expr4true(EXPR4 *expr)");
                    Ret = expr4true(Expr);
                    sprintf(ReturnStr,"%d",Ret);
                    Result = 0;
                    OutPut = 1;
                    break;
                case 7:
                    strcpy(Usage,"int expr4type(EXPR4 *expr)");
                    Ret = expr4type(Expr);
                    switch(Ret)
                    {
                        case r4num  : strcpy(ReturnStr2,"r4num  ");break;
                        case r4num_doub : strcpy(ReturnStr2,"r4num_doub ");break;
                        case r4date_doub: strcpy(ReturnStr2,"r4date_doub");break;
                        case r4date : strcpy(ReturnStr2,"r4date ");break;
                        case r4str      : strcpy(ReturnStr2,"r4str      ");break;
                        case r4log      : strcpy(ReturnStr2,"r4log      ");break;
                        default:sprintf(ReturnStr2,"%d",Ret);
                    }
                    Result = ReturnStr2;
                    OutPut = 1;
                    break;
                case 8:
                    strcpy(Usage,"int expr4vary(EXPR4 *expr,char **result)");
                    Ret = expr4vary(Expr,&Result);
                    sprintf(ReturnStr,"%d",Ret);
                    OutPut = 1;
                    break;


                case 9:
                    Aborted = 1;
                    w4deactivate(Win);
                    w4close(Win);
                    break;
            }
            if(OutPut)
            {
                OutPut = 0;
                w4select(Win);
                w4attribute(NormalText);
                w4(10,28,"                                          ");
                w4(12,28,"                                          ");
                w4(14,28,"                                          ");
                w4(10,28,Usage);
                if(Result != 0)
                {
                    if(strlen(Result) > 32);
                        Result[32] = 0;
                    w4(12,28,Result);
                }
                w4(14,28,ReturnStr);
            }
            w4deactivate(FunctMenu);
            w4close(FunctMenu);
        }
        else
        {
            Aborted = 1;
            if(Win)
            {
                w4deactivate(Win);
                w4close(Win);
            }
        }

    }
    return(0);
}


/***************************************************************************\
*                                                                           *
*   Index Functions                                                         *
*                                                                           *
\***************************************************************************/


/***************************************************************************\
*                                                                           *
*   Function    i4createFunct                                               *
*                                                                           *
\***************************************************************************/

void    i4createFunct( void )
{
    int     Win1,Win3,TagEntries= 0;
    char    FileName[70],Usage[60],ReturnStr[40],Extension[6];
    DATA4  *Data;
    INDEX4 *Index;
    TAG4INFO *Tags;
    struct  TAGLIST   *FirstTag = NULL;

    strcpy(FileName,DefaultPath);

    strcpy(Usage," INDEX4 *i4create(DATA4 *data,char *file_name,TAG4INFO ...)");
    Win1 = GetDataWindow(&Data," i4create ",Usage,"","",0,0);
    if(Win1)
    {
        w4deactivate(Win1);
        w4close(Win1);
        #ifdef N4OTHER
            strcpy(Extension,"CGP");
        #endif
        #ifdef S4FOX
            strcpy(Extension,"CDX");
        #endif
        #ifdef S4MDX
            strcpy(Extension,"MDX");
        #endif
        Win1 = FileNameWindow(" i4create ",Usage,Extension,FileName,2);

        if(Win1)
        {
            if(strcmp(FileName,"0") == 0)
            {
	        w4attribute(GetColor);
	        w4(3,50,"        NULL");
            }

            Tags = EnterTags(&FirstTag,9,18,&TagEntries);
            Win3 = Busy(CID_CRI,"",CID_WAI,"");
            if(strcmp(FileName,"0") == 0)
                Index = i4create(Data,0,Tags);
            else
                Index = i4create(Data,FileName,Tags);
            ClearBusy(Win3);

            if(Tags)
                u4free(Tags);
            FreeTags(FirstTag);
            w4deactivate(Win1);
            w4close(Win1);

            if(Index)
            {
                strcpy(ReturnStr,"Valid INDEX4 Pointer");
                FunctionReturn(" i4create ",Usage,Data,ReturnStr);
            }
            else
            {
                sprintf(ReturnStr,CID_ERR,CodeBase.error_code);
                FunctionReturn(" i4create ",Usage,0,ReturnStr);
            }
            e4set(&CodeBase,0);
        }
    }
}


/***************************************************************************\
*                                                                           *
*   Function    i4openFunct                                                 *
*                                                                           *
\***************************************************************************/

void    i4openFunct( void )
{
    int     Win1;
    char    FileName[70],Usage[60],ReturnStr[40],Extension[6];
    DATA4  *Data;
    INDEX4 *Index;

    strcpy(FileName,DefaultPath);
    strcpy(Usage," INDEX4 *i4open(DATA4 *data,char *file_name)");

    Win1 = GetDataWindow(&Data," i4open ",Usage,"","",0,0);
    if(Win1)
    {
        w4deactivate(Win1);
        w4close(Win1);
        #ifdef N4OTHER
            strcpy(Extension,"*.CGP");
        #endif
        #ifdef S4FOX
            strcpy(Extension,"*.CDX");
        #endif
        #ifdef S4MDX
            strcpy(Extension,"*.MDX");
        #endif

        Win1 = FileRequesterWindow(" i4open ",Usage,Extension,FileName);
        if(Win1)
        {
            Index = i4open(Data,FileName);
            w4deactivate(Win1);
            w4close(Win1);
            if(Index)
            {
                strcpy(ReturnStr,"Valid INDEX4 Pointer");
                FunctionReturn(" i4open ",Usage,Data,ReturnStr);
            }
            else
            {
                sprintf(ReturnStr,CID_ERR,CodeBase.error_code);
                FunctionReturn(" i4open ",Usage,0,ReturnStr);
            }
            e4set(&CodeBase,0);
        }
    }
}

/***************************************************************************\
*                                                                           *
*   Function    t4openFunct                                                 *
*                                                                           *
\***************************************************************************/

#ifdef N4OTHER
void    t4openFunct( void )
{
    int     Win1,Ret;
    char    FileName[70],Usage[60],ReturnStr[40],Extension[6];
    DATA4  *Data;
    TAG4 *Index;

    strcpy(FileName,DefaultPath);
    strcpy(Usage," TAG4 *t4open(DATA4 *data,INDEX4 *index,char *file_name)");
    Win1 = GetDataWindow(&Data," t4open ",Usage,"","",0,0);
    if(Win1)
    {
        w4deactivate(Win1);
        w4close(Win1);

        #ifdef S4CLIPPER
            strcpy(Extension,"*.NTX");
        #else
            strcpy(Extension,"*.NDX");
        #endif

        Win1 = FileRequesterWindow(" t4open ",Usage,Extension,FileName);
        if(Win1)
        {
            Index = t4open(Data,0,FileName);

            w4deactivate(Win1);
            w4close(Win1);

            if(Index)
            {
                strcpy(ReturnStr,"Valid TAG4 Pointer");
                FunctionReturn(" t4open ",Usage,Data,ReturnStr);
            }
            else
            {
                sprintf(ReturnStr,CID_ERR,CodeBase.error_code);
                FunctionReturn(" t4open ",Usage,0,ReturnStr);
            }
            e4set(&CodeBase,0);
        }
    }
}


#endif

/***************************************************************************\
*                                                                           *
*   Function    DataOnePramData                                             *
*                                                                           *
\***************************************************************************/

int     OneParmData( int Function )
{
    int Win,Win3,ReturnInt,NotFound = 0;
    long ReturnLong;
    char Title[30],Usage[60],ReturnChar[40];
    DATA4  *Data;
    double  ReturnDouble;

    switch(Function)
    {
        case 1001:  strcpy(Title," d4alias ");strcpy(Usage," char *d4alias(DATA4 *data) ");break;
        case 1003:  strcpy(Title," d4append ");strcpy(Usage," int d4append(DATA4 *data) ");break;
        case 1004:  strcpy(Title," d4append_blank ");strcpy(Usage," int d4append_blank(DATA4 *data) ");break;
        case 1006:  strcpy(Title," d4blank ");strcpy(Usage," void d4blank(DATA4 *data) ");break;
        case 1007:  strcpy(Title," d4bof ");strcpy(Usage," int d4bof(DATA4 *data) ");break;
        case 1008:  strcpy(Title," d4bottom ");strcpy(Usage," int d4bottom(DATA4 *data) ");break;
        case 1010:  strcpy(Title," d4close ");strcpy(Usage," int d4close(DATA4 *data) ");break;
        case 1013:  strcpy(Title," d4delete ");strcpy(Usage," void d4delete(DATA4 *data) ");break;
        case 1014:  strcpy(Title," d4deleted ");strcpy(Usage," int d4deleted(DATA4 *data) ");break;
        case 1015:  strcpy(Title," d4eof ");strcpy(Usage," int d4oef(DATA4 *data) ");break;
        case 1017:  strcpy(Title," d4flush ");strcpy(Usage," int d4flush(DATA4 *data) ");break;
        case 2001:  strcpy(Title," d4free_blocks ");strcpy(Usage," int d4free_blocks(DATA4 *data) ");break;
        case 2003:  strcpy(Title," d4go_eof ");strcpy(Usage," int d4go_eof(DATA4 *data) ");break;
        case 2005:  strcpy(Title," d4lock_append ");strcpy(Usage," int d4lock_append(DATA4 *data) ");break;
        case 2006:  strcpy(Title," d4lock_file ");strcpy(Usage," int d4lock_file(DATA4 *data) ");break;
        case 2007:  strcpy(Title," d4lock_index ");strcpy(Usage," int d4lock_index(DATA4 *data) ");break;
        case 2009:  strcpy(Title," d4lock_test_append ");strcpy(Usage," int d4lock_test_append(DATA4 *data) ");break;
        case 2010:  strcpy(Title," d4lock_test_file ");strcpy(Usage," int d4lock_test_file(DATA4 *data) ");break;
        case 2011:  strcpy(Title," d4memo_compress ");strcpy(Usage," int d4memo_compress(DATA4 *data) ");break;
        case 2012:  strcpy(Title," d4num_fields ");strcpy(Usage," int d4num_fields(DATA4 *data) ");break;
        case 3001:  strcpy(Title," d4pack ");strcpy(Usage," int d4pack(DATA4 *data) ");break;
        case 3002:  strcpy(Title," d4position ");strcpy(Usage," double d4position(DATA4 *data) ");break;
        case 3004:  strcpy(Title," d4recall ");strcpy(Usage," void d4recall(DATA4 *data) ");break;
        case 3005:  strcpy(Title," d4reccount ");strcpy(Usage," long d4reccount(DATA4 *data) ");break;
        case 3006:  strcpy(Title," d4recno ");strcpy(Usage," long d4recno(DATA4 *data) ");break;
        case 3007:  strcpy(Title," d4record_width ");strcpy(Usage," long d4record_width(DATA4 *data) ");break;
        case 3008:  strcpy(Title," d4reindex ");strcpy(Usage," int d4reindex(DATA4 *data) ");break;
        case 3013:  strcpy(Title," d4top ");strcpy(Usage," int d4top(DATA4 *data) ");break;
        case 3014:  strcpy(Title," d4unlock ");strcpy(Usage," int d4unlock(DATA4 *data) ");break;
        default: NotFound = 1;
    }
    if(NotFound) return(0);

    Win = GetDataWindow(&Data,Title,Usage,"","",0,0);

    if(Win)
    {
        w4deactivate(Win);
        w4close(Win);

        switch(Function)
        {
            case 1001:  strcpy(ReturnChar,d4alias(Data));break;
            case 1003:  ReturnInt = d4append(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 1004:  ReturnInt = d4append_blank(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 1006:  d4blank(Data);strcpy(ReturnChar," N/A ");break;
            case 1007:  ReturnInt = d4bof(Data);sprintf(ReturnChar," %d ",ReturnInt);break;
            case 1008:  ReturnInt = d4bottom(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 1010:  RemoveData(Data);ReturnInt = d4close(Data);Data = NULL;ReturnCode(ReturnChar,ReturnInt);break;
            case 1013:  d4delete(Data);strcpy(ReturnChar," N/A ");break;
            case 1014:  ReturnInt = d4deleted(Data);sprintf(ReturnChar," %d ",ReturnInt);break;
            case 1015:  ReturnInt = d4eof(Data);sprintf(ReturnChar," %d ",ReturnInt);break;
            case 1017:  ReturnInt = d4flush(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 2001:  ReturnInt = d4free_blocks(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 2003:  ReturnInt = d4go_eof(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 2005:  ReturnInt = d4lock_append(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 2006:  ReturnInt = d4lock_file(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 2007:  ReturnInt = d4lock_index(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 2009:  ReturnInt = d4lock_test_append(Data);sprintf(ReturnChar," %d ",ReturnInt);break;
            case 2010:  ReturnInt = d4lock_test_file(Data);sprintf(ReturnChar," %d ",ReturnInt);break;
            case 2011:  Win3 = Busy(CID_COM,"",CID_WAI,"");ReturnInt = d4memo_compress(Data);ClearBusy(Win3);ReturnCode(ReturnChar,ReturnInt);break;
            case 2012:  ReturnInt = d4num_fields(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 3001:  Win3 = Busy(CID_PAC,"","",CID_WAI);ReturnInt = d4pack(Data);ClearBusy(Win3);ReturnCode(ReturnChar,ReturnInt);break;
            case 3002:  ReturnDouble = d4position(Data);sprintf(ReturnChar," %lf ",ReturnDouble);break;
            case 3004:  d4recall(Data);strcpy(ReturnChar," N/A ");break;
            case 3005:  ReturnLong = d4reccount(Data);sprintf(ReturnChar," %ld ",ReturnLong);break;
            case 3006:  ReturnLong = d4recno(Data);sprintf(ReturnChar," %ld ",ReturnLong);break;
            case 3007:  ReturnLong = d4record_width(Data);sprintf(ReturnChar," %ld ",ReturnLong);break;
            case 3008:  Win3 = Busy(CID_REI,"",CID_WAI,"");ReturnInt = d4reindex(Data);ClearBusy(Win3);ReturnCode(ReturnChar,ReturnInt);break;
            case 3013:  ReturnInt = d4top(Data);ReturnCode(ReturnChar,ReturnInt);break;
            case 3014:  ReturnInt = d4unlock(Data);ReturnCode(ReturnChar,ReturnInt);break;
        }
        FunctionReturn(Title,Usage,Data,ReturnChar);
    }
    return(1);
}
/***************************************************************************\
*                                                                           *
*   Function    TwoParmData                                                 *
*                                                                           *
\***************************************************************************/

int TwoParmData( int Function )
{
    int Win,ReturnInt,EntryType,NotFound = 0;
    long ReturnLong;
    double  ReturnDouble;
    char Title[20],Usage[60],ReturnChar[40],Parm1[20],ResultChar[60];
    char    *Dunsel;
    DATA4  *Data;


    switch(Function)
    {
        case 1002:
            strcpy(Title," d4alias_set ");
            strcpy(Usage," void d4alias_set(DATA4 *data,char *alias) ");
            strcpy(Parm1,"Alias Name:");
            EntryType = CHARTYPE;
            break;
        case 1005:
            strcpy(Title," d4append_start ");
            strcpy(Usage," int d4append_start(DATA4 *data,int use_memo_entries) ");
            strcpy(Parm1,"Use Memo Entries:");
            EntryType = INTTYPE;
            break;
        case 1016:
            strcpy(Title," d4field_number ");
            strcpy(Usage," int d4field_number(DATA4 *data,char *name) ");
            strcpy(Parm1,"Field Name:");
            EntryType = CHARTYPE;
            break;
        case 1027:
            strcpy(Title," d4changed ");
            strcpy(Usage," int d4changed(DATA4 *data,int flag) ");
            strcpy(Parm1,"flag:");
            EntryType = INTTYPE;
            break;
        case 2002:
            strcpy(Title," d4go ");
            strcpy(Usage," int d4go(DATA4 *data,long record_number) ");
            strcpy(Parm1,"Record Number:");
            EntryType = LONGTYPE;
            break;
        case 2004:
            strcpy(Title," d4lock ");
            strcpy(Usage," int d4lock(DATA4 *data,long record_number) ");
            strcpy(Parm1,"Record Number:");
            EntryType = LONGTYPE;
            break;
        case 2008:
            strcpy(Title," d4lock_test ");
            strcpy(Usage," int d4lock_test(DATA4 *data,long record_number) ");
            strcpy(Parm1,"Record Number:");
            EntryType = LONGTYPE;
            break;
        case 2016:
            strcpy(Title," d4optimize ");
            strcpy(Usage," int d4optimize(DATA4 *data,int opt_flag) ");
            strcpy(Parm1,"opt_flag:");
            EntryType = INTTYPE;
            break;
        case 2017:
            strcpy(Title," d4optimize_write ");
            strcpy(Usage," int d4optimize_write(DATA4 *data,int opt_flag) ");
            strcpy(Parm1,"opt_flag:");
            EntryType = INTTYPE;
            break;
        case 3003:
            strcpy(Title," d4position_set ");
            strcpy(Usage," int d4position_set(DATA4 *data,double per) ");
            strcpy(Parm1,"Percentage :");
            EntryType = DOUBLETYPE;
            break;
        case 3009:
            strcpy(Title," d4seek ");
            strcpy(Usage," int d4seek(DATA4 *data,char *ptr) ");
            strcpy(Parm1,"Search Key:");
            EntryType = CHARTYPE;
            break;
        case 3010:
            strcpy(Title," d4seek_double ");
            strcpy(Usage," int d4seek_double(DATA4 *data,double value) ");
            strcpy(Parm1,"Search Key:");
            EntryType = DOUBLETYPE;
            break;
        case 3011:
            strcpy(Title," d4skip ");
            strcpy(Usage," int d4skip(DATA4 *data,long num_records) ");
            strcpy(Parm1,"Number of Records:");
            EntryType = LONGTYPE;
            break;
        case 3016:
            strcpy(Title," d4write ");
            strcpy(Usage," int d4write(DATA4 *data,long record_num) ");
            strcpy(Parm1,"Record Number:");
            EntryType = LONGTYPE;
            break;
        default: NotFound = 1;

    }
    if(NotFound) return(0);

    strcpy(ResultChar,"                                     ");
    Win = GetDataWindow(&Data,Title,Usage,Parm1,ResultChar,1,EntryType);

    if(Win)
    {
        w4deactivate(Win);
        w4close(Win);

        switch(Function)
        {
            case 1002:
                ResultChar[19] = 0;
                d4alias_set(Data,ResultChar);
                strcpy(ReturnChar," N/A ");
                break;
            case 1005:
                ResultChar[19] = 0;
                ReturnInt = atoi(ResultChar);
                ReturnInt = d4append_start(Data,ReturnInt);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 1016:
                ResultChar[19] = 0;
                ReturnInt = d4field_number(Data,ResultChar);
                sprintf(ReturnChar," %d ",ReturnInt);
                break;
            case 1027:
                ResultChar[19] = 0;
                ReturnInt = atoi(ResultChar);
                ReturnInt = d4changed(Data,ReturnInt);
                sprintf(ReturnChar," %d ",ReturnInt);
                break;
            case 2002:
                ResultChar[19] = 0;
                ReturnLong = atol(ResultChar);
                ReturnInt = d4go(Data,ReturnLong);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 2004:
                ResultChar[19] = 0;
                ReturnLong = atol(ResultChar);
                ReturnInt = d4lock(Data,ReturnLong);
                sprintf(ReturnChar," %d ",ReturnInt);
                break;
            case 2008:
                ResultChar[19] = 0;
                ReturnLong = atol(ResultChar);
                ReturnInt = d4lock_test(Data,ReturnLong);
                sprintf(ReturnChar," %d ",ReturnInt);
                break;
            case 2016:
                ResultChar[19] = 0;
                ReturnInt = atoi(ResultChar);
                ReturnInt = d4optimize(Data,ReturnInt);
                sprintf(ReturnChar," %d ",ReturnInt);
                break;
            case 2017:
                ResultChar[19] = 0;
                ReturnInt = atoi(ResultChar);
                ReturnInt = d4optimize_write(Data,ReturnInt);
                sprintf(ReturnChar," %d ",ReturnInt);
                break;
            case 3003:
                ResultChar[19] = 0;
                ReturnDouble = strtod(ResultChar,&Dunsel);
                ReturnInt = d4position_set(Data,ReturnDouble);
                sprintf(ReturnChar," %d ",ReturnInt);
                break;
            case 3009:
                ResultChar[19] = 0;
                ReturnInt = d4seek(Data,ResultChar);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 3010:
                ResultChar[19] = 0;
                ReturnDouble = strtod(ResultChar,&Dunsel);
                ReturnInt = d4seek_double(Data,ReturnDouble);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 3011:
                ResultChar[19] = 0;
                ReturnLong = atol(ResultChar);
                ReturnInt = d4skip(Data,ReturnLong);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 3016:
                ResultChar[19] = 0;
                ReturnLong = atol(ResultChar);
                ReturnInt = d4write(Data,ReturnLong);
                sprintf(ReturnChar," %d ",ReturnInt);
                break;
        }
        FunctionReturn(Title,Usage,Data,ReturnChar);
    }
    return(1);
}

/***************************************************************************\
*                                                                           *
*   Function    OneParmDate                                                 *
*                                                                           *
\***************************************************************************/

void    OneParmDate( int Function )
{
    int Win,ReturnInt,EntryType,Aborted;
    long ReturnLong;
    double  ReturnDouble;
    char Title[20],Usage[60],ReturnChar[40],Parm1[20];
    char    *Dunsel;

    switch(Function)
    {
        case 5101:
            strcpy(Title," date4assign ");
            strcpy(Usage," void date4assign(char *date,long julian_day) ");
            strcpy(Parm1,CID_JUL);
            EntryType = LONGTYPE;
            break;
        case 5102:
            strcpy(Title," date4cdow ");
            strcpy(Usage," char *date4cdow(char *date) ");
            strcpy(Parm1,"Date String (CCYYMMDD):");
            EntryType = CHARTYPE;
            break;
        case 5103:
            strcpy(Title," date4month ");
            strcpy(Usage," char *date4cmonth(char *date) ");
            strcpy(Parm1,"Date String (CCYYMMDD):");
            EntryType = CHARTYPE;
            break;
        case 5104:
            strcpy(Title," date4day ");
            strcpy(Usage," int date4day(char *date) ");
            strcpy(Parm1,"Date String (CCYYMMDD):");
            EntryType = CHARTYPE;
            break;
        case 5105:
            strcpy(Title," date4dow ");
            strcpy(Usage," int date4dow(char *date) ");
            strcpy(Parm1,"Date String (CCYYMMDD):");
            EntryType = CHARTYPE;
            break;
        case 5107:
            strcpy(Title," date4format_mdx ");
            strcpy(Usage," double date4format_mdx(char *date) ");
            strcpy(Parm1,"Date String (CCYYMMDD):");
            EntryType = CHARTYPE;
            break;
        case 5109:
            strcpy(Title," date4long ");
            strcpy(Usage," long date4long(char *date) ");
            strcpy(Parm1,"Date String (CCYYMMDD):");
            EntryType = CHARTYPE;
            break;
        case 5110:
            strcpy(Title," date4month ");
            strcpy(Usage," int date4month(char *date) ");
            strcpy(Parm1,"Date String (CCYYMMDD):");
            EntryType = CHARTYPE;
            break;
        case 5113:
            strcpy(Title," date4year ");
            strcpy(Usage," int date4year(char *date) ");
            strcpy(Parm1,"Date String (CCYYMMDD):");
            EntryType = CHARTYPE;
            break;
    }

    Win = EntryWindowSmall(Title);
    if(Win)
    {
        w4(1,2,CID_USA);
        w4attribute(NormalText);
        w4(1,9,Usage);
        w4attribute(NormalBord);
        w4(4,2,Parm1);
        Aborted = SingleGet(3,27,EntryType,8,8,ReturnChar);
        w4deactivate(Win);
        w4close(Win);
        if(!Aborted)
        {
            switch(Function)
            {
                case 5101:
                    ReturnLong = atol(ReturnChar);
                    date4assign(ReturnChar,ReturnLong);
                    break;
                case 5102:
                    Dunsel = date4cdow(ReturnChar);
                    sprintf(ReturnChar,"\"%s\"",Dunsel);
                    break;
                case 5103:
                    Dunsel = date4cmonth(ReturnChar);
                    sprintf(ReturnChar,"\"%s\"",Dunsel);
                    break;
                case 5104:
                    ReturnInt = date4day(ReturnChar);
                    sprintf(ReturnChar," %d ",ReturnInt);
                    break;
                case 5105:
                    ReturnInt = date4dow(ReturnChar);
                    sprintf(ReturnChar," %d ",ReturnInt);
                    break;
                case 5107:
                    ReturnDouble = date4format_mdx(ReturnChar);
                    sprintf(ReturnChar," %10lf ",ReturnDouble);
                    break;
                case 5109:
                    ReturnLong = date4long(ReturnChar);
                    sprintf(ReturnChar," %ld ",ReturnLong);
                    break;
                case 5110:
                    ReturnInt = date4month(ReturnChar);
                    sprintf(ReturnChar," %d ",ReturnInt);
                    break;
                case 5113:
                    ReturnInt = date4year(ReturnChar);
                    sprintf(ReturnChar," %d ",ReturnInt);
                    break;
            }
            FunctionReturn(Title,Usage,0,ReturnChar);
        }
    }
}

/***************************************************************************\
*                                                                           *
*   Function    FieldFunct                                                  *
*                                                                           *
\***************************************************************************/

void    FieldFunct(int Function)
{
    DATA4  *Data;
    FIELD4 *Field;
    int Win,ReturnInt,Extra=0,GetType1,Aborted = 0,GetLength;
    char    Title[20],Usage[60],ReturnStr[256],Parm[20],Parm2[20],*Dunsel;
    double  ReturnDouble;
    long    ReturnLong;

    switch(Function)
    {
        case 6101:
            strcpy(Title," f4assign ");
            strcpy(Usage," void f4assign(FIELD4 *field,char *ptr) ");
            strcpy(Parm,"String Ptr :");
            Extra = 1;GetType1 = CHARTYPE;GetLength = -1;
            break;
        case 6102:
            strcpy(Title," f4assign_char ");
            strcpy(Usage," void f4assign_char(FIELD4 *field,int char) ");
            strcpy(Parm,"Character :");
            Extra = 1;GetType1 = INTTYPE;GetLength = 5;
            break;
        case 6103:
            strcpy(Title," f4assign_double ");
            strcpy(Usage," void f4assign_double(FIELD4 *field,double value) ");
            strcpy(Parm,"Double Value :");
            Extra = 1;GetType1 = DOUBLETYPE;GetLength = 10;
            break;
        case 6104:
            strcpy(Title," f4assign_int ");
            strcpy(Usage," void f4assign_int(FIELD4 *field,int value) ");
            strcpy(Parm,"Int Value :");
            Extra = 1;GetType1 = INTTYPE;GetLength = 5;
            break;
        case 6105:
            strcpy(Title," f4assign_long ");
            strcpy(Usage," void f4assign_long(FIELD4 *field,long value) ");
            strcpy(Parm,"Long Value :");
            Extra = 1;GetType1 = LONGTYPE;GetLength = 10;
            break;
        case 6206:
            strcpy(Title," f4assign_n ");
            strcpy(Usage," void f4assign_n(FIELD4 *field,char *ptr,int ptr_len) ");
            strcpy(Parm,"String Ptr :");
            strcpy(Parm2,"String Length :");
            Extra = 2;GetType1 = CHARTYPE;GetLength = -1;
            break;
        case 6007:
            strcpy(Title," f4blank ");
            strcpy(Usage," void f4blank(FIELD4 *field) ");
            break;
        case 6008:
            strcpy(Title," f4decimals ");
            strcpy(Usage," int f4decimals(FIELD4 *field) ");
            break;
        case 6009:
            strcpy(Title," f4double ");
            strcpy(Usage," double f4double(FIELD4 *field) ");
            break;
        case 6010:
            strcpy(Title," f4int ");
            strcpy(Usage," int f4int(FIELD4 *field) ");
            break;
        case 6011:
            strcpy(Title," f4len ");
            strcpy(Usage," int f4len(FIELD4 *field) ");
            break;
        case 6012:
            strcpy(Title," f4long ");
            strcpy(Usage," long f4long(FIELD4 *field) ");
            break;
        case 6013:
            strcpy(Title," f4str ");
            strcpy(Usage," char *f4str(FIELD4 *field) ");
            break;
        case 6014:
            strcpy(Title," f4true ");
            strcpy(Usage," int f4true(FIELD4 *field) ");
            break;
        case 6015:
            strcpy(Title," f4type ");
            strcpy(Usage," int f4type(FIELD4 *field) ");
            break;
        case 6019:
            strcpy(Title," f4memo_str ");
            strcpy(Usage," char * f4memo_str(FIELD4 field) ");
            break;
        case 6016:
            strcpy(Title," f4memo_assign ");
            strcpy(Usage," char * f4memo_assign(FIELD4 field,char *ptr) ");
            break;
        case 6017:
            strcpy(Title," f4memo_free ");
            strcpy(Usage," int f4memo_free(FIELD4 *field) ");
            break;
        case 6018:
            strcpy(Title," f4memo_len ");
            strcpy(Usage," int f4memo_len(FIELD4 *field) ");
            break;
    }
    Win = GetFieldWindow(&Data,&Field,Title,Usage);
    if(Win)
    {
        if(Extra == 1)
        {
            w4select(Win);
            w4attribute(NormalBord);
            w4(5,45,Parm);
            if(GetLength == -1)
                GetLength = f4len(Field);
            Aborted = SingleGet(6,45,GetType1,GetLength,23,ReturnStr);
        }
        else if(Extra == 2)
        {
            w4select(Win);
            w4attribute(NormalBord);
            w4(5,45,Parm);
            w4(9,45,Parm2);
            if(GetLength == -1)
                GetLength = f4len(Field);
            Aborted = DoubleGet(6,45,GetType1,GetLength,23,ReturnStr,
                                10,45,INTTYPE,5,23,Parm2);
        }
        w4deactivate(Win);
        w4close(Win);
        if(!Aborted)
        {
            switch(Function)
            {
                case 6101:
                    f4assign(Field,ReturnStr);
                    strcpy(ReturnStr," N/A ");
                    break;
                case 6102:
                    ReturnInt = atoi(ReturnStr);
                    f4assign_char(Field,ReturnInt);
                    strcpy(ReturnStr," N/A ");
                    break;
                case 6103:
                    ReturnDouble = atof(ReturnStr);
                    f4assign_double(Field,ReturnDouble);
                    strcpy(ReturnStr," N/A ");
                    break;
                case 6104:
                    ReturnInt = atoi(ReturnStr);
                    f4assign_int(Field,ReturnInt);
                    strcpy(ReturnStr," N/A ");
                    break;
                case 6105:
                    ReturnLong = atol(ReturnStr);
                    f4assign_long(Field,ReturnLong);
                    strcpy(ReturnStr," N/A ");
                    break;
                case 6206:
                    ReturnInt = atoi(Parm2);
                    f4assign_n(Field,ReturnStr,ReturnInt);
                    strcpy(ReturnStr," N/A ");
                    break;
                case 6007:
                    f4blank(Field);
                    strcpy(ReturnStr," N/A ");
                    break;
                case 6008:
                    ReturnInt = f4decimals(Field);
                    sprintf(ReturnStr," %d ",ReturnInt);
                    break;
                case 6009:
                    ReturnDouble = f4double(Field);
                    sprintf(ReturnStr," %lf ",ReturnDouble);
                    break;
                case 6010:
                    ReturnInt = f4int(Field);
                    sprintf(ReturnStr," %d ",ReturnInt);
                    break;
                case 6011:
                    ReturnInt = f4len(Field);
                    sprintf(ReturnStr," %d ",ReturnInt);
                    break;
                case 6012:
                    ReturnLong = f4long(Field);
                    sprintf(ReturnStr," %ld ",ReturnLong);
                    break;
                case 6013:
                    Dunsel = f4str(Field);
                    sprintf(ReturnStr,"\"%s\"",Dunsel);
                    break;
                case 6014:
                    ReturnInt = f4true(Field);
                    sprintf(ReturnStr," %d ",ReturnInt);
                    break;
                case 6015:
                    ReturnInt = f4type(Field);
                    sprintf(ReturnStr," '%c' ",ReturnInt);
                    break;
                case 6019:
                    if(f4type(Field) == r4memo)
                    {
                        if(d4recno(Data) < 1L)
                           sprintf(ReturnStr," Not on valid record ");
                        else
                        {
                           edit4memo(Field,2,2,12,77," f4memo_str  (ESC) to quit ",0,1,NormalBord,NormalBord);
                           sprintf(ReturnStr," r4success ");
                        }
                    }
                    else
                       sprintf(ReturnStr," Not a Memo Field ");
                    break;
                case 6016:
                    if(f4type(Field) == r4memo)
                    {
                        if(d4recno(Data) < 1L)
                           sprintf(ReturnStr," Not on valid record ");
                        else
                        {
                           edit4memo(Field,2,2,12,77," f4memo_assign  (ESC) to quit (F1) to save ",1,1,NormalBord,NormalBord);
                           sprintf(ReturnStr," r4success ");
                        }
                    }
                    else
                       sprintf(ReturnStr," Not a Memo Field ");
                    break;
                case 6017:
                    f4memo_free(Field);
                    sprintf(ReturnStr," N/A ");
                    break;
                case 6018:
                    ReturnInt = f4memo_len(Field);
                    sprintf(ReturnStr," '%d' ",ReturnInt);
                    break;

            }
            FunctionReturn(Title,Usage,Data,ReturnStr);
        }
    }
}


/***************************************************************************\
*                                                                           *
*   Function    IndexFunct                                                  *
*                                                                           *
\***************************************************************************/

void    IndexFunct(int  Funct)
{
    int     Win1,Win2,Ret,count = 0,Selection = 27,Win3;
    char    FileName[70],Usage[60],ReturnStr[40],Title[25];
    DATA4  *Data;
    INDEX4 *Index;

    strcpy(FileName,DefaultPath);
    switch(Funct)
    {
        case 8003:
            strcpy(Usage," int i4close(INDEX4 *index)");
            strcpy(Title," i4close ");
            break;
        case 8004:
            strcpy(Usage," int i4lock(INDEX4 *index)");
            strcpy(Title," i4lock ");
            break;
        case 8005:
            strcpy(Usage," int i4reindex(INDEX4 *index)");
            strcpy(Title," i4reindex ");
            break;
        case 8006:
            strcpy(Usage," int i4unlock(INDEX4 *index)");
            strcpy(Title," i4unlock ");
            break;
    }
    Win1 = GetDataWindow(&Data,Title,Usage,"","",2,0);
    if(Win1)
    {
        while(Selection == 27)
        {
            Win2 = w4define(8,32,21,73);
            w4border(SINGLE,NormalBord);
            w4attribute(NormalBord);
            w4popup();
            w4title(0,14,CID_SLI,NormalBord);

            n4attribute(PopUpText,MenuSelected);

            for(Index = 0;Index = (INDEX4 *) l4next(&Data->indexes,Index);count++)
            {
                #ifdef N4OTHER
                    n4(Index->alias);
                #else
                    n4(Index->file.name);
                #endif
                n4item_width(38);
                n4parm(count+1);
            }
            Selection = n4activate(Win2);
            w4close(Win2);
        }
        if(count == 0)
        {
            Message(CID_DAT,Data->alias,CID_DOE,CID_IND,CID_ABO);
            w4deactivate(Win1);
            w4close(Win1);
        }
        else
        {
            Index = 0;
            for(count =0;count < Selection;count ++)
            {
                Index = (INDEX4 *) l4next(&Data->indexes,Index);
            }

            switch(Funct)
            {
                case 8003:
                    Ret = i4close(Index);
                    break;
                case 8004:
                    Ret = i4lock(Index);
                    break;
                case 8005:
                    Win3 = Busy(CID_REI,"",CID_WAI,"");
                    Ret = i4reindex(Index);
                    ClearBusy(Win3);
                    break;
                case 8006:
                    Ret = i4unlock(Index);
                    break;
             }
            w4deactivate(Win1);
            w4close(Win1);
            ReturnCode(ReturnStr,Ret);
            FunctionReturn(Title,Usage,Data,ReturnStr);
        }
    }
}
void AddRel(RELATE4 *Rel,char *alias)
{
   struct  RELATELIST  *RelNode;

   if(Rel)
   {
      RelNode = (struct RELATELIST *) u4alloc(sizeof(struct RELATELIST));
      RelNode->rel = Rel;
      u4ncpy(RelNode->Alias,alias,20);
      l4add(&RelList,(void *) RelNode);
   }
}


/***************************************************************************\
*                                                                           *
*   Function    Relation Functions                                          *
*                                                                           *
\***************************************************************************/

void    relate4initFunct( void )
{
    int     Win1;
    char    FileName[70],Usage[60],ResultChar[60];
    DATA4   *Data;
    RELATE4 *Rel;

    strcpy(FileName,DefaultPath);
    strcpy(Usage," RELATE4 *relate4init(DATA4 *data)");


    strcpy(ResultChar,"                                     ");
    Win1 = GetDataWindow(&Data," relate4init ",Usage,"Relation Alias:",ResultChar,1,CHARTYPE);
    if(Win1)
    {
        Rel = relate4init(Data);
        AddRel(Rel,ResultChar);
        w4deactivate(Win1);
        w4close(Win1);

        if(Rel)
           FunctionReturn(" relate4init ",Usage,Data," VALID RELATE4 *");
        else
        {
           sprintf(FileName," Error Code: %d",CodeBase.error_code);
           FunctionReturn(" relate4init ",Usage,Data,FileName);
        }

    }

}

int     GetRelWindow(RELATE4 **RelParm,char *Title,char *Usage,char *Parm1,
                        char *Result1,int Extra,int GetType)
{
    int Win,Menu,Count,Choice,Ret,GetInt=0;
    long    GetLong = 0;
    double  GetDouble = 0.0;
    RELATE4  *Rel;
    struct RELATELIST *Node;

    if(RelList.n_link <= 0)
        Message("","A relation must be created","before calling this function","",CID_CON);
    else
    {
    Win = EntryWindow(Title);
    w4(1,2,CID_USA);
    w4(3,2,"RELATION :");
    if(Extra == 1)
    {
        w4(6,31,Parm1);
        w4box(SINGLE,5,29,8,69);

    }
    else if(Extra == 2)
        w4box(SINGLE,5,28,18,69);
    else if(Extra == 3)
    {
        w4box(SINGLE,5,28,18,43);
        w4(5,30,CID_SLF);
        Extra = 0;
    }

    w4box(SINGLE,5,2,18,26);
    w4attribute(GetColor);
    if(Extra)
        w4(7,31,Result1);
    w4(3,13,"                    ");
    w4attribute(NormalText);
    w4(1,9,Usage);

    Menu = w4define(8,6,21,30);
    w4border(SINGLE,NormalBord);
    w4attribute(NormalBord);
    w4popup();
    w4title(0,5," Select Relation ",NormalBord);

    n4attribute(PopUpText,MenuSelected);

    Node = (struct RELATELIST *) l4first(&RelList);
    Count = 0;
    while(Node != NULL)
    {
        Count++;
        Rel = Node->rel;
        Node->Item = Count;

        n4(Node->Alias);
        n4item_width(20);
        n4parm(Count);
        Node =(struct RELATELIST *) l4next(&RelList,(void *) Node);
    }

    Choice = 27;
    while(Choice == 27 && !Aborted)
    {
        Choice = n4activate(Menu);
        if(Choice == 27)
        {
            Ret = Continue("",CID_AOP,"","",CID_CON,CID_ABO);
            if(Ret == 0)
            Aborted = TRUE;
        }
    }
    w4close(Menu);
    if(!Aborted)
    {
        Node = (struct RELATELIST *) l4first(&RelList);
        Ret = FALSE;
        Rel = NULL;
        while(Node != NULL && !Ret)
        {
            if(Node->Item == Choice)
            {
                Rel = Node->rel;
                *RelParm = Rel;
                Ret = TRUE;
            }
            else
                Node =(struct RELATELIST *) l4next(&RelList,(void *) Node);
        }
        if(!Ret || Rel == NULL)
            e4severe( e4info, "GetDataWindow()");
        w4select(Win);

        w4attribute(GetColor);
        w4(3,13,Node->Alias);

        if(Extra)
        {
            Choice = 27;
            while(Choice == 27 && !Aborted)
            {
                g4attribute(GetColor);
                switch(GetType)
                {
                    case INTTYPE:
                        g4int(7,31,&GetInt);
                        g4picture("#######");
                        break;
                    case LONGTYPE:
                        g4long(7,31,&GetLong);
                        g4picture("#######");
                        break;
                    case DOUBLETYPE:
                        g4double(7,31,&GetDouble);
                        g4picture("#####.##");
                        break;
                    case CHARTYPE:
                        g4(7,31,Result1);
                        break;
                }
                Choice = g4read();
                if(Choice == 27)
                {
                    Ret = Continue("",CID_AOP,"","",CID_CON,CID_ABO);
                    if(Ret == 0)
                    Aborted = TRUE;
                }
            }
            if(!Aborted)
            {
                switch(GetType)
                {
                    case INTTYPE:
                        sprintf(Result1," %d ",GetInt);
                        break;
                    case LONGTYPE:
                        sprintf(Result1," %ld ",GetLong);
                        break;
                    case DOUBLETYPE:
                        sprintf(Result1," %lf ",GetDouble);
                        break;

                }
            }

        }
    }
    if(Aborted)
    {
        Aborted = FALSE;
        w4deactivate(Win);
        w4close(Win);
        return(0);
    }
    else
        return(Win);
    }
    return(0);
}


void OneParmRelation(int Selection)
{
    int Win,ReturnInt,NotFound = 0;
    long ReturnLong;
    char Title[30],Usage[60],ReturnChar[40];
    RELATE4  *Rel;
    double  ReturnDouble;

    switch( Selection)
    {
        case 9001:  strcpy(Title," relate4bottom ");strcpy(Usage," int *relate4bottom(RELATE4 *relate) ");break;
        case 9002:  strcpy(Title," relate4changed ");strcpy(Usage," void relate4changed(RELATE4 *relate) ");break;
        case 9004:  strcpy(Title," relate4do ");strcpy(Usage," int *relate4do(RELATE4 *relate) ");break;
        case 9005:  strcpy(Title," relate4do_one ");strcpy(Usage," int *relate4do_one(RELATE4 *relate) ");break;
        case 9009:  strcpy(Title," relate4lock ");strcpy(Usage," int *relate4lock(RELATE4 *relate) ");break;
        case 9015:  strcpy(Title," relate4top ");strcpy(Usage," int *relate4top(RELATE4 *relate) ");break;
        case 9017:  strcpy(Title," relate4unlock ");strcpy(Usage," int *relate4unlock(RELATE4 *relate) ");break;

        default: NotFound = 1;
    }
    if(NotFound) return(0);

    Win = GetRelWindow(&Rel,Title,Usage,"","",0,0);

    if(Win)
    {
        w4deactivate(Win);
        w4close(Win);

        switch(Selection)
        {
            case 9001:   ReturnInt = relate4bottom(Rel);ReturnCode(ReturnChar,ReturnInt);break;
            case 9002:   relate4changed(Rel);strcpy(ReturnChar," N/A ");break;
            case 9004:   ReturnInt = relate4do(Rel);ReturnCode(ReturnChar,ReturnInt);break;
            case 9005:   ReturnInt = relate4do_one(Rel);ReturnCode(ReturnChar,ReturnInt);break;
            case 9009:   ReturnInt = relate4lock(Rel);ReturnCode(ReturnChar,ReturnInt);break;
            case 9015:   ReturnInt = relate4top(Rel);ReturnCode(ReturnChar,ReturnInt);break;
            case 9017:   ReturnInt = relate4unlock(Rel);ReturnCode(ReturnChar,ReturnInt);break;
        }
        FunctionReturn(Title,Usage,Rel->data,ReturnChar);
    }
}

int TwoParmRelation( int Function )
{
    int Win,ReturnInt,EntryType,NotFound = 0;
    long ReturnLong;
    double  ReturnDouble;
    char Title[30],Usage[60],ReturnChar[40],Parm1[20],ResultChar[60];
    char    *Dunsel;
    RELATE4  *Rel;


    switch(Function)
    {
        case 9206:
            strcpy(Title," relate4error_action ");
            strcpy(Usage," int relate4error_action(RELATE4 *relate,int error_action) ");
            strcpy(Parm1,"Error Action:");
            EntryType = INTTYPE;
            break;
        case 9207:
            strcpy(Title," relate4free ");
            strcpy(Usage," int relate4free((RELATE4 *relate,int close_files) ");
            strcpy(Parm1,"Close Files:");
            EntryType = INTTYPE;
            break;
        case 9210:
            strcpy(Title," relate4match_len ");
            strcpy(Usage," int relate4match_len(RELATE4 *relate,int len) ");
            strcpy(Parm1,"Match Length:");
            EntryType = INTTYPE;
            break;
        case 9211:
            strcpy(Title," relate4query_set ");
            strcpy(Usage," int relate4query_set(RELATE4 *relate,char *expr) ");
            strcpy(Parm1,"Query Expression:");
            EntryType = CHARTYPE;
            break;
        case 9212:
            strcpy(Title," relate4skip ");
            strcpy(Usage," int relate4skip(RELATE4 *relate,long n) ");
            strcpy(Parm1,"Record Number:");
            EntryType = LONGTYPE;
            break;
        case 9213:
            strcpy(Title," relate4skip_enable ");
            strcpy(Usage," int relate4skip_enable(RELATE4 *relate,int do_enable) ");
            strcpy(Parm1,"Do Enable:");
            EntryType = INTTYPE;
            break;
        case 9214:
            strcpy(Title," relate4sort_set ");
            strcpy(Usage," int relate4sort_set(RELATE4 *relate,char *expr) ");
            strcpy(Parm1,"Sort Expression:");
            EntryType = CHARTYPE;
            break;
        case 9216:
            strcpy(Title," relate4type ");
            strcpy(Usage," int relate4type(RELATE4 *relate,int relate_type) ");
            strcpy(Parm1,"Relation Type:");
            EntryType = INTTYPE;
            break;

        default: NotFound = 1;

    }
    if(NotFound) return(0);

    strcpy(ResultChar,"                                     ");
    Win = GetRelWindow(&Rel,Title,Usage,Parm1,ResultChar,1,EntryType);

    if(Win)
    {
        w4deactivate(Win);
        w4close(Win);

        switch(Function)
        {
            case 9206:
                ResultChar[19] = 0;
                ReturnInt = atoi(ResultChar);
                ReturnInt = relate4error_action(Rel,ReturnInt);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 9207:
                ResultChar[19] = 0;
                ReturnInt = atoi(ResultChar);
                ReturnInt = relate4free(Rel,ReturnInt);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 9210:
                ResultChar[19] = 0;
                ReturnInt = atoi(ResultChar);
                ReturnInt = relate4match_len(Rel,ReturnInt);
                sprintf(ReturnChar," %d ",ReturnInt);
                break;
            case 9211:
                ResultChar[19] = 0;
                ReturnInt = relate4query_set(Rel,ResultChar);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 9212:
                ResultChar[19] = 0;
                ReturnLong = atol(ResultChar);
                ReturnInt = relate4skip(Rel,ReturnLong);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 9213:
                ResultChar[19] = 0;
                ReturnInt = atoi(ResultChar);
                ReturnInt = relate4skip_enable(Rel,ReturnInt);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 9214:
                ResultChar[19] = 0;
                ReturnInt = relate4sort_set(Rel,ResultChar);
                ReturnCode(ReturnChar,ReturnInt);
                break;
            case 9216:
                ResultChar[19] = 0;
                ReturnInt = atoi(ResultChar);
                ReturnInt = relate4type(Rel,ReturnInt);
                ReturnCode(ReturnChar,ReturnInt);
                break;

        }
        FunctionReturn(Title,Usage,Rel->data,ReturnChar);
    }
    return(1);
}

void    relate4create_slaveFunct( void )
{
    int     Win;
    char    FileName[70],Usage[60],Parm1[60],ResultChar[60],Result2Char[60];
    DATA4   *Data;
    RELATE4 *Rel,*Slave;
    TAG4    *SlaveTag;

    strcpy(FileName,DefaultPath);
    strcpy(Usage," RELATE4 *relate4create_slave(RELATE4 *master, ...)");

    strcpy(ResultChar,"                                     ");
    strcpy(Result2Char,"                                     ");
    Win = GetRelWindow(&Rel," relate4create_slave ",Usage,"Master Expression:",ResultChar,1,CHARTYPE);

    if(Win)
    {
       w4deactivate(Win);
       w4close(Win);
       Win = GetDataWindow(&Data," relate4create_slave ",Usage,"Relation Alias:",Result2Char,1,CHARTYPE);
       if(Win)
       {
          SlaveTag = TagSelect(Data,8,32,1);
          w4deactivate(Win);
          w4close(Win);
          Slave = relate4create_slave(Rel,Data,ResultChar,SlaveTag);
          if(Slave)
          {
             AddRel(Slave,Result2Char);
             FunctionReturn(" relate4create_slave ",Usage,Data," Valid RELATE4 * ");
          }
          else
          {
             sprintf(ResultChar," Error Code: %d ",CodeBase.error_code);
             FunctionReturn(" relate4create_slave ",Usage,Data,ResultChar);
          }
       }
    }

}

/***************************************************************************\
*                                                                           *
*   Function    CodeMenu                                                    *
*                                                                           *
\***************************************************************************/

void  LockAttempts(void )
{
    int win,Attempts;
    char ReturnValue[6];

    win = w4define(5,14,7,64);
    w4border(SINGLE,NormalBord);
    w4attribute(NormalText);
    w4popup();

    w4activate(win);
    w4(0,3,CID_LAT);

    Attempts = CodeBase.lock_attempts;
    g4attribute(GetColor);
    g4int(0,40,&Attempts);
    g4read();


    CodeBase.lock_attempts = Attempts;
    w4deactivate(win);
    w4close(win);

}

int DefaultUnique( int dummy)
{
    int win,rc;
    struct String{char Str[40];};
    struct String MenuItems[3];

    win = w4define(4,44,8,68);
    w4popup();
    w4border(SINGLE,NormalBord);
    w4attribute(NormalBord);
    n4attribute(MenuText,MenuSelected);
    n4arrow_exit();

    strcpy(MenuItems[0].Str,"[ ] r4unique_continue");
    MenuItems[0].Str[1] = (CodeBase.default_unique_error == r4unique_continue) ? '':' ';
    strcpy(MenuItems[1].Str,"[ ] r4unique         ");
    MenuItems[1].Str[1] = (CodeBase.default_unique_error == r4unique) ? '':' ';
    strcpy(MenuItems[2].Str,"[ ] e4unique         ");
    MenuItems[2].Str[1] = (CodeBase.default_unique_error == e4unique) ? '':' ';

    n4(MenuItems[0].Str);n4parm(1101);n4key('c',1,13);
    n4(MenuItems[1].Str);n4parm(1102);n4key('r',1,4);
    n4(MenuItems[2].Str);n4parm(1103);n4key('e',1,4);

    rc = n4activate(win) ;

    switch(rc)
    {
        case 1101: CodeBase.default_unique_error = r4unique_continue;break;
        case 1102: CodeBase.default_unique_error = r4unique;break;
        case 1103: CodeBase.default_unique_error = e4unique;break;
    }
    w4deactivate(win);
    w4close(win);

    return(0);
}

int Optimize( int dummy)
{
    int win,rc;
    struct String{char Str[60];};
    struct String MenuItems[3];

    win = w4define(12,44,16,79);
    w4popup();
    w4border(SINGLE,NormalBord);
    w4attribute(NormalBord);
    n4attribute(MenuText,MenuSelected);
    n4arrow_exit();

    strcpy(MenuItems[0].Str,"[ ] Exclusive Read Optimize (-1)");
    MenuItems[0].Str[1] = (CodeBase.optimize == -1) ? '':' ';
    strcpy(MenuItems[1].Str,"[ ] No Optimizations         (0)");
    MenuItems[1].Str[1] = (CodeBase.optimize == 0) ? '':' ';
    strcpy(MenuItems[2].Str,"[ ] Shared Read Optimize     (1)");
    MenuItems[2].Str[1] = (CodeBase.optimize == 1) ? '':' ';

    n4(MenuItems[0].Str);n4parm(1101);n4key('e',1,4);
    n4(MenuItems[1].Str);n4parm(1102);n4key('n',1,4);
    n4(MenuItems[2].Str);n4parm(1103);n4key('s',1,4);

    rc = n4activate(win) ;

    switch(rc)
    {
        case 1101: CodeBase.optimize = -1;break;
        case 1102: CodeBase.optimize = 0;break;
        case 1103: CodeBase.optimize = 1;break;
    }
    w4deactivate(win);
    w4close(win);

    return(0);
}
 int OptimizeWrite( int dummy)
{
    int win,rc;
    struct String{char Str[60];};
    struct String MenuItems[3];

    win = w4define(13,44,17,79);
    w4popup();
    w4border(SINGLE,NormalBord);
    w4attribute(NormalBord);
    n4attribute(MenuText,MenuSelected);
    n4arrow_exit();

    strcpy(MenuItems[0].Str,"[ ] Exclusive Write Optimize(-1)");
    MenuItems[0].Str[1] = (CodeBase.optimize_write == -1) ? '':' ';
    strcpy(MenuItems[1].Str,"[ ] No Write Optimizations   (0)");
    MenuItems[1].Str[1] = (CodeBase.optimize_write == 0) ? '':' ';
    strcpy(MenuItems[2].Str,"[ ] Shared Write Optimize    (1)");
    MenuItems[2].Str[1] = (CodeBase.optimize_write == 1) ? '':' ';

    n4(MenuItems[0].Str);n4parm(1101);n4key('e',1,4);
    n4(MenuItems[1].Str);n4parm(1102);n4key('n',1,4);
    n4(MenuItems[2].Str);n4parm(1103);n4key('s',1,4);

    rc = n4activate(win) ;

    switch(rc)
    {
        case 1101: CodeBase.optimize_write = -1;break;
        case 1102: CodeBase.optimize_write = 0;break;
        case 1103: CodeBase.optimize_write = 1;break;
    }
    w4deactivate(win);
    w4close(win);

    return(0);
}

int  CodeMenu( int item_ref )
{
    struct String{char Str[40];};
    struct String MenuItems[18];
    int Selection,WinRef,FieldRef ;

    u4ncpy(MenuItems[0].Str,"[ ] CODE4.auto_open            ",sizeof(struct String));
    MenuItems[0].Str[1] = CodeBase.auto_open ? '':' ';
    strcpy(MenuItems[1].Str,"[ ] CODE4.create_error          ");
    MenuItems[1].Str[1] = CodeBase.create_error ? '':' ';
    strcpy(MenuItems[2].Str,"    CODE4.default_unique_error  ");
    strcpy(MenuItems[3].Str,"[ ] CODE4.exclusive             ");
    MenuItems[3].Str[1] = CodeBase.exclusive ? '':' ';
    sprintf(MenuItems[4].Str,"    CODE4.error_code      :%5d",CodeBase.error_code);
    strcpy(MenuItems[5].Str,"[ ] CODE4.expr_error            ");
    MenuItems[5].Str[1] = CodeBase.expr_error ? '':' ';
    strcpy(MenuItems[6].Str,"[ ] CODE4.field_name_error      ");
    MenuItems[6].Str[1] = CodeBase.field_name_error ? '':' ';
    strcpy(MenuItems[7].Str,"[ ] CODE4.go_error              ");
    MenuItems[7].Str[1] = CodeBase.go_error ? '':' ';
    sprintf(MenuItems[8].Str,"    CODE4.lock_attempts   :%5d",CodeBase.lock_attempts);
    strcpy(MenuItems[9].Str,"[ ] CODE4.open_error            ");
    MenuItems[9].Str[1] = CodeBase.open_error ? '':' ';
    strcpy(MenuItems[10].Str,"    CODE4.optimize             ");
    strcpy(MenuItems[11].Str,"    CODE4.optimize_write       ");
    strcpy(MenuItems[12].Str,"[ ] CODE4.read_lock             ");
    MenuItems[12].Str[1] = CodeBase.read_lock ? '':' ';
    strcpy(MenuItems[13].Str,"[ ] CODE4.read_only             ");
    MenuItems[13].Str[1] = CodeBase.read_only ? '':' ';
    strcpy(MenuItems[14].Str,"[ ] CODE4.relate_error          ");
    MenuItems[14].Str[1] = CodeBase.relate_error ? '':' ';
    strcpy(MenuItems[15].Str,"[ ] CODE4.safety                ");
    MenuItems[15].Str[1] = CodeBase.safety ? '':' ';
    strcpy(MenuItems[16].Str,"[ ] CODE4.tag_name_error        ");
    MenuItems[16].Str[1] = CodeBase.tag_name_error ? '':' ';

    if(DataRef >= 0)
    {
        w4deactivate(DataRef);
        w4close(DataRef);
        DataRef = -1;
        DataEntry = 0;
    }

    WinRef = w4define(1,9,19,44);
    v4window[WinRef].arrow_exit =  1 ;
    w4popup();
    w4border(SINGLE,NormalBord);
    w4attribute(NormalBord);
    n4attribute(MenuText,MenuSelected);

    FieldRef = n4(MenuItems[0].Str);n4parm(1001);n4key('a',1,10);
    n4key_special(ESC,CTRL_C,ALT_Q,ALT_M);
    n4(MenuItems[1].Str);n4parm(1002);n4key('c',1,10);
    n4(MenuItems[2].Str);n4parm(1003);n4key('u',1,18);n4reaction(DefaultUnique);
    n4(MenuItems[3].Str);n4parm(1004);n4key('x',1,11);
    n4(MenuItems[4].Str);n4parm(1005);n4key('e',1,10);
    n4(MenuItems[5].Str);n4parm(1006);n4key('p',1,12);
    n4(MenuItems[6].Str);n4parm(1007);n4key('f',1,10);
    n4(MenuItems[7].Str);n4parm(1008);n4key('g',1,10);
    n4(MenuItems[8].Str);n4parm(1009);n4key('l',1,10);
    n4(MenuItems[9].Str);n4parm(1010);n4key('o',1,10);
    n4(MenuItems[10].Str);n4parm(1011);n4key('z',1,16);n4reaction(Optimize);
    n4(MenuItems[11].Str);n4parm(1012);n4key('w',1,19);n4reaction(OptimizeWrite);
    n4(MenuItems[12].Str);n4parm(1013);n4key('r',1,10);
    n4(MenuItems[13].Str);n4parm(1014);n4key('d',1,13);
    n4(MenuItems[14].Str);n4parm(1015);n4key('k',0,-1);
    n4(MenuItems[15].Str);n4parm(1016);n4key('s',1,10);
    n4(MenuItems[16].Str);n4parm(1017);n4key('t',1,10);

    n4start_item(FieldRef + LastEntry);
    Selection = n4activate(WinRef ) ;
    LastEntry = Selection % 1000 -1;

    switch(Selection)
    {
        case 1001: CodeBase.auto_open        = !(CodeBase.auto_open       );break;
        case 1002: CodeBase.create_error     = !(CodeBase.create_error    );break;
        case 1004: CodeBase.exclusive        = !(CodeBase.exclusive       );break;
        case 1005: if( Continue("Reset","CODE4.error_code","to zero ?","",CID_OK,CID_ABO))
                       e4set(&CodeBase,0);
                   break;

        case 1006: CodeBase.expr_error       = !(CodeBase.expr_error      );break;
        case 1007: CodeBase.field_name_error = !(CodeBase.field_name_error);break;
        case 1008: CodeBase.go_error         = !(CodeBase.go_error      );break;
        case 1009: LockAttempts(); break;
        case 1010: CodeBase.open_error       = !(CodeBase.open_error    );break;
        case 1013: CodeBase.read_lock        = !(CodeBase.read_lock     );break;
        case 1014: CodeBase.read_only        = !(CodeBase.read_only     );break;
        case 1015: CodeBase.relate_error     = !(CodeBase.relate_error  );break;
        case 1016: CodeBase.safety           = !(CodeBase.safety        );break;
        case 1017: CodeBase.tag_name_error   = !(CodeBase.tag_name_error);break;
   }
    w4deactivate(WinRef);
    w4close(WinRef);

    return(Selection);
}

int DrawData( void )
{
    int DataMenuWin;


    DataMenuWin = w4define(1,16,19,71);
    w4popup();
    w4border(SINGLE,NormalBord);
    w4attribute(MenuText);
    w4activate(DataMenuWin);
    w4( 0,1,"d4alias         d4free_blocks       d4pack          ");
    w4( 1,1,"d4alias_set     d4go                d4position      ");
    w4( 2,1,"d4append        d4go_eof            d4position_set  ");
    w4( 3,1,"d4append_blank  d4lock              d4recall        ");
    w4( 4,1,"d4append_start  d4lock_append       d4reccount      ");
    w4( 5,1,"d4blank         d4lock_file         d4recno         ");
    w4( 6,1,"d4bof           d4lock_index        d4record_width  ");
    w4( 7,1,"d4bottom        d4lock_test         d4reindex       ");
    w4( 8,1,"d4changed       d4lock_test_append  d4seek          ");
    w4( 9,1,"d4close         d4lock_test_file    d4seek_double   ");
    w4(10,1,"d4close_all     d4memo_compress     d4skip          ");
    w4(11,1,"d4create        d4num_fields        d4tag_select    ");
    w4(12,1,"d4delete        d4open              d4top           ");
    w4(13,1,"d4deleted       d4opt_start         d4unlock        ");
    w4(14,1,"d4eof           d4opt_suspend       d4update_header ");
    w4(15,1,"d4field_number  d4optimize          d4write         ");
    w4(16,1,"d4flush         d4optimize_write    d4zap           ");

    return(DataMenuWin);
}

int MenuPos(int item_ref)
{
    DataEntry = item_ref;
    return( 0 );
};

int Parm(int item_ref)
{
    return( -1 * item_ref );
};

void    DataHandler(int *Selection,int item_ref)
{
    int Handled = 1;

    if(*Selection  != LEFT && *Selection  != RIGHT)
    {
        w4deactivate(DataRef);
        w4close(DataRef);
        DataRef = -1;
    }
    if(! OneParmData(*Selection))
    {
        if(! TwoParmData(*Selection))
        {
            switch(*Selection)
            {
                case 1011:d4closeallFunct();break;
                case 1012:d4createFunct();break;
                case 2013:d4openFunct();break;
                case 2014:d4optFunct();break;
                case 2015:d4optSuspendFunct();break;
                case 3012:d4tag_selectFunct();break;
                case 3015:d4update_headerFunct();break;
                case 3017:d4zapFunct();break;
                default:Handled = 0;
            }
        }
    }
    if(Handled)
        *Selection = item_ref;
}

int  Data1Menu( int item_ref )
{
    int Selection,WinRef,Item;

    if(DataRef < 0)
        DataRef = DrawData();

    WinRef = w4define(2,17,18,33);
    v4window[WinRef].arrow_exit =  1 ;
    w4popup();
    w4attribute(NormalBord);
    n4attribute(MenuText,MenuSelected);
    Item = n4("d4alias       ");n4parm( 1);n4key('a',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4alias_set   ");n4parm( 2);n4key('s',1,8);n4reaction(MenuPos);n4action(Parm);
    n4("d4append      ");n4parm( 3);n4key('p',1,3);n4reaction(MenuPos);n4action(Parm);
    n4("d4append_blank");n4parm( 4);n4key('k',1,13);n4reaction(MenuPos);n4action(Parm);
    n4("d4append_start");n4parm( 5);n4key('t',1,13);n4reaction(MenuPos);n4action(Parm);
    n4("d4blank       ");n4parm( 6);n4key(' ',0,-1);n4reaction(MenuPos);n4action(Parm);
    n4("d4bof         ");n4parm( 7);n4key(' ',0,-1);n4reaction(MenuPos);n4action(Parm);
    n4("d4bottom      ");n4parm( 8);n4key('b',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4changed     ");n4parm( 9);n4key('g',1,6);n4reaction(MenuPos);n4action(Parm);
    n4("d4close       ");n4parm(10);n4key('e',1,6);n4reaction(MenuPos);n4action(Parm);
    n4("d4close_all   ");n4parm(11);n4key('o',1,4);n4reaction(MenuPos);n4action(Parm);
    n4("d4create      ");n4parm(12);n4key('c',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4delete      ");n4parm(13);n4key('d',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4deleted     ");n4parm(14);n4key('l',1,4);n4reaction(MenuPos);n4action(Parm);
    n4("d4eof         ");n4parm(15);n4key(' ',0,-1);n4reaction(MenuPos);n4action(Parm);
    n4("d4field_number");n4parm(16);n4key('n',1,8);n4reaction(MenuPos);n4action(Parm);
    n4("d4flush   ");n4parm(17);n4key('f',1,2);n4reaction(MenuPos);n4action(Parm);
    n4key_special(ESC,CTRL_C,ALT_Q,ALT_M);
    n4start_item(DataEntry+ Item -1);
    Selection = n4activate(WinRef );
    w4deactivate(WinRef);
    w4close(WinRef);
    if (Selection < 0) Selection = (-1 * Selection) + 1000;
    DataHandler(&Selection,'D');
    return(Selection);
}

int  Data2Menu( int item_ref )
{
    int Selection,WinRef,Item;

    if(DataRef < 0)
        DataRef = DrawData();

    WinRef = w4define(2,33,18,53);
    v4window[WinRef].arrow_exit =  1 ;
    w4popup();
    w4attribute(NormalBord);
    n4attribute(MenuText,MenuSelected);
    Item = n4("d4free_blocks     ");n4parm( 1);n4key('b',1,7);n4reaction(MenuPos);n4action(Parm);
    n4("d4go              ");n4parm( 2);n4key('g',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4go_eof          ");n4parm( 3);n4key('e',1,5);n4reaction(MenuPos);n4action(Parm);
    n4("d4lock            ");n4parm( 4);n4key('l',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4lock_append     ");n4parm( 5);n4key('a',1,7);n4reaction(MenuPos);n4action(Parm);
    n4("d4lock_file       ");n4parm( 6);n4key('f',1,7);n4reaction(MenuPos);n4action(Parm);
    n4("d4lock_index      ");n4parm( 7);n4key('i',1,7);n4reaction(MenuPos);n4action(Parm);
    n4("d4lock_test       ");n4parm( 8);n4key('t',1,7);n4reaction(MenuPos);n4action(Parm);
    n4("d4lock_test_append");n4parm( 9);n4key('p',1,13);n4reaction(MenuPos);n4action(Parm);
    n4("d4lock_test_file  ");n4parm(10);n4key('i',1,13);n4reaction(MenuPos);n4action(Parm);
    n4("d4memo_compress   ");n4parm(11);n4key('m',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4num_fields      ");n4parm(12);n4key('n',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4open            ");n4parm(13);n4key('o',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4opt_start       ");n4parm(14);n4key('s',1,6);n4reaction(MenuPos);n4action(Parm);
    n4("d4opt_suspend     ");n4parm(15);n4key('d',1,12);n4reaction(MenuPos);n4action(Parm);
    n4("d4optimize        ");n4parm(16);n4key('z',1,8);n4reaction(MenuPos);n4action(Parm);
    n4("d4optimize_write  ");n4parm(17);n4key('w',1,11);n4reaction(MenuPos);n4action(Parm);

    n4key_special(ESC,CTRL_C,ALT_Q,ALT_M);
    n4start_item(DataEntry + Item -1);
    Selection = n4activate(WinRef );
    w4deactivate(WinRef);
    w4close(WinRef);
    if (Selection < 0) Selection = (-1 * Selection) + 2000;
    DataHandler(&Selection,'H');
    return(Selection);
}

int  Data3Menu( int item_ref )
{
    int Selection,WinRef,Item;

    if(DataRef < 0)
        DataRef = DrawData();

    WinRef = w4define(2,53,18,70);
    v4window[WinRef].arrow_exit =  1 ;
    w4popup();
    w4attribute(NormalBord);
    n4attribute(MenuText,MenuSelected);
    Item = n4("d4pack            ");n4parm(1);n4key('p',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4position        ");n4parm(2);n4key('i',1,5);n4reaction(MenuPos);n4action(Parm);
    n4("d4position_set    ");n4parm(3);n4key(' ',0,-1);n4reaction(MenuPos);n4action(Parm);
    n4("d4recall          ");n4parm(4);n4key('r',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4reccount      ");n4parm( 5);n4key('c',1,5);n4reaction(MenuPos);n4action(Parm);
    n4("d4recno         ");n4parm( 6);n4key('n',1,5);n4reaction(MenuPos);n4action(Parm);n4action(Parm);
    n4("d4record_width  ");n4parm( 7);n4key('w',1,9);n4reaction(MenuPos);n4action(Parm);
    n4("d4reindex       ");n4parm( 8);n4key('x',1,8);n4reaction(MenuPos);n4action(Parm);
    n4("d4seek          ");n4parm( 9);n4key('e',1,3);n4reaction(MenuPos);n4action(Parm);
    n4("d4seek_double   ");n4parm(10);n4key('d',1,7);n4reaction(MenuPos);n4action(Parm);
    n4("d4skip          ");n4parm(11);n4key('s',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4tag_select    ");n4parm(12);n4key('t',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4top           ");n4parm(13);n4key('o',1,3);n4reaction(MenuPos);n4action(Parm);
    n4("d4unlock    ");n4parm(14);n4key('k',1,7);n4reaction(MenuPos);n4action(Parm);
    n4("d4update_header ");n4parm(15);n4key('h',1,9);n4reaction(MenuPos);n4action(Parm);
    n4("d4write         ");n4parm(16);n4key('w',1,2);n4reaction(MenuPos);n4action(Parm);
    n4("d4zap           ");n4parm(17);n4key('z',1,2);n4reaction(MenuPos);n4action(Parm);
    n4key_special(ESC,CTRL_C,ALT_Q,ALT_M);
    n4start_item(DataEntry + Item -1);
    Selection = n4activate(WinRef ) ;
    w4deactivate(WinRef);
    w4close(WinRef);
    if (Selection < 0) Selection = (-1 * Selection) + 3000;
    DataHandler(&Selection,'J');
    return(Selection);
}

/***************************************************************************\
*                                                                           *
*   Function    DateMenu                                                    *
*                                                                           *
\***************************************************************************/

int  DateMenu( int item_ref )
{
    int Selection,WinRef ;

    if(DataRef >= 0)
    {
        w4deactivate(DataRef);
        w4close(DataRef);
        DataRef = -1;
        DataEntry = 0;
    }

    WinRef = w4define(1,23,15,41);
    v4window[WinRef].arrow_exit =  1 ;
    w4popup();
    w4border(SINGLE,NormalBord);
    w4attribute(MenuText);
    n4attribute(MenuText,MenuSelected);
    n4("date4assign    ");n4parm(5101);n4key('a',1,5);
    n4("date4cdow      ");n4parm(5102);n4key('c',1,5);
    n4("date4cmonth    ");n4parm(5103);n4key('o',1,7);
    n4("date4day       ");n4parm(5104);n4key('d',1,5);
    n4("date4dow       ");n4parm(5105);n4key('w',1,7);
    n4("date4format    ");n4parm(5006);n4key('f',1,5);
    n4("date4format_mdx");n4parm(5107);n4key('x',1,14);
    n4("date4init      ");n4parm(5008);n4key('i',1,8);
    n4("date4long      ");n4parm(5109);n4key('l',1,5);
    n4("date4month     ");n4parm(5110);n4key('m',1,5);
    n4("date4time_now  ");n4parm(5011);n4key('n',1,10);
    n4("date4today     ");n4parm(5012);n4key('t',1,5);
    n4("date4year      ");n4parm(5113);n4key('y',1,5);
    n4key_special(ESC,CTRL_C,ALT_Q,ALT_M);

    Selection = n4activate(WinRef ) ;
    if(Selection > 5100 && Selection  != LEFT && Selection  != RIGHT)
        OneParmDate(Selection);
    else
        switch(Selection)
        {
            case 5006:  date4formatFunct();break;
            case 5008:  date4initFunct();break;
            case 5011:  date4time_nowFunct();break;
            case 5012:  date4todayFunct();break;
        }

    w4deactivate(WinRef);
    w4close(WinRef);

    return(Selection);
}

/***************************************************************************\
*                                                                           *
*   Function    FieldMenu                                                   *
*                                                                           *
\***************************************************************************/

int  FieldMenu( int item_ref )
{
    int Selection,WinRef ;

    WinRef = w4define(1,37,21,55);
    v4window[WinRef].arrow_exit =  1 ;
    w4popup();
    w4border(SINGLE,NormalBord);
    w4attribute(MenuText);
    n4attribute(MenuText,MenuSelected);
    n4("f4assign       ");n4parm(6101);n4key('a',1,2);
    n4("f4assign_char  ");n4parm(6102);n4key('c',1,9);
    n4("f4assign_double");n4parm(6103);n4key('b',1,12);
    n4("f4assign_int   ");n4parm(6104);n4key('n',1,10);
    n4("f4assign_long  ");n4parm(6105);n4key('g',1,12);
    n4("f4assign_n     ");n4parm(6206);n4key('n',1,9);
    n4("f4blank        ");n4parm(6007);n4key('b',1,2);
    n4("f4decimals     ");n4parm(6008);n4key('e',1,3);
    n4("f4double       ");n4parm(6009);n4key('d',1,2);
    n4("f4int          ");n4parm(6010);n4key('i',1,2);
    n4("f4len          ");n4parm(6011);n4key(' ',0,-1);
    n4("f4long         ");n4parm(6012);n4key('l',1,2);
    n4("f4memo_assign  ");n4parm(6016);n4key('m',0,2);
    n4("f4memo_free    ");n4parm(6017);n4key('f',0,7);
    n4("f4memo_len     ");n4parm(6018);n4key(' ',0,-1);
    n4("f4memo_str     ");n4parm(6019);n4key('o',0,5);
    n4("f4str          ");n4parm(6013);n4key('s',1,2);
    n4("f4true         ");n4parm(6014);n4key('r',1,3);
    n4("f4type         ");n4parm(6015);n4key('t',1,2);
    n4key_special(ESC,CTRL_C,ALT_Q,ALT_M);

    Selection = n4activate(WinRef ) ;
    if(Selection  != LEFT && Selection  != RIGHT)
        FieldFunct(Selection);
    w4deactivate(WinRef);
    w4close(WinRef);

    return(Selection);
}

/***************************************************************************\
*                                                                           *
*   Function    IndexMenu                                                   *
*                                                                           *
\***************************************************************************/

int  IndexMenu( int item_ref )
{
    int Selection,WinRef ;
#ifdef N4OTHER
    WinRef = w4define(1,45,9,57);
#else
    WinRef = w4define(1,45,8,57);
#endif
    v4window[WinRef].arrow_exit =  1 ;
    w4popup();
    w4border(SINGLE,NormalBord);
    w4attribute(MenuText);
    n4attribute(MenuText,MenuSelected);
    n4("i4close  ");n4parm(8003);n4key('c',1,2);
    n4("i4create ");n4parm(8001);n4key('r',1,3);
    n4("i4lock   ");n4parm(8004);n4key('l',1,2);
    n4("i4open   ");n4parm(8002);n4key('o',1,2);
    n4("i4reindex");n4parm(8005);n4key('i',1,4);
    n4("i4unlock ");n4parm(8006);n4key('u',1,2);
#ifdef N4OTHER
    n4("t4open   ");n4parm(8007);n4key('n',1,5);
#endif
    n4key_special(ESC,CTRL_C,ALT_Q,ALT_M);
    Selection = n4activate(WinRef ) ;
    w4deactivate(WinRef);
    w4close(WinRef);

    switch(Selection)
    {
        case 8001:
            i4createFunct();
            break;
        case 8002:
            i4openFunct();
            break;
#ifdef N4OTHER
        case 8007:
            t4openFunct();
            break;
#endif
    }
    if((Selection > 8002) && (Selection < 8007))
        IndexFunct(Selection);

    return(Selection);
}
/***************************************************************************\
*                                                                           *
*   Function    RelateMenu                                                  *
*                                                                           *
\***************************************************************************/

int  RelateMenu( int item_ref )
{
    int Selection,WinRef ;

    if(DataRef >= 0)
    {
        w4deactivate(DataRef);
        w4close(DataRef);
        DataRef = -1;
        DataEntry = 0;
    }

    WinRef = w4define(1,53,19,75);
    v4window[WinRef].arrow_exit =  1 ;
    w4popup();
    w4border(SINGLE,NormalBord);
    w4attribute(MenuText);
    n4attribute(MenuText,MenuSelected);
    n4("relate4bottom      ");n4parm(9001);n4key('b',1,7);
    n4("relate4changed     ");n4parm(9002);n4key('g',1,11);
    n4("relate4create_slave");n4parm(9303);n4key('c',1,7);
    n4("relate4do          ");n4parm(9004);n4key('d',1,7);
    n4("relate4do_one      ");n4parm(9005);n4key('o',1,10);
    n4("relate4error_action");n4parm(9206);n4key('e',1,7);
    n4("relate4free        ");n4parm(9207);n4key('f',1,7);
    n4("relate4init        ");n4parm(9308);n4key('i',1,7);
    n4("relate4lock        ");n4parm(9009);n4key('l',1,7);
    n4("relate4match_len   ");n4parm(9210);n4key('m',1,7);
    n4("relate4query_set   ");n4parm(9211);n4key('q',1,7);
    n4("relate4skip        ");n4parm(9212);n4key('s',1,7);
    n4("relate4skip_enable ");n4parm(9213);n4key('n',1,13);
    n4("relate4sort_set    ");n4parm(9214);n4key('r',1,9);
    n4("relate4top         ");n4parm(9015);n4key('t',1,7);
    n4("relate4type        ");n4parm(9216);n4key('y',1,8);
    n4("relate4unlock      ");n4parm(9017);n4key('u',1,7);
    n4key_special(ESC,CTRL_C,ALT_Q,ALT_M);

    Selection = n4activate(WinRef ) ;
    if(Selection > 9000 && Selection < 9200 && Selection  != LEFT && Selection  != RIGHT)
        OneParmRelation(Selection);
    else if (Selection > 9200 && Selection < 9300 && Selection  != LEFT && Selection  != RIGHT)
        TwoParmRelation(Selection);
    else
        switch(Selection)
        {
            case 9303:  relate4create_slaveFunct();break;
            case 9308:  relate4initFunct();break;
        }

    w4deactivate(WinRef);
    w4close(WinRef);

    return(Selection);
}


/***************************************************************************\
*                                                                           *
*   Function    Quit                                                        *
*                                                                           *
\***************************************************************************/

int Quit(int item_ref )
{
    int Choice;
    Choice = Continue("",CID_QUI,"","",CID_TER,CID_CON);
    if(Choice)
        return(CTRL_C);
    else
        return(0);
}

/***************************************************************************\
*                                                                           *
*   Function    CreateMainMenu                                              *
*                                                                           *
*       This function defines the main menu.  It defines the menu bar and   *
*   two pull down menus.  The action routines for the menu bar are defined  *
*   and a pointer to a structure containing the window references is        *
*   returned.                                                               *
*                                                                           *
\***************************************************************************/

void    CreateMainMenu( void )
{
    int     MenuBar,Selection = 27;

    MenuBar = w4define(0,0,0,MAXCOL);
    w4attribute(NormalBord);
    n4horizontal();
    n4item_width(9);
    n4attribute(MenuText,MenuSelected);
    n4item(0,0 ," BROWSER ");n4key(ALT_B,1,1);n4action(Browser);
    n4item(0,9 ," CODE4 ");n4key(ALT_C,1,1);n4reaction(CodeMenu);
    n4item(0,16," DATA4 ");n4key(ALT_D,1,1);n4reaction(Data1Menu);
    n4item(0,16," DATA4 ");n4key(ALT_D,1,1);n4reaction(Data2Menu);
    n4item(0,16," DATA4 ");n4key(ALT_D,1,1);n4reaction(Data3Menu);
    n4item(0,23," DATE4 ");n4key(ALT_A,1,2);n4reaction(DateMenu);
    n4item(0,30," EXPR4 ");n4key(ALT_E,1,1);n4action(e4exprFunct);
    n4item(0,37," FIELD4 ");n4key(ALT_F,1,1);n4reaction(FieldMenu);
    n4item(0,45," INDEX4 ");n4key(ALT_I,1,1);n4reaction(IndexMenu);
    n4item(0,53," RELATE4 ");n4key(ALT_R,1,1);n4reaction(RelateMenu);

    n4item(0,74," QUIT ");n4key(ALT_Q,1,1);n4action(Quit);
    while(Selection == 27)
    {
        Selection = n4activate(MenuBar);
        if(DataRef >= 0)
        {
            w4deactivate(DataRef);
            w4close(DataRef);
            DataRef = -1;
        }
    }
    w4deactivate(MenuBar);
    w4close(MenuBar);

}


/***************************************************************************\
*                                                                           *
*   Functions SetColor and SetMono                                          *
*                                                                           *
\***************************************************************************/

void    SetColor( void )
{
        BackGroundColor=F_BLUE|F_INTENSE|B_GREEN;
        TitleBarColor  =F_BLUE|B_WHITE;
        NormalBord     =F_INTENSE|F_WHITE|B_BLUE;
        NormalText     =F_INTENSE|F_RED|F_GREEN|B_BLUE;
        WarningBord    =F_INTENSE|F_WHITE|B_RED|B_BLINK;
        WarningText    =F_INTENSE|F_WHITE|B_RED;
        ReturnBord     =F_INTENSE|F_WHITE|B_GREEN;
        ReturnText     =B_GREEN;
        MenuText       =F_WHITE|B_BLUE;
        MenuSelected   =F_INTENSE|F_WHITE|B_GREEN|B_BLUE;
        PopUpText      =F_INTENSE|F_GREEN|F_BLUE|B_BLUE;
        GetColor       =F_INTENSE|F_GREEN|F_RED;
        SelectedColor  =F_INTENSE|F_GREEN|F_RED;
}

void    SetMono( void )
{
        BackGroundColor=B_WHITE;
        TitleBarColor  =B_WHITE;
        NormalBord     =F_INTENSE|F_WHITE;
        NormalText     =F_WHITE;
        WarningBord    =F_INTENSE|F_WHITE|B_BLINK|B_WHITE;
        WarningText    =F_INTENSE|F_WHITE|B_WHITE;
        ReturnBord     =F_INTENSE|F_WHITE|B_WHITE;
        ReturnText     =B_WHITE;
        MenuText       =F_WHITE;
        MenuSelected   =B_WHITE;
        PopUpText      =F_INTENSE|F_WHITE;
        GetColor       =B_WHITE;
        SelectedColor  =F_INTENSE|F_WHITE;
}

/***************************************************************************\
*                                                                           *
*   Function main                                                           *
*                                                                           *
\***************************************************************************/

void    main(int argc, char **argv )
{
    int BackWindow;

    if( (argc == 2) && (!memcmp(argv[1], "MONO", 4)) )
       SetMono();
    else
       SetColor() ;

    strcpy(DefaultPath,".");

    d4init(&CodeBase);
    memset(&RelList,NULL,sizeof(RelList));

#ifndef S4FOX
    #ifdef N4OTHER
        #ifdef S4CLIPPER
    BackWindow = TitleScreen("InterActive CodeBase. [NTX Version] (C) 1993 Sequiter Software Inc.");
        #else
    BackWindow = TitleScreen("InterActive CodeBase. [NDX Version] (C) 1993 Sequiter Software Inc.");
        #endif
    #else
    BackWindow = TitleScreen("InterActive CodeBase. [MDX Version] (C) 1993 Sequiter Software Inc.");
    #endif
#else
    BackWindow = TitleScreen("InterActive CodeBase. [CDX Version] (C) 1993 Sequiter Software Inc.");
#endif

    w4cursor(-1,-1);
    HelloMessage();
    CreateMainMenu();
    FreeData();
    FreeRel();
    d4close_all(&CodeBase);
    w4deactivate(BackWindow);
    w4cursor(22,1);
    exit(0);
}

/***************************************************************************\
\***************************************************************************/
