/***************************************************************************\
*                                                                           *
*   CID.H       Copyright 1992 Sequiter Software Inc.                       *
*                                                                           *
\***************************************************************************/

/***************************************************************************\
*   defines                                                                 *
\***************************************************************************/

#define     MAXCOL      79
#define     MAXROW      24
#define     TRUE        1
#define     FALSE       0
#define     INTTYPE     1
#define     CHARTYPE    2
#define     LONGTYPE    3
#define     DOUBLETYPE  4

#define     EDIT4MAXBUFF     32700


/***************************************************************************\
*   language defines                                                                 *
\***************************************************************************/

#ifndef S4LANGUAGE

   #define  CID_ABO " Abort "
   #define  CID_ADD "     ADD NEW FIELD    "
   #define  CID_AOP "Abort Operation ?"
   #define  CID_BRO " Browse "
   #define  CID_COM "Compressing Memo File"
   #define  CID_CON " Continue "
   #define  CID_CRI "Creating Index"
   #define  CID_CUR "Current Record Number :"
   #define  CID_DAT "Database"
   #define  CID_DBF "A Database file must be opened"
   #define  CID_DBS "Database:"
   #define  CID_DCT "Directory:"
   #define  CID_DIR "In this directory"
   #define  CID_DNE "                  DONE                  "
   #define  CID_DOE "Does not have any "
   #define  CID_DON "         DONE         "
   #define  CID_DTB "Database              :"
   #define  CID_ERR "Error Number :%d"
   #define  CID_EXI "         EXIT        "
   #define  CID_EXP "Expression String"
   #define  CID_EXS "Does not exist !!!"
   #define  CID_FIL "File:"
   #define  CID_IND "Index Files open"
   #define  CID_JUL "Julian Day :"
   #define  CID_LAT "Enter CODE4.lock_attempts value :"
   #define  CID_LOC "Record Locking Status :"
   #define  CID_NAT "NATURAL ORDER"
   #define  CID_NWD "     NEW DATABASE    "
   #define  CID_NWE "    NEW EXPRESSION   "
   #define  CID_NOF "There are no files matching"
   #define  CID_OK  " OK "
   #define  CID_PAC "Packing Database"
   #define  CID_PRI "prior to calling this function"
   #define  CID_QBR " QUIT BROWSER "
   #define  CID_QBR_POS 66
   #define  CID_QUI "Quit InterActive for DOS ?"
   #define  CID_REC "Reccount              :"
   #define  CID_REI "Reindexing"
   #define  CID_RES "Result :"
   #define  CID_RET "Return Value          :"
   #define  CID_RTV "Return Value :"
   #define  CID_SEL "Select"
   #define  CID_SEV "Severe Error Number :%d"
   #define  CID_SLD "Select Database"
   #define  CID_SLF "Select Field"
   #define  CID_SLU "Select Function"
   #define  CID_SLI "Select Index"
   #define  CID_SLT "Select Tag"
   #define  CID_TAG "              ADD NEW TAGS              "
   #define  CID_TER " Terminate "
   #define  CID_USA "Usage :"
   #define  CID_WAI "Please wait ..."
   #define  CID_ZAP "Zapping Database"
#else
   #ifdef S4GERMAN
      #define  CID_ABO " Abort "
      #define  CID_ADD "     ADD NEW FIELD    "
      #define  CID_AOP "Abort Operation ?"
      #define  CID_BRO " Browse "
      #define  CID_COM "Compressing Memo File"
      #define  CID_CON " Continue "
      #define  CID_CRI "Creating Index"
      #define  CID_CUR "Current Record Number :"
      #define  CID_DAT "Datenbank"
      #define  CID_DBF "A Database file must be opened"
      #define  CID_DBS "Database:"
      #define  CID_DCT "Directory:"
      #define  CID_DIR "In this directory"
      #define  CID_DNE "                  DONE                  "
      #define  CID_DOE "Does not have any "
      #define  CID_DON "         DONE         "
      #define  CID_DTB "Database              :"
      #define  CID_ERR "Error Number :%d"
      #define  CID_EXI "         EXIT        "
      #define  CID_EXP "Expression String"
      #define  CID_EXS "Does not exist !!!"
      #define  CID_FIL "Datei:
      #define  CID_IND "Offene Indexdateien
      #define  CID_JUL "Julianischer Tag :
      #define  CID_LOC "Status der Datensatzsperren :
      #define  CID_NAT "PHYSIKALISCHE REIHENFOLGE
      #define  CID_NWD "    NEUE DATENBANK   "
      #define  CID_NWE "    NEUER AUSDRUCK   "
      #define  CID_NOF "Keine bereinstimmung
      #define  CID_PAC "Packe Datenbank
      #define  CID_PRI "zuvor folgende Funktion aufrufen
      #define  CID_QBR " QUIT BROWSER "              88888
      #define  CID_QUI "Interactive CodeBase fr DOS verlassen ?
      #define  CID_QBR_POS 63
      #define  CID_REC "Datensatznummer       :"
      #define  CID_REI "Reindiziere
      #define  CID_RES "Result :"
      #define  CID_RET "Return Value          :"
      #define  CID_RTV "Return Value :"
      #define  CID_SEL "Select"
      #define  CID_SEV "Severe Error Number :%d"
      #define  CID_SLD "Select Database"
      #define  CID_SLF "Select Field"
      #define  CID_SLU "Select Function"
      #define  CID_SLI "Select Index"
      #define  CID_SLT "Select Tag"
      #define  CID_TAG "              ADD NEW TAGS              "
      #define  CID_TER " Terminate "
      #define  CID_USA "Usage :"
      #define  CID_WAI "Please wait ..."
      #define  CID_ZAP "Zapping Database"
   #endif
   
   #ifdef S4FRENCH
      #define  CID_ABO " Abort "
      #define  CID_ADD "     ADD NEW FIELD    "
      #define  CID_AOP "Abort Operation ?"
      #define  CID_BRO " Browse "
      #define  CID_COM "Compressing Memo File"
      #define  CID_CON " Continue "
      #define  CID_CRI "Creating Index"
      #define  CID_CUR "Current Record Number :"
      #define  CID_DAT "Database"        Datenbank
      #define  CID_DBF "A Database file must be opened"
      #define  CID_DBS "Database:"
      #define  CID_DCT "Directory:"
      #define  CID_DIR "In this directory"
      #define  CID_DNE "                  DONE                  "
      #define  CID_DOE "Does not have any "
      #define  CID_DON "         DONE         "
      #define  CID_DTB "Database              :"
      #define  CID_ERR "Error Number :%d"
      #define  CID_EXI "         EXIT        "
      #define  CID_EXP "Expression String"
      #define  CID_EXS "Does not exist !!!"
      #define  CID_FIL "File:"
      #define  CID_IND "Index Files open"
      #define  CID_JUL "Julian Day :"
      #define  CID_LOC "Record Locking Status :"
      #define  CID_NAT "NATURAL ORDER"
      #define  CID_NWD "     NEW DATABASE    "
      #define  CID_NWE "    NEW EXPRESSION   "
      #define  CID_NOF "There are no files matching"   
      #define  CID_PAC "Packing Database"
      #define  CID_PRI "prior to calling this function"
      #define  CID_QBR " QUIT BROWSER "
      #define  CID_QBR_POS 66
      #define  CID_QUI "Quit InterActive for DOS ?"
      #define  CID_REC "Reccount              :"
      #define  CID_REI "Reindexing"
      #define  CID_RES "Result :"
      #define  CID_RET "Return Value          :"
      #define  CID_RTV "Return Value :"
      #define  CID_SEL "Select"
      #define  CID_SEV "Severe Error Number :%d"
      #define  CID_SLD "Select Database"
      #define  CID_SLF "Select Field"
      #define  CID_SLU "Select Function"
      #define  CID_SLI "Select Index"
      #define  CID_SLT "Select Tag"
      #define  CID_TAG "              ADD NEW TAGS              "
      #define  CID_TER " Terminate "
      #define  CID_USA "Usage :"
      #define  CID_WAI "Please wait ..."
      #define  CID_ZAP "Zapping Database"
   #endif
#endif

/***************************************************************************\
*   structures                                                              *
\***************************************************************************/

struct  DATALIST
{
    struct  DATALIST  *Next;
    DATA4   *Data;
    char    Alias[20];
    int     Item;
};

struct FIELDLIST
{
    struct  FIELDLIST *Next;
    char    Name[15],Type,FieldStr[25];
    short   Dec,Len;
};

struct TAGLIST
{
    struct  TAGLIST *Next;
    char    Name[15],Expr[62],Filter[62],FieldStr[40];
    short   Unique,Descending;
};

struct RELATELIST
{
    LINK4    link;
    RELATE4  *rel;
    char    Alias[20];
    int     Item;
};


typedef struct
{
   char   *buffer;
   int    buflen;
   int    *startpos;
   int    *endpos;
   int    rows;
   int    cols;
   int    start;
   int    currow;
   int    curcol;
   int    insert;
   int    word_wrap;
   int    allow_edits;
   int    x,y;
   long   text_att;
   int    prev_start;
   int    maxbuf;
}  EDIT4MULTI;


/***************************************************************************\
*   browse structures                                                       *
\***************************************************************************/

typedef struct
{
    DATA4   *data;
    LIST4  records;

    int     row;
    int     col;
    int     maxrow;
    int     maxcol;
    long    BorderColor;
    long    SelectedRecColor;
    long    NormalColor;
    long    SelectedFieldColor;
    long    EditColor;
    int     Reload;
    int     win_ref;
    int     maxdisplay;
    int     maxrecords;
    int     num_fields;
    int     CurrentField;
    int     CurrentRecord;
    long    CurrentOffset;
    int    *offsets;
    long    buffer_size;
    long    CurrentRecno;

}BROW4BROWSE;

typedef struct
{
    FIELD4  *field;
    int     field_no;
    int     field_len;
    int     display_len;
}BROW4FIELD;

typedef struct
{
    LINK4  link;
    DATA4   *data;
    char    *buffer;
    long    recno;
    int     changed;
    int     deleted;
    int     num_fields;
    BROW4FIELD *fields;

}BROW4RECORD;

/***************************************************************************\
*   ProtoTypes                                                              *
\***************************************************************************/

BROW4BROWSE    *brow4define(int ,int ,int ,int );
void        brow4attribute(BROW4BROWSE *,long ,long ,long ,long ,long );
void        brow4free_browse(BROW4BROWSE *);
int         brow4activate(DATA4 *,BROW4BROWSE *);
void        brow4browse(BROW4BROWSE *,int ,int );
void        brow4resize(BROW4BROWSE **,int ,int ,int ,int );

int         Busy(char *,char *,char *,char *);
void        ClearBusy(int);
void        Message(char *,char *,char *,char *,char *);
int         Continue(char *,char *,char *,char *,char *,char *);
void        AddData(DATA4 *);
void        FreeData( void );
void        RemoveData( DATA4 *);
void        ReturnCode(char *,int);
int         CheckDir(GET *);
int         CheckFileName(GET *);
int         CheckBlank(GET *);
int         CheckType(GET *);
void        FreeFields(struct FIELDLIST *);
void        FreeTags(struct TAGLIST *);
int         EmptyStr(char *);
int         TitleScreen(char *);
int         EntryWindow(char *);
int         EntryWindowSmall(char *);
void        HelloMessage( void );

int         u4file_first(char *,char *);
int         u4file_next(char *);

int     SingleGet(int,int,int,int,int,char *);
int     DoubleGet(int,int,int,int,int,char *,int,int,int,int,int,char *);
void    FunctionReturn(char *,char *,DATA4 *,char *);

void    edit4memo(FIELD4 *memo,int y1,int x1,int y2,int x2,char *title
           ,int allow_edits,int word_wrap,long text_att,long bord_att);


int     edit4(char *buffer,int *buffsize,int maxbuff,int y1,int x1,int y2,int x2,char *title
           ,int allow_edits,int word_wrap,long text_att,long bord_att);

