/* cid_3.c  (c)Copyright Sequiter Software Inc., 1992-1993.  All rights reserved. */

#include    <conio.h>
#include    <dos.h>
#include    "d4all.h"
#include    "w4.h"
#include    "cid.h"
#include    "g4char.h"

/***************************************************************************\
*                                                                           *
*   Browse Routines                                                         *
*                                                                           *
*****************************************************************************
*                                                                           *
*       The following set of funtions provides a generic browser with simple*
*   editing capibilites.                                                    *
*                                                                           *
*   BROW4BROWSE *brow4define(int row,int col,int maxrow,int maxcol)               *
*                                                                           *
*       This function defines a browse window of the dimensions provided.   *
*                                                                           *
*   brow4attribute(BROW4BROWSE *Browse,long BorderColor,long NormalColor          *
*               ,long SelectedRecordColor,long SelectedFieldColor           *
*               ,long EditColor)                                            *
*                                                                           *
*       This function sets the colors for the browse screen                 *
*                                                                           *
*   brow4activate(DATA4 *Data,BROW4BROWSE *Browse)                               *
*                                                                           *
*       This function associates a database with the browse.                *
*                                                                           *
*   brow4browse(BROW4BROWSE *Browse,int AllowEdits,int ReturnAtOnce)              *
*                                                                           *
*       This function transfers control to the browse screen.  If the       *
*       AllowEdits flag is false, no changes to the database are allowed.   *
*       If the ReturnAtOnce flag is true, the display is updated, and       *
*       control is returned to the calling function.                        *
*                                                                           *
*   brow4resize(BROW4Browse **Browse,int row,int col,int maxrow,int maxcol)       *
*                                                                           *
*       This function will resize the browse window to the new dimesions    *
*       provided.                                                           *
*                                                                           *
*   brow4free_browse(BROW4BROWSE *Browse)                                         *
*                                                                           *
*       This function deactivates the browse window and frees all the       *
*   allocated memory associated with the BROW4BROWSE pointer.                  *
*                                                                           *
\***************************************************************************/

int     RecordLockAndLoad(DATA4 *Data,long Recno,int Release)
{
    int LockStatus,WaitStatus,Ret;

    LockStatus = Data->code_base->read_lock;
    WaitStatus = Data->code_base->lock_attempts;
    Data->code_base->read_lock = 1;
    Data->code_base->lock_attempts = 0;
    Ret = d4go(Data,Recno);
    if(Ret != r4locked && Release)
        d4unlock(Data);

    Data->code_base->read_lock = LockStatus;
    Data->code_base->lock_attempts = WaitStatus;
    return(Ret);
}

BROW4BROWSE *brow4define(int row,int col,int maxrow,int maxcol)
{
    BROW4BROWSE *Browse;

    Browse = (BROW4BROWSE *) u4alloc(sizeof(BROW4BROWSE));

    if(col < 0)
        col = 0;
    if(col > 59)
        col =59;
    if(maxcol < col + 20)
        maxcol = col + 20;
    if(maxcol > 79)
        maxcol = 79;
    if(row < 0)
        row = 0;
    if(row > 19)
        row = 19;
    if(maxrow < row + 5)
        maxrow = row + 5;
    if(maxrow > 24)
        maxrow = 24;

    Browse->col = col;
    Browse->maxcol = maxcol;
    Browse->row = row;
    Browse->maxrow = maxrow;

    return(Browse);
}

void    brow4attribute(BROW4BROWSE *Browse,long BorderColor,long NormalColor
                    ,long SelRecColor,long SelFieldColor,long EditColor)
{
    if(Browse)
    {
        Browse->BorderColor = BorderColor;
        Browse->NormalColor = NormalColor;
        Browse->SelectedRecColor = SelRecColor;
        Browse->SelectedFieldColor = SelFieldColor;
        Browse->EditColor = EditColor;
    }
}

BROW4RECORD *brow4create_record(DATA4 *Data,long buff_size
            ,int    maxdisplay)
{
    int j;
    BROW4RECORD *Record;
    FIELD4  *Field;

    if(!Data)
        return 0;
    else
    {
        Record = (BROW4RECORD *) u4alloc(sizeof(BROW4RECORD));
        Record->recno = d4recno(Data);
        Record->data = Data;
        Record->changed = 0;
        Record->num_fields = d4num_fields(Data);
        Record->fields = (BROW4FIELD *) u4alloc(sizeof(BROW4FIELD) * (Record->num_fields + 1));
        Record->buffer = (char *) u4alloc(buff_size);

        for(j =1;j<=Record->num_fields;j++)
        {
            Field = d4field_j(Data,j);
            (Record->fields[j]).field = Field;
            (Record->fields[j]).field_no = j;
            (Record->fields[j]).field_len = Field->len;
            if(Field->type == 'M')
                (Record->fields[j]).display_len = 6;
            else if(Field->len > maxdisplay)
                (Record->fields[j]).display_len = maxdisplay;
            else
                (Record->fields[j]).display_len = Field->len;
        }
    }
    return(Record);
}

void    brow4free_browse(BROW4BROWSE *Browse)
{
    BROW4RECORD    *Current;


    w4deactivate(Browse->win_ref);
    w4close(Browse->win_ref);

    u4free(Browse->offsets);

    /* free records */

    Current = (BROW4RECORD *) l4pop((void *)&(Browse->records));
    while(Current != NULL)
    {
        u4free(Current->buffer);
        u4free(Current->fields);
        u4free(Current);
        Current = (BROW4RECORD *) l4pop((void *)&(Browse->records));
    }
    u4free(Browse);
}

void    brow4load_record(BROW4RECORD *Record,int offsets[])
{
    int j;
    char *Buffer;

    if(Record->recno != -1)
    {
        d4go(Record->data,Record->recno);
        d4unlock(Record->data);
    }
    else
        Record->recno = d4recno(Record->data);

    Buffer = Record->buffer;
    Record->deleted = d4deleted(Record->data);
    for(j=1;j <= Record->num_fields;j++)
    {
        if(((Record->fields[j]).field)->type == 'M')
            memcpy(&(Buffer[offsets[j]])," MEMO ",(Record->fields[j]).display_len);
        else
        {
            memcpy(&(Buffer[offsets[j]]),f4str((Record->fields[j]).field)
                ,(Record->fields[j]).display_len);
            if((Record->fields[j]).field_len > (Record->fields[j]).display_len)
                Buffer[offsets[j] + (Record->fields[j]).display_len -1] =0x10;
        }

        Buffer[offsets[j+1] -1] = '';
    }
    Buffer[offsets[j] -1] = 0;
}

void    brow4reload(BROW4BROWSE *Browse)
{
    BROW4RECORD *Record,*First;
    long    StartRecno;
    int     j,Ret = 0;

    StartRecno = d4recno(Browse->data);

    Record = NULL;
    for(j = 1;j <= Browse->maxrecords;j++)
    {
        if(Ret != r4eof)
        {
            Record = (BROW4RECORD *) l4next(&(Browse->records),(void *)Record);
            Record->recno = -1;
            brow4load_record(Record,Browse->offsets);
            Ret = d4skip(Browse->data,1L);
            d4unlock(Browse->data);
            if(Ret == r4eof)
            {
                d4go(Browse->data,StartRecno);
                d4unlock(Browse->data);
                Browse->CurrentRecord = Browse->maxrecords - j +1;
            }
        }
        else
        {
            Record = (BROW4RECORD *) l4pop(&(Browse->records));
            d4skip(Browse->data,-1L);
            d4unlock(Browse->data);
            Record->recno = -1;
            brow4load_record(Record,Browse->offsets);
            First = (BROW4RECORD *) l4first(&(Browse->records));
            l4add_before(&(Browse->records),First,Record);
        }
    }
}




int brow4activate(DATA4 *Data,BROW4BROWSE *Browse)
{
    FIELD4     *Field;
    BROW4RECORD    *NewRecord;
    int j,maxdisplay,OldLockStatus,BufferSize = 0;
    long    maxrecords;

    if(!Data || !Browse)
        return(e4parm);
    else
    {
        OldLockStatus = Data->code_base->read_lock;
        Data->code_base->read_lock = 0;
        d4unlock(Data);
        Browse->data = Data;
        Browse->CurrentOffset = 0;
        Browse->offsets = (int *)u4alloc((d4num_fields(Data) +2) * sizeof(long));
        memset((&Browse->records),0,sizeof(Browse->records));

        maxdisplay = Browse->maxcol - Browse->col -3;

        /* generate display offsets */

        for(j=1;j<=d4num_fields(Data);j++)
        {
            Field = d4field_j(Data,j);
            (Browse->offsets)[j] = BufferSize;
            if(Field->type == 'M')
                BufferSize += 6;
            else
            {
                if(Field->len > maxdisplay)
                    BufferSize += maxdisplay;
                else
                    BufferSize += Field->len;
            }
            BufferSize++;
        }
        Browse->offsets[j] = BufferSize;
        Browse->num_fields = d4num_fields(Data);

        if(BufferSize < maxdisplay)
            maxdisplay = BufferSize;
        maxrecords = Browse->maxrow - Browse->row - 3;
        if(maxrecords > d4reccount(Data))
            maxrecords = d4reccount(Data);
        d4unlock(Data);
        Browse->maxrecords = maxrecords;
        Browse->maxdisplay = maxdisplay;
        /* create record buffers */

        for(j=0;j< maxrecords;j++)
        {
            NewRecord = brow4create_record(Data,BufferSize,maxdisplay);
            l4add(&(Browse->records),(void *) NewRecord);
            d4skip(Data,1L);
            d4unlock(Data);
        }
        d4top(Browse->data);
        d4unlock(Data);
        /* load buffers */
        brow4reload(Browse);
        /* open browse window */
        Browse->win_ref = w4define(Browse->row,Browse->col
                                ,Browse->maxrow,Browse->maxcol);

        w4popup();
        w4attribute(Browse->NormalColor);
        w4border(DOUBLE,Browse->BorderColor);
        w4activate(Browse->win_ref);
        Browse->CurrentRecord = 1;
        Browse->CurrentField = 1;
        Browse->Reload = 1;
        Data->code_base->read_lock = OldLockStatus;

    }
    return(0);
}

void    brow4update_scroll(BROW4BROWSE *Browse)
{
    double  Pos;
    int     PosInt,row;


    Pos = d4position(Browse->data);
    PosInt = 1 + (int) (Pos * (double) (Browse->maxrecords));
    if(PosInt > Browse->maxrecords)
        PosInt = Browse->maxrecords;
    for(row = 1;row <= Browse->maxrecords;row++)
    {
        if(row == PosInt)
            w4write_att((Browse->row + row +2 ),Browse->maxcol,"",1,Browse->BorderColor);
        else
            w4write_att((Browse->row + row +2 ),Browse->maxcol,"",1,Browse->BorderColor);
    }
}

void    brow4update(BROW4BROWSE *Browse)
{
    int     OldWin,row = 1,j,DoneFirst=0,Col,Pos,ScrollLen;
    int     Offset,NewOffset;
    char    TBorder[81],NBorder[92],MBorder[81],BBorder[81],Name[12],*Buffer
            ,Filler[81],Recno[10];

    BROW4RECORD    *Record;

    OldWin = w4select(-1);
    w4select(Browse->win_ref);

    memset(TBorder,'',Browse->maxcol - Browse->col);
    memset(NBorder,' ',Browse->maxcol - Browse->col);
    memset(Filler ,' ',Browse->maxcol - Browse->col);
    memset(MBorder,'',Browse->maxcol - Browse->col);
    memset(BBorder,'',Browse->maxcol - Browse->col);

    Record = (BROW4RECORD *) l4first(&(Browse->records));
    for(j=1;j<=Browse->num_fields;j++)
    {
        Offset = Browse->offsets[j] - Browse->CurrentOffset;
        if(Offset >= 0 && Offset <= Browse->maxdisplay)
        {
            if(j != 1 && !DoneFirst)
            {
                memset(Name,' ',11);
                memcpy(Name,(Record->fields[j-1].field)->name,strlen((Record->fields[j-1].field)->name));
                memcpy(&(NBorder[3]),Name,10);
                DoneFirst = 1;
            }
            memset(Name,' ',11);
            memcpy(Name,(Record->fields[j].field)->name,strlen((Record->fields[j].field)->name));
            memcpy(&(NBorder[Offset+3]),Name,10);
            TBorder[Offset+2] = '';
            NBorder[Offset+2] = '';
            Filler[Offset+2] = '';
            MBorder[Offset+2] = '';
            BBorder[Offset+2] = '';
        }
    }
    if(Browse->offsets[Browse->num_fields + 1] < (Browse->maxcol - Browse->col - 3))
    {
        TBorder[Browse->offsets[Browse->num_fields +1]+2] = '';
        NBorder[Browse->offsets[Browse->num_fields +1]+2] = '';
        Filler[Browse->offsets[Browse->num_fields +1]+2] = '';
        MBorder[Browse->offsets[Browse->num_fields +1]+2] = '';
        BBorder[Browse->offsets[Browse->num_fields +1]+2] = '';
    }

    TBorder[0] = '';TBorder[Browse->maxcol - Browse->col] ='';TBorder[2] = '';
    NBorder[0] = '';NBorder[Browse->maxcol - Browse->col] ='';NBorder[2] = '';
    Filler[0] = '';Filler[Browse->maxcol - Browse->col] ='';Filler[2] = '';
    MBorder[0] = '';MBorder[Browse->maxcol - Browse->col] ='';MBorder[2] = '';
    BBorder[0] = '';BBorder[Browse->maxcol - Browse->col] ='';BBorder[2] = '';

    Record = (BROW4RECORD *) l4first(&(Browse->records));
     while(Record != NULL)
    {
        if(Record->deleted)
            w4(row+1,0,"\x04");
        else
            w4(row+1,0," ");


        if(row == Browse->CurrentRecord)
        {
            w4num_att(row+1,2,&(Record->buffer[Browse->CurrentOffset]),
                Browse->maxdisplay,Browse->SelectedRecColor);
            Col = (Browse->offsets[Browse->CurrentField]);
            Col -= Browse->CurrentOffset;
            NewOffset = Browse->offsets[Browse->CurrentField];
            Buffer = &(Record->buffer[NewOffset]);

            w4num_att(1+row,Col+2,Buffer
                ,(Record->fields[Browse->CurrentField]).display_len
                ,Browse->SelectedFieldColor);

            Browse->CurrentRecno = Record->recno;
            sprintf(Recno,"%9ld",Record->recno);
            d4go(Browse->data,Record->recno);
            brow4update_scroll(Browse);

        }
        else
        {
            w4num_att(row+1,2,&(Record->buffer[Browse->CurrentOffset]),
                        Browse->maxdisplay,Browse->NormalColor);
        }
        if(Browse->offsets[Browse->num_fields + 1] < (Browse->maxcol - Browse->col - 3))
                    w4num_att(1+row,Browse->offsets[Browse->num_fields + 1]+1
                ,"",1,Browse->NormalColor);
        row ++;
        Record = (BROW4RECORD *) l4next(&(Browse->records),(void *) Record);
    }
    for(;row <= (Browse->maxrow - Browse->row -3);row ++)
        w4write_att(Browse->row + row+2,Browse->col,Filler
                ,Browse->maxdisplay+4,Browse->BorderColor);

    memcpy(&(BBorder[2]),Recno,11);
    ScrollLen = Browse->maxcol - Browse->col - 15;
    memset(&(BBorder[14]),'',ScrollLen);
    if(Browse->num_fields == 1)
        Pos =0;
    else
        Pos = (int) ((double) (ScrollLen-1) * ((double) (Browse->CurrentField -1)/(double) (Browse->num_fields -1)));
    BBorder[14+ Pos] = '';

    w4write_att(Browse->row,Browse->col,TBorder
                ,Browse->maxcol - Browse->col +1,Browse->BorderColor);
    w4write_att(Browse->row+1,Browse->col,NBorder
                ,Browse->maxcol - Browse->col +1,Browse->BorderColor);
    w4write_att(Browse->row+2,Browse->col,MBorder
                ,Browse->maxcol - Browse->col +1,Browse->BorderColor);
    w4write_att(Browse->maxrow,Browse->col,BBorder
                ,Browse->maxcol - Browse->col +1,Browse->BorderColor);

   w4select(OldWin);
}



void    brow4get(BROW4BROWSE *Browse)
{
    DATA4  *Data;
    BROW4FIELD *Field;
    BROW4RECORD *Record;
    int     len,display_len,count,Ret;
    char    *OldField;
    char    *NewField;
    char    *Picture;
    char    Type;


    if(Browse)
    {
        Data = Browse->data;
        Record = 0;
        for(count =1;count <= Browse->CurrentRecord;count ++)
            Record = (BROW4RECORD *) l4next(&(Browse->records),(void *)Record);
        Field = &(Record->fields[Browse->CurrentField]);
        if(RecordLockAndLoad(Data,Record->recno,0) != r4locked)
        {
            len = Field->field_len;
            display_len = Field->display_len;
            Type = Field->field->type;
            NewField = (char *) u4alloc((len +1)* sizeof(char));
            Picture = (char *) u4alloc((len +1)* sizeof(char));
            OldField = f4str(Field->field);
            memcpy(NewField,OldField,len+1);
            if(Type != 'M')
            {
                switch(Type)
                {
                    case 'N':
                    case 'F':
                        memset(Picture,'9',len);
                        if(Field->field->dec >0)
                            Picture[len - Field->field->dec] = '.';
                        break;
                    case 'L':
                        strcpy(Picture,"L");
                    default:
                        memset(Picture,'X',len);
                }
                g4attribute(Browse->EditColor);
                g4(Browse->CurrentRecord+1,Browse->offsets[Browse->CurrentField] - Browse->CurrentOffset +2
                    ,NewField);
                g4width(len,display_len);
                g4picture(Picture);
                Ret = g4read();
                if(Ret != 27)
                {
                    f4assign(Field->field,NewField);
                    brow4load_record(Record,Browse->offsets);
                }
                brow4update(Browse);
            }
/*            else
            {
                #ifdef EDIT4MAXBUFF
                    edit4memo(Field->field,2,2,12,77," Memo Edit (ESC) to quit (F1) to save ",1,1,F_WHITE|F_INTENSE|B_BLUE,F_WHITE|F_INTENSE|B_BLUE);
                #endif
            }  */
            u4free(NewField);
            u4free(Picture);
        }
    }
}

void    brow4browse(BROW4BROWSE *Browse,int AllowEdits,int ReturnAtOnce)
{
    int Responce = 0;
    int     Ret,OldLockStatus,WaitStatus;
    long    Recno;
    BROW4RECORD    *Record,*Record2;

    if(Browse)
    {
        OldLockStatus = Browse->data->code_base->read_lock;
        Browse->data->code_base->read_lock = 0;
        d4unlock(Browse->data);
        if(Browse->Reload)
            brow4reload(Browse);
        brow4update(Browse);
        if(!ReturnAtOnce)
        {
            while(Responce != ESC)
            {
                Responce = g4char();
                switch(Responce)
                {
                    case DOWN:
                        if(Browse->CurrentRecord == Browse->maxrecords)
                        {
                            Record = (BROW4RECORD *) l4last(&(Browse->records));
                            if(Record->recno == 35)
                                Ret = 1;
                            d4go(Browse->data,Record->recno);
                            Ret = d4skip(Browse->data,1L);
                            d4unlock(Browse->data);
                            if(Ret == r4success)
                            {
                                Record = (BROW4RECORD *) l4first(&(Browse->records));
                                l4remove(&(Browse->records),(void *) Record);
                                Record->recno = -1;
                                brow4load_record(Record,Browse->offsets);
                                Record2 = (BROW4RECORD *) l4last(&(Browse->records));
                                l4add_after(&(Browse->records),(void *) Record2,(void *) Record);
                                brow4update(Browse);
                            }
                        }
                        else
                            Browse->CurrentRecord ++;
                        brow4update(Browse);
                        break;
                    case UP:
                        if(Browse->CurrentRecord == 1)
                        {

                            Record = (BROW4RECORD *) l4first(&(Browse->records));
                            d4go(Browse->data,Record->recno);
                            Ret = d4skip(Browse->data,-1L);
                            d4unlock(Browse->data);
                            if(Ret == r4success)
                            {
                                Record = (BROW4RECORD *) l4last(&(Browse->records));
                                l4remove(&(Browse->records),(void *) Record);
                                Record->recno = -1;
                                brow4load_record(Record,Browse->offsets);
                                Record2 = (BROW4RECORD *) l4first(&(Browse->records));
                                l4add_before(&(Browse->records),(void *) Record2,(void *) Record);

                                brow4update(Browse);
                            }
                        }
                        else
                            Browse->CurrentRecord --;
                        brow4update(Browse);
                        break;

                    case TAB:
                        if(Browse->CurrentField == Browse->num_fields)
                        {
                            Browse->CurrentField = 1;
                            Browse->CurrentOffset = 0;
                            brow4update(Browse);
                            break;
                        }
                    case RIGHT:
                        if(Browse->CurrentField < Browse->num_fields)
                        {
                            Browse->CurrentField ++;
    if(((Browse->offsets[Browse->CurrentField +1]) - Browse->CurrentOffset)
        > (Browse->maxdisplay))
                            {
                                Browse->CurrentOffset =
                                (Browse->offsets[Browse->CurrentField +1])
                                - Browse->maxdisplay -1 ;
                            }
                            brow4update(Browse);
                        }
                        break;
                    case SHIFT_TAB:
                        if(Browse->CurrentField == 1)
                        {
                            Browse->CurrentField = Browse->num_fields;
                            if(Browse->offsets[Browse->num_fields + 1] < (Browse->maxcol - Browse->col - 3))
                            Browse->CurrentOffset =
                                Browse->offsets[Browse->num_fields +1] - Browse->maxdisplay;
                            else
                            Browse->CurrentOffset =
                                Browse->offsets[Browse->num_fields +1] - Browse->maxdisplay -1;
                            Browse->CurrentField = Browse->num_fields;
                            brow4update(Browse);
                            break;
                        }
                    case LEFT:
                        if(Browse->CurrentField > 1)
                        {
                            Browse->CurrentField --;
    if((Browse->offsets[Browse->CurrentField]) < Browse->CurrentOffset)
                            {
                                Browse->CurrentOffset = Browse->offsets[Browse->CurrentField];
                            }
                            brow4update(Browse);
                        }
                        break;
                    case END:
                        Browse->CurrentField = Browse->num_fields;
                        if(Browse->offsets[Browse->num_fields + 1] < (Browse->maxcol - Browse->col - 3))
                        Browse->CurrentOffset =
                            Browse->offsets[Browse->num_fields +1] - Browse->maxdisplay;
                        else
                        Browse->CurrentOffset =
                            Browse->offsets[Browse->num_fields +1] - Browse->maxdisplay -1;


                        brow4update(Browse);
                        break;
                    case HOME:
                        Browse->CurrentField = 1;
                        Browse->CurrentOffset = 0;
                        brow4update(Browse);
                        break;
                    case PGUP:
                        if(Browse->CurrentRecord != 1)
                            Browse->CurrentRecord = 1;
                        else
                        {
                            Record = (BROW4RECORD *) l4first(&(Browse->records));
                            d4go(Browse->data,Record->recno);
                            Recno = (Browse->maxrecords - 1) * -1L;
                            d4skip(Browse->data,Recno);
                            d4unlock(Browse->data);
                            Record = (BROW4RECORD *) l4first(&(Browse->records));
                            while(Record != NULL)
                            {
                                Record->recno = -1;
                                brow4load_record(Record,Browse->offsets);
                                Record = (BROW4RECORD *) l4next(&(Browse->records),(void *)Record);
                                d4skip(Browse->data,1L);
                                d4unlock(Browse->data);
                            }
                        }
                        brow4update(Browse);
                        break;
                    case PGDN:
                        if(Browse->CurrentRecord == Browse->maxrecords)
                        {
                            Record = (BROW4RECORD *) l4last(&(Browse->records));
                            d4go(Browse->data,Record->recno);
                            Recno = Browse->maxrecords;
                            Ret = d4skip(Browse->data,Recno);
                            d4unlock(Browse->data);
                            if(Ret == r4eof)
                                Recno = (Browse->maxrecords +1) * -1L;
                            else
                                Recno = (Browse->maxrecords) * -1L;

                            d4skip(Browse->data,Recno);
                            d4unlock(Browse->data);
                            Record = (BROW4RECORD *) l4first(&(Browse->records));
                            while(Record != NULL)
                            {
                                Record->recno = -1;
                                brow4load_record(Record,Browse->offsets);
                                Record = (BROW4RECORD *) l4next(&(Browse->records),(void *)Record);
                                d4skip(Browse->data,1L);
                                d4unlock(Browse->data);
                            }
                        }
                        Browse->CurrentRecord = Browse->maxrecords;
                        brow4update(Browse);
                        break;
                    case CTRL_HOME:
                        d4top(Browse->data);
                        d4unlock(Browse->data);
                        brow4reload(Browse);
                        Browse->CurrentRecord = 1;
                        brow4update(Browse);
                        break;
                    case CTRL_END:
                        d4bottom(Browse->data);
                        d4unlock(Browse->data);
                        brow4reload(Browse);
                        brow4update(Browse);
                        break;
                    case RETURN:
                        if(AllowEdits)
                            brow4get(Browse);
                        break;
                    case DEL:
                        if(AllowEdits)
                        {
                            d4go(Browse->data,Browse->CurrentRecno);
                            WaitStatus = Browse->data->code_base->lock_attempts;
                            Browse->data->code_base->lock_attempts = -1;
                            Browse->data->code_base->read_lock = 1;
                            if(d4deleted(Browse->data))
                                d4recall(Browse->data);
                            else
                                d4delete(Browse->data);
                            Browse->data->code_base->lock_attempts = WaitStatus;
                            Browse->data->code_base->read_lock = 0;
                            d4unlock(Browse->data);
                            Browse->CurrentRecord = 1;
                            brow4reload(Browse);
                            brow4update(Browse);
                        }
                        break;
                    case INS:
                        if(AllowEdits)
                        {
                            WaitStatus = Browse->data->code_base->lock_attempts;
                            Browse->data->code_base->lock_attempts = -1;
                            Browse->data->code_base->read_lock = 1;
                            d4append_blank(Browse->data);
                            Browse->data->code_base->lock_attempts = WaitStatus;
                            Browse->data->code_base->read_lock = 0;
                            d4unlock(Browse->data);
                            d4bottom(Browse->data);
                            d4unlock(Browse->data);
                            Browse->maxrecords = Browse->maxrow - Browse->row - 3;
                            if(Browse->maxrecords >= d4reccount(Browse->data))
                            {
                                Browse->maxrecords = d4reccount(Browse->data);
                                Record = brow4create_record(Browse->data,Browse->offsets[Browse->num_fields +1],Browse->maxdisplay);
                                l4add(&(Browse->records),(void *) Record);
                            }
                            brow4reload(Browse);
                            brow4update(Browse);
                        }
                        break;
                }
            }
        }
        Browse->data->code_base->read_lock=OldLockStatus;

    }
}

void    brow4resize(BROW4BROWSE **Brow,int row,int col,int maxrow,int maxcol)
{
    long    Border,Normal,SelectedField,SelectedRec,CurrentRecNo,EditColor;
    DATA4  *Data;
    BROW4BROWSE *Browse;
    int     CurrentLockStatus;

    if(*Brow)
    {
        Browse = *Brow;
        Data = Browse->data;
        CurrentLockStatus = Data->code_base->read_lock;
        Data->code_base->read_lock = 0;
        CurrentRecNo = d4recno(Data);
        Border = Browse->BorderColor;
        Normal = Browse->NormalColor;
        SelectedField = Browse->SelectedFieldColor;
        SelectedRec = Browse->SelectedRecColor;
        EditColor = Browse->EditColor;

        brow4free_browse(Browse);
        Browse = brow4define(row,col,maxrow,maxcol);
        brow4attribute(Browse,Border,Normal,SelectedRec,SelectedField,EditColor);
        brow4activate(Data,Browse);
        d4go(Data,CurrentRecNo);
        d4unlock(Data);
        brow4browse(Browse,0,1);
        *Brow = Browse;
        Data->code_base->read_lock = CurrentLockStatus;
    }
}
/***************************************************************************\
\***************************************************************************/
