/* cid_2.c  (c)Copyright Sequiter Software Inc., 1992-1993.  All rights reserved. */

#include    "d4all.h"
#include    "w4.h"
#include    "g4char.h"
#include    "cid.h"

int     mini(int x,int y)
{
        if(x < y)
             return x;
        return y;
}


void  scan_edit(EDIT4MULTI *Edit)
{
   int c1,c2,pos,eoln,lastblank;

   pos = Edit->start;

   for(c1 = 0;c1 < Edit->rows;c1 ++)
   {
        Edit->startpos[c1] = pos;
        c2 = 0;
        eoln = 0;
        lastblank = -1;
        while(!eoln)
        {
           if(Edit->buffer[pos] == ' ')
             lastblank = pos;
           if(pos == Edit->buflen -1)
           {
             Edit->endpos[c1] = pos;
             eoln = 1;
           }
           else if(Edit->buffer[pos] == '\r')
           {
             Edit->endpos[c1] = pos;
             pos ++ ;
             eoln = 1;
           }
           else if( c2 == Edit->cols -1)
           {
             eoln = 1;
             if(Edit->word_wrap)
                if(lastblank > Edit->startpos[c1])
                   pos = lastblank;
             Edit->endpos[c1] = pos;
           }
           c2 ++;
           pos ++;
        }

   }
}

void  display_edit(EDIT4MULTI *Edit)
{
   int c1;
   for(c1 = 0;c1 < Edit->rows; c1 ++)
   {
      w4repeat(c1 ,0,' ',Edit->cols);
      if(Edit->startpos[c1] < Edit->buflen)
      {
         w4write_att(Edit->y + c1 + 1,Edit->x + 1,&(Edit->buffer[Edit->startpos[c1]]),(min(Edit->buflen - 1,Edit->endpos[c1]) - Edit->startpos[c1]) + 1,Edit->text_att);
         if(Edit->buffer[Edit->endpos[c1]] == '\r')
         {
            w4write_att(Edit->y + c1 + 1, Edit->x+ 1  + min(Edit->buflen - 1,Edit->endpos[c1]) - Edit->startpos[c1]," ",1,Edit->text_att);
         }
      }
   }
}

void down_cur(EDIT4MULTI *Edit)
{
   int  pos;

   if(Edit->endpos[Edit->currow] < (Edit->buflen -1))
   {
      Edit->currow ++;
      if(Edit->currow >= Edit->rows)
      {
         Edit->currow = Edit->rows -1;
         Edit->prev_start = Edit->start;
         Edit->start = Edit->startpos[1];
         scan_edit(Edit);
         display_edit(Edit);
      }
      if(Edit->curcol > Edit->endpos[Edit->currow] - Edit->startpos[Edit->currow])
         Edit->curcol = Edit->endpos[Edit->currow] - Edit->startpos[Edit->currow];
   }
   w4cursor(Edit->currow,Edit->curcol);
}

void  insertchar(EDIT4MULTI *Edit,char character,int *pos)
{
    if(character == '\r')
    {
       memmove(&(Edit->buffer[*pos+2]),&(Edit->buffer[*pos]),Edit->buflen - *pos);
       Edit->buffer[*pos] = '\r';
       Edit->buffer[*pos +1] = '\n';
       Edit->buflen += 2;
       (*pos) += 2;

    }
    else
    {
       memmove(&(Edit->buffer[*pos+1]),&(Edit->buffer[*pos]),Edit->buflen - *pos);
       Edit->buffer[*pos] = character;
       Edit->buflen ++;
       (*pos) ++;
    }
}

void  overwritechar(EDIT4MULTI *Edit,char character,int *pos)
{
    if(*pos != Edit->buflen -1)
    {
       if(character == '\r')
       {

       }
       else if(Edit->buffer[*pos]  == '\r')
       {
          memmove(&(Edit->buffer[*pos+1]),&(Edit->buffer[*pos +2 ]),Edit->buflen - *pos);
          Edit->buflen -= 2;
          Edit->buffer[*pos] = character;
       }
       else
       {
          Edit->buffer[*pos] = character;
       }
       (*pos) ++;
    }
}

void  deletechar(EDIT4MULTI *Edit,int *pos)
{
    if(*pos != Edit->buflen -1 )
    {
        if(Edit->buffer[*pos] == '\r')
        {
            memmove(&(Edit->buffer[*pos]),&(Edit->buffer[*pos+2]),Edit->buflen - *pos);
            Edit->buflen -= 2;
        }
        else
        {
            memmove(&(Edit->buffer[*pos]),&(Edit->buffer[*pos+1]),Edit->buflen - *pos);
            Edit->buflen --;
        }
    }
}


int  getpos(EDIT4MULTI *Edit)
{
    int  c1;

    for(c1 = 0;c1 < Edit->currow;) c1 ++;
    return(Edit->startpos[c1] + Edit->curcol);
}

void getcursor(EDIT4MULTI *Edit,int pos)
{
    int c1,c2,*start,*end;

    c1 = 0;
    while(Edit->endpos[c1] < pos)
    {
       c1 ++;
    }
    if(c1 >= Edit->rows)
    {
        Edit->currow = Edit->rows -1;
        down_cur(Edit);
        c1 --;
    }

    Edit->currow = c1;
    for(c2 = (Edit->startpos[c1]);c2 <= (Edit->endpos[c1]);c2 ++)
    {
       if( c2 == pos)
          Edit->curcol = c2 - Edit->startpos[c1];
    }
}
int   find_next_line(EDIT4MULTI *Edit,int start)
{
   int c1,eoln = 0,lastblank;


   c1 = 0;
   while(! eoln)
   {
      if(Edit->buffer[c1+start] == ' ')
        lastblank = c1;
      if(c1+start == Edit->buflen -1)
      {
         eoln = 1;
      }
      else if(Edit->buffer[c1+start] == '\r')
      {
         c1 ++ ;
         eoln = 1;
      }
      else if( c1 == Edit->cols -1)
      {
         eoln = 1;
         if(Edit->word_wrap)
            if(lastblank > 0)
                c1 = lastblank;
      }
      c1 ++;
   }
   return(start + c1);
}


void  scan_prev(EDIT4MULTI *Edit)
{
   int  start,prev_start,c1,c2,eoln,lastblank,endpos,c3;

   if(Edit->start != 0)
   {
      if(Edit->buffer[Edit->start - 2] == '\r' && Edit->start -2 == 0)
        prev_start = 0;
      else
      {
         if(Edit->buffer[Edit->start - 2] == '\r')
            (Edit->start) -= 3;

         c1 = Edit->start;
         c3 = Edit->start;

         while(c1 >= 0 && Edit->buffer[c1] != '\r')
            c1 --;

         if(c1 < 0) c1 = 0;
         if (Edit->buffer[c1] == '\r')
            c1 += 2;

         start = c1;
         prev_start = start;

         while(start < Edit->start)
         {
              prev_start = start;
              start = find_next_line(Edit,start);
         }
      }
      Edit->start = prev_start;
   }
}

void up_cur(EDIT4MULTI *Edit)
{
   int  pos,eoln,c1;


   Edit->currow --;
   if(Edit->currow < 0)
   {
      Edit->currow = 0;
      if(Edit->start != 0)
      {
         scan_prev(Edit);
         scan_edit(Edit);
         display_edit(Edit);
      }
   }
   if(Edit->curcol > Edit->endpos[Edit->currow] - Edit->startpos[Edit->currow])
      Edit->curcol = Edit->endpos[Edit->currow] - Edit->startpos[Edit->currow];

   w4cursor(Edit->currow,Edit->curcol);
}

void right_cur(EDIT4MULTI *Edit)
{
   int  pos;

   pos = getpos(Edit);
   if(pos != Edit->buflen -1)
   {
      Edit->curcol ++;
      if((Edit->endpos[Edit->currow] - Edit->startpos[Edit->currow]) < Edit->curcol)
      {
         Edit->curcol = 0;
         down_cur(Edit);
      }
   }
   w4cursor(Edit->currow,Edit->curcol);
}

void left_cur(EDIT4MULTI *Edit)
{
   int  pos;

   Edit->curcol --;
   if( Edit->curcol < 0)
   {
      Edit->curcol = 100;
      up_cur(Edit);
   }

   w4cursor(Edit->currow,Edit->curcol);
}

void  backspace(EDIT4MULTI *Edit,int *pos)
{
    if(*pos != 0 )
    {
       if(*pos == Edit->start)
          up_cur(Edit);

       if(Edit->buffer[*pos -2] == '\r' )// && Edit->buffer[*pos -1] == '\n'
       {
          memmove(&(Edit->buffer[*pos -2]),&(Edit->buffer[*pos]),Edit->buflen - *pos);
          Edit->buflen -= 2;
          (*pos) -= 2;
       }
       else
       {
          memmove(&(Edit->buffer[*pos -1]),&(Edit->buffer[*pos]),Edit->buflen - *pos);
          Edit->buflen --;
          (*pos) --;
       }
   }
}

int  edit4(char *buffer,int *buffsize,int maxbuff,int y1,int x1,int y2,int x2,char *title
           ,int allow_edits,int word_wrap,long text_att,long bord_att)
{
    int win,entry,pos,c1;
    EDIT4MULTI  Edit;

    Edit.allow_edits = allow_edits;
    Edit.word_wrap = word_wrap;
    Edit.insert = 1;
    Edit.maxbuf = maxbuff;

  //  memset(Edit.buffer,'\0',maxbuff);
    Edit.buffer = buffer;

    /* Add blank to end of buffer */
    Edit.buflen = *buffsize + 1;
    Edit.buffer[Edit.buflen -1] = ' ';

    Edit.text_att = text_att;
    Edit.x = x1;
    Edit.y = y1;
    Edit.start = 0;
    Edit.rows = y2 - y1 -1;
    Edit.cols = x2 - x1 -1;
    Edit.startpos = (int *) u4alloc(Edit.rows * sizeof(int));
    Edit.endpos = (int *) u4alloc(Edit.rows * sizeof(int));

    win = w4define(y1,x1,y2,x2);
    w4popup();
    w4border(SINGLE,bord_att);
    w4title(0,5,title,bord_att);
    w4attribute( text_att);
    w4activate(win);

    scan_edit(&Edit);
    display_edit(&Edit);

    Edit.insert = 1;
    w4cursor(0,0);
    Edit.currow = 0;
    Edit.curcol = 0;
    entry = 0;
    while(entry != ESC && entry != F1)
    {
       entry = g4char();
       switch(entry)
       {
          case HOME :
             Edit.curcol = 0;
             w4cursor(Edit.currow,Edit.curcol);
             break;
          case END :
             Edit.curcol = (Edit.endpos[Edit.currow] - Edit.startpos[Edit.currow]);
             w4cursor(Edit.currow,Edit.curcol);
             break;
          case RIGHT :
             right_cur(&Edit);
             break;
          case DOWN :
             down_cur(&Edit);
             break;
          case LEFT:
             left_cur(&Edit);
             break;
          case UP:
             up_cur(&Edit);
             break;
          case INS:
             if(Edit.allow_edits)
             {
                Edit.insert = !(Edit.insert);
                if(Edit.insert)
                {
                   w4cursor_size(7,7);
                }
                else
                   w4cursor_size(1,7);
             }
             break;
          case PGDN :
             for(c1 = 1; c1 < Edit.rows;c1 ++)
                down_cur(&Edit);
             break;
          case PGUP :
             for(c1 = 1; c1 < Edit.rows;c1 ++)
                up_cur(&Edit);
             break;
          case DEL:
             if(Edit.allow_edits)
             {
                pos = getpos(&Edit);
                deletechar(&Edit,&pos);
                scan_edit(&Edit);
                display_edit(&Edit);
                getcursor(&Edit,pos);
                w4cursor(Edit.currow,Edit.curcol);
             }
             break;
          case BACK_SPACE:
             if(Edit.allow_edits)
             {
                pos = getpos(&Edit);
                backspace(&Edit,&pos);
                scan_edit(&Edit);
                display_edit(&Edit);
                getcursor(&Edit,pos);
                w4cursor(Edit.currow,Edit.curcol);
             }
             break;
          case F1 :
             break;

          default:
             if(Edit.allow_edits)
             {
                pos = getpos(&Edit);
                if(Edit.insert)
                {
                   insertchar(&Edit,(char)entry,&pos);
                }
                else
                {
                   overwritechar(&Edit,(char)entry,&pos);
                }
                scan_edit(&Edit);
                display_edit(&Edit);
                getcursor(&Edit,pos);
                w4cursor(Edit.currow,Edit.curcol);
             }
             break;
       }

    }
    *buffsize = Edit.buflen -1;
    u4free(Edit.startpos);
    u4free(Edit.endpos);
    w4cursor_size(7,7);
    w4deactivate(win);
    w4close(win);
    return entry;

}

void   edit4memo(FIELD4 *memo,int y1,int x1,int y2,int x2,char *title
           ,int allow_edits,int word_wrap,long text_att,long bord_att)
{
    int buflen,rc;
    unsigned bufmax;
    char *ptr,buffer[EDIT4MAXBUFF];

    if(!memo)
       return -1;
    if(f4type(memo) != r4memo)
       return -1;

    buflen = f4memo_len(memo);
    bufmax = EDIT4MAXBUFF ;
    ptr = f4memo_str(memo);

    u4ncpy(buffer,ptr,mini(buflen,bufmax));
    rc = edit4(buffer,&buflen,bufmax,y1,x1,y2,x2,title,allow_edits,word_wrap,text_att,bord_att);
    if(rc == F1 )
       f4memo_assign_n(memo,buffer,buflen);

    u4free(buffer);
}
