#include "d4all.h"
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

REPORT4 *report = NULL;
CODE4   cb;

void cleanup( void );
void show_parms( void );
void launch_error( char *, char * );

void main( int argc, char **argv)
{
   int out_code = 1, use_codes = 0, p_height = 25, p_width = 80, i;
   char *sort_expr = NULL, *query_expr = NULL, *dest = NULL, *fname = NULL;
   int len;

   /* routine must have at least a file name */
   if(argc < 2)
   {
      show_parms();
      return;
   }

   /* initialize CODE4 structure */
   d4init(&cb);
   cb.auto_open = 0;


   if(argv[1][0] == '-')
   {
      launch_error( "The first parameter must be a file name.", NULL );      
      cleanup();
      return;
   }

   /* open the specified report file */
   len = strlen(argv[1]);
   fname = (char *) u4alloc_free( &cb, len + 6 );
   u4ncpy( fname, argv[1], len + 1 );
   u4name_ext( fname, len + 6, ".rep", 0 );
   report = report4retrieve( &cb, fname, 1 );

   if( report == NULL )
   {
      launch_error("Unable to retrieve report file:",fname);
      cleanup();
      return;
   }

   d4opt_start( &cb );


   /* parse the command line arguments */
   for(i = 2; i < argc; i++)
   {
      if(argv[i][0] == '-')
      {
         switch( argv[i][1] )
         {
            case 'q':
               i++;
               len = strlen(argv[i]);
               query_expr = (char *)u4alloc_free( &cb, len + 1 );
               if( ! query_expr )
                  break;
               u4ncpy( query_expr, argv[i], len+1 );
               break;

            case 's':
               i++;
               len = strlen(argv[i]);
               sort_expr = (char *)u4alloc_free( &cb, len + 1  );
               if( ! sort_expr )
                  break;
               u4ncpy( sort_expr, argv[i], len+1 );
               break;

            case 'x':
               p_width = atoi(argv[i]+2);
               break;

            case 'y':
               p_height = atoi(argv[i]+2);
               break;

            case 'p':
               if( p_height == 25 )
                  p_height = 65;
               len = strlen( argv[i] );
               if( len == 2)
               {
                  out_code = 4;
               }
               else
               {
                  dest = u4alloc_er( &cb, len + 1 );
                  if( dest == NULL )
                     return;
                  u4ncpy( dest, argv[i] + 2, len + 1 );

                  out_code = 0;
                  if((out_code = open( dest, O_CREAT | O_BINARY | O_RDWR, S_IWRITE )) == -1)
                  {
                     printf("Unable to open output file %s.\n",dest);
                     out_code = -1;
                     break;
                  }
               }
               break;

            case 't':
               use_codes = 1;
               break;


         }
      }
      else
      {
         launch_error("Unknown argument:",argv[i]);
      }
   }

   if(out_code == -1)
   {
      cleanup();
      return;
   }

   /* set the new query expression */
   if( query_expr )
      if( relate4query_set( report->relate, query_expr) < 0 )
      {
         cleanup();
         return;
      }

   /* set the new sort expression */
   if( sort_expr )
      if( relate4sort_set ( report->relate, sort_expr) < 0 )
      {
         cleanup();
         return;
      }

   if(out_code == 1)
      use_codes = 0;

   report4output( report, out_code, NULL, use_codes );

   report4page_size( report, p_width, p_height );

   
   report4do(report);

   cleanup();

}


void cleanup( void )
{
   if( report )
      report4free( report, 1, 1 );

   d4init_undo( &cb );

   return;
}


void launch_error( char *message, char *parm )
{
   printf("\nLaunch utility error:\n");
   printf("\n\t%s ",message);

   ( parm ) ? printf("%s\n",parm) : printf("\n");

   return;
}


void show_parms( void )
{

   printf("Usage: launch_d <filename> [-q<expr>][-s<expr>][-x<nn>][-p[dest]][-t]\n");
   printf("\n");
   printf("Options:\n\n");
   printf("-q<expr>  Change the default query expression. Query expressions\n");
   printf("          must be entered in double quotes. String literals within\n");
   printf("          the expression must be entered in single quotes.\n");
   printf("-s<expr>  Change the default sort expression. Sort expressions\n");
   printf("          must be entered in double quotes. String literals within\n");
   printf("          the expression must be entered in single quotes.\n");
   printf("-x<nn>    Change the default horizontal size of the page ( in \n");
   printf("          characters ). The default number of characters is 80.\n");
   printf("-y<nn>    Change the default vertical size of the page (in lines ).\n");
   printf("          The default number of lines is 25.\n");
   printf("-p[dest]  Change the default print destination. Reports by default\n");
   printf("          go to the monitor. Specifying the -p option alone sends\n");
   printf("          output to \'standart print\'. If a character string is\n");
   printf("          specified, output is directed to a file or device with the\n");
   printf("          specified name.\n");
   printf("-t        Use the Non-Windows printer codes stored in the report. By\n");
   printf("          default the printer codes are not used.\n");
   return;
}


