/***********************************************************************\
*                                                                       *
*   APPEND.C       Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

CODE4 cb ;
DATA4 *data_from, *data_to ;
FIELD4 *info_from, *info_to ;

void main()
{
   int rc1, rc2, rc ;

   d4init( &cb ) ;

   cb.optimize = 1 ;
   cb.optimize_write = 1 ;

   data_from = d4open( &cb, "data1.DBF" ) ;
   data_to = d4open( &cb, "new.DBF" ) ;
   e4exit_test( &cb ) ;

   d4opt_start( &cb ) ;

   info_from =  d4field( data_from, "INFO" ) ;
   info_to =  d4field( data_to, "INFO" ) ;

   cb.lock_attempts = 1 ;
   rc1 = d4lock_file( data_from ) ;
   rc2 = d4lock_file( data_to ) ;
   if( rc1 != 0 || rc2 != 0 )
   {
      printf( "Locking Failed\n" ) ;
      exit(0) ;
   }
      
   for( rc = d4top(data_from); rc == 0
                ; rc = d4skip(data_from,1) )
   {
      d4append_start( data_to, 0 ) ;
      f4assign_field( info_to, info_from ) ;
      d4append( data_to ) ;
   }

   d4unlock( data_from ) ;
   d4unlock( data_to ) ;

   d4close_all( &cb ) ;
}


