/* d4exampl.c (c)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */

#include "d4all.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000 ;
#endif

extern void verify_switches(void) ;

FIELD4INFO field_info[] =
{
   { "TEST_FIELD",'C',20,0 },
   { 0,0,0,0 },
};

void main()
{
   int rc ;
   CODE4 cb ;

   verify_switches() ;
   printf( "\nSwitches Verified Successfully!\n" ) ;

   d4init( &cb ) ;

   cb.open_error = 0 ;
   if( d4open( &cb, "TEST.DBF" ) != 0 )
      printf( "\nTEST.DBF Opened\n" ) ;
   else
   {
      if( d4create(&cb,"TEST.DBF",field_info,0) != 0 )
	 printf("\nTEST.DBF Created\n") ;
   }
}

void verify_switches()
{
   #if S4VERSION != 5001
      #error Your CodeBase source version does not match your header file version.
   #endif

   long d4switch ;

   d4switch = u4switch() ;

   printf( "\n\nLibrary Conditional Compilation Switches:\n" ) ;
   if( d4switch & 1 )
      printf( "S4FOX - FoxPro Index File Compatibility\n" ) ;
   if( d4switch & 2 )
      printf( "S4CLIPPER - Clipper Index File Compatibility\n" ) ;
   if( d4switch & 4 )
      printf( "S4MDX - dBASE IV Index File Compatibility\n" ) ;
   if( d4switch & 8 )
      printf( "S4NDX - dBASE III or III PLUS Index File Compatibility\n" ) ;
   if( d4switch & 0x10 )
      printf( "S4DLL - Microsoft Windows DLL (S4DLL_BUILD on Library Build)\n" ) ;
   if( d4switch & 0x20 )
      printf( "S4WINDOWS - Microsoft Windows Static with Static Library\n" ) ;
   if( d4switch & 0x40 )
      printf( "S4OS2 - OS/2\n" ) ;
   if( d4switch & 0x40 )
      printf( "S4CODE_SCREENS - CodeScreens output Functions\n" ) ;
   if( d4switch & 0x100 ) 
      printf( "S4DEBUG - Extensive CodeBase Error Checking\n" ) ;
   if( d4switch & 0x200 )
      printf( "S4ERROR_HOOK - Custom Error Function\n" ) ;
   if( d4switch & 0x400 )
      printf( "\nS4LOCK_CHECK - Internal CodeBase Locking Diagnostics\n" ) ;
   if( d4switch & 0x800 )
      printf( "\nS4LOCK_HOOK - Custom Lock Failure Function\n" ) ;
   if( d4switch & 0x1000 )
      printf( "\nS4MAX - Maximum Memory Allocation Testing\n" ) ;
   if( d4switch & 0x2000 )
      printf( "\nS4MEMO_OFF - Memo File support source code removed\n" ) ;
   if( d4switch & 0x4000 )
      printf( "\nS4OLD_CODE - Support Functions from CodeBase 4.5\n" ) ;
   if( d4switch & 0x8000 )
      printf( "\nS4OPTIMIZE_OFF - Memory Optimization source code removed\n" ) ;
   if( d4switch & 0x10000 )
      printf( "\nS4PORTABLE - Maximum Portability\n" ) ;
   if( d4switch & 0x20000 )
      printf( "\nS4SAFE  - Immediate File Length Updates\n" ) ;
   if( d4switch & 0x40000 )
      printf( "\nS4SINGLE  - Multi-user support source code removed\n" ) ;

   #ifdef S4OPTIMIZE_OFF
      if( (d4switch & 0x10000)  ==  0 )
	 e4severe( e4result, "S4OPTIMIZE_OFF must be used in Library Build too.\n" ) ;
   #else
      if( d4switch & 0x10000  )
	 e4severe( e4result, "S4OPTIMIZE_OFF must be off in Library Build too.\n" ) ;
   #endif

   #ifdef S4FOX
      if( (d4switch & 1)  == 0 )
	 e4severe( e4result, "S4FOX must be used in Library Build too.\n" ) ;
   #endif

   #ifdef S4CLIPPER
      if( (d4switch & 2)  == 0 )
	 e4severe( e4result, "S4CLIPPER must be used in Library Build too.\n" ) ;
   #endif

   #ifdef S4MDX
      if( (d4switch & 4)  == 0 )
	 e4severe( e4result, "S4MDX must be used in Library Build too.\n" ) ;
   #endif

   #ifdef S4NDX
      if( (d4switch & 8)  == 0 )
	 e4severe( e4result, "S4NDX must be used in Library Build too.\n" ) ;
   #endif
}
