/***********************************************************************\
*                                                                       *
*   DATAINFO.C    Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

int main(int argc,char *argv[])
{

   CODE4    code_base;
   DATA4    *data_file;
   FIELD4   *field_ref;

   int      j,num_fields;
   int      len,dec;
   int      rec_width;
   char     *name;
   char     type;
   char     *alias;
   long     rec_count;

   if(argc != 2)
   { 
      printf(" USAGE: FLDINFO <FILENAME.DBF> \n");
      exit(0); 
   }

   d4init(&code_base);

   data_file = d4open(&code_base,argv[1]);
   e4exit_test(&code_base);


   rec_count = d4reccount(data_file);
   num_fields = d4num_fields(data_file);
   rec_width = d4record_width(data_file);
   alias = d4alias(data_file);

   printf("ͻ\n");
   printf(" Data File: %12s         \n",argv[1]);
   printf(" Alias    : %12s         \n",alias);
   printf("                                 \n");
   printf(" Number of Records: %7ld      \n",rec_count);
   printf(" Length of Record : %7d      \n",rec_width);
   printf(" Number of Fields : %7d      \n",num_fields);
   printf("                                 \n");
   printf(" Field Information :             \n");
   printf("͹\n");
   printf(" Name        type  len   dec  \n");
   printf("͹\n");



   for(j = 1;j < d4num_fields(data_file);j ++)
   {
      field_ref = d4field_j(data_file,j);
      name = f4name(field_ref);
      type = f4type(field_ref);
      len = f4len(field_ref);
      dec = f4decimals(field_ref);

      printf(" %10s    %c   %4d  %4d \n",name,type,len,dec);

   }
   printf("ͼ\n");


   d4close(data_file);

   return 0;
}