/***********************************************************************\
*                                                                       *
*   DELETION.C     Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

CODE4       code_base;
DATA4       *data_file = 0;
FIELD4INFO  field_info[]=
{
    {"DUMMY",'C',10,0},
    {"MEMO",'M',10,0},
    {0,0,0,0},
};

void print_delete_status(int status,long rec_no)
{
    if(status)
        printf("Record %5ld - DELETED\n",rec_no);
    else
        printf("Record %5ld - NOT DELETED\n"
                                    ,rec_no);
}

void print_records(DATA4 *data_file)
{
    int  rc,status;
    long rec_no;

    printf("\n");

    rc = d4top(data_file);
    while(rc != r4eof)
    {
        rec_no = d4recno(data_file);
        status = d4deleted(data_file);
        print_delete_status(status,rec_no);
        rc = d4skip(data_file,1L);
    }

}

void main( void )
{
    int count;

    d4init(&code_base);
    data_file = d4create(&code_base,"TUTOR5"
                                   ,field_info,0);
    e4exit_test(&code_base);

    for(count = 0;count < 4;count ++)
        d4append_blank(data_file);


    print_records(data_file);

    d4go(data_file,3L);
    d4delete(data_file);
    d4go(data_file,1L);
    d4delete(data_file);
    print_records(data_file);

    d4go(data_file,3L);
    d4recall(data_file);
    print_records(data_file);

    d4pack(data_file);
    d4memo_compress(data_file);
    print_records(data_file);
   
}
