/* filetest.c  (c)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */
#include "d4all.h"

#define MAX_PATH  80

extern unsigned _stklen = 10000;

void main( int argc, char **argv )
{
    CODE4 c4;
    DATA4 *d4;
    INDEX4 *i4 ;
    int rc;
    char database[MAX_PATH], index[MAX_PATH] ;

    system( "cls" ) ;

    #ifdef N4OTHER
       #ifdef S4NDX
          #define format "DBASE III"
       #else   /* ifdef S4CLIPPER */
          #define format "CLIPPER"
       #endif
    #else
       #ifdef S4MDX
          #define format "DBASE IV"
       #else   /* ifdef S4FOX */
          #define format "FOXPRO"
       #endif
    #endif

    printf("    DATABASE AND INDEX CORRUPTION FILE CHECK: %s\n", format ) ;
    printf("    --------------------------------------------------\n\n\n" ) ;

    if (argc == 1)
    {
       printf("* * ERROR * * SPECIFY NAME:(eg) filetest <filename> [<indexname>]\n\n" ) ;
       exit(0) ;
    }

    d4init(&c4);
    c4.auto_open = 0 ;

    strcpy( database, argv[1] ) ;

    if ( argc > 2 )
       strcpy( index, argv[2] ) ;
    else
       u4name_piece( index, MAX_PATH, database, 1, 0 ) ;

    c4upper( database ) ;
    d4 = d4open(&c4, database ) ;
    if ( d4 == 0 )  
    {
       printf("ERROR OPENING DATA FILE:  %s\n", database ) ;
       printf("\n\n   --------------  END  --------------\n" ) ;
       exit(0) ;
    }

    printf("DATAFILE OPENED:  %s\n", d4->file.name ) ;

    c4upper( index ) ;
    i4 = i4open(d4, index ) ;
    if ( i4 == 0 )
    {
       printf("ERROR OPENING INDEX FILE:  %s\n", index ) ;
       printf("\n\n   --------------  END  --------------\n" ) ;
       exit(0) ;
    }
 
    printf("INDEX OPENED:  %s\n", i4->file.name ) ;

    printf( "\nCHECKING FILES, PLEASE WAIT . . .\n" ) ;
    rc = d4check(d4);

    if (!rc)  printf( "\nFINISHED CHECKING FILES:    OK \n" ) ;
    else  printf( "\n\nFINISHED CHECKING FILES:  ERROR ,%s, %s \n", d4->file.name, i4->file.name ) ;
       
    printf("\n\n   --------------  END  --------------\n" ) ;

    d4close(d4);
    d4init_undo(&c4);
}
