/* t4stats.c   (c)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */

#include "d4all.h"
#ifndef S4UNIX
   #ifdef __TURBOC__
      #pragma hdrstop
   #endif
#endif

/* determines statistics about the given tag - puts into a pointer called s4 */
/* stats are:  # entries in the tag
               tag fragmentation
               tag balance
               # of leaf and branch blocks
               efficiency
               min and maximum height of the tag
*/

void S4FUNCTION t4stats( TAG4 *t4, TAG4STATS *s4 )
{
   B4BLOCK *current ;
   long unused = 0 ;   /* free bytes in the index file */
   int rc, height = 0 ;
   long total_height = 0L ;
   char done = 0 ;
   #ifndef S4FOX
      long prev_leaf_fb = 0 ;
   #endif

   #ifndef S4SINGLE
      rc = i4lock( t4->index ) ;
      if ( rc )
         return ;
   #endif

   memset( s4, 0, sizeof( TAG4STATS ) ) ;
   s4->min_keys = 0xFFFF ; /* largest possible value */

   for ( t4top( t4 ) ; t4up( t4 ) == 0 ; ) ;
   t4down( t4 ) ; height++ ;

   while ( !done )
   {
      current = (B4BLOCK *)l4last( &t4->blocks ) ;
      #ifdef S4DEBUG
         if ( current == 0 )
            e4severe( e4info, E4_INFO_ACC ) ;
      #endif
      if ( b4leaf( current ) )
      {
         s4->num_leafs++ ;
         #ifdef S4FOX
            if ( current->header.right_node == current->file_block + B4BLOCK_SIZE )
               s4->sequential_leafs++ ;
            s4->count += current->header.n_keys ;
            if ( current->header.n_keys > s4->max_keys )
               s4->max_keys = current->header.n_keys ;
            if ( current->header.n_keys < s4->min_keys )
               s4->min_keys = current->header.n_keys ;
            unused += current->node_hdr.free_space ;
         #endif
         #ifdef N4OTHER
            if ( prev_leaf_fb == current->file_block - B4BLOCK_SIZE )
               s4->sequential_leafs++ ;
            prev_leaf_fb = current->file_block ;
            s4->count += current->n_keys ;
            if ( current->n_keys > s4->max_keys )
               s4->max_keys = current->n_keys ;
            if ( current->n_keys < s4->min_keys )
               s4->min_keys = current->n_keys ;
            unused += ( B4BLOCK_SIZE - sizeof( short) - 6 * sizeof( char ) - ( (current->n_keys) * (t4->header.key_len + 2*sizeof( long ) ) ) ) ;
         #endif
         #ifdef S4MDX
            if ( prev_leaf_fb == current->file_block - t4->index->header.block_rw )
               s4->sequential_leafs++ ;
            prev_leaf_fb = current->file_block ;
            s4->count += current->n_keys ;
            if ( current->n_keys > s4->max_keys )
               s4->max_keys = current->n_keys ;
            if ( current->n_keys < s4->min_keys )
               s4->min_keys = current->n_keys ;
            unused += ( t4->index->header.block_rw - sizeof( short) - 6 * sizeof( char ) - ( (current->n_keys) * (t4->header.key_len + 2*sizeof( long ) ) ) ) ;
         #endif
         if ( height > s4->max_height )
            s4->max_height = height ;
         total_height += height ;
         for( ;; )
         {
            t4up( t4 ) ; height-- ;
            current = (B4BLOCK *)l4last( &t4->blocks ) ;
            if ( current == 0 )
            {
               done = 1 ;
               break ;
            }

            if ( current == l4first( &t4->blocks ) )
            #ifdef S4FOX
               if ( current->key_on + 1 >= current->header.n_keys )
            #else
               if ( current->key_on + 1 >= current->n_keys )
            #endif
               {
                  done = 1 ;
                  break ;
               }

            if ( b4skip( (B4BLOCK *)l4last( &t4->blocks), 1L ) == 1L )
            {
               for ( ; t4down( t4 ) == 0 ; height++ ) ;
               break ;
            }
         }
      }
      else
      {
         s4->num_branches++ ;
         #ifdef S4FOX
            unused += ( B4BLOCK_SIZE - sizeof( B4STD_HEADER) - ( (current->header.n_keys) * (t4->header.key_len + 2*sizeof( long ) ) ) ) ;
         #endif
         #ifdef S4NDX
            unused += ( B4BLOCK_SIZE - sizeof( short ) - 2 * sizeof( char ) - ( (current->n_keys) * (t4->header.group_len ) ) ) ;
         #endif
         #ifdef S4CLIPPER
            unused += ( B4BLOCK_SIZE - sizeof( short ) - ( (current->n_keys) * ( t4->header.group_len + sizeof( short ) ) ) ) ;
         #endif
         #ifdef S4MDX
            unused += ( t4->index->header.block_rw - sizeof( short ) - 6 * sizeof( char ) - ( (current->n_keys) * ( t4->header.group_len ) ) ) ;
         #endif
         t4down( t4 ) ; height++ ;
      }
   }

   s4->avg_keys = s4->count / s4->num_leafs ;
   s4->avg_height = (unsigned) ((double)total_height / (double)s4->num_leafs) ;
   #ifdef S4FOX
      s4->utilization = (double)unused / (double)( (s4->num_leafs + s4->num_branches) * B4BLOCK_SIZE ) ;
      s4->efficiency = (double)( s4->count * t4->header.key_len ) / (double)( (s4->num_leafs + s4->num_branches) * B4BLOCK_SIZE ) ;
   #endif
   #ifdef N4OTHER
      s4->utilization = (double)unused / (double)( (s4->num_leafs + s4->num_branches) * B4BLOCK_SIZE ) ;
      s4->efficiency = (double)( s4->count * t4->header.key_len ) / (double)( (s4->num_leafs + s4->num_branches) * B4BLOCK_SIZE ) ;
   #endif
   #ifdef S4MDX
      s4->utilization = (double)unused / (double)( (s4->num_leafs + s4->num_branches) * t4->index->header.block_rw ) ;
      s4->efficiency = (double)( s4->count * t4->header.key_len ) / (double)( (s4->num_leafs + s4->num_branches) * t4->index->header.block_rw ) ;
   #endif
   s4->distribution = (double)s4->num_branches / (double)( s4->num_leafs + s4->num_branches ) ;
}
