/***********************************************************************\
*                                                                       *
*   LIST1.C    Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

typedef struct
{
   LINK4   link;
   int     age;
}AGES;

void print_list(LIST4 *);

void main( void )
{

   LIST4   age_list;
   AGES    first_age,middle_age,last_age;

   memset(&age_list,NULL,sizeof(age_list));

   first_age.age = 3;
   middle_age.age = 5;
   last_age.age = 7;

   l4add(&age_list,&middle_age);
   l4add_before(&age_list,&middle_age,&first_age);
   l4add_after(&age_list,&middle_age,&last_age);

   print_list(&age_list);

   l4remove(&age_list,(void *) &middle_age);

   print_list(&age_list);

   l4pop(&age_list);

   print_list(&age_list);
}

void print_list(LIST4 *list)
{
   AGES    *age_ptr;

   printf("\nThere are %d links\n",list->n_link);

   age_ptr =(AGES *) l4first(list);
   while(age_ptr != NULL)
   {
      printf("%d\n",age_ptr->age);
      age_ptr = (AGES *) l4next(list,age_ptr);
   }

   age_ptr = (AGES *) list->selected;
}
