/***********************************************************************\
*                                                                       *
*   MULTI.C       Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

CODE4 cb ;
FIELD4 *field_name ;
DATA4 *data_names ;
TAG4 *tag_name ;

void add_record(),find_record(), modify_record()
                                   , list_data() ;

void main()
{
   d4init( &cb ) ;

   cb.exclusive = 0 ;
   cb.read_only = 0 ;
   cb.read_lock = 0 ;
   cb.lock_attempts = -1 ;

   data_names = d4open( &cb, "DATA1" ) ;
   e4exit_test( &cb ) ;

   field_name = d4field( data_names, "F_NAME" ) ;
   tag_name = d4tag( data_names, "NAME" ) ;

   d4top( data_names ) ;

   for(;;)
   {
      e4set( &cb, 0 ) ;

      printf( "\n\nRecord #: %ld   Name: %s\n" 
              ,d4recno( data_names )
              , f4str( field_name ) ) ;

      printf( "Enter Command ('a','f','l','m' or                                      'x')\n" ) ;

      int command =  getchar() ;
      switch( command )
      {
         case 'a':
            add_record() ;
            break ;

         case 'f':
            find_record() ;
            break ;

         case 'l':
            list_data() ;
            break ;

         case 'm':
            modify_record() ;
            break ;

         case 'x':
            d4close_all( &cb ) ;
            exit(0) ;
      }
   }
}

void add_record()
{
   char buf[100] ;
   printf( "Enter New Record\n" ) ;
   scanf( "%s", buf ) ;

   d4append_start( data_names, 0 ) ;
   f4assign( field_name, buf ) ;
   d4append( data_names ) ;

   d4unlock( data_names ) ;
}

void find_record()
{
   char buf[100] ;
   printf( "Enter Name to Find\n" ) ;
   scanf( "%s", buf ) ;

   d4tag_select( data_names, tag_name ) ;
   d4seek( data_names, buf ) ;
}

void modify_record()
{
   char buf[100] ;
   printf( "Enter Replacement Record\n" ) ;
   scanf( "%s", buf ) ;

   f4assign( field_name, buf ) ;

   d4flush( data_names ) ;
   d4unlock( data_names ) ;
}

void list_data()
{
   d4opt_start( &cb ) ;
   d4optimize( data_names, 1 ) ;

   d4tag_select( data_names, tag_name ) ;

   for( d4top(data_names); ! d4eof(data_names)
                          ; d4skip(data_names,1) )
      printf( "%ld %s\n", d4recno(data_names)
                           , f4str(field_name) ) ;

   d4optimize( data_names, 0 ) ;
   d4opt_suspend( &cb ) ;
}
