/***********************************************************************\
*                                                                       *
*   NEWLIST.C     Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

   CODE4    code_base;
   DATA4    *data_file = 0;
   FIELD4   *f_name,*l_name,*address,*age,*birth_date,*married ,*amount,*comment;


   FIELD4INFO  field_info [] =
   {
      {"F_NAME",r4str,10,0},      
      {"L_NAME",r4str,10,0},
      {"ADDRESS",r4str,15,0},
      {"AGE",r4num,2,0},          
      {"BIRTH_DATE",r4date,8,0},
      {"MARRIED",r4log,1,0},      
      {"AMOUNT",r4num,7,2},
      {"COMMENT",r4memo,10,0},    
      {0,0,0,0},
   };


void  OpenDataFile( void )
{
   data_file = d4open(&code_base,"DATA1.DBF");
   if(data_file == NULL)
      data_file = d4create(&code_base,"DATA1.DBF",field_info,0);

   f_name = d4field(data_file,"F_NAME");
   l_name = d4field(data_file,"L_NAME");
   address = d4field(data_file,"ADDRESS");
   age = d4field(data_file,"AGE");
   birth_date = d4field(data_file,"BIRTH_DATE");
   married = d4field(data_file,"MARRIED");
   amount = d4field(data_file,"AMOUNT");
   comment = d4field(data_file,"COMMENT");

}

void PrintRecords( void )
{

   int      rc,j,age_value;
   double   amount_value;
   char     name_str[25];
   char     address_str[20];
   char     date_str[9];
   char     married_str[2];
   char     *comment_str;

   for(rc = d4top(data_file);rc == r4success
                      ;rc = d4skip(data_file, 1L))
   {
      u4ncpy(name_str,f4str(f_name)
                             ,sizeof(name_str));
      u4ncpy(address_str,f4str(address)
                           ,sizeof(address_str));
      age_value = f4int(age);
      amount_value = f4double(amount);
 
      u4ncpy(date_str,f4str(birth_date)
                              ,sizeof(date_str));
      u4ncpy(married_str,f4str(married),
                            sizeof(married_str));
      comment_str = f4memo_str(comment);

      printf("------------------------------\n");
      printf("Name     : %20s\n",name_str);
      printf("Address  : %15s\n",address_str);
      printf("Age : %3d   Married : %1s\n"
                          ,age_value,married_str);
      printf("Comment: %s\n",comment_str);
      printf("Purchased this year : $%5.2lf \n"
                                   ,amount_value);

      printf("\n");
   }
}


void AddNewRecord(char *f_name_str
                 ,char*l_name_str
                 ,char *address_str
                 ,int age_value
                 ,int married_value
                 ,double amount_value
                 ,char *comment_str)
{

   d4append_start(data_file,0);

   f4assign(f_name,f_name_str);
   f4assign(l_name,l_name_str);
   f4assign(address,address_str);

   f4assign_int(age,age_value);

   if(married_value)
      f4assign(married,"T");
   else
      f4assign(married,"F");

   f4assign_double(amount,amount_value);
   f4memo_assign(comment,comment_str);

   d4append(data_file);
}



int main( void )
{

   d4init(&code_base);
   code_base.open_error = 0;
   code_base.safety = 0;

   OpenDataFile();

   PrintRecords();

   AddNewRecord("Sarah"
               ,"Webber"
               ,"132-43 St."
               ,32
               ,1
               ,147.99
               ,"New Customer");

   AddNewRecord("John"
               ,"Albridge"
               ,"1232-76 Ave."
               ,12
               ,0
               ,98.99
               ,0);

   PrintRecords();

   d4close_all(&code_base);
   return 0;
}


