/***********************************************************************\
*                                                                       *
*   NEWLIST2.C    Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

CODE4    code_base;
DATA4    *data_file;
FIELD4   *f_name,*l_name,*address,*age,*birth_date
                       ,*married,*amount,*comment;
TAG4     *name_tag,*age_tag,*amount_tag;

FIELD4INFO  field_info [] =
{
   {"F_NAME",r4str,10,0},
   {"L_NAME",r4str,10,0},
   {"ADDRESS",r4str,15,0},
   {"AGE",r4num,2,0},          
   {"BIRTH_DATE",r4date,8,0},  
   {"MARRIED",r4log,1,0},      
   {"AMOUNT",r4num,7,2},
   {"COMMENT",r4memo,10,0},    
   {0,0,0,0},
};

TAG4INFO  tag_info[] =
{
   {"NAME_TAG","F_NAME + L_NAME",0,0,0},
   {"AGE_TAG","AGE",0,0,0},
   {"AMNT_TAG","AMOUNT",0,0,0},
   {0,0,0,0,0},
};

void  CreateDataFile( void )
{

   data_file = d4create(&code_base,"DATA1.DBF"
                            ,field_info,tag_info);

   f_name = d4field(data_file,"F_NAME");
   l_name = d4field(data_file,"L_NAME");
   address = d4field(data_file,"ADDRESS");
   age = d4field(data_file,"AGE");
   birth_date = d4field(data_file,"BIRTH_DATE");
   married = d4field(data_file,"MARRIED");
   amount = d4field(data_file,"AMOUNT");
   comment = d4field(data_file,"COMMENT");

   name_tag = d4tag(data_file,"NAME_TAG");
   age_tag = d4tag(data_file,"AGE_TAG");
   amount_tag = d4tag(data_file,"AMNT_TAG");
}

void PrintRecords( void )
{
   int      rc,j,age_value;
   double   amount_value;
   char     f_name_str[15],l_name_str[15];
   char     address_str[20];
   char     date_str[9];
   char     married_str[2];
   char     *comment_str;

   for(rc = d4top(data_file);rc == r4success
                    ;rc =   d4skip(data_file, 1L))
   {
      f4ncpy(f_name,f_name_str,sizeof(f_name_str));
      f4ncpy(l_name,l_name_str
                           ,sizeof(l_name_str));
      f4ncpy(address,address_str
                          ,sizeof(address_str));
      age_value = f4int(age);
      amount_value = f4double(amount);
      f4ncpy(birth_date,date_str
                            ,sizeof(date_str));
      f4ncpy(married,married_str,
                         sizeof(married_str));
      comment_str = f4memo_str(comment);

      printf("-------------------------------\n");

      printf("Name     : %10s %10s\n",f_name_str
                                     ,l_name_str);
      printf("Address  : %15s\n",address_str);
      printf("Age : %3d   Married : %1s\n"
                          ,age_value,married_str);
      printf("Comment: %s\n",comment_str);
      printf("Amount purchased this year: "
             " $%5.2lf\n\n", amount_value);
   }
}

void AddNewRecord(char *f_name_str
                  ,char *l_name_str
                  ,char *address_str
                  ,int age_value
                  ,int married_value
                  ,double amount_value
                   ,char *comment_str)
{
   d4append_start(data_file,0);

   f4assign(f_name,f_name_str);
   f4assign(l_name,l_name_str);
   f4assign(address,address_str);
   f4assign_int(age,age_value);
   if(married_value)
      f4assign(married,"T");
   else
      f4assign(married,"F");
   f4assign_double(amount,amount_value);
   f4memo_assign(comment,comment_str);

   d4append(data_file);
}


int main( void )
{
   d4init(&code_base);
   code_base.safety = 0;

   CreateDataFile();

   AddNewRecord("Sarah","Webber","132-43 St.",32,1
                          ,147.99,"New Customer");
   AddNewRecord("John","Albridge"
                    ,"1232-76 Ave.",12,0,98.99,0);

   PrintRecords();

   d4tag_select(data_file,name_tag);
   PrintRecords();

   d4tag_select(data_file,age_tag);
   PrintRecords();

   d4tag_select(data_file,amount_tag);
   PrintRecords();

   d4close_all(&code_base);
   return 0;
}
