/* relate.c  (c)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */

/* CodeBase 5 Example Program. */

#include "d4all.h"

unsigned _stklen = 10000 ;

void main()
{
   CODE4 cb ;
   DATA4  *invoice ;
   FIELD4 *amount ;
   RELATE4 *relate ;
   int rc ;

   d4init( &cb ) ;

   // Turn on optimization
   cb.optimize = 1 ;

   // Open the master data file
   invoice =  d4open( &cb, "INVOICE" ) ;

   // Initialize the relation set.  In this case, 
   // there are no slave data files.
   relate = relate4init( invoice ) ; 

   // Specify a query of overdue invoices
   relate4query_set( relate, "DATE() > DATE_DUE" ) ;

   amount   =  d4field( invoice, "AMOUNT" ) ;
   double total_value = 0.0 ;

   relate4lock( relate ) ;

   d4opt_start( &cb ) ;  // Start the optimization

   // Skip through each record in the relation
   for( rc = relate4top( relate ); rc == 0;
	 rc = relate4skip( relate, 1 ) )
   {
      total_value +=  f4double( amount ) ;
   }

   printf( "\nThe invoice total is: %f", total_value ) ;

   relate4unlock( relate ) ;
   relate4free( relate, 0 ) ;  // Free the relation set memory
   d4close_all( &cb ) ;
}
