/***********************************************************************\
*                                                                       *
*   RELATE1.C     Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

CODE4   code_base;
DATA4   *student = NULL,*enrollment = NULL;
RELATE4 *master = NULL,*slave = NULL;
TAG4    *id_tag,*name_tag;

void open_data_files()
{
    d4init(&code_base);

    student = d4open(&code_base,"STUDENT");
    enrollment = d4open(&code_base,"ENROLL");

    name_tag = d4tag(student,"NAME");
    id_tag = d4tag(enrollment,"STU_ID_TAG");

    e4exit_test(&code_base);

}

void set_relation()
{
    master = relate4init(student);
    if(master == NULL) exit(1);

    slave = relate4create_slave(master,enrollment
                                    ,"ID",id_tag);

    relate4type(slave,relate4scan);

    relate4top(master);
}

void print_record()
{
    RELATE4 *relation;
    DATA4   *data;
    FIELD4  *field;
    int     j;

    for(relation = master;relation != NULL
                          ;relate4next(&relation))
    {
        data = relation->data;

        for(j = 1;j <= d4num_fields(data);j++)
            printf("%s "
                ,f4memo_str(d4field_j(data,j)));

    }
    printf("\n");
}

void list_records( void )
{
    int rc;

    for(rc = relate4top(master);rc != r4eof
                     ;rc = relate4skip(master,1L))
        print_record();

    printf("\n");

    relate4unlock(master);
}

void main( void )
{
    open_data_files();

    set_relation();

    list_records();

    relate4unlock(master);
    relate4free(master,0);

    d4close_all(&code_base);
}
