/***********************************************************************\
*                                                                       *
*   RELATE2.C     Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

CODE4   code_base;
DATA4   *student = NULL;

void open_data_files()
{
    student = d4open(&code_base,"STUDENT");

    e4exit_test(&code_base);
}

void print_record(DATA4 *data_file)
{
    int j;

    for(j=1;j<=d4num_fields(data_file);j++)
        printf("%s "
           ,f4memo_str(d4field_j(data_file,j)));

    printf("\n");
}

void query(DATA4 *data_file
          ,char *expr
          ,char *order)
{
    RELATE4 *relation = NULL;
    int     rc;

    relation = relate4init(data_file);
    if(relation == NULL) exit(1);


    relate4query_set(relation,expr);
    relate4sort_set(relation,order);


    for(rc = relate4top(relation);rc != r4eof
                 ;rc = relate4skip(relation,1L))
        print_record(data_file);

    printf("\n");

    relate4unlock(relation);
    relate4free(relation,0);

}

void main( void )
{
    int     rc,num_fields,j;

    d4init(&code_base);
    open_data_files();

    query(student
          ,"AGE > 30"
          ,"");

    query(student
         ,"UPPER(L_NAME) = 'MILLER'"
         ,"L_NAME + F_NAME");

    d4close_all(&code_base);
}
