/* REPORT.C  CodeBase 5 Example Program. */

#include "d4all.h"
unsigned _stklen = 10000 ;

main()
{
   CODE4 code_base ;
   DATA4 *data;
   RELATE4 *relate;
   REPORT4 *report;
   GROUP4  *country, *state, *city;
   TOTAL4  *country_total, *state_total;

   d4init( &code_base ) ;  // Initialize CodeBase

   data =  d4open( &code_base, "CITIES" ) ;  // Open the data file
   relate =  relate4init( data ) ;  // Initialize the relate module
   relate4sort_set(relate,"COUNTRY+STATE+CITY");
   report =  report4init( relate ) ; // Initialize the report module

   style4default_create( report ) ; // Create the default style

   country =  report4group( report ) ; // Create the groups
   state   =  report4group( report ) ;
   city    =  report4group( report ) ;

   group4expr( country, "COUNTRY" ) ;  // Specifiy the group expressions
   group4expr( state,   "STATE" ) ;
   group4expr( city,    "CITY" ) ;

   // Note how the 'header' and 'footer' members are accessed directly.
   objects4height( &country->header, 500 ) ; // 1/2 of an inch
   objects4height( &country->footer, 333 ) ; // 1/3 of an inch
   objects4height( &state->header, 167 ) ; // 1/6 of an inch
   objects4height( &state->footer, 167 ) ; // 1/6 of an inch
   objects4height( &city->header, 167 ) ; // 1/6 of an inch

   text4expr( &country->header, 0, 167, "COUNTRY" ) ;
   text4expr( &state->header, 250, 0, "STATE" ) ; // 1/4 of an inch
   text4expr( &city->header, 500, 0, "CITY" ) ;   // 1/2 of an inch
   text4expr( &city->header, 2000, 0, "POPULATION" ) ;  // 2 Inches

   text4label( &state->footer, 500, 0, "State Total" ) ;
   text4label( &country->footer, 500, 167, "Country Total" ) ;

   // Create the two totals.  They are the same except one gets
   // reset after each country and the other after each state.
   country_total = total4create( report, "t1",
             "POPULATION", total4sum ) ;

   state_total = total4create( report, "t2",
	     "POPULATION", total4sum ) ;

   total4reset_level( country_total, country ) ;
   total4reset_level( state_total, state ) ;

   // Display the totals in the state and country footers.
   text4total( &country->footer, 2000, 167, country_total ) ;
   text4total( &state->footer, 2000, 0, state_total ) ;

   // Set the report output for the screen
   report4page_size( report, 80, 25 );
   report4output( report, 1, NULL, 0 );
   report4do( report ) ;  // Display the report.
   report4free( report, 1, 1 );

   return 0 ;
}
