/***********************************************************************\
*                                                                       *
*   SHOWDAT2.C    Copyright (C) 1993 Sequiter Software Inc.             *
*                                                                       *
\***********************************************************************/


#include "D4ALL.h"

#ifdef __TURBOC__
   extern unsigned _stklen = 10000;
#endif

CODE4    code_base;
DATA4    *data_file = 0;
FIELD4   *f_name
        ,*l_name
        ,*address
        ,*age
        ,*birth_date
        ,*married
        ,*amount
        ,*comment;

TAG4     *name_tag
        ,*age_tag
        ,*amount_tag
        ,*address_tag
        ,*birthdate_tag;

TAG4INFO  tag_info[] =
{
   {"NAME","L_NAME+F_NAME",".NOT. DELETED()",0,0},
   {"ADDRESS","ADDRESS",0,0,0},
   {"AGE_TAG","AGE","AGE >= 18",0,0},
   {"DATE_TAG","BIRTH_DATE",0,0,0},
   {"AMNT_TAG","AMOUNT",0,0,0},
   {0,0,0,0,0},
};

void  OpenDataFile( void )
{

   code_base.auto_open = 0;
   code_base.safety = 0;
   data_file = d4open(&code_base,"DATA1.DBF");

   i4create(data_file,NULL,tag_info);

   f_name = d4field(data_file,"F_NAME");
   l_name = d4field(data_file,"L_NAME");
   address = d4field(data_file,"ADDRESS");
   age = d4field(data_file,"AGE");
   birth_date = d4field(data_file,"BIRTH_DATE");
   married = d4field(data_file,"MARRIED");
   amount = d4field(data_file,"AMOUNT");
   comment = d4field(data_file,"COMMENT");

   name_tag = d4tag(data_file,"NAME");
   address_tag = d4tag(data_file,"ADDRESS");
   age_tag = d4tag(data_file,"AGE_TAG");
   birthdate_tag = d4tag(data_file,"DATE_TAG");
   amount_tag = d4tag(data_file,"AMNT_TAG");
}


void PrintRecords( void )
{
   int      rc,j,age_value;
   double   amount_value;
   char     f_name_str[15],l_name_str[15];
   char     address_str[20];
   char     date_str[9];
   char     married_str[2];
   char     *comment_str;


   for(rc = d4top(data_file);rc == r4success
                     ;rc = d4skip(data_file, 1L))
   {
      f4ncpy(f_name,f_name_str
                             ,sizeof(f_name_str));
      f4ncpy(l_name,l_name_str
                             ,sizeof(l_name_str));
      f4ncpy(address,address_str
                            ,sizeof(address_str));
      age_value = f4int(age);
      amount_value = f4double(amount);
      f4ncpy(birth_date,date_str
                               ,sizeof(date_str));
      f4ncpy(married,married_str
                            ,sizeof(married_str));
      comment_str = f4memo_str(comment);

      printf("---------------------------\n");
      printf("Name     : %10s %10s\n"
                          ,f_name_str,l_name_str);

      printf("Address  : %15s\n",address_str);
      printf("Age : %3d   Married : %1s\n"
                          ,age_value,married_str);
      printf("Comment: %s\n",comment_str);
      printf("Amount purchased : $%5.2lf \n"
                                   ,amount_value);

      printf("\n");
   }

}

int main( void )
{
   d4init(&code_base);

   OpenDataFile();

   d4tag_select(data_file,name_tag);
   PrintRecords();

   d4tag_select(data_file,age_tag);
   PrintRecords();

   d4tag_select(data_file,amount_tag);
   PrintRecords();

   d4close_all(&code_base);
   return 0;
}
