/* t4conv.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved.

   Tests Code Base conversion routines.
*/

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif
#include "t4test.h"

CODE4 cb;

#ifndef S4LANGUAGE
   #define MONDAY "Monday"              /* English */
   #define OCTOBER "October"
   #define OCTOBER8 "Oct 08, 1990"
#else
   #ifdef S4GERMAN
      #define MONDAY "Montag"           
      #define OCTOBER "Oktober"
      #define OCTOBER8 "Okt 08, 1990"
   #endif
   #ifdef S4FRENCH
      #define MONDAY "Lundi"
      #define OCTOBER "Octobre"
      #define OCTOBER8 "Oct 08, 1990"
   #endif
#endif

static int do_test(void)
{
   char encde[10], result[20], date[8] ;
   double num ;

   /*   conversion tests  */
   num = atof("108.625");
   if ( num != 108.625 )
      e4severe( e4result, "t4conv:  c4atod" );

   c4dtoa45( 190457.311, encde, 8, 1 ) ;
   if ( strncmp( "190457.3", encde, 8 ) !=0 )
      e4severe( e4result, "t4conv:  c4dtoa45" ) ;

   if ( c4atoi( "12", 2 ) != 12 )
      e4severe( e4result, "t4conv:  c4atoi" ) ;

   if ( c4atol( "1234567", 5 ) != 12345 )
      e4severe( e4result, "t4conv:  c4atol" ) ;

   c4encode( encde, "123456", "AA%BB*CC", "CCAABB");
   if ( strcmp( encde, "34%56*12" ) != 0)
      e4severe( e4result, "t4conv:  c4encode" ) ;

   c4ltoa45( (long) 10, encde, 8) ;
   if ( strcmp( encde, "      10") != 0 )
      e4severe( e4result, "t4conv:  c4ltoa45" ) ;

   c4ltoa45( (long) 10, encde, -8);
   if ( strcmp( encde, "00000010") != 0 )
      e4severe( e4result, "t4conv:  c4ltoa45" ) ;

   strcpy( encde, "tESTiNG 4");

   c4lower(encde);
   if ( strcmp( encde, "testing 4") != 0 )
      e4severe( e4result, "t4conv:  c4lower" ) ;

   c4upper(encde);
   if ( strcmp( encde, "TESTING 4") != 0 )
      e4severe( e4result, "t4conv:  c4upper" ) ;

   /*   date tests   */

   date4format_mdx2("19901225", &num) ;
   date4assign( date, (long) num ) ;
   if ( strncmp( "19901225" , date, sizeof(date) ) != 0 )
      e4severe( e4result, "t4conv:  date4assign" ) ;

   memcpy( date, "19901008", sizeof(date) );  /*Monday,October 8, 1990*/

   date4format(date, result, "YY.MM.DD");
   if ( strcmp( result, "90.10.08")  != 0 )
      e4severe( e4result, "t4conv:  date4format" ) ;

   date4format(date, result, "CCYY.MM.DD");
   if ( strcmp( result, "1990.10.08")  != 0 )
      e4severe( e4result, "t4conv:  date4format" ) ;

   date4format(date, result, "MM/DD/YY");
   if ( strcmp( result, "10/08/90")  != 0 )
      e4severe( e4result, "t4conv:  date4format" ) ;

   date4format(date, result, "MMM DD, CCYY");
   if ( strcmp( result, OCTOBER8 )  != 0 )
      e4severe( e4result, "t4conv:  date4format" ) ;

   strcpy( result, date4cdow(date) ) ;
   if ( strcmp( result, MONDAY )  != 0 )
      e4severe( e4result, "t4conv:  date4cdow" ) ;

   strcpy( result, date4cmonth( date ) ) ;
   if ( strcmp( result, OCTOBER )  != 0 )
      e4severe( e4result, "t4conv:  date4cmonth" ) ;

   if ( date4day(date) != 8 )
      e4severe( e4result, "t4conv:  date4day" ) ;

   if ( date4month(date) != 10 )
      e4severe( e4result, "t4conv:  date4month" ) ;

   if ( date4dow(date) != 2 )
      e4severe( e4result, "t4conv:  date4dow" ) ;

   date4format_mdx2(date, &num);
   if (  2448173.0 != num )
      e4severe( e4result, "t4conv:  date4format_mdx" ) ;

   if ( date4long(date) != 2448173 )
      e4severe( e4result, "t4conv:  date4long" ) ;

   date4init( date, "Nov 07/90", "MMM DD/YY");
   if ( strncmp( "19901107" , date, sizeof(date) ) != 0 )
      e4severe( e4result, "t4conv:  date4init" ) ;

   date4init( date, "08/07/1989", "MM/DD/CCYY");
   if ( strncmp( "19890807" , date, sizeof(date) ) != 0 )
      e4severe( e4result, "t4conv:  date4init" ) ;

   date4init( date, "08/07/1963", "DD/MM/CCYY");
   if ( strncmp( "19630708" , date, sizeof(date) ) != 0 )
      e4severe( e4result, "t4conv:  date4init" ) ;

   return 0;
}


static int  test_with_mem_check( D4DISPLAY *display )

{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( do_test() )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo( &cb ) ;

      #ifndef DLL
         mem4reset() ;
         if ( mem4free_check( 100 ) != 0 )
            e4severe( e4result, "t4conv:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif
   return 0 ;
}


int S4FUNCTION t4test( D4DISPLAY *disp )
{
   if ( test_with_mem_check(disp) )
      e4severe( e4result, "t4conv.c" ) ;
   if ( test_with_mem_check(disp) )
      e4severe( e4result, "t4conv.c" ) ;

   d4display_str( disp, "T4CONV:   SUCCESS", 1 ) ;
   d4display_str( disp, "", 1 ) ;
   return 1 ;
}  

