/* t4index.c (c)Copyright Sequiter Software Inc., 1990-1993 All rights reserved.

   1.  Checks to make sure dBASE Function 'RECNO()' is working while indexing.
*/

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include "t4test.h"


static FIELD4INFO test_fields[] =
{
   { "C", 'C', 100, 0 },
   { "C2", 'C', 8, 0 },
   { 0,  0, 0, 0 },
} ;

static TAG4INFO tag_info[] =
{
   /* name, expression, filter, unique,descending */
   { "C", "C", "", 0, 0 },
   { "C2", "C2", "", 0, 0 },
   { "R", "RECNO()", "", 0, 0 },
   { 0,  0,  0, 0, 0 },

};

CODE4 cb;
DATA4 *data;
INDEX4 *test_index, *index_check ;

static int do_test( long num_recs, D4DISPLAY *disp, int do_open )
{
   long i_rec ;

   cb.hWnd = disp->hWnd ;

   if ( d4display_quit( disp ) )
      return 1 ;
   d4display_str( disp,  "  Index Test: part one ", 1 ) ;
   disp->y += 2 ;
   d4display_str( disp,  "        Number of Records: ", 1 ) ;
   d4display_num( disp, num_recs, 0 ) ;
   d4display_str( disp, " ", 1 ) ;

   cb.safety = 0 ;

   if (do_open)
   {
      cb.auto_open = 0 ;
      data = d4open( &cb, "T4INDEX" ) ;
      if ( d4zap( data, 1L, d4reccount( data ) ) != 0 )
         e4severe( 0, "t4index:  d4zap" ) ;
   }
   else
      data = d4create( &cb, "T4INDEX", test_fields, 0);

   if ( cb.error_code || data == 0 )
      e4severe( 0, "t4index:  d4create" ) ;

   d4opt_start( &cb ) ;

   for ( i_rec = 1L; i_rec <= num_recs; i_rec++ )
   {
      if ( (i_rec % 50 == 0) || (i_rec == num_recs) )
      {
	 d4display_str( disp,  "        Writing Record:   ", 0 ) ;
	 d4display_num( disp, i_rec, 0 ) ;
	 d4display_str( disp,  "      ", 0 ) ;
	 disp->x = (int) 0 ;
      }

      if ( d4append_blank( data ) < 0 )
	 e4severe( 0, "t4index:  d4append_blank" ) ;
   }

   if ( d4display_quit( disp ) )
      return 1 ;
   disp->y += 2 ;
   d4display_str( disp,  "          Creating Index File . . .", 1 ) ;

   test_index =  i4create( data, "T4INDEX", tag_info ) ;
   if ( test_index == 0 )
      e4severe( 0, "t4index:  failure to create" ) ;
      

   d4display_str( disp,  "          Checking Index File . . .", 1 ) ;
   if ( i4check( test_index )  != 0 )
      e4severe( 0, "t4index:  i4check" ) ;

   index_check = d4index( data, "T4INDEX" );
   if (index_check == 0)
      e4severe( 0, "t4index:  d4index" ) ;

   index_check = d4index( data, "S4INDEX" ); /* doesn't exist */
   if (index_check != 0)
      e4severe( 0, "t4index:  d4index(2)" ) ;

   if ( d4close_all( &cb ) != 0 )
      e4severe( 0, "T4INDEX.C" ) ;

   return 0 ;
}

static int  test_with_mem_check( long num_recs, D4DISPLAY *disp, int i )
{
   d4init( &cb ) ;

   if ( do_test( num_recs, disp, i ) )
      return 1 ;

   if ( d4close_all( &cb ) != 0 )
      e4severe( 0, "T4INDEX.C" ) ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo( &cb ) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4index:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int S4FUNCTION t4test( D4DISPLAY *disp )
{
   long num_recs ;

   num_recs = atol( d4parsestring_nparm( &disp->parse_str ) ) ;

   if (num_recs == 0)
      e4severe( 0, "T4INDEX:  Missing command line parameter(s)" ) ;

   if ( test_with_mem_check( num_recs, disp, 0 ) )
      e4severe( 0, "t4index.c" ) ;
   if ( test_with_mem_check( num_recs, disp, 1 ) )
      e4severe( 0, "t4index.c" ) ;

   disp->y += 2 ;
   d4display_str( disp, "T4INDEX:   SUCCESS", 1 ) ;
   d4display_str( disp, "", 1 ) ;
   return 1 ;
}

