/* t4index2.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved.

   1.  Checks to make sure dBASE Function 'RECNO()' is working while indexing.
*/

#include  "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include  "t4test.h"

static FIELD4INFO test_fields[] =
{
   { "C" , 'C' , 100, 0 },
   { "D", 'D', 8, 0 },
   { "M", 'M',10, 0 },
   { "N", 'N', 7, 2 },
   { 0,  0, 0, 0 },
} ;

static TAG4INFO tag_info[] =
{
   /* name, expression, filter, unique,descending */
   { "C_TAG",  "C", 0, 0, 0 },
   { "N_TAG",  "N", "", 0, 0 },
   { "D_TAG",  "D", 0, 0, 0 },
   { 0,0,0,0,0 },
} ;

#ifdef S4CLIPPER
static TAG4INFO tag_info2[] =
{
   { "C_TAG2", "C", 0, r4unique_continue, 0 },
   { 0,0,0,0,0 },
} ;
#endif

CODE4 cb ;
DATA4 *database ;
FIELD4 *c_field, *n_field, *m_field, *d_field ;

static int do_test( long num_recs, D4DISPLAY *disp )
{
   TAG4 *c_tag, *d_tag, *n_tag ;
   long i_rec ;
   char buf[1000] ;
   int rc ;

   #ifdef S4CLIPPER
      INDEX4 *test_index ;
   #endif

   d4display_str( disp,  "Index Test (t4index2); ", 1 ) ;
   disp->y += 2 ;
   d4display_str( disp,  "        Number of Records: ", 1 ) ;
   d4display_num( disp, num_recs, 0 ) ;

   cb.mem_size_sort_buffer = 0x800 ;
   cb.safety = 0 ;

   database = d4create( &cb, "T4INDEX2", test_fields, tag_info ) ;
   if ( database == 0 )
      e4severe( e4result, "t4index2:  d4create" ) ;

   c_field = d4field( database, "C" ) ;
   d_field = d4field( database, "D" ) ;
   n_field = d4field( database, "N" ) ;
   m_field = d4field( database, "M" ) ;

   if ( c_field == 0 || d_field == 0 || n_field == 0 || m_field == 0 )
      e4severe( e4result, "t4index2:  d4field" ) ;

   d4opt_start( &cb ) ;

   if ( d4check( database ) != 0 )
      e4severe( e4result, "t4index2:  d4check" ) ;
   e4exit_test( &cb ) ;
   d4display_str( disp,  "Appending Record:   ", 1 ) ;

   for ( i_rec = 1L; i_rec <= num_recs; i_rec++ )
   {
      if ( d4display_quit( disp ) )
         return 1 ;
      if ( i_rec % 25 == 0 )
      {
         disp->x = 0 ;
         d4display_str( disp,  "Appending Record:   ", 0 ) ;
         d4display_num( disp, i_rec, 0 ) ;
      }

      if ( d4append_start( database, 0 ) < 0 )
         return -1 ;

      if (i_rec % 3 == 0 )
         f4assign( c_field, "A" ) ;
      else
         f4assign( c_field, "B" ) ;

      f4assign_long( d_field, date4long( "19830208" ) + i_rec ) ;
      f4assign_long( n_field, i_rec ) ;
      if ( i_rec > 5 )
      {
         c4ltoa45( i_rec, buf, -6 ) ;
         f4memo_assign_n( m_field, buf, 6 ) ;
      }

      if ( d4append( database ) != 0 )
         e4severe( e4result, "t4index2:  d4check" ) ;
   }
   disp->y += 2 ;
   d4display_str( disp,  "          Checking Index File . . .", 1 ) ;

   if ( d4check( database ) != 0 )
      e4severe( 0, "t4index2:  i4check" ) ;

   c_tag = d4tag( database, "C_TAG" ) ;
   if ( c_tag == 0 )
      e4severe( e4result, "t4index2:  d4tag" ) ;

   n_tag = d4tag_prev( database, c_tag ) ;
   if ( n_tag )
      e4severe( e4result, "t4index2:  d4tag_prev" ) ;

   c_tag = d4tag( database, "C_TAG" ) ;
   if ( c_tag == 0 )
      e4severe( e4result, "t4index2:  d4tag" ) ;

   d4tag_select( database, c_tag ) ;
   if ( num_recs >= 3 )
   {
      if( d4seek( database, "B" ) != 0 )
         e4severe( e4result, "d4seek; c_tag" ) ;
   }

   n_tag = d4tag_next( database, c_tag ) ;
   if ( n_tag == 0 )
      e4severe( e4result, "t4index2:  d4tag_next" ) ;
   d4tag_select( database, n_tag ) ;
   rc =  d4seek_double( database, 2.0 ) ;
   if (num_recs > 2 )
      if ( rc != 0 || d4recno(database) != 2 )
         e4severe( e4result, "t4index2:  d4seek_double, n_tag" ) ;

   d_tag = d4tag_next( database, n_tag ) ;
   if ( d_tag == 0 )
      e4severe( e4result, "t4index2:  d4tag_next" ) ;

   c_tag = d4tag_next( database, d_tag ) ;
   if ( c_tag )
      e4severe( e4result, "t4index2:  d4tag_next" ) ;

   d4tag_select( database, d_tag ) ;
   rc =  d4seek( database, "19830210") ;
   if ( num_recs > 1 )
      if ( rc != 0 || d4recno(database) != 2 )
         e4severe( e4result, "t4index2:  d4seek (d_tag)" ) ;

   disp->y += 2 ;
   d4display_str( disp,  "          Reindexing . . .", 1 ) ;
   
   if( d4reindex( database ) != 0 )
      e4severe( e4result, "t4index2:  d4reindex" ) ;

   if ( d4check( database ) != 0 )
      e4severe( e4result, "t4index2:  d4check" ) ;

   d4tag_select( database, 0 ) ;  /* use record number ordering */
   if ( d4top( database ) < 0 )
      return -1 ;

   for( i_rec = 1L; i_rec < num_recs/2; i_rec++ )
   {
      f4assign( c_field, "Z") ;
      if ( d4skip( database, 1L ) < 0 )
         e4severe( e4result, "t4index2:  d4skip" ) ;
   }

   disp->y += 2 ;

   d4display_str( disp,  "          Check of Index . . .", 1 ) ;
   if ( d4check( database )  != 0 )
      e4severe( e4result, "t4index2:  i4check (second i4check)" ) ;

   /* now reverse the process to make sure also works */
   for( i_rec = num_recs / 2; i_rec > 0L; i_rec-- )
   {
      if ( d4go( database, i_rec ) < 0 )
         e4severe( e4result, "t4index2:  d4skip" ) ;
      f4assign( c_field, "A" ) ;
   }

   disp->y += 2 ;

   d4display_str( disp,  "          Check of Index . . .", 1 ) ;
   if ( d4check( database )  != 0 )
      e4severe( e4result, "t4index2:  i4check (second i4check)" ) ;

   #ifdef S4CLIPPER
      test_index =  i4create( database, "T4INDEXX", tag_info2 ) ;
      if ( test_index == 0 )
         e4severe( 0, "t4index:  failure to create" ) ;
   #endif

   for ( i_rec = 1 ; i_rec <= num_recs ; i_rec++ )
   {
      if ( d4go( database, i_rec ) < 0 )
         e4severe( e4result, "t4index2:  d4skip" ) ;
      f4assign_long( c_field, i_rec ) ;
   }

   disp->y += 2 ;

   d4display_str( disp,  "          Check of Index . . .", 1 ) ;

   #ifdef S4CLIPPER
      i4close( test_index ) ;
   #endif

   if ( d4check( database )  != 0 )
      e4severe( e4result, "t4index2:  i4check (second i4check)" ) ;

   #ifdef S4CLIPPER
      test_index = i4open( database, "T4INDEXX" ) ;
   #endif

   for ( i_rec = 1 ; i_rec <= num_recs ; i_rec++ )
   {
      if ( d4go( database, i_rec ) < 0 )
         e4severe( e4result, "t4index2:  d4skip" ) ;
      f4assign_long( c_field, 0 ) ;
   }

   #ifdef S4CLIPPER
      i4close( test_index ) ;
   #endif

   disp->y += 2 ;

   d4display_str( disp,  "          Check of Index . . .", 1 ) ;
   if ( d4check( database )  != 0 )
      e4severe( e4result, "t4index2:  i4check (second i4check)" ) ;

   if ( d4close_all( &cb ) < 0 )
      e4severe( 0, "t4index2:  d4close_all" ) ;

   return 0 ;
}

static int  test_with_mem_check( long num_recs, D4DISPLAY *disp )
{
   d4init( &cb ) ;
   cb.hWnd = disp->hWnd ;

   if ( do_test( num_recs, disp ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo(&cb) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4index:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int S4FUNCTION t4test( D4DISPLAY *disp )
{
   long num_recs ;

   num_recs = atol( d4parsestring_nparm( &disp->parse_str ) ) ;
   
   if (num_recs == 0)
      e4severe( 0, "T4INDEX2:  Missing command line parameter(s)" ) ;
   
   #ifdef S4CLIPPER
      if ( test_with_mem_check( 9, disp ) )
         e4exit(&cb) ;
   
      if ( test_with_mem_check( 21, disp ) )
         e4exit(&cb) ;
   
      if ( test_with_mem_check( 51, disp ) )
         e4exit(&cb) ;
   
      if ( test_with_mem_check( 54, disp ) )
         e4exit(&cb) ;
   
      if ( test_with_mem_check( 400, disp ) )
         e4exit(&cb) ;
   #endif
   
   if ( test_with_mem_check( num_recs, disp ) )
      e4exit(&cb) ;

   disp->y += 2 ;
   d4display_str( disp, "T4INDEX2:   SUCCESS", 1) ;
   d4display_str( disp, "", 1) ;
   return 1 ;
}
