/* t4index3.c (c)Copyright Sequiter Software Inc., 1990-1993 All rights reserved.
   Checks the Trim functions.
*/

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include "t4test.h"

static FIELD4INFO test_fields[] =
{
   { "C",  'C', 10, 0 },
   { "C2", 'C', 10, 0 },
   { 0,0,0,0 },
} ;

static TAG4INFO tag_info[] =
{
   { "T1", "TRIM(C2)+TRIM(C)", "", 0, 0 },
   { "T2", "TRIM(C)+TRIM(C2)", "", 0, 0 },
   { "T3", "UPPER(TRIM(C2)+TRIM(C))", "", 0, 0 },
   { "T4", "UPPER(TRIM(C)+TRIM(C2))", "", 0, 0 },
   { 0,0,0,0,0 },
} ;

CODE4 cb;
DATA4 *test_database;
INDEX4 *test_index, *index_check ;
FIELD4 *c_fld, *c2_fld ;

static int do_test( D4DISPLAY *disp )
{
   char i ;

   static char arr[] =  "a         " ;
   static char arr2[] = "         a" ;
   static char arr3[] = "a         a" ;
   static char arr4[] = "         aa" ;
   cb.hWnd = disp->hWnd ;
   if ( d4display_quit( disp ) )
      return 1 ;

   cb.safety = '\0';

   test_database = d4create( &cb, "T4INDEX3", test_fields, tag_info ) ;

   if ( cb.error_code || test_database == 0 )
      e4severe( 0, "t4index:  d4create" ) ;

   d4opt_start( &cb ) ;

   c_fld  = d4field( test_database, "C" ) ;
   c2_fld = d4field( test_database, "C2" ) ;

   if ( c_fld == 0 || c2_fld == 0 )
      e4severe( e4info, "t4index3.c" ) ;

   for ( i = 0; i <= 25; i++ )
   {
      if ( d4append_start( test_database, 0 ) < 0 )
         e4severe( 0, "t4index:  d4append_start" ) ;

      arr[0]  = 'a' + i ;
      arr2[9] = 'a' + i ;
      f4assign( c_fld, arr ) ;
      f4assign( c2_fld, arr2 ) ;

      if ( d4append( test_database ) < 0 )
         e4severe( 0, "t4index:  d4append" ) ;
   }

   d4tag_select( test_database, d4tag( test_database, "T1" ) ) ;
   for ( i = 0; i <= 25; i++ )
   {
      arr4[9]  = 'a' + i ;
      arr4[10]  = 'a' + i ;
      if ( d4seek( test_database, arr4 ) != 0 )
         e4severe( e4info, "failed seek" ) ;
   }

   d4tag_select( test_database, d4tag( test_database, "T2" ) ) ;
   for ( i = 0; i <= 25; i++ )
   {
      arr3[0]  = 'a' + i ;
      arr3[10]  = 'a' + i ;
      if ( d4seek( test_database, arr3 ) != 0 )
         e4severe( e4info, "failed seek" ) ;
   }

   d4tag_select( test_database, d4tag( test_database, "T3" ) ) ;
   for ( i = 0; i <= 25; i++ )
   {
      arr4[9]  = 'A' + i ;
      arr4[10]  = 'A' + i ;
      if ( d4seek( test_database, arr4 ) != 0 )
         e4severe( e4info, "failed seek" ) ;
   }

   d4tag_select( test_database, d4tag( test_database, "T4" ) ) ;
   for ( i = 0; i <= 25; i++ )
   {
      arr3[0]  = 'A' + i ;
      arr3[10]  = 'A' + i ;
      if ( d4seek( test_database, arr3 ) != 0 )
         e4severe( e4info, "failed seek" ) ;
   }

   if ( d4check( test_database )  != 0 )
      e4severe( e4info, "t4index3.c" ) ;

   if ( d4close_all( &cb ) != 0 )
      e4severe( e4info, "t4index3.c" ) ;

   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *disp )
{
   d4init( &cb ) ;

   if ( do_test( disp ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo( &cb ) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4index:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int S4FUNCTION t4test( D4DISPLAY *disp )
{
   if ( d4display_quit( disp ) )  return 1 ;
   d4display_str( disp,  "  Index3 Test", 1 ) ;
   disp->y += 2 ;

   if ( test_with_mem_check( disp ) )
      e4severe( e4info, "failed seek" ) ;

   d4display_str( disp, "T4INDEX3:   SUCCESS", 1 ) ;
   d4display_str( disp, "", 1 ) ;
   return 1 ;
}

