/* t4max.c   (C)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */
/* Maximum Testing */

#include  "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include  "t4test.h"

static FIELD4INFO test_field[] =
{
   { "C1", 'C', 28767, 0 },
   { "C2", 'C', 11733, 0 },
   { 0,  0, 0, 0 },
} ;

#ifdef S4UNIX
   int max_fields = 1022 ;
#else
   const int max_fields = 1022 ;
#endif

CODE4 cb ;
DATA4 *database ;
INDEX4 *index ;
FIELD4 *f1 ;
FIELD4 *f2 ;

char test1[] = "1234567890" ;
char test2[] = "ABCDEFGHIJ" ;

static void  check( FIELD4 *f1, FIELD4 *f2 )
{
   if ( memcmp( f4ptr(f1)+40000, test1, sizeof(test1) ) != 0 )
      e4severe( e4result, (char *) 0 ) ;
   if ( memcmp( f4ptr(f2)+10000, test2, sizeof(test2) ) != 0 )
      e4severe( e4result, (char *) 0 ) ;
}

static void  test_fields( DATA4 *database, long num_rec, int num_field )
{
   long start_rec, r ;
   int  i_field ;

   start_rec = d4reccount( database ) ;

   if ( database->n_fields < num_field )
      e4severe( e4result, "t4max" ) ;

   for ( r = 1; r <= num_rec; r++ )
   {
      if ( d4append_start( database, 0 ) != 0 )
         e4severe( e4result, "t4max" ) ;

      for ( i_field = 1 ; i_field <= num_field ; i_field++ )
         f4assign_long( d4field_j( database, i_field ), i_field ) ;

      if ( d4append( database ) != 0 )
         e4severe( e4result, "t4max" ) ;
   }

   for ( r = 1; r <= num_rec; r++ )
   {
      if ( d4go( database, start_rec + r) != 0 )
         e4severe( e4result, (char *) 0 ) ;

      for ( i_field = 1 ; i_field <= num_field ; i_field++ )
         if ( f4long( d4field_j( database, i_field ) ) != i_field )
            e4severe( e4result, "t4max" ) ;
   }
}


static void test_tags( D4DISPLAY *display, DATA4 *database, char *names, int num_tags, long num_recs )
{
   TAG4INFO *tags ;
   int i, i_field ;
   long r ;

   tags = (TAG4INFO *)u4alloc( sizeof(TAG4INFO) * 48 ) ;
   if ( tags == 0 )
      e4severe( e4memory, "t4max.c" ) ;

   for ( i = 0; i < num_tags; i++ )
   {
      tags[i].name       = names + i*6 ;
      tags[i].expression = names + i*6 ;
   }

   d4display_str( display,  "        Creating Index. . .", 1 ) ;

   #ifdef S4OPEN_FILE
      index = i4open( database, "T4MANY" ) ;
   #else
      index = i4create( database, "T4MANY", tags ) ;
   #endif

   /* i4check( index ) ; */

   d4opt_start( &cb ) ;

   d4display_str( display,  "        Appending Record:   ", 1 ) ;

   for ( r = 1; r <= num_recs; r++ )
   {
      if ( r % 50 == 0 || r == num_recs || r == 1)
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Appending Record:   ", 0 ) ;
         d4display_num( display, r, 0 ) ;
      }

      if ( d4append_start( database, 0 ) != 0 )
         e4severe( e4result, "t4max" ) ;

      for ( i_field = 1; i_field < d4num_fields(database); i_field++ )
         f4assign_long( d4field_j(database, i_field), r ) ;

      if ( d4append(database) != 0 )
         e4severe( e4result, "t4max" ) ;
   }

   d4display_str( display,  "        Checking Index. . .", 1 ) ;
   if ( i4check( index )  != 0 )
      e4severe( e4result, "t4max.c" ) ;

   if ( i4close( index ) != 0 )
      e4severe( e4result, "t4max" ) ;

   u4free( tags ) ;
}


static int  do_test( D4DISPLAY *disp , long n_rec, int num_tags,
                        int block_size, long n_rec2 )
{
   FIELD4INFO *fields ;
   char *names ;
   long i_rec ;
   int i ;

   cb.hWnd = disp->hWnd ;
   #ifdef S4DLL
      cb.hInst = disp->hInst ;
   #endif

   cb.safety = 0 ;
   cb.mem_expand_block = 1 ;  /* Keep from running out of memory */
   cb.mem_start_block = 1 ;

   /* Check 'max_fields' Fields */
   fields = (FIELD4INFO *) u4alloc( sizeof(FIELD4INFO) * 1023 ) ;
   names  = (char *) u4alloc( 6 * max_fields ) ;
   if ( fields == 0 || names == 0 )
      e4severe( e4memory, "t4max.c" ) ;

   for ( i = 0 ; i < max_fields ; i++ )
   {
      fields[i].name = names + i*6 ;
      fields[i].name[0] = 'F' ;
      c4ltoa45( (long)i, fields[i].name + 1, -4 ) ;

      fields[i].type = 'C' ;
      fields[i].len = (short) 4 ;
   }

   d4display_str( disp, "Creating Data File.  Number of Fields: ", 1 ) ;
   d4display_num( disp, (long) max_fields , 0 ) ;

   #ifdef S4OPEN_FILE
      database = d4open( &cb, "T4MANY" ) ;
   #else
      database = d4create( &cb, "T4MANY", fields, 0 ) ;
   #endif

   if ( database == 0 )
      e4severe( e4result, "t4max" ) ;

   if (database->n_fields != max_fields )
      e4severe( e4result, "t4max" ) ;

   u4free( fields ) ;

   test_fields( database, 5, max_fields ) ;


   d4display_str( disp, "Test an Index file with 1 tag. Number of Records: ", 1 ) ;
   d4display_num( disp, (long) n_rec , 0 ) ;

   test_tags( disp, database, names, 1, n_rec ) ;

   d4display_str( disp, "Test an Index file. Number of Tags: ", 1 ) ;
   d4display_num( disp, (long) num_tags, 0 ) ;
   test_tags( disp, database, names, num_tags, 1 ) ;

   d4display_str( disp, "Test an Index file with a block size of: ", 1 ) ;
   d4display_num( disp, (long) block_size, 0 ) ;
   d4display_str( disp, "   Number of Records: ", 1 ) ;
   d4display_num( disp, (long) n_rec2, 0 ) ;

   cb.mem_size_block = (int) block_size ;
   test_tags( disp, database, names, 1, n_rec2 ) ;

   u4free( names ) ;

   if ( d4close( database ) != 0 )
      e4exit( &cb ) ;

   d4display_str( disp, "Check Wide Field and Large Record Width. . . ", 1 ) ;

   /* Check Wide Field and Large Record Width */

   #ifdef S4OPEN_FILE
      database = d4open( &cb, "T4MLARGE" ) ;
   #else
      database = d4create( &cb, "T4MLARGE", test_field, 0 ) ;
   #endif

   e4exit_test( &cb ) ;

   f1 = d4field( database, "C1" ) ;
   f2 = d4field( database, "C2" ) ;

   if ( f1 == 0 || f2 == 0 )
      e4severe( e4result, "t4max" ) ;

   if ( (short) f4len( f1 ) != test_field[0].len )
      e4severe( e4result, "t4max" ) ;

   if ( (short) f4len( f2 ) != test_field[1].len )
      e4severe( e4result, "t4max" ) ;

   if ( d4append_start( database, 0 ) != 0 )
      e4severe( e4result, "t4max" ) ;

   f4assign( f1, "A") ;

   memcpy( f4assign_ptr( f1 ) + 40000, test1, sizeof( test1 ) ) ;
   memcpy( f4assign_ptr( f2 ) + 10000, test2, sizeof( test2 ) ) ;
   if ( d4append( database ) < 0 )
      e4severe( e4result, "t4max" ) ;

   check( f1, f2 ) ;

   if ( d4append_start( database, 0 ) != 0 )
      e4severe( e4result, "t4max" ) ;
   if ( d4append( database ) != 0 )
      e4severe( e4result, "t4max" ) ;

   check( f1, f2 ) ;

   if ( d4close( database ) != 0 )
      e4severe( e4result, "t4max" ) ;
   e4exit_test( &cb ) ;

   cb.auto_open = 0 ;

   database = d4open( &cb, "T4MLARGE" ) ;
   f1 = d4field( database, "C1" ) ;
   f2 = d4field( database, "C2" ) ;
   if ( database == 0 || f1 == 0 || f2 == 0 )
      e4severe( e4result, "t4max" ) ;
   e4exit_test( &cb ) ;

   for ( i_rec = 1L; i_rec <= 2; i_rec++ )
   {
      if ( d4go( database, i_rec ) != 0 )
         e4severe( e4result, "t4max" ) ;
      check( f1, f2 ) ;
   }

   if ( d4close( database ) != 0 )
      e4severe( e4result, "t4max" ) ;
   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *disp , long n_rec, int num_tags,
                                    int block_size, long n_rec2)
{
   d4init( &cb ) ;

   if ( do_test( disp , n_rec, num_tags, block_size, n_rec2 ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo(&cb) ;

      #ifndef DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4max:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}


int  S4FUNCTION t4test( D4DISPLAY *disp )
{
   int num_tags = 47 ;
   unsigned block_size = 16384 ;
   long n_rec = 2000 ;
   long n_rec2 = 5000 ;
   long temp_parm ;

   temp_parm = atol( d4parsestring_nparm( &disp->parse_str ) ) ;
   if ( temp_parm == 0 )
   {
      d4display_str( disp, "T4MAX Test  ", 1 ) ;
      d4display_num( disp, n_rec, 0 ) ;
      d4display_num( disp, (long)num_tags, 0 ) ;
      d4display_num( disp, (long)block_size, 0 ) ;
      d4display_num( disp, n_rec2, 0 ) ;
      #ifdef S4WINDOWS
         d4display_quit( disp ) ;
      #endif
      return 1 ;
   }

   n_rec = temp_parm ;

   temp_parm = atol( d4parsestring_nparm( &disp->parse_str ) ) ;
   if ( temp_parm > 0 )
      num_tags = (int) temp_parm ;

   if ( num_tags > 47 )
      num_tags = 47 ;

   #ifdef N4OTHER     /* for twentry file limit consideration */
      if ( num_tags > 14 )
         num_tags = 14 ;
   #endif

   temp_parm = atol( d4parsestring_nparm( &disp->parse_str ) ) ;
   if ( temp_parm > 0 )
      block_size = (unsigned) temp_parm  ;

   temp_parm = atol( d4parsestring_nparm( &disp->parse_str ) ) ;
   if ( temp_parm > 0 )
      n_rec2 = temp_parm ;

   d4display_str( disp, "Warning: this test program creates large database and index", 1 ) ;
   d4display_str( disp, "files that are not deleted upon completion.  It requires", 1 ) ;
   d4display_str( disp, "several megabytes of hard disk space.", 1 ) ;
   d4display_str( disp, " ", 1 );
   d4display_str( disp, "Warning: This program requires a significant amount of time", 1 ) ;
   d4display_str( disp, "         to run.  On a standard 386 time requirements may be", 1 ) ;
   d4display_str( disp, "         as high as 30 minutes.", 1 );
   d4display_str( disp, " ", 1 );
   d4display_str( disp, "Please note that number of tags may be decreased because", 1 ) ;
   d4display_str( disp, "of twenty-files-open considerations", 1 ) ;
   d4display_str( disp, " ", 1 );

   d4display_str( disp, "Num Recs for Test 1:   ", 1 ) ;
   d4display_num( disp, (long) n_rec, 0 ) ;

   d4display_str( disp, "Num Tags for Test 2:   ", 1 ) ;
   d4display_num( disp, (long) num_tags, 0 ) ;

   d4display_str( disp, "Block Size for Test 3: ", 1 ) ;
   d4display_num( disp, (long) block_size, 0 ) ;

   d4display_str( disp, "Num Recs for Test 3:   ", 1 ) ;
   d4display_num( disp, (long) n_rec2, 0 ) ;

   d4display_str( disp, "Number of Fields for test: ", 1 ) ;
   d4display_num( disp, (long) max_fields, 0 ) ;

   if ( test_with_mem_check( disp, n_rec, num_tags, block_size, n_rec2 ) )
      e4exit( &cb ) ;

   disp->y += 2 ;
   d4display_str( disp, "T4MAX:   SUCCESS", 1) ;
   d4display_str( disp, "", 1) ;
   return 1 ;
}
