/* t4memo.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

#include  "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include  "t4test.h"

static FIELD4INFO test_fields[] =
{
   {"MEMO_DAT", 'M', 10,0},
   { 0,  0, 0, 0 },
} ;

#define   RW_SIZE  12000

CODE4 cb;
DATA4 *t4memo;
FIELD4 *mfield;
char rec_two[] = "New Data" ;

static int do_test( D4DISPLAY *disp , unsigned block_size )
{
   char *write_data ;
   int i, rc ;
   unsigned len ;
   long binary_out[260] ;
   char buf[20] ;

   cb.hWnd = disp->hWnd ;
   #ifdef S4DLL
      cb.hInst = disp->hInst ;
   #endif

   d4display_str( disp,  "  Memo Test: ", 1 ) ;

   write_data = (char *)u4alloc( RW_SIZE ) ;
   if ( write_data == 0 )
      e4severe( e4memory, "t4memo.c" ) ;

   cb.safety = 0 ;
   cb.mem_size_block = block_size ;

   t4memo = d4create( &cb, "T4MEMO", test_fields, 0 ) ;
   if ( t4memo == 0 )
      e4severe( e4result, "t4memo.c" ) ;

   d4opt_start( &cb ) ;

   mfield = d4field( t4memo, "MEMO_DAT" ) ;

   for ( i = 0 ; i < 260 ; i++ )
   #ifdef N4OTHER
      binary_out[i] = 65 ;
   #else
      binary_out[i] = (long) 256-i ;
   #endif

   d4display_str( disp,  "        Doing Initial Memo Testing . . .", 1 ) ;
   d4display_str( disp,  "             Block size : ", 1 ) ;
   d4display_num( disp,  (long) block_size, 0 ) ;

   if ( d4append_start( t4memo, 0 ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;
   f4memo_assign_n( mfield, (char *) binary_out, sizeof(binary_out) ) ;
   if ( d4append( t4memo ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;

   if ( d4append_start( t4memo, 0 ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;
   f4memo_assign( mfield, rec_two ) ;
   if ( d4append( t4memo ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;

   #ifndef S4UNIX
      #ifdef S4MDX
         if ( f4memo_check( &t4memo->memo_file ) != 0 )
            e4severe( e4result, "t4memo.c" ) ;
      #endif
   #endif

   if ( d4go( t4memo, 1L ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;

   len = f4memo_len(mfield) ;
   if ( len != sizeof(binary_out) || len != f4memo_len(mfield) )
      e4severe( e4result, "t4memo.c" ) ;

   if ( memcmp( (char *) f4memo_ptr(mfield), (char *) binary_out, len ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;

   if ( d4go(t4memo, 2L) != 0 )
      e4severe( e4result, "t4memo.c" ) ;
   if ( f4memo_len( mfield ) != (unsigned) strlen(rec_two) )
      e4severe( e4result, "t4memo.c" ) ;

   if ( strcmp( f4memo_str( mfield ), rec_two ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;

   if ( d4zap(t4memo, 1L, 2L) < 0 )
      e4severe( e4result, "t4memo.c" ) ;

   #ifndef S4UNIX
      if ( d4memo_compress(t4memo) != 0 )
         e4severe( e4result, "t4memo.c" ) ;
   #endif

   d4display_str( disp,  "        Appending 200 records with memo entries . . .", 1 ) ;
   for ( i = 1; i< 200; i++ )
   {
      if ( d4display_quit( disp ) )
         return 1 ;

      if ( d4append_blank( t4memo ) != 0 )
         e4severe( e4result, "t4memo.c" ) ;

      c4ltoa45( (long) i, buf, i/20 + 2 ) ;
      f4memo_assign_n( mfield, buf, i/20 + 2 ) ;
   }

   d4display_str( disp,  "        Checking Assignments and New Records . . .", 1 ) ;

   #ifndef S4UNIX
      #ifdef S4MDX
         if ( f4memo_check( &t4memo->memo_file ) != 0 )
            e4severe( e4result, "t4memo.c" ) ;
      #endif
   #endif

   for ( i = 1; i< 200; i++ )
   {
      if ( d4display_quit( disp ) )
         return 1 ;

      if ( d4go( t4memo, (long)i ) != 0 )
         e4severe( e4result, "t4memo.c" ) ;
      c4ltoa45( (long) i, buf, i/20 + 2 ) ;

      if ( memcmp( buf, f4memo_ptr(mfield), i/20+2 ) != 0 )
         e4severe( e4result, "t4memo.c" ) ;
   }

   #ifndef S4UNIX
      #ifdef S4MDX
         if ( f4memo_check( &t4memo->memo_file ) != 0 )
            e4severe( e4result, "t4memo.c" ) ;
      #endif
   #endif

   d4display_str( disp,  "        Deleting and Recalling . . .", 1 ) ;

   for ( i = 1; i< 200; i += 2 )
   {
      if ( d4display_quit( disp ) )
         return 1 ;

      if ( d4go( t4memo, (long)i ) != 0 )
         e4severe( e4result, "t4memo.c" ) ;
      d4delete( t4memo ) ;
   }

   for ( i = 101; i< 200; i+= 2 )
   {
      if ( d4display_quit( disp ) )
         return 1 ;

      if ( d4go( t4memo, (long)i ) != 0 )
         e4severe( e4result, "t4memo.c" ) ;
      d4recall( t4memo ) ;
   }

   d4display_str( disp,  "        Packing . . .", 1 ) ;
   d4display_wait( disp ) ;
   if ( d4pack( t4memo ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;

   #ifndef S4UNIX
      if ( d4memo_compress(t4memo) != 0 )
         e4severe( e4result, "t4memo.c" ) ;
   #endif

   if ( d4reccount( t4memo) != 149 )
      e4severe( e4result, "t4memo.c" ) ;

   d4display_str( disp,  "        Checking after Packing . . .", 1 ) ;

   #ifndef S4UNIX
      #ifdef S4MDX
         rc = f4memo_check( &t4memo->memo_file ) ;
         d4display_start() ;
         if ( rc != 0 )
            e4severe( e4result, "t4memo.c" ) ;
      #endif
   #endif

   if ( d4close( t4memo ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;

   d4display_str( disp,  "        Creating new memo file. . .", 1 ) ;
   t4memo = d4create( &cb, "T4MEMO", test_fields, 0 ) ;
   mfield = d4field( t4memo, "MEMO_DAT" ) ;
   if ( t4memo == 0 || mfield == 0 )
      e4severe( e4result, "t4memo.c" ) ;
   e4exit_test(&cb) ;

   if ( f4memo_len ( mfield ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;

   memset( write_data, (int) '1', RW_SIZE ) ;

   d4display_str( disp,  "        Appending Large Records. . .", 1 ) ;

   if ( d4append_start( t4memo, 0 ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;
   f4memo_assign_n( mfield, write_data, RW_SIZE ) ;
   if ( d4append( t4memo ) != 0 )
      e4severe( e4result, "t4memo.c" ) ;
   d4display_str( disp,  "        Appending Record. . .", 1 ) ;
   disp->x = 0 ;

   for ( i=2; i <= 50; i++ )
   {
      if ( d4display_quit( disp ) )
         return 1 ;
      d4display_str( disp,  "        Appending Record. . .", 0 ) ;
      d4display_num( disp,  (long) i, 0 ) ;
      disp->x = 0 ;
      if ( d4append_start( t4memo, 1 ) != 0 )
         e4severe( e4result, "t4memo.c" ) ;
      if ( d4append( t4memo ) != 0 )
         e4severe( e4result, "t4memo.c" ) ;
   }

   d4display_str( disp,  "        Checking Record. . .", 1 ) ;
   disp->x = 0;

   for ( i=1; i <= 50; i++ )
   {
      if ( d4display_quit( disp ) )
         return 1 ;
      d4display_str( disp,  "   Checking Record. . .", 0 ) ;
      d4display_num( disp,  (long) i, 0 ) ;
      if ( d4go( t4memo, (long)i ) != 0 )
         e4severe( e4result, "t4memo.c" ) ;
      if ( memcmp( f4memo_ptr(mfield), write_data, RW_SIZE) != 0 ) 
         e4severe( e4result, "t4memo.c" ) ;

      d4display_str( disp,  "   Replacing Record. . .", 0 ) ;
      d4display_num( disp,  (long) i, 0 ) ;
      disp->x = 0 ;
      f4memo_assign( mfield, "Test" ) ;
   }

   d4display_str( disp,  "        Checking Record (2nd Loop). . .", 1 ) ;
   disp->x = 0 ;

   for ( i=1; i <= 50; i++ )
   {
      if ( d4display_quit( disp ) )
         return 1 ;
      d4display_str( disp,  "        Checking Record (2nd Loop). . .", 0 ) ;
      d4display_num( disp,  (long) i, 0 ) ;
      disp->x = 0 ;
      if ( d4go( t4memo, (long) i ) != 0 )
         e4severe( e4result, "t4memo.c" ) ;
      if ( strcmp( f4memo_str( mfield ), "Test") != 0 ) 
         e4severe( e4result, "t4memo.c" ) ;
   }

   d4display_str( disp,  "        Checking memo file internal integrity . . .", 1 ) ;
   d4display_wait( disp ) ;

   #ifndef S4UNIX
      #ifdef S4MDX
         rc = f4memo_check( &t4memo->memo_file ) ;
         d4display_start() ;
         if ( rc != 0 )
            e4severe( e4result, "t4memo.c" ) ;
      #endif
   #endif

   if ( d4close_all( &cb ) < 0 )
      e4severe( e4result, "t4memo.c" ) ;

   u4free( write_data ) ;
   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *disp )
{
   d4init( &cb ) ;

   if ( do_test( disp, 1024 ) )
      return 1 ;
   if ( do_test( disp, 16384 ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo( &cb ) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check( 100 ) != 0 )
            e4severe( e4result, "t4memo:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int S4FUNCTION t4test( D4DISPLAY *disp )
{                           
   if ( test_with_mem_check( disp ) )
      return 1 ;

   disp->y += 2 ;
   d4display_str( disp, "T4MEMO:   SUCCESS", 1) ;
   d4display_str( disp, "", 1) ;
   return 1 ;
}
