/* t4mul2.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

/* Tests CodeBase multi-user capabilities. */

/*    1.  Erase 't4mul2.dbf', 't4mul2.dbt' and 't4mul2.mdx' */
/*    2.  Run 't4mul2' on one station. */
/*    3.  Run 't4mul2' on a second station. */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif


#include "t4test.h"

#ifdef S4WINDOWS
   /* currently just exclude <conio.h> */
#else
   #ifdef S4UNIX
      #ifdef S4CURSES
/*       #include <curses.h>  */
      #else
/*       #include <tinfo.h>   */
      #endif
   #else
      #include <conio.h>
   #endif
#endif

static FIELD4INFO fields[] =
{
   { "TEST", 'C', 10, 0 },
   { "MEM",  'M', 10, 0 },
   { 0, 0,0,0 },
} ;

static TAG4INFO tags[] =
{
   {  "TAG", "TEST", "", 0, 0 },
   {  0, 0, 0, 0, 0 },
} ;

CODE4 cb;
CODE4 S4PTR *cb_ptr ;
DATA4 S4PTR *t4mul2 ;
INDEX4 S4PTR *index ;
FIELD4 S4PTR *field, S4PTR *mfield ;


static int test_mul2( D4DISPLAY *display, long num_recs )
{
   char buf[11] ;
   int did_create = 1 ;
   long i_rec, r, mfield_info ;

   cb.create_error = 0 ;

   t4mul2 = d4create( cb_ptr, "T4MUL2", fields, tags ) ;
   if ( t4mul2 == 0 )
   {
      did_create = 0 ;
      cb.auto_open = 0 ;

      d4display_str( display,  "Opening Database. . .", 1 ) ;

      t4mul2 = d4open( cb_ptr, "T4MUL2" ) ;
      if ( t4mul2 == 0 )
         e4severe( e4result, "t4mul2.c:  Opening database." ) ;

      if ( (index = i4open( t4mul2, "T4MUL2" ))  == 0 )
         e4severe( e4result, "Opening Index" ) ;
   }

   field = d4field( t4mul2, "TEST" ) ;
   mfield = d4field( t4mul2, "MEM" ) ;

   if ( field == 0 || mfield == 0 )
      e4severe( e4result, "t4mul2.c" ) ;

   d4display_str( display,  "    Record:  ", 1 ) ;

   for ( i_rec = 1L; i_rec <= num_recs; i_rec++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( d4append_start( t4mul2, 0 ) != 0 )
         e4severe( e4result, "t4mul2.c" ) ;

      if ( did_create )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "    Record:  ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
         d4display_str( display,  "     New Value:  ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
         d4display_str( display,  "       ", 0 ) ;
         f4assign_long( field, (long) i_rec ) ;

         c4ltoa45( (long) i_rec, (char S4PTR *) buf, 10 ) ;
         buf[10] = '\0' ;
         f4memo_assign_n( mfield, (char S4PTR *) buf, 10 ) ;
      }
      else
      {
         display->x = (int) 0 ;
         d4display_str( display,  "    Record:  ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
         d4display_str( display,  "       ", 0 ) ;

         f4assign_long( field, (long) num_recs - i_rec ) ;
         c4ltoa45( (long) num_recs - i_rec, (char S4PTR *) buf, 10 ) ;
         buf[10] = '\0' ;
         f4memo_assign_n( mfield, (char S4PTR *) buf, 10 ) ;
      }
      if ( d4append( t4mul2 ) < 0 )
         e4severe( e4result, "t4mul2: d4append()" ) ;

      d4display_str( display, "Before d4unlock()", 1 ) ;

      if ( d4unlock( t4mul2 ) != 0 )
         e4severe( e4result, "t4mul2.c" ) ;
   }

   d4display_str( display,  "        Checking Index File . . .  ", 1 ) ;

   if ( d4check( t4mul2 ) != 0 )
      e4severe( e4result, "d4check()" ) ;

   d4display_str( display,  "        Skipping down File . . .  ", 1 ) ;
   d4display_str( display,  "    Record:  ", 1 ) ;

   for ( r = d4reccount( t4mul2 ); r >= 1; r-- )
   {

      if ( d4display_quit( display ) )
         return 1 ;

      if ( d4go( t4mul2, (long)r ) != 0 )
         e4severe( e4result, "t4mul2.c" ) ;
      display->x = (int) 0 ;
      d4display_str( display,  "    Record:  ", 0 ) ;
      d4display_num( display, r, 0 ) ;
      d4display_str( display,  "       ", 0 ) ;

      mfield_info = c4atol( f4memo_str(mfield), 10 ) ;

      if ( f4long(field) != mfield_info )
         e4severe( e4result, "t4mul2.c" ) ;
   }

   if ( d4close_all( cb_ptr ) != 0 )
      e4severe( e4result, "t4mul2.c" ) ;

   #ifdef S4LOCK_CHECK
      if ( l4lock_check() != 0 )
         e4severe( e4result, "Not everything was unlocked" ) ;
   #endif

   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display, long num_recs )
{
   d4init( cb_ptr ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( test_mul2( display, num_recs ) )
      return 1 ;

   d4init_undo( cb_ptr ) ;

   #ifdef S4DEBUG
      #ifndef S4DLL
         #ifndef S4LOCK_CHECK
            mem4reset() ;
            if ( mem4free_check(100) != 0 )
               e4severe( e4result, "t4mul2.c:  Memory items not freed" ) ;
         #endif
      #endif
   #endif

   return 0 ;
}


int S4FUNCTION t4test( D4DISPLAY *display )
{
   long num_recs = 0 ;

   cb_ptr = &cb ;
   num_recs = atol( d4parsestring_nparm( &display->parse_str ) ) ;
   if ( num_recs <= 0 )
      e4severe( 0, "T4MUL2:  Missing command line parameter(s)" ) ;
  
   d4display_str( display,  "T4MUL2 Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;
   d4display_str( display,  "Number of Recs:   ", 1 ) ;
   d4display_num( display,  (long) num_recs, 0 ) ;
   d4display_str( display,  "", 1 ) ;

   if ( test_with_mem_check( display, num_recs ) )
      e4severe( e4result, "t4mul2.c" ) ;

   display->y += 2 ;
   d4display_str( display, "T4MUL2:   SUCCESS", 1 ) ;
   d4display_str( display, "", 1 ) ;
   return 1 ;
}
