/* t4pack_z.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

/* Tests CodeBase++ Date class. */

#include  "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include  "t4test.h"

static FIELD4INFO field_list[] =
{
   {"NUM", 'N',  11,  2  },
   {"CH ", 'C',  17,  0  },
   {"DT ", 'D',   8,  0  },
   { 0,0,0,0 },
} ;

static TAG4INFO tag_list[] =
{
   { "T_NUM", "NUM", 0, 0, 0 },
   { "T_CH",   "CH", 0, 0, 0 },
   { "T_DT",   "DT", 0, 0, 0 },
   { 0,0,0,0,0 },
} ;

CODE4 cb ;
DATA4  *data ;
FIELD4 *field ;


static int do_test( D4DISPLAY *display, int do_pack, long num_recs, long num_delete, int do_open )
{
   int  rc, i, delete_cycle ;
   char *dt = "19891220" ;
   long index_date, rec_num, l_count, del_rec, start ;

   index_date = date4long( dt ) ;

   cb.safety =  0 ;

   if ( do_open )
      data = d4open( &cb, "T4PACK_Z" ) ;
   else
      data = d4create( &cb, "T4PACK_Z", field_list, tag_list ) ;

   if ( data == 0 )
      e4severe( e4result, "t4pack_z.c" ) ;

   d4opt_start( &cb ) ;

   d4display_str( display,  "        Appending Record:   ", 1 ) ;

   for ( rec_num = 1; rec_num <= num_recs; rec_num++)
   {
      if ( d4display_quit( display ) )  return 1 ;

      if ( rec_num % 50 == 0 )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Appending Record:   ", 0 ) ;
         d4display_num( display, rec_num, 0 ) ;
      }

      if ( d4append_start( data, 0 ) < 0 )
         e4severe( e4result, "t4pack_z - d4append_start()" ) ;

      for ( i= 1 ; i <= d4num_fields( data ) ; i++ )
      {
         field = d4field_j( data, i ) ;
         if ( field == 0 )
            e4severe( e4result, "t4pack_z - d4field()" ) ;

         switch( f4type( field ) )
         {
            case  'N':
               f4assign_double( field, (double) rec_num / 5 ) ;
               break ;
            case  'C':
               f4assign_long( field, rec_num ) ;
               break ;
            case  'D':
               f4assign_long( field, (long)( index_date + rec_num / 3 ) ) ;
               break ;
            default:
               e4severe( e4result, "t4pack_z - f4type() (type shouldn't exist in file)" ) ;
         }
      }

      if ( d4append( data ) < 0 )
         e4severe( e4result, "t4pack_z - d4append()" ) ;
   }

   d4display_str( display,  "  ", 1 ) ;
   d4display_str( display,  "        Checking Index File. . . ", 1 ) ;
   d4display_wait( display ) ;
   rc = d4check( data ) ;
   d4display_start() ;
   if ( rc != 0 )
      e4severe( e4result, "t4pack_z.c - d4check()" ) ;

   delete_cycle = 0L ;

   while ( d4reccount( data ) > 0 )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( d4reccount( data ) != ( num_recs - delete_cycle * num_delete ) )
         e4severe( e4result, "t4pack_z.c - d4reccount()" ) ;

      delete_cycle++ ;

      if ( do_pack )
      {
         d4display_str( display,  "        Packing.  Current Reccount: ", 1 ) ;
         d4display_num( display, (long) d4reccount( data ), 0 ) ;

         for (l_count=1; l_count<=num_delete && l_count<=d4reccount(data); l_count++)
         {
            if ( d4display_quit( display ) )
               return 1 ;

            if ( delete_cycle % 2L == 0L )
               del_rec = l_count ;
            else
               del_rec =  d4reccount( data )+1-l_count ;

            if ( d4go( data, del_rec ) != 0 )
               e4severe( e4result, "t4pack_z.c - d4go()" ) ;

  	       d4delete( data ) ;
         }

         if ( d4pack( data ) != 0 )
            e4severe( e4result, "t4pack_z.c - d4pack()" ) ;
      }
      else
      {
         d4display_str( display,  "        Zapping.  Current Reccount: ", 1 ) ;
         d4display_num( display, (long) d4reccount( data ), 0 ) ;

         if ( delete_cycle % 3L == 0L )
            start =  1L ;
         else
         {
            if ( delete_cycle % 3L == 1L )
               start =  (num_delete+1L)/2 ;
            else
               start =  d4reccount( data ) + 1L - num_delete ;
         }

         if ( ( start + num_delete ) > d4reccount( data ) )
            start = d4reccount( data ) +1L - num_delete ;

         if ( start <= 0L )
            start = 1L ;

         d4display_wait( display ) ;
         rc = d4zap( data, start, start + num_delete - 1  ) ;
         d4display_start() ;
         if ( rc != 0 )
            e4severe( e4result, "t4pack_z.c" ) ;
      }

      d4display_str( display,  "        Checking Index File. . . ", 1 ) ;
      d4display_wait( display ) ;
      rc = d4check( data ) ;
      d4display_start() ;
      if ( rc != 0 )
         e4severe( e4result, "t4pack_z.c" ) ;
   }
   d4close( data );
   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display, long num_recs, long num_delete )
{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( do_test( display, 1, num_recs, num_delete, 0 ) )
      return 1 ;
   if ( do_test( display, 0, num_recs, num_delete, 1 ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo(&cb) ;

      #ifndef S4DLL
	 mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4pack_z:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int  S4FUNCTION t4test( D4DISPLAY *display )
{
   long num_recs = 0 ;
   long num_delete = 0 ;

   num_recs = atol( d4parsestring_nparm( &display->parse_str ) ) ;
   num_delete = atol( d4parsestring_nparm( &display->parse_str ) ) ;

   if ( num_recs <= 0 || num_delete <= 0 )
      e4severe( 0, "T4PACK_Z:  Missing command line parameter(s)" ) ;

   d4display_str( display,  "T4PACK_Z Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;
   d4display_str( display,  "Number of Recs:   ", 1 ) ;
   d4display_num( display,  (long) num_recs, 0 ) ;
   d4display_str( display,  "Number for Deletion:   ", 1 ) ;
   d4display_num( display,  (long) num_delete, 0 ) ;
   d4display_str( display,  "", 1 ) ;

   if ( test_with_mem_check( display, num_recs, num_delete ) )
      e4exit(&cb) ;

   display->y += 2 ;
   d4display_str( display, "T4PACK_Z:   SUCCESS", 1) ;
   d4display_str( display, "", 1) ;
   return 1 ;
}
