/* t4positi.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

/* Tests Code Base 'd4position' routine. */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif
#include "t4test.h"

static FIELD4INFO fields[] =
{
   { "FIELD", 'C', 25, 0 },
   { 0, 0,0,0 },
} ;

static TAG4INFO tags[] =
{
   { "TAG_NAME", "FIELD", "", 0, 0 },
   { 0,0,0, 0, 0 },
} ;

CODE4 cb;
DATA4 *data;
FIELD4 *field ;
TAG4 *tag ;

static int test_position( D4DISPLAY *display ) ;

static int  test_main( D4DISPLAY *display, long num_recs, int do_open )
{
   long on_rec ;

   cb.safety = 0 ;

   if ( do_open )
   {
      data = d4open( &cb, "T4POSITI" ) ;
      d4zap( data, 1L, d4reccount( data ) ) ;
   }
   else
      data = d4create( &cb, "T4POSITI", fields, tags ) ;

   if ( data == 0 )
      e4severe( e4result, "t4positi.c" ) ;

   d4opt_start( &cb ) ;

   field = d4field( data, "FIELD" ) ;
   if ( field == 0 )
      e4severe( e4result, "t4positi.c" ) ;

   d4display_str( display,  "        Writing Record:   ", 1 ) ;

   for ( on_rec = 1;  on_rec <= num_recs; on_rec++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( on_rec % 50 == 0 || on_rec == num_recs )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Writing Record:   ", 0 ) ;
         d4display_num( display, on_rec, 0 ) ;
      }

      if ( d4append_start(data, 0) < 0 )
         e4severe( e4result, "t4positi.c" ) ;

      f4assign_long( field, on_rec ) ;
      if ( d4append(data) < 0 )
         e4severe( e4result, "t4positi.c" ) ;
   }

   if ( d4check( data ) != 0 )
      e4severe( e4result, "t4positi.c" ) ;

   d4tag_select( data, 0 ) ;
   if ( test_position( display ) )
      return 1 ;

   tag = d4tag( data, "TAG_NAME" ) ;
   if ( tag == 0 )
      e4severe( e4result, "t4positi.c" ) ;
   d4tag_select( data, tag ) ;
   if ( test_position( display ) )
      return 1 ;

   if ( d4close_all( &cb ) != 0 )
      e4severe( e4result, "t4positi.c" ) ;
   return 0 ;
}


static int  test_position( D4DISPLAY *display )
{
   long count, r, top_rec, bottom_rec ;
   double pos ;
   double last_pos = -.1 ;

   count = d4reccount( data ) ;

   for ( r = 1L; r <= count; r++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( d4go( data, r ) != 0 )
         e4severe( e4result, "t4positi.c" ) ;

      d4position2( data, &pos ) ;

      if ( pos <= last_pos )
         e4severe( e4result, "t4positi.c" ) ;

      if ( d4position_set( data, pos )  != 0 )
         e4severe( e4result, "t4positi.c" ) ;

      if ( d4recno( data ) != r )
         e4severe( e4result, "t4positi.c" ) ;

      if ( d4recno( data ) != r )
         e4severe( e4result, "t4positi.c" ) ;

      pos = last_pos ;
   }

   /* EOF, BOF testing */
   if ( d4top( data )  != 0 )
      e4severe( e4result, "t4positi.c" ) ;
   top_rec = d4recno( data ) ;

   if ( d4position_set( data, 0.0 ) != 0 )
      e4severe( e4result, "t4positi.c" ) ;
   if ( top_rec != d4recno( data ) )
      e4severe( e4result, "t4positi.c" ) ;

   if ( d4bottom( data )  != 0 )
      e4severe( e4result, "t4positi.c" ) ;
   bottom_rec = d4recno( data ) ;

   if ( d4position_set( data, 1.0 ) != 0 )
      e4severe( e4result, "t4positi.c" ) ;
   if ( bottom_rec != d4recno( data ) )
      e4severe( e4result, "t4positi.c" ) ;

   if ( d4skip( data, 1L ) != r4eof )
      e4severe( e4result, "t4positi.c" ) ;

   d4position2( data, &pos );
   if ( pos <= 1.0 )
      e4severe( e4result, "t4positi.c" ) ;

   if ( d4position_set( data, 1.1 ) != r4eof )
      e4severe( e4result, "t4positi.c" ) ;

   if ( ! d4eof( data ) )
      e4severe( e4result, "t4positi.c" ) ;

   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display, long num_recs )
{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( test_main( display, num_recs, 0 ) )
      return 1 ;
   if ( test_main( display, num_recs, 1 ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo(&cb) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4positi.c:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int S4FUNCTION t4test( D4DISPLAY *display )
{
   #ifdef S4CLIPPER
      d4display_str( display,  "T4POSITI: not for CLIPPER format ", 1 ) ;
      return 0 ;
   #else
      long num_recs = 0 ;
   
      num_recs = atol( d4parsestring_nparm( &display->parse_str ) ) ;
      if ( num_recs <= 0 )
         e4severe( 0, "T4POSITI:  Missing command line parameter(s)" ) ;
   
      d4display_str( display,  "T4POSITION Test  ", 1 ) ;
      d4display_str( display,  " ", 1 ) ;
      d4display_str( display,  "Number of Recs:   ", 1 ) ;
      d4display_num( display,  (long) num_recs, 0 ) ;
      d4display_str( display,  "", 1 ) ;
   
      if ( test_with_mem_check( display, num_recs ) )
         e4severe( e4result, "t4positi.c" ) ;
   
      display->y += 2 ;
      d4display_str( display, "T4POSITION:   SUCCESS", 1) ;
      d4display_str( display, "", 1) ;
      return 1 ;
   #endif
}
