/* t4seek.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

/* Tests CodeBase d4seek() function. */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include "t4test.h"

static FIELD4INFO fields[] =
{
   { "FIELD", 'C', 25, 0 },
   { 0, 0,0,0 },
} ;

static FIELD4INFO fields2[] =
{
   { "FIELD1", 'C', 5, 0 },
   { "FIELD2", 'C', 4, 0 },
   { 0, 0,0,0 },
} ;

static TAG4INFO tags[] =
{
   { "TAG_NAME", "FIELD", "", 0, 0 },
   { 0,0,0, 0, 0 },
} ;

static TAG4INFO tags2[] =
{
   #ifndef N4OTHER
      { "TAG_NAME", "FIELD1+FIELD2", ".NOT. DELETED()", 0, 0 },
   #else
      { "TAG_NAME", "FIELD1+FIELD2", "", 0, 0 },
   #endif
   { "TAG2", "FIELD1", "", 0, 0 },
   { 0,0,0, 0, 0 },
} ;

CODE4 cb;
DATA4 *data;
INDEX4 *index ;
FIELD4 *field, *field1, *field2 ;


static long power( long val, long p )
{
   long r ;

   r = 1L ;

   while ( --p >= 0 )
      r *= val ;

   return r ;
}

static void do_seek( DATA4 *data )
{
   int i ;
   i = d4seek( data, "  " ) ;
   if ( (d4recno(data) != 3) ||  (i != 0) )
      e4severe( e4result, "d4seek()" ) ;

   i = d4seek( data, "  1  222 " ) ;
   if ( (d4recno(data) != 2) ||  (i != 0) )
      e4severe( e4result, "d4seek()" ) ;

   i = d4seek( data, "  1  222 " ) ;
   if ( (d4recno(data) != 2) ||  (i != 0) )
      e4severe( e4result, "d4seek()" ) ;

   i = d4seek( data, "123456789" ) ;
   if ( (d4recno(data) != 7) ||  (i != 0) )
      e4severe( e4result, "d4seek()" ) ;

   /* do some 'not found' seeks */
   i = d4seek( data, " 1      2" ) ;
   if ( (d4recno(data) != 8) ||  (i != r4after) )
      e4severe( e4result, "d4seek()" ) ;

   i = d4seek( data, "     111 " ) ;
   if ( (d4recno(data) != 1) ||  (i != r4after) )
      e4severe( e4result, "d4seek()" ) ;

   i = d4seek( data, "123456799" ) ;
   if ( (d4recno(data) != 13) ||  (i != r4eof) )
      e4severe( e4result, "d4seek()" ) ;
}

static int  test_seek( D4DISPLAY *display, long left )
{
   long num_digits, num_recs, on_rec, i ;
   long limit, extra ;
   int  rc ;
   unsigned on_digits ;
   char buff[200] ;

   cb.safety = 0 ;

   data = d4create( &cb, "T4SEEK", fields, 0 ) ;
   if ( data == 0 )
      e4severe( e4result, "t4seek.c" ) ;

   d4opt_start( &cb ) ;

   for ( num_digits = 0; left> 0; num_digits++ )
      left /= 10 ;

   if ( num_digits <= 0 )  num_digits = 1 ;

   for ( num_recs = 10, i=1; i< num_digits; i++ )
      num_recs  *= 10 ;

   num_recs-- ;

   if ( num_digits > fields[0].len )
      e4severe( e4result, "t4seek.c" ) ;

   field = d4field( data, "FIELD" ) ;
   if ( field == 0 )
      e4severe( e4result, "t4seek.c" ) ;

   d4display_str( display,  "        Writing Record:   ", 1 ) ;

   for ( on_rec = 1 ; on_rec <= num_recs ; on_rec++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( on_rec % 50 == 0 || on_rec == num_recs )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Writing Record:   ", 0 ) ;
         d4display_num( display, on_rec, 0 ) ;
      }

      if ( d4append_start( data, 0 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      c4ltoa45( (long) on_rec, buff, (int) -num_digits ) ;
      f4assign_n( field, buff, (int) num_digits ) ;
      if ( d4append( data ) < 0 )
         e4severe( e4result, "t4positi.c" ) ;
   }

   d4display_str( display,  "        Indexing . . .    ", 1 ) ;
   index = i4create( data, "T4SEEK", tags ) ;

   if ( index == 0 )
      e4severe( e4result, "t4seek.c" ) ;

   for ( on_digits = 1; on_digits <= (unsigned)num_digits; on_digits++ )
   {
      limit  = power( 10L, on_digits ) ;
      extra  = power( 10L, num_digits-on_digits ) ;
      d4display_str( display,  " Seeking Value:   ", 1 ) ;
      display->x = 0;

      for ( i=0; i< limit; i++ )
      {
         if ( d4display_quit( display ) )  return 1 ;

         c4ltoa45( (long) i, buff, (int) -on_digits ) ;
         buff[on_digits] = '\0' ;

         d4display_str( display,  " Seeking Value:   ", 0 ) ;
         d4display_num( display, i, 0 ) ;

         rc = d4seek( data, buff ) ;
         d4display_str( display,  "      Record:   ", 0 ) ;
         d4display_num( display, d4recno( data ), 0 ) ;
         display->x = 0;

         if ( rc != 0 )
         {
            if ( rc != r4after || d4recno( data ) != 1 )
               e4severe( e4result, "t4seek.c" ) ;
         }
         if ( d4recno( data ) != i*extra && d4recno( data ) != 1 )
            e4severe( e4result, "t4seek.c" ) ;
      }
   }

   if ( d4close_all( &cb ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   cb.safety = 0 ;

   d4display_str( display,  "T4SEEK Test: Part TWO  \n", 1 ) ;

   data = d4create( &cb, "T4SEEK2", fields2, tags2 ) ;
   if ( data == 0 )
      e4severe( e4result, "t4seek.c" ) ;

   field1 = d4field( data, "FIELD1" ) ;     /* assign pointers to fields */
   field2 = d4field( data, "FIELD2" ) ;     /* assign pointers to fields */
   if ( field1 == 0 || field2 == 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, "   " ) ;
   f4assign( field2, "1111" ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, "  1" ) ;
   f4assign( field2, "222" ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, "   " ) ;
   f4assign( field2, "   " ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, " 1 " ) ;
   f4assign( field2, "223" ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, " 1 " ) ;
   f4assign( field2, "    " ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, " 1 " ) ;
   f4assign( field2, "224" ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, "12345" ) ;
   f4assign( field2, "6789" ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, " 1 " ) ;
   f4assign( field2, "   3" ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, "   " ) ;
   f4assign( field2, " 111" ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, " 3 " ) ;
   f4assign( field2, "333" ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, "    1" ) ;
   f4assign( field2, "7777" ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   if ( d4append_start( data, 0 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   f4assign( field1, " 1 " ) ;
   f4assign( field2, "333" ) ;
   if ( d4append( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;

   d4tag_select( data, d4tag_default( data ) ) ;

   /* do some basic checks on database to ensure tag order is correct */
   if ( d4top( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   if ( memcmp( f4ptr(field2), "    ", 4 ) )
      e4severe( e4result, "d4top()" ) ;

   if ( d4skip( data, 4 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   if ( memcmp( f4ptr(field2), "222 ", 4 ) )
      e4severe( e4result, "d4go()" ) ;

   if ( d4skip( data, 5 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   if ( memcmp( f4ptr(field2), "333 ", 4 ) )
      e4severe( e4result, "d4skip()" ) ;

   if ( d4skip( data, -4 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   if ( memcmp( f4ptr(field2), "    ", 4 ) )
      e4severe( e4result, "d4skip()" ) ;

   d4delete( data ) ;

   if ( d4skip( data, -2 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   if ( memcmp( f4ptr(field2), "7777", 4 ) )
      e4severe( e4result, "d4skip()" ) ;

   if ( d4skip( data, 2 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   #ifndef N4OTHER
      if ( memcmp( f4ptr(field2), "   3", 4 ) )
   #else
      if ( memcmp( f4ptr(field2), "    ", 4 ) )
   #endif
      e4severe( e4result, "d4skip()" ) ;

   if ( d4go( data, 7 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   if ( memcmp( f4ptr(field2), "6789", 4 ) )
      e4severe( e4result, "d4go()" ) ;

   if ( d4skip( data, 1 ) != r4eof )
      e4severe( e4result, "t4seek.c" ) ;
   if ( (d4recno(data) != d4reccount(data)+1) ||  (!d4eof(data)) )
      e4severe( e4result, "d4eof()" ) ;

   if ( d4top( data ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   if (d4recno(data) != 3)
      e4severe( e4result, "d4top()" ) ;

   if ( d4skip( data, -1 ) != r4bof )
      e4severe( e4result, "d4eof()" ) ;

   /* test seeking */
   do_seek( data ) ;

   if ( d4go( data, 4 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   d4delete( data ) ;
   if ( d4go( data, 9 ) != 0 )
      e4severe( e4result, "t4seek.c" ) ;
   d4delete( data ) ;

   #ifndef N4OTHER
      do_seek( data ) ;
   
      i = d4seek( data, " 1   223 " ) ;
      if ( (d4recno(data) != 6) ||  (i != r4after) )
         e4severe( e4result, "d4seek()" ) ;
   
      i = d4seek( data, "      111" ) ;
      if ( (d4recno(data) != 1) ||  (i != r4after) )
         e4severe( e4result, "d4seek()" ) ;
   
      /* delete all records so tag is empty */
      if ( d4bottom( data ) != 0 )
         e4severe( e4result, "d4seek()" ) ;
      for ( ;; )
      {
         if ( d4eof( data ) )
            break ;
         d4delete( data ) ;
         if ( d4skip( data, -1L ) < 0 )
            e4severe( e4result, "d4seek()" ) ;
      }

           /* check empty tag */
      if ( d4go( data, 4 ) != 0 )
         e4severe( e4result, "d4seek()" ) ;
      if ( d4skip( data, -1 ) != r4eof )
         e4severe( e4result, "d4seek()" ) ;
      if ( (d4recno(data) != d4reccount(data)+1) ||  (!d4eof(data)) || (!d4bof(data)) )
         e4severe( e4result, "d4eof()" ) ;
      if ( d4go( data, 6 ) != 0 )
         e4severe( e4result, "d4seek()" ) ;
      if ( d4skip( data, 1 ) != r4eof )
         e4severe( e4result, "d4seek()" ) ;
      if ( (d4recno(data) != d4reccount(data)+1) ||  (!d4eof(data)) || (!d4bof(data)) )
         e4severe( e4result, "d4eof()" ) ;
      if ( d4seek( data, " 1   333 " ) != r4eof )
         e4severe( e4result, "d4eof()" ) ;
   
      /* recall one record */
      if ( d4go( data, 6 ) != 0 )
         e4severe( e4result, "d4seek()" ) ;
      d4recall( data ) ;
   
      if ( d4go( data, 2 ) != 0 )
         e4severe( e4result, "d4seek()" ) ;
      if ( d4skip( data, -1 ) != r4bof )
         e4severe( e4result, "d4seek()" ) ;
      if ( (d4recno(data) != 6)  ||  (!d4bof(data)) )
         e4severe( e4result, "d4bof()" ) ;
      if ( d4go( data, 8 ) != 0 )
         e4severe( e4result, "d4seek()" ) ;
      if ( d4skip( data, 1 ) != 0 )
         e4severe( e4result, "d4seek()" ) ;
      if ( (d4recno(data) != 6) ||  (d4eof(data)) || (d4bof(data)) )
         e4severe( e4result, "d4eof()" ) ;
      if ( d4skip( data, 1 ) != r4eof )
         e4severe( e4result, "d4seek()" ) ;
      if ( (d4recno(data) != d4reccount(data)+1) ||  (!d4eof(data)) || (d4bof(data)) )
         e4severe( e4result, "d4eof()" ) ;
   
      if ( d4seek( data, " 1   224 " ) != 0 )
         e4severe( e4result, "d4eof()" ) ;

      if ( d4check( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      d4tag_select( data, d4tag( data, "TAG2" ) ) ;

      if ( d4append_start( data, 0 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      f4assign( field1, "ZZZZZ" ) ;
      if ( d4append( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4check( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4append_start( data, 0 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      f4assign( field1, "YYYYY" ) ;
      if ( d4append( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4check( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4append_start( data, 0 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      f4assign( field1, "VVVVV" ) ;
      if ( d4append( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4check( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4append_start( data, 0 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      f4assign( field1, "XXXXX" ) ;
      if ( d4append( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4check( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4bottom( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      if ( memcmp( f4str( field1 ), "ZZZZZ", 5 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      f4assign( field1, "VVVVV" ) ;

      if ( d4check( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4bottom( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      if ( memcmp( f4str( field1 ), "YYYYY", 5 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      f4assign( field1, "VVVVV" ) ;

      if ( d4check( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4bottom( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      if ( memcmp( f4str( field1 ), "XXXXX", 5 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      f4assign( field1, "VVVVV" ) ;

      if ( d4check( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4append_start( data, 0 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      f4assign( field1, "AAAAA" ) ;
      if ( d4append( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4append_start( data, 0 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      f4assign( field1, "AA  B" ) ;
      if ( d4append( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4seek( data, "AA " ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
      if ( memcmp( f4str( field1 ), "AA  B", 5 ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;

      if ( d4check( data ) != 0 )
         e4severe( e4result, "t4seek.c" ) ;
   #endif

   if ( d4close_all( &cb ) != 0 )
      e4severe( e4result, "d4seek()" ) ;
   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display, long left )
{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( test_seek( display, left ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo(&cb) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4seek.c:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int S4FUNCTION t4test( D4DISPLAY *display )
{
   long left = 100 ;

   left = atol( d4parsestring_nparm( &display->parse_str ) ) ;
   if ( left <= 0 )
      e4severe( e4result, "T4SEEK:  Missing command line parameter(s)" ) ;

   d4display_str( display,  "T4SEEK Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;
   d4display_str( display,  "Number of Recs:   ", 1 ) ;
   d4display_num( display,  (long) left, 0 ) ;
   d4display_str( display,  "", 1 ) ;

   if ( test_with_mem_check( display, left ) )
      e4severe( e4result, "d4seek()" ) ;

   display->y += 2 ;
   d4display_str( display, "T4SEEK:   SUCCESS", 1) ;
   d4display_str( display, "", 1) ;
   return 1 ;
}
