/* t4sort2.c   (c)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */
/* Tests sorting. */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif
#include "t4test.h"

CODE4 cb;
DATA4 *data;
SORT4 sort ;

int  S4CALL my_cmp( S4CMP_PARM a, S4CMP_PARM b, size_t c )
{
   return memcmp( a, b, c ) ;
}

static int test_sort( D4DISPLAY *display, long num_sort )
{
   char sort_val[7] ;
   long i_rec ;
   long sort_record_no ;
   char *other_ptr ;
   char *data_ptr ;
   int rc ;

   /* sort4init() must be called before sort4put(). */
   /* The sort data length is one; there is no extra data */
   if ( sort4init( &sort, &cb, 6, 0 ) != 0 )
      e4severe( e4result, "t4sort2.c" ) ;

   /* re-assign the sort function: */
   sort4assign_cmp( &sort, my_cmp ) ;

   d4display_str( display,  "        Putting Item:   ", 1 ) ;

   for ( i_rec = 1; i_rec <= num_sort; i_rec++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( i_rec % 2000 == 0 || i_rec == num_sort )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Putting Item:   ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
      }

      c4ltoa45( i_rec, sort_val, 6 ) ;
      sort_val[6] = '\0' ;

      if ( sort4put( &sort, i_rec, sort_val, "" ) != 0 )
         e4severe( e4result, "t4sort2.c" ) ;
   }

   /* Specify that there will be no more calls to sort4put() */ 

   d4display_str( display,  "        Initializing for gets . . .   ", 1 ) ;

   if ( sort4get_init( &sort ) < 0 )
      e4severe( e4result, "t4sort2.c" ) ;

   for ( i_rec = 1; i_rec <= num_sort; i_rec++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( i_rec % 2000 == 0 || i_rec == num_sort )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Getting Item:   ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
      }

      rc = sort4get( &sort, &sort_record_no, (void **) &data_ptr, (void **) &other_ptr ) ;
      if ( rc < 0 )
         e4severe( e4result, "t4sort2.c" ) ;

      c4ltoa45( i_rec, sort_val, 6 ) ;

      if ( strncmp( data_ptr, sort_val, 6) != 0 )
         e4severe( e4result, "t4sort2.c" ) ;

      if ( sort_record_no != i_rec )
         e4severe( e4result, "t4sort2.c" ) ;
   }

   rc = sort4get( &sort, &sort_record_no, (void **) &data_ptr, (void **) &other_ptr ) ;
   if ( rc < 0 )
      e4severe( e4result, "t4sort2.c" ) ;

   if ( d4close_all( &cb ) != 0 )
      e4severe( e4result, "t4sort2.c" ) ;
   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display, long num_sort )
{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   cb.hInst = display->hInst ;

   if ( test_sort( display, num_sort ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4sort2.c:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}


int  S4FUNCTION t4test( D4DISPLAY *display )
{
   long num_sort = 0 ;

   num_sort = atol( d4parsestring_nparm( &display->parse_str ) ) ;
   if ( num_sort <= 0 )
      num_sort = 70000L ;

   d4display_str( display,  "T4SORT2 Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;
   d4display_str( display,  "Number to Sort:   ", 1 ) ;
   d4display_num( display,  (long) num_sort, 0 ) ;
   d4display_str( display,  "", 1 ) ;

   if ( test_with_mem_check( display, num_sort ) )
      e4severe( e4result, "t4sort2.c" ) ;

   display->y += 2 ;
   d4display_str( display, "T4SORT2:   SUCCESS", 1) ;
   d4display_str( display, "", 1) ;
   return 1 ;
}
