/* t4unique.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

#include "d4all.h"
#include "t4test.h"

CODE4   cb;
DATA4  *data;
FIELD4 *c_field ;
TAG4   *tag ;

static FIELD4INFO fields[] =
{
   { "C_FIELD", 'C', 8, 0 },
   { 0, 0,0,0 },
} ;

static TAG4INFO tags[] =
{
   { "C_TAG", "C_FIELD", "", r4unique, 0 },
   { 0,0,0, 0, 0 },
} ;

static int  test_unique( D4DISPLAY *display )
{
   long r ;

   cb.skip_error =  0 ;
   cb.safety =  0 ;

   d4display_str( display,  "        Creating T4UNIQUE...  ", 1 ) ;
   data = d4create( &cb, "T4UNIQUE", fields, tags ) ;
   if ( data == 0 )
      e4severe( e4result, "t4positi.c" ) ;

   d4opt_start( &cb ) ;

   c_field =  d4field( data, "C_FIELD" ) ;
   if ( c_field == 0 )
      e4severe( e4result, "t4uniq2:  d4field()" ) ;

   for ( r = 1; r <= 10; r++ )
   {
      if ( d4append_start( data, 0 ) < 0 )
         e4severe( e4result, "t4unique.c - d4append_start()" ) ;
      f4assign_long( c_field, r ) ;
      if ( d4append( data ) < 0 )
         e4severe( e4result, "t4unique.c - d4append()" ) ;
   }

   if ( d4append_start( data, 0 ) < 0 )
      e4severe( e4result, "t4unique.c - d4append_start()" ) ;
   f4assign_long( c_field, 1 ) ;
   if ( d4append( data ) != r4unique )
      e4severe( e4result, "t4unique.c - d4append()" ) ;

   if ( d4check( data ) != 0 )
      e4severe( e4result, "t4unique.c - d4check()" ) ;

   if ( d4pack( data ) != 0 )
      e4severe( e4result, "t4unique.c - d4pack()" ) ;

   if ( d4check( data ) != 0 )
      e4severe( e4result, "t4unique.c - d4check()" ) ;

   if ( d4append_start( data, 0 ) < 0 )
      e4severe( e4result, "t4unique.c - d4append_start()" ) ;
   f4assign_long( c_field, 1 ) ;
   if ( d4append( data ) != r4unique )
      e4severe( e4result, "t4unique.c - d4append()" ) ;

   if ( d4check( data ) != 0 )
      e4severe( e4result, "t4unique.c - d4check()" ) ;

   if ( d4close_all( &cb ) != 0 )
      e4severe( e4result, "t4unique.c - d4close_all()" ) ;
   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display )
{
   d4init( &cb ) ;
   if ( test_unique( display ) )
      return 1 ;
   d4init_undo( &cb ) ;
   return 0 ;
}


int  S4FUNCTION t4test( D4DISPLAY *display )
{
   if ( test_with_mem_check( display ) )
      e4exit(&cb) ;
   return 1 ;
}
