/* t4unique.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

/* Tests CodeBase unique entry code. */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include "t4test.h"

CODE4   cb;
DATA4  *data, *data2;
FIELD4 *c_field, *d_field, *n_field, *num, *char1, *char2 ;
TAG4   *tag ;
int count = 9 ;

static FIELD4INFO fields[] =
{
   { "N_FIELD", 'N', 8, 0 },
   { "C_FIELD", 'C', 8, 0 },
   { "D_FIELD", 'D', 8, 0 },
   { 0, 0,0,0 },
} ;

static TAG4INFO tags[] =
{
   #ifdef N4OTHER
      { "N_TAG", "N_FIELD", "", r4unique_continue, 0 },
      { "C_TAG", "C_FIELD", "", r4unique_continue, 0 },
      { "D_TAG", "D_FIELD", "", r4unique_continue, 0 },
   #else
      { "N_TAG", "N_FIELD", "", r4unique_continue, r4descending },
      { "C_TAG", "C_FIELD", "", r4unique_continue, r4descending },
      { "D_TAG", "D_FIELD", "", r4unique_continue, r4descending },
   #endif
   { 0,0,0, 0, 0 },
} ;

static FIELD4INFO fields2[] =
{
   { "NUM", 'N', 8, 0 },
   { "CHAR1", 'C', 8, 0 },
   { "CHAR2", 'C', 8, 0 },
   { 0, 0,0,0 },
} ;

static TAG4INFO tags2[] =
{
   { "TAG1", "NUM", "", r4unique_continue, 0 },
   { "TAG2", "NUM", "", r4unique, 0 },

   { "TAG3", "NUM", ".NOT. DELETED()", r4unique_continue, 0 },
   { "TAG4", "NUM", ".NOT. DELETED()", r4unique, 0 },

   { "TAG5", "CHAR1", "", r4unique_continue, 0 },
   { "TAG6", "CHAR1", "", r4unique, 0 },

   { "TAG7", "CHAR1", ".NOT. DELETED()", r4unique_continue, 0 },
   { "TAG8", "CHAR1", ".NOT. DELETED()", r4unique, 0 },

   { "TAG9", "CHAR1+CHAR2", "", r4unique_continue, 0 },
   { "TAG10", "CHAR1+CHAR2", "", r4unique, 0 },

   { "TAG11", "CHAR1+CHAR2", ".NOT. DELETED()", r4unique_continue, 0 },
   { "TAG12", "CHAR1+CHAR2", ".NOT. DELETED()", r4unique, 0 },
   { 0,0,0, 0, 0 },
} ;

static int test_tag( D4DISPLAY *display )
{
   #ifdef N4OTHER
      long r = 1 ;
   #else
      long r = 9 ;
   #endif

   if ( d4top( data ) != 0 )
      e4severe( e4result, "t4unique:  d4top" ) ;
   for ( ;; )
   {
      if ( d4eof( data ) )
         break ;
      if ( d4display_quit( display ) )
         return 1 ;

      if ( d4recno( data ) != r )
         e4severe( e4result, "t4unique.c" ) ;

      #ifdef N4OTHER
         r += 2 ;
      #else
         r -= 2 ;
      #endif
      if ( d4skip( data, 1L ) < 0 )
         e4severe( e4result, "t4unique:  d4skip" ) ;
   }

   if ( d4go( data, 2L ) != 0 )
      e4severe( e4result, "t4unique:  d4go" ) ;

   #ifndef N4OTHER
      if ( d4skip( data, 2L ) != r4eof )
   #else
      if ( d4skip( data, 5 ) != r4eof )
   #endif
      e4severe( e4result, "t4unique.c" ) ;

   return 0 ;
}

static int test_unique( D4DISPLAY *display, int do_open )
{
   long start_date, r ;
   char hold[10] ;
   start_date =  date4long( "19800101" ) ;

   cb.skip_error =  0 ;
   cb.safety =  0 ;

   if (do_open)
   {
      data = d4open( &cb, "T4UNIQUE" ) ;
      d4zap( data, 1L, d4reccount(data) ) ;
   }
   else
      data = d4create( &cb, "T4UNIQUE", fields, tags ) ;

   if ( data == 0 )
      e4severe( e4result, "t4positi.c" ) ;

   d4opt_start( &cb ) ;

   c_field = d4field( data, "C_FIELD" ) ;
   d_field = d4field( data, "D_FIELD" ) ;
   n_field = d4field( data, "N_FIELD" ) ;
   if ( c_field == 0 || d_field == 0 || n_field == 0 )
      e4severe( e4result, "t4unique:  d4field()" ) ;

   for ( r = 1; r <= 10; r++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( d4append_start(data, 0) < 0 )
         e4severe( e4result, "t4unique.c" ) ;

      f4assign_long( n_field, (r+1)/2 ) ;
      f4assign_long( c_field, (r+1)/2 ) ;
      f4assign_long( d_field, start_date + (r+1)/2 ) ;

      if ( d4append(data) < 0 )
         e4severe( e4result, "t4unique.c" ) ;
   }

   d4display_str( display,  "Testing using tags . . . ", 1 ) ;

   tag = d4tag( data, "N_TAG" ) ;
   if ( tag == 0 )
      e4severe( e4result, "t4unique:  d4tag()" ) ;
   d4tag_select( data, tag ) ;
   if ( test_tag( display ) )
      return 1 ;

   if ( d4seek_double( data, 2.0 ) != 0 )
      e4severe( e4result, "t4unique.c" ) ;
   if ( d4recno( data ) != 3 )
      e4severe( e4result, "t4unique.c" ) ;

   tag = d4tag( data, "D_TAG" ) ;
   if ( tag == 0 )
      e4severe( e4result, "t4unique:  d4tag()" ) ;
   d4tag_select( data, tag ) ;
   if ( test_tag( display ) )
      return 1 ;

   tag = d4tag( data, "C_TAG" ) ;
   if ( tag == 0 )
      e4severe( e4result, "t4unique:  d4tag()" ) ;
   d4tag_select( data, tag ) ;
   if ( test_tag( display ) )
      return 1 ;

   if ( d4reindex( data ) != 0 )
      e4severe( e4result, "t4unique:  d4reindex()" ) ;

   tag = d4tag( data, "N_TAG" ) ;
   if ( tag == 0 )
      e4severe( e4result, "t4unique:  d4tag()" ) ;
   d4tag_select( data, tag ) ;
   if ( test_tag( display ) )
      return 1 ;

   tag = d4tag( data, "D_TAG" ) ;
   if ( tag == 0 )
      e4severe( e4result, "t4unique:  d4tag()" ) ;
   d4tag_select( data, tag ) ;
   if ( test_tag( display ) )
      return 1 ;

   tag = d4tag( data, "C_TAG" ) ;
   if ( tag == 0 )
      e4severe( e4result, "t4unique:  d4tag()" ) ;
   d4tag_select( data, tag ) ;
   if ( test_tag( display ) )
      return 1 ;

   #ifndef N4OTHER
      if (do_open)
      {
         data2 = d4open( &cb, "T4UNIQU2" ) ;
         if ( data2 == 0 )
            e4severe( e4result, "t4unique:  d4open()" ) ;

         for ( r = 0, tag = 0; r < 6; r++ ) /* set every second tag.unique_error to r4unique */
         {
            tag = d4tag_next( data2 , d4tag_next( data2, tag ) ) ;
            if ( tag == 0 )
               e4severe( e4result, "t4unique:  d4tag()" ) ;
            tag->unique_error = r4unique ;
         }

         if ( d4zap( data2, 6L, d4reccount( data2 ) ) != 0 ) /* delete half the records */
            e4severe( e4result, "t4unique:  d4zap()" ) ;
         count -= 5 ;       /* set count so that append adds zapped records back */
         if ( d4check( data2 ) != 0 )
            e4severe( e4result, "t4unique:  d4check()" ) ;
      }
      else
      {
         d4display_str( display,  "T4UNIQUE: Part two . . . ", 1 ) ;
         data2 = d4create( &cb, "T4UNIQU2", fields2, tags2 ) ;
         if ( data2 == 0 )
            e4severe( e4result, "t4unique:  d4open()" ) ;
      }

      num = d4field( data2, "NUM" ) ;
      char1 =  d4field( data2, "CHAR1" ) ;
      char2 =  d4field( data2, "CHAR2" ) ;
      if ( num == 0 || char1 == 0 || char2 == 0 )
         e4severe( e4result, "t4unique:  d4field()" ) ;

      for ( r = count; r >= 0; r-- )
      {
         if ( d4display_quit( display ) )
            return 1 ;

         if ( d4append_start( data2, 0) < 0 )
            e4severe( e4result, "t4unique.c: d4append_start()" ) ;

         f4assign_long( num, (r*100000+24689) ) ;
         c4ltoa45( (r*100000+24689), hold, 8 ) ;
         f4assign( char1, hold ) ;
         c4ltoa45( (r*100000+24689), hold, 8 ) ;
         f4assign( char2, hold ) ;

         if ( d4append( data2 ) < 0 )
            e4severe( e4result, "t4unique.c: d4append()" ) ;
      }

      if ( d4check( data2 ) != 0 )
         e4severe( e4result, "t4unique:  d4check()" ) ;

      tag = d4tag( data2, "TAG6" ) ;
      if ( tag == 0 )
         e4severe( e4result, "t4unique:  d4tag()" ) ;
      d4tag_select( data2, tag ) ;

      if ( d4go( data2, 2L ) != 0 )
         e4severe( e4result, "t4unique:  d4go()" ) ;
      f4assign( char1, "  724689" ) ;     /* create non-unique key situation */
      if ( d4flush( data2 ) != r4unique )
           e4severe( e4result, "t4unique.c: d4flush()" ) ;
      data2->record_changed = 0 ; /* replace with d4abort_change */

      if ( d4seek( data2, "  824689" ) )  /* check that no change made to tag */
         e4severe( e4result, "t4unique.c: d4seek()" ) ;

      if ( memcmp( f4ptr( char1 ), "  824689", 8 ) ) /* check record unchanged */
         e4severe( e4result, "t4unique.c: f4ptr()" ) ;

      if ( d4check( data2 ) != 0 )
         e4severe( e4result, "t4unique:  d4check()" ) ;

      tag = d4tag( data2, "TAG2" ) ; /* check that previous tags not updated */
      if ( tag == 0 )
         e4severe( e4result, "t4unique:  d4tag()" ) ;
      d4tag_select( data2, tag ) ;
      if ( d4seek_double( data2, 724689.0 ) )
         e4severe( e4result, "t4unique.c: d4seek_double()" ) ;

      if ( d4append_start( data2, 0 ) != 0 )
         e4severe( e4result, "t4unique.c: d4append_start()" ) ;
      f4assign_long( num, 99999999 ) ;
      f4assign( char1, "99999999" ) ;
      f4assign( char2, "99999999" ) ;
      if ( d4append_start( data2, 0 ) != 0 )
         e4severe( e4result, "t4unique.c: d4append_start()" ) ;
      if ( d4flush( data2 ) != 0 )
         e4severe( e4result, "t4unique.c: d4flush()" ) ;

      if ( d4seek_double( data2, 99999999.0 ) != r4eof )  /* check that no change made to tag */
         e4severe( e4result, "t4unique.c: d4seek_double() not r4eof" ) ;

      if ( d4check( data2 ) != 0 )
         e4severe( e4result, "t4unique:  d4check()" ) ;
   #endif

   if ( d4close_all( &cb ) < 0 )
      e4severe( e4result, "t4skip:  d4close_all()" ) ;
   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display )
{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( test_unique( display, 0 ) )
      return 1 ;
   if ( test_unique( display, 1 ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo(&cb) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4unique.c:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}


int  S4FUNCTION t4test( D4DISPLAY *display )
{
   d4display_str( display,  "T4UNIQUE Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;

   if ( test_with_mem_check( display ) )
      e4exit(&cb) ;

   display->y += 2 ;
   d4display_str( display, "T4UNIQUE:   SUCCESS", 1) ;
   return 1 ;
}
