/* t4write2.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved.

   Tests Code Base 'd4seek()' and 'd4write()' routines.

   1.  Create databases 't4test.dbf' and 't4test.mdx'.

   2.  Write 'n' records with even values
       2*reccount - 2*n
       Ex.  For 5 records      8, 6, 4, 2, 0
       

   3.  Seek for a record which has not yet been searched for.
       Write corresponding Odd Value.   2*n-1
       Ex.  For 5 records   1, 3, 5, 7, 9

   4.  Check the index file.
*/

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif

#include "t4test.h"

CODE4 cb;
DATA4 *data;
FIELD4 *field ;
TAG4 *tag ;

static FIELD4INFO fields[] =
{
   { "TEST", 'C', 10, 0 },
   { 0,0,0,0 },
} ;

static TAG4INFO tags[] =
{
   { "TAG", "TEST", "", 0, 0 },
   { 0,0,0,0,0 },
} ;

static int test_write2( D4DISPLAY *display , long num_recs, int do_open )
{
   long odd_rec, i_rec ;
   int  rc ;
   long count = 1 ;
   long start_check = 94 ;
   char buff[11] ;

   cb.safety = 0 ;

   if ( do_open )
   {
      data = d4open( &cb, "T4WRITE2" ) ;
      if ( data == 0 )
         e4severe( e4result, "t4write.c" ) ;
      if ( d4zap( data, 1L, d4reccount( data ) ) != 0 )
         e4severe( e4result, "t4write.c" ) ;
   }
   else
   {
      data = d4create( &cb, "T4WRITE2", fields, tags ) ;
      if ( data == 0 )
         e4severe( e4result, "t4write.c" ) ;
   }

   d4opt_start( &cb ) ;

   field = d4field( data, "TEST" ) ;
   if ( field == 0 )
      e4severe( e4result, "t4write.c" ) ;

   d4display_str( display,  "        Writing Record:  ", 1 ) ;

   tag = d4tag( data, "TAG" ) ;
   /* in ntx, ndx and mdx versions (except fox)can manually increase the levels for better testing */
   #ifndef S4FOX
      #ifndef S4CLIPPER
         tag->header.keys_max = 4 ;
      #endif
   #endif

   for ( i_rec = 1L; i_rec <= num_recs; i_rec++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( i_rec % 50 == 0 || i_rec == num_recs )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Writing Record:  ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
      }

      if ( d4append_start( data, 0 ) != 0 )
         e4severe( e4result, "t4write.c" ) ;
      f4assign_long( field, 2*num_recs - 2*i_rec ) ;
      if ( d4append( data ) != 0 )
         e4severe( e4result, "t4write.c" ) ;
   }

   d4display_str( display,  "        Checking Index . . .", 1 ) ;
   d4display_wait( display ) ;
   rc = d4check( data ) ;
   d4display_start() ;
   if ( rc != 0 )
      e4severe( e4result, "t4write2.c, Index file Incorrect" ) ;

   /* Ex. 5 records:  2,3,1,4,0 (ignored),5;
      Ex. 4 records:  2,3,1,4
   */

   if (  num_recs & 1L )
      odd_rec = num_recs ;
   else 
      odd_rec = num_recs+1 ;

   d4display_str( display,  "        Seeking Record:  ", 1 ) ;

   for ( i_rec = num_recs/2; i_rec >= 0; )
   {
      if ( d4display_quit( display ) )  return 1 ;

      if ( i_rec > 0  &&  i_rec <= num_recs )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Seeking Record:  ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
         d4display_str( display,  "          ", 0 ) ;

         c4ltoa45( (long) (2*num_recs - 2*i_rec), buff, 10 ) ;
         buff[10] = '\0' ;

         if ( (count++) >= start_check )
         {
            if ( d4check( data ) != 0 )
               e4severe( e4result, "t4write.c" ) ;
         }

         if ( d4seek( data, buff ) != 0 )
            e4severe( e4result, "t4write2, seek result" ) ;

         c4ltoa45( (long) 2*i_rec-1, buff, 10 ) ;
         f4assign( field, buff ) ;
      }

      if ( i_rec <= num_recs/2 )
         i_rec = odd_rec-i_rec ;
      else
      {
         i_rec = odd_rec-i_rec ;
         i_rec -- ;
      }
   }

   d4display_wait( display ) ;
   rc = d4check( data ) ;
   d4display_start() ;
   if ( rc != 0 )
      e4severe( e4result, "t4write2.c, Index file Incorrect" ) ;

   d4display_str( display,  "        Checking Record:  ", 1 ) ;

   d4tag_select( data, tag ) ;

   for ( i_rec = 1L, rc = d4top( data ); rc != r4eof;
                i_rec++,  rc = d4skip( data, 1L ) ) 
   {
      if ( d4display_quit( display ) )  return 1 ;

      if ( i_rec % 50 == 0 )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Checking Record:  ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
      }

      if ( d4recno( data ) != i_rec )
         e4severe( e4result, "t4write2:  Seek/Write Test Fail, Final Check" ) ;

      c4ltoa45( (long) 2*i_rec-1, buff, 10 ) ;
      buff[10] = '\0' ;

      if ( memcmp( buff, f4ptr( field ), 10 ) != 0 )
         e4severe( e4result, "t4write2:  Seek/Write Test Fail, Final Check" ) ;
   }

   if ( d4close_all( &cb ) != 0 )
      e4severe( e4result, "t4write.c" ) ;

   return 0 ;
}

static int  test_with_mem_check( D4DISPLAY *display, long num_recs )
{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( test_write2( display, num_recs, 0 ) )
      return 1 ;
   if ( test_write2( display, num_recs, 1 ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo( &cb ) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4write2.c:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int  S4FUNCTION t4test( D4DISPLAY *display )
{
   long num_recs = 0 ;

   num_recs = atol( d4parsestring_nparm( &display->parse_str ) ) ;
   if ( num_recs <= 0 )
      e4severe( 0, "T4WRITE2:  Missing command line parameter(s)" ) ;

   d4display_str( display,  "T4WRITE2 Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;
   d4display_str( display,  "Number of Recs:   ", 1 ) ;
   d4display_num( display,  (long) num_recs, 0 ) ;
   d4display_str( display,  "", 1 ) ;

   if ( test_with_mem_check( display, num_recs ) )
      e4severe( e4result, "t4write.c" ) ;

   display->y += 2 ;
   d4display_str( display, "T4WRITE2:   SUCCESS", 1 ) ;
   d4display_str( display, "", 1 ) ;
   return 1 ;
}
