/* t4write3.c (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved.

   Tests CodeBase writing/appending with 2 tags, 
   a specified number of records and a specified block size.
*/

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif


#include "t4test.h"

CODE4 cb;
DATA4 *data;
FIELD4 *field1 ;
FIELD4 *field2 ;
TAG4 *tag1 ;
TAG4 *tag2 ;

static FIELD4INFO fields[] =
{
   { "TEST1",   'C', 10, 0 },
   { "TEST1_A", 'C', 90, 0 },
   { "TEST2",   'C', 10, 0 },
   { "TEST2_A", 'C', 90, 0 },
   { 0,0,0,0},
} ;

static TAG4INFO tags[] =
{
   { "TAG1", "TEST1+TEST1_A", "", 0, 0 },
   { "TAG2", "TEST2+TEST2_A", "", 0, 0 },
   { 0,0,0, 0,0 },
} ;

long start_check_rec = 0 ;
long end_check_rec  =  0 ;

static int test_write3( D4DISPLAY *display, long num_recs,
                        unsigned block_size, long dump_rec, int do_open )
{
   int rc ;
   long i_rec ;

   if ( block_size > 4096 )
   {
      cb.mem_start_block  =  1 ;
      cb.mem_expand_block =  1 ;
   }

   cb.mem_size_block = block_size ;
   cb.safety =  0 ;

   if (do_open)
      data = d4open( &cb, "T4WRITE3" ) ;
   else
      data = d4create( &cb, "T4WRITE3", fields, tags ) ;

   if ( data == 0 )
      e4severe( e4result, "t4write.c" ) ;

   d4opt_start( &cb ) ;

   field1 = d4field( data, "TEST1" ) ;
   field2 = d4field( data, "TEST2" ) ;
   if ( field1 == 0 || field2 == 0 )
      e4severe( e4result, "t4write3:  d4field()" ) ;

   tag1 = d4tag( data, "TAG1" ) ;
   tag2 = d4tag( data, "TAG2" ) ;
   if ( tag1 == 0 || tag2 == 0 )
      e4severe( e4result, "t4write3:  d4tag()" ) ;

   d4tag_select( data, tag2 ) ;

   d4display_str( display,  "        Appending Record:  ", 1 ) ;

   for ( i_rec = 1L; i_rec <= num_recs; i_rec++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( i_rec % 50 == 0 || i_rec == num_recs )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Appending Record:  ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
      }

      d4append_start(data, 0) ;

      f4assign_long( field1, i_rec ) ;
      f4assign_long( field2, i_rec ) ;

      d4append(data) ;
   }

   d4display_str( display,  "        Checking Database . . .", 1 ) ;
   d4display_wait( display ) ;
   rc = d4check( data ) ;
   d4display_start() ;
   if ( rc != 0 )
      e4severe( e4result, "t4write3.c: d4check" ) ;

   d4display_str( display,  "        Writing Record:  ", 1 ) ;

   for ( i_rec = num_recs; i_rec >= 1; i_rec-- )
   {
      if ( d4display_quit( display ) )
         return 1 ;
      e4exit_test( &cb ) ;

      display->x = (int) 0 ;
      d4display_str( display,  "        Writing Record:  ", 0 ) ;
      d4display_num( display, i_rec, 0 ) ;
      d4display_str( display,  "        ", 0 ) ;

      if ( d4go( data, i_rec ) != 0 )
         e4severe( e4result, "t4write3.c: d4go" ) ;

      f4assign_long( field1, num_recs - i_rec + 2 ) ;
      f4assign_long( field2, num_recs - i_rec + 2 ) ;

      if ( i_rec == dump_rec )
         if ( d4flush( data ) < 0 )
            e4severe( e4result, "t4write3.c: d4flush_record" ) ;

      if ( i_rec >= start_check_rec && i_rec <= end_check_rec )
      {
         if ( t4check( tag1 ) != 0 )
            return 1 ;
         if ( t4check( tag2 ) != 0 )
            return 1 ;
      }
   }

   d4display_str( display,  "        Checking Database . . .", 1 ) ;
   d4display_wait( display ) ;
   rc = d4check( data ) ;
   d4display_start() ;
   if ( rc != 0 )
      e4severe( e4result, "t4write3.c: d4check" ) ;

   d4display_str( display,  "        Checking Record:  ", 1 ) ;

   for ( i_rec = num_recs; i_rec >= 1L; i_rec-- )
   {
      if ( d4display_quit( display ) )
         return 1 ;
      e4exit_test( &cb ) ;

      if ( i_rec % 50 == 0 || i_rec == num_recs )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Checking Record:  ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
         d4display_str( display,  "     ", 0 ) ;
      }

      if ( d4go( data, i_rec ) != 0 )
         e4severe( e4result, "t4write3.c: d4go" ) ;

      if (  f4long( field1 ) !=  num_recs - i_rec + 2 )
         e4severe( e4result, "t4write3.c" ) ;
      if (  f4long( field2 ) !=  num_recs - i_rec + 2 )
         e4severe( e4result, "t4write3.c" ) ;
   }

   if ( d4close_all( &cb ) != 0 )
      e4severe( e4result, "t4write3.c: d4close_all" ) ;
   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display, long num_recs, 
                                 unsigned block_size, long dump_rec )
{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( test_write3( display, num_recs, block_size, dump_rec, 0 ) )
      return 1 ;
   if ( test_write3( display, num_recs, block_size, dump_rec, 1 ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo( &cb ) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4write3.c:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int  S4FUNCTION t4test( D4DISPLAY *display )
{
   long num_recs = 0 ;
   long dump_rec = 0 ;
   unsigned block_size = 0 ;

   num_recs = atol( d4parsestring_nparm( &display->parse_str ) ) ;
   block_size = (unsigned) atol( d4parsestring_nparm( &display->parse_str ) ) ;
   dump_rec = atol( d4parsestring_nparm( &display->parse_str ) ) ;

   if ( num_recs <= 0 )
      e4severe( 0, "T4WRITE3:  Missing command line parameter(s)" ) ;

   if ( block_size % 512 != 0   ||  block_size == 0 )
      block_size =  1024L ;

   d4display_str( display,  "T4WRITE3 Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;
   d4display_str( display,  "Number of Recs:   ", 1 ) ;
   d4display_num( display,  (long) num_recs, 0 ) ;
   d4display_str( display,  "Block Size:   ", 1 ) ;
   d4display_num( display,  (long) block_size, 0 ) ;
   d4display_str( display,  "Dump Record:   ", 1 ) ;
   d4display_num( display,  (long) dump_rec, 0 ) ;
   d4display_str( display,  "", 1 ) ;

   if ( test_with_mem_check( display, num_recs, block_size, dump_rec ) )
      e4exit(&cb) ;

   display->y += 2 ;
   d4display_str( display, "T4WRITE3:   SUCCESS", 1) ;
   d4display_str( display, "", 1) ;
   return 1 ;
}
