/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/* The source code in this module is proprietary software belonging to       */
/* Clark Development Company and is part of the PCBoard source code library. */
/* You are granted the right to use this source code for the building of any */
/* of the PCBoard products you have licensed.  Any other usage is forbidden  */
/* without prior written consent from Clark Development Company, Inc.        */
/*                                                                           */
/* Be sure to read the source code license agreement before utilizing any    */
/* of the source code found herein.                                          */
/*                                                                           */
/* Copyright (C) 1996  Clark Development Company, Inc.  All Rights Reserved. */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/


#ifndef H_PCBTEXT
#define H_PCBTEXT

#ifdef PCB152
#define TXT_NUMPROMPTS         746
#define TXT_NEWPROMPTS           0
#else
#define TXT_NUMPROMPTS         713
#define TXT_NEWPROMPTS           0
#endif
#define TXT_NUM145PROMPTS      615
#define TXT_STOPCHAR            '_'

#pragma pack(1)
typedef struct {
  char Color;                          /* color to be displayed with text */
  char Str[80];                        /* text brought in from PCBTEXT */
} pcbtexttype;
#pragma pack()

/*
#ifdef __cplusplus
extern "C" {
#endif
*/

void LIBENTRY closepcbtext(void);
int  LIBENTRY readpcbtextfile(char *Extension, callfromtype CalledFrom);
bool LIBENTRY getpcbtext(int PcbTextNum, pcbtexttype *Buffer);
bool LIBENTRY getsystext(int PcbTextNum, pcbtexttype *Buffer);
void LIBENTRY logsystext(int PcbTextNum, padtype Pad);
void LIBENTRY getpcbtextshowcolor(int PcbTextNum, pcbtexttype *Buffer);
bool LIBENTRY pcbtextspaces(int TextNum);


bool LIBENTRY displaypcbtext(int PcbTextNum, DISPLAYTYPE Display);
void LIBENTRY substpcbtext(int PcbTextNum, DISPLAYTYPE Display, char *Search, char *Replace);

/*
#ifdef __cplusplus
}
#endif
*/

#define TXT_LEAVECOMMENT         1
#define TXT_COMMENTFIELDPROMPT   2
#define TXT_ACCESSDENIEDFOREVENT 3
#define TXT_TIMELIMITEXCEEDED    4
#define TXT_UNAUTHORIZEDNAME     5
#define TXT_LOCKEDOUT            6
#define TXT_DENIEDWRONGPWRD      7
#define TXT_DENIEDREFUSETOREG    8
#define TXT_DENIEDPWRDFAILED     9
#define TXT_NAMEALREADYINUSE    10
#define TXT_CLOSEDBOARD         11
#define TXT_SECURITYVIOL        12
#define TXT_NOROOMFORTEXT       13
#define TXT_CANTPROTECTMSGTOALL 14
#define TXT_CALLERMUSTKNOWPWRD  15
#define TXT_WRONGMODEMTYPE      16
#define TXT_LOCALDNLDPATH       17
#define TXT_PASSWORDTOREADMSG   18
#define TXT_LOCALUPLDPATH       19
#define TXT_SECURITYPASSWORD    21
#define TXT_REPLYTOMSGS         22
#define TXT_NOTAVAILABLELOCALLY 24
#define TXT_SYSOPLEVELREMOVED   25
#define TXT_SYSOPLEVELGRANTED   26
#define TXT_GRAPHICSUNAVAIL     27
#define TXT_AUTOMATICLOCKOUT    28
#define TXT_RIPMODEON           29
#define TXT_TEXTENTRYFULL       30
#define TXT_ASCIINOTAVAILONBIN  31
#define TXT_MUSTENDWITHCTRLZ    32
#define TXT_NONE                33
#define TXT_NOCONNECT           34
#define TXT_FULLCOUNTDOWN       35
#define TXT_NOCARRIER           36
#define TXT_DISKFULL            37
#define TXT_NODESBUSY           38
#define TXT_ALLNAME             39
#define TXT_UPLOADMODE          40
#define TXT_ECHO                41
#define TXT_ALLCONFIND          42
#define TXT_READONLYIND         43
#define TXT_MSGBASEINUSE        45
#define TXT_NOREMOTESYSFILE     46
#define TXT_HANDLEFORCHAT       49
#define TXT_ATTACHMENT          50
#define TXT_LONGERDESCRIPTION   51
#define TXT_NOQUESTIONNAIRES    52
#define TXT_REENTERNAME         53
#define TXT_REGISTER            54
#define TXT_KBDTIMEEXPIRED      55
#define TXT_INVALIDENTRY        56
#define TXT_UPLOADSAREPRIVATE   57
#define TXT_ONLINEUPGRADE       58
#define TXT_AUTODISCONNECTNOW   59
#define TXT_FULLUSERNAMETOFIND  60
#define TXT_FILENAMETODOWNLOAD  61
#define TXT_TEXTVIEWFILENAME    62
#define TXT_HELPPROMPT          63
#define TXT_JOINCONFNUM         64
#define TXT_NODENUMTOLOGOFF     65
#define TXT_NODETOVIEW          66
#define TXT_QNUMTOANSWER        67
#define TXT_FILENAMETOUPLOAD    68
#define TXT_DOORNUMBER          69
#define TXT_TEXTTOSCANFOR       70
#define TXT_SEARCHFILENAME      71
#define TXT_DATETOSEARCH        72
#define TXT_PRIVATETOPIC        73
#define TXT_NOTREGINCONF        74
#define TXT_OPENTOPIC           75
#define TXT_AUTODISCONNECT      76
#define TXT_MSGNUMTOACTIVATE    77
#define TXT_NOMAILFOUND         78
#define TXT_PACKTHEMSGBASE      79
#define TXT_DELETECALLERSLOG    80
#define TXT_RENUMBERDURINGPACK  82
#define TXT_NEWLOWMSGNUM        83
#define TXT_COMPLETEQUESTION    84
#define TXT_WANTTODELETELINE    85
#define TXT_PACKTHEUSERSFILE    86
#define TXT_OVERWRITE           87
#define TXT_VIEWCONFMEMBERS     88
#define TXT_PURGEPRIVRECEIVED   89
#define TXT_EXITTODOS           90
#define TXT_WRONGPWRDENTERED    92
#define TXT_NOSUCHLINENUMBER    93
#define TXT_NOSUCHMSGNUMBER     94
#define TXT_YOUCANNOTKILLMSG    95
#define TXT_INVALIDSELECTION    96
#define TXT_PAGING              97
#define TXT_CHANNELTEXT         98
#define TXT_ENTERNOCHANGE       99
#define TXT_SHELLCOMPLETED     100
#define TXT_PAGELENGTHSETTO    101
#define TXT_USERNOTREGINCONF   102
#define TXT_INFOSAVED          103
#define TXT_AUTOLOGOFF         104
#define TXT_KEEPLOCKEDOUT      105
#define TXT_PURGEOLDERTHAN     106
#define TXT_KEEPSECURITY       107
#define TXT_USERSFILEPACKED    108
#define TXT_JOININGCHANNEL     109
#define TXT_PWRDSDONTMATCH     110
#define TXT_REENTERPASSWORD    111
#define TXT_ENTERUSERSECLEVEL  112
#define TXT_BUSDATAPHONE       113
#define TXT_HOMEVOICEPHONE     114
#define TXT_TIMEADJUSTED       116
#define TXT_RESPONSEREQUIRED   117
#define TXT_REALNAMESONLY      118
#define TXT_INSUFSECTOVIEW     119
#define TXT_DOORNOTAVAILABLE   120
#define TXT_NONETWORKACTIVE    121
#define TXT_REGINFOSAVED       123
#define TXT_ERRORSAVINGMESSAGE 125
#define TXT_ERRORINUSERSFILE   126
#define TXT_CHANNELBUSY        127
#define TXT_SYSOPUNAVAILABLE   128
#define TXT_SYSOPBUSY          129
#define TXT_USERBUSY           130
#define TXT_DOSBUSY            131
#define TXT_DOSNOTBUSY         132
#define TXT_TURNPRINTERON      133
#define TXT_TURNALARMON        134
#define TXT_TURNPAGEON         135
#define TXT_NEWHANDLE          136
#define TXT_BULLETINSUPDATED   137
#define TXT_NOTIMEFORXFER      138
#define TXT_INSUFUPLOADSPACE   139
#define TXT_UPLOADSDISABLED    140
#define TXT_7E1INEFFECT        141
#define TXT_DOSFUNCTION        142
#define TXT_ENTERLOGONPWRD     143
#define TXT_EXCESSIVEERRORS    144
#define TXT_ABORTKEYS          145
#define TXT_ENTERPAGELENGTH    146
#define TXT_YOURPASSWORD       148
#define TXT_WANTGRAPHICS       149
#define TXT_REENTERUSERSNAME   150
#define TXT_NEWPASSWORD        152
#define TXT_CHECKINGFILEXFER   153
#define TXT_DUPLICATEFILE      154
#define TXT_MSGSCANPROMPT      155
#define TXT_JOINGROUPCHAT      156
#define TXT_WAITINGFOREVENT    157
#define TXT_FIVESCANHEADER     158
#define TXT_BYTESLEFTARE       159
#define TXT_ENTERDESCRIPTION   160
#define TXT_SLASHFORPRIVATE    161
#define TXT_THANKSFORTHEFILES  162
#define TXT_MSGCOMMANDEXPERT   163
#define TXT_MSGCOMMANDNOVICE1  164
#define TXT_MODEMERROR         165
#define TXT_THANKSFORCALLING   166
#define TXT_USERMODEXPERT      167
#define TXT_USERMODNONEXPERT   168
#define TXT_TO                 169
#define TXT_FROM               170
#define TXT_SUBJ               171
#define TXT_NEWTOPIC           173
#define TXT_SYSOPCHATACTIVE    175
#define TXT_TRANSFERSUCCESSFUL 176
#define TXT_INVALIDFILENAME    177
#define TXT_CHATPROMPTEXPERT   178
#define TXT_CHATPROMPTNOVICE   179
#define TXT_TOPICNOWPRIVATE    180
#define TXT_CHANNELISPRIVATE   181
#define TXT_7E1NOTAVAILABLE    182
#define TXT_RELOADINGPCBOARD   184
#define TXT_USERRECNUMISBAD    185
#define TXT_PRESSESCFORCOMMAND 186
#define TXT_ABORTEDUSING       187
#define TXT_COMPLETEDUSING     188
#define TXT_MADETOPICPRIVATE   189
#define TXT_RINGDETECTED       190
#define TXT_SPACETOACKNOWLEDGE 191
#define TXT_MINUTESUSED        192
#define TXT_NEWSUBJECT         193
#define TXT_MSGSECURITY        194
#define TXT_MSGSEARCHFROM      195
#define TXT_MOREPROMPT         196
#define TXT_ENDOFMESSAGE       197
#define TXT_DESIREDPROTOCOL    198
#define TXT_MSGTO              199
#define TXT_MSGSUBJ            200
#define TXT_CREATINGNEWMSGBASE 203
#define TXT_ONLINEUPGRADEDONE  204
#define TXT_NOTINUSERSFILE     208
#define TXT_TWOLINESLEFT       209
#define TXT_ENTEREDCHANNEL     210
#define TXT_LEFTCHANNEL        211
#define TXT_VIEWCALLERS        212
#define TXT_VIEWPRINTUSERS     213
#define TXT_WASNOTFOUNDINLINE  214
#define TXT_CARRIERLOST        215
#define TXT_ENTERSTARTS        216
#define TXT_ABORTSTRANSFER     217
#define TXT_FILESIZEISZERO     218
#define TXT_SYSOPCHATENDED     219
#define TXT_EDITHEADER         220
#define TXT_ECHOMESSAGE        221
#define TXT_TEXTENTRYCOMMAND   222
#define TXT_FILELISTCOMMAND    223
#define TXT_BLTLISTCOMMAND     224
#define TXT_WANTSTOCHAT        225
#define TXT_TORESPONDTOCHAT    226
#define TXT_NODECHATUPROMPT    227
#define TXT_NODECHATAPROMPT    228
#define TXT_NODENOTAVAILABLE   229
#define TXT_NODECHATENDED      230
#define TXT_NODECHATENTERED    231
#define TXT_TOPICFORCHAT       232
#define TXT_REFUSEDTOREGISTER  233
#define TXT_NEWCHANNEL         234
#define TXT_MONITOROFF         235
#define TXT_MONITORON          236
#define TXT_NOCHANNELSINUSE    237
#define TXT_MSGENTERTEXT       238
#define TXT_OUTTODOS           239
#define TXT_ARCVIEWFILENAME    240
#define TXT_ERRORVIEWINGFILE   241
#define TXT_VIEWEXECUTEDONFILE 242
#define TXT_CHECKINGARCVIEW    243
#define TXT_CHATWITHSYSOP      244
#define TXT_DEFAULTPROTOCOL    245
#define TXT_ERRORINPROTFILE    246
#define TXT_ANSWERSCRIPT       247
#define TXT_NODETOCALL         248
#define TXT_GETIGNORELIST      249
#define TXT_IGNORECANCELLED    250
#define TXT_TOPICNOWPUBLIC     251
#define TXT_RCVDMESSAGE        252
#define TXT_LOADINGPACKMODULE  253
#define TXT_PACKMODULEMISSING  254
#define TXT_IGNORINGNODES      255
#define TXT_USEREXISTS         256
#define TXT_USERSFIRSTNAME     257
#define TXT_USERSLASTNAME      258
#define TXT_YOURFIRSTNAME      259
#define TXT_YOURLASTNAME       260
#define TXT_SILENTOFF          261
#define TXT_SILENTON           262
#define TXT_SENDTONODE         263
#define TXT_ADDTOINDEX         264
#define TXT_CITYSTATE          265
#define TXT_EXPDATE            266
#define TXT_EXPSECLEVEL        267
#define TXT_EXPREGCONF         268
#define TXT_SPECIALCOMMENT     269
#define TXT_BAUDNOTSUPPORTED   270
#define TXT_BAUDSUPPORTEDFROM  271
#define TXT_SYSTEMUNAVAILABLE  272
#define TXT_USERRECORDUPDATED  273
#define TXT_NODENUMTODROP      274
#define TXT_NOBLTSAVAILABLE    275
#define TXT_NODOORSAVAILABLE   276
#define TXT_NODIRSAVAILABLE    277
#define TXT_NOCONFAVAILABLE    278
#define TXT_USERNETUNDERLINE   279
#define TXT_PROTOCOLFORXFER    280
#define TXT_INVALIDCONFNUM     281
#define TXT_INVALIDDOOR        282
#define TXT_SCANNINGDIRECTORY  283
#define TXT_CURPAGELEN         284
#define TXT_BADUPLOADFORMAT    285
#define TXT_USERNETHEADER      286
#define TXT_GRAPHICSON         287
#define TXT_GRAPHICSOFF        288
#define TXT_LOGOFFINFOSAVED    289
#define TXT_TRANSFERABORTED    290
#define TXT_INVALIDBLTNUM      291
#define TXT_INVALIDFILENUM     292
#define TXT_EVENTRAN           293
#define TXT_EXITEDTODOSAT      294
#define TXT_TEXTFILEVIEWED     295
#define TXT_SCANMSGBASE        296
#define TXT_NEWINFO            297
#define TXT_TEXTTOSEND         298
#define TXT_RCVDPRIVATEMESSAGE 299
#define TXT_DFLTFILENAMETODNLD 300
#define TXT_CARBONCOPYTO       301
#define TXT_OPENEDDOOR         302
#define TXT_NOCALLER           303
#define TXT_AVAILABLE          304
#define TXT_INADOOR            305
#define TXT_LOGOFFPENDING      306
#define TXT_RECYCLEBBS         307
#define TXT_UNAVAILABLE        308
#define TXT_TRANSFER           309
#define TXT_ENTERMESSAGE       310
#define TXT_GROUPCHAT          311
#define TXT_DROPDOSDELAYED     312
#define TXT_MADETOPICPUBLIC    313
#define TXT_CANTBEPRIVATE      314
#define TXT_BADDOWNLOADPWRD    315
#define TXT_BADUPLOADPWRD      316
#define TXT_BADVIEWPWRD        317
#define TXT_BADPWRDFORDOOR     318
#define TXT_NODENOTINCHAT      319
#define TXT_ANNOUNCECOPY       320
#define TXT_BULLETINREAD       321
#define TXT_INPUTFILENAME      322
#define TXT_FILESELECTED       323
#define TXT_PROTOCOLTYPE       324
#define TXT_SELECTCONFS        325
#define TXT_NOTFOUNDONDISK     326
#define TXT_THANKSFORWAITING   327
#define TXT_CONFJOINED         328
#define TXT_LOCALPASSWORD      329
#define TXT_MSGNUMBERTOKILL    330
#define TXT_PUNCTUATIONERROR   331
#define TXT_BACKFROMDOS        332
#define TXT_HELLOTHISIS        333
#define TXT_MSGRESTORED        334
#define TXT_MSGKILLED          335
#define TXT_COMMENTLEFT        336
#define TXT_MESSAGELEFT        337
#define TXT_SAVINGCOMMENT      338
#define TXT_SAVINGMESSAGE      339
#define TXT_MOREHELP_ENTER     340
#define TXT_MOREHELP_YES       341
#define TXT_MOREHELP_NO        342
#define TXT_MOREHELP_NONSTOP   343
#define TXT_DROPDOSNOW         344
#define TXT_DROPNOW            345
#define TXT_MOREHELP_VIEW      346
#define TXT_TOTALMSGSFOUND     347
#define TXT_RECYCLETHRUDOS     348
#define TXT_PASSWORDFAILURE    349
#define TXT_EXPERTON           350
#define TXT_EXPERTOFF          351
#define TXT_FILENUMEXPERT      352
#define TXT_FILENUMNOVICE      353
#define TXT_HELPLINE1          354
#define TXT_HELPLINE2          355
#define TXT_NETWORKDELAY       356
#define TXT_DOWNLOADTIME       357
#define TXT_DOWNLOADSIZE       358
#define TXT_TOTALWILLBE        359
#define TXT_UPLOADDRIVE        360
#define TXT_FREEDISKSPACE      361
#define TXT_MSGNUMBERMEMORIZED 363
#define TXT_INSUFMEMFORCHAT    365
#define TXT_UPLOADSTATUS       366
#define TXT_SCREENED           367
#define TXT_POSTEDIMMEDIATELY  368
#define TXT_CALLERNUMBER       369
#define TXT_CANTOPENCHATFILE   370
#define TXT_LASTDATEONE        371
#define TXT_EXPIREDATE         372
#define TXT_NUMTIMESON         373
#define TXT_PAGELENGTH         374
#define TXT_EXPERTMODEON       375
#define TXT_EXPERTMODEOFF      376
#define TXT_SECURITYLEVEL      377
#define TXT_NUMDOWNLOADS       378
#define TXT_NUMUPLOADS         379
#define TXT_BYTESAVAILABLE     380
#define TXT_LASTMSGREAD        381
#define TXT_HIGHMSGNUMBER      382
#define TXT_NUMACTIVEMSGS      383
#define TXT_TRANSFERPROTOCOL   384
#define TXT_LANGAVAIL          385
#define TXT_LANGALTNOTAVAIL    386
#define TXT_LANGENTERNUMBER    387
#define TXT_LANGACTIVE         388
#define TXT_LANGNOTAVAIL       389
#define TXT_MINUTES            390
#define TXT_RESETMODEM         393
#define TXT_SYSTEMAVAIL        394
#define TXT_MINUTESLEFT        395
#define TXT_COMMANDPROMPT      396
#define TXT_SCANNING           397
#define TXT_SCANNINGMAIN       398
#define TXT_CONFERENCE         399
#define TXT_MAINBOARD          400
#define TXT_CHATFORMATERROR    401
#define TXT_FOUNDNAME          402
#define TXT_MSGABORT           403
#define TXT_MSGABORTED         404
#define TXT_DELETELINENUM      405
#define TXT_CANNOTINSERT       406
#define TXT_INSERTBEFORENUM    407
#define TXT_EDITLINENUM        408
#define TXT_OPERATORPAGED      409
#define TXT_GOINGOFFHOOK       411
#define TXT_CONFABANDONED      412
#define TXT_MENUSELUNAVAIL     413
#define TXT_PWRDFORUPLOAD      414
#define TXT_PWRDFORDOOR        415
#define TXT_PWRDFORVIEW        416
#define TXT_PWRDFORDOWNLOAD    417
#define TXT_PRESSENTER         418
#define TXT_INSUFSECFORDOOR    419
#define TXT_EDITHEADERECHO     420
#define TXT_NONEWS             421
#define TXT_MSGSFORYOU         422
#define TXT_MSGSFROMYOU        423
#define TXT_MSGSCANCOMMAND     424
#define TXT_MSGREADCOMMAND     425
#define TXT_NOTMEMORIZED       426
#define TXT_CALLANYWAY         427
#define TXT_INSUFSECTODLFILE   428
#define TXT_CALLERSLOGVIEWED   429
#define TXT_DIRECTORYSCAN      430
#define TXT_USERSFILEVIEWED    431
#define TXT_BEGINUPTEST        433
#define TXT_HANGUPNOWORWAIT    434
#define TXT_HANGINGUPNOW       435
#define TXT_SYSOPEXITEDTODOS   436
#define TXT_UPLOADABORTED      437
#define TXT_OLDTEXTNEWTEXT     438
#define TXT_MSGDATENUM         439
#define TXT_MSGTOLINE          440
#define TXT_MSGREPLIES         441
#define TXT_MSGFROM            442
#define TXT_MSGNA              443
#define TXT_MSGNOTREAD         444
#define TXT_MSGRCVRONLY        445
#define TXT_MSGGROUPPWRD       446
#define TXT_MSGSENDERPWRD      447
#define TXT_MSGPUBLIC          448
#define TXT_CONTINUEUPLOAD     449
#define TXT_ERRORCORRECTING    450
#define TXT_MSGREFERNUM        451
#define TXT_MSGREAD            452
#define TXT_MSGSUBJLINE        453
#define TXT_NOTRECNUMONE       454
#define TXT_MSGSTATUS          455
#define TXT_NOMATCHINPWRD      457
#define TXT_NUMFREEMSGS        458
#define TXT_LOWMSGNUM          459
#define TXT_NUMDEFINEDMSGS     460
#define TXT_GENERATENEWINDEX   461
#define TXT_ECHODISABLED       463
#define TXT_ECHOENABLED        464
#define TXT_MOVEMESSAGETOCONF  465
#define TXT_MSGFILE            466
#define TXT_MESSAGEMOVED       467
#define TXT_MSGLIST            468
#define TXT_RECENTUPLOADS      469
#define TXT_SCROLLKEYS         470
#define TXT_SCROLLABOVE        471
#define TXT_SCROLLBELOW        472
#define TXT_GENERICMESSAGE     473
#define TXT_GOODBYEAFTERUP     474
#define TXT_READYTOSENDBATCH   475
#define TXT_MSGTOOWIDE         476
#define TXT_MSGTOOWIDESAVE     477
#define TXT_BATCHXFERENDED     478
#define TXT_OUTPUTFILENAME     479
#define TXT_BATCHDLTIME        480
#define TXT_BATCHDLSIZE        481
#define TXT_BATCHPROTOCOL      482
#define TXT_RESUMEALL          483
#define TXT_MSGSGENERAL        484
#define TXT_MSGSTHREAD         485
#define TXT_MSGSTEXTSCAN       486
#define TXT_MSGSREADFORYOU     487
#define TXT_MSGSREADFROMYOU    488
#define TXT_MSGSREADTOORFROM   489
#define TXT_BYEAFTERDOWNLOAD   490
#define TXT_ATTACHEDFILE       491
#define TXT_POINTERSRESTORED   492
#define TXT_BYEINTENSECONDS    493
#define TXT_CAPISEMPTY         494
#define TXT_TOTALMSGSINCAPTURE 495
#define TXT_SENDINGFILES       496
#define TXT_LOGINTOSYSTEM      497
#define TXT_USEFULLSCREEN      498
#define TXT_REQUIRESANSI       499
#define TXT_DOWNLOADTAGGED     500
#define TXT_NEWBULLETINS       501
#define TXT_NAMESTRIED         502
#define TXT_DOSOUNDEXSEARCH    503
#define TXT_USEFOUNDNAME       504
#define TXT_QUOTESTART         505
#define TXT_QUOTEEND           506
#define TXT_COMPRESSING        507
#define TXT_INSUFFICIENTMEMORY 508
#define TXT_SYSOPNOTBUSY       509
#define TXT_USERNOTBUSY        510
#define TXT_PCBSYSMGR          511
#define TXT_PCBFILER           512
#define TXT_PCBSETUP           513
#define TXT_SETSTATSLOCAL      514
#define TXT_PCBMONI            515
#define TXT_RESETSTATS         516
#define TXT_NOPRINTER          517
#define TXT_TURNPRINTEROFF     518
#define TXT_TURNALARMOFF       519
#define TXT_TURNPAGEOFF        520
#define TXT_USERBUSYDESC       521
#define TXT_USERNOTBUSYDESC    522
#define TXT_TOGGLEPRINTERDESC  523
#define TXT_PCBSYSMGRDESC      524
#define TXT_SETSTATSDESC       525
#define TXT_SYSOPBUSYDESC      526
#define TXT_SYSOPNOTBUSYDESC   527
#define TXT_TOGGLEPAGEDESC     528
#define TXT_PCBFILERDESC       529
#define TXT_PCBMONIDESC        530
#define TXT_DOSBUSYDESC        531
#define TXT_DOSNOTBUSYDESC     532
#define TXT_TOGGLEALARMDESC    533
#define TXT_PCBSETUPDESC       534
#define TXT_RESETSTATSDESC     535
#define TXT_NOMODEMSELECTED    536
#define TXT_LASTCALLER         537
#define TXT_NUMCALLS           538
#define TXT_NUMMESSAGES        539
#define TXT_NUMDOWN            540
#define TXT_NUMUP              541
#define TXT_ESCTOEXIT          542
#define TXT_INSFORINSERT       543
#define TXT_INSFOROVERWRITE    544
#define TXT_SETLASTMSGREADPTR  545
#define TXT_LASTMSGREADSETTO   546
#define TXT_UNLIMITED          547
#define TXT_MOREHELP_FLAG      548
#define TXT_FILESMOREPROMPT    549
#define TXT_GOODBYEAFTERDOWN   550
#define TXT_EDITBATCH          551
#define TXT_REMOVEFILENUMBER   552
#define TXT_REMOVEDFILE        553
#define TXT_DUPLICATEBATCHFILE 554
#define TXT_BATCHLIMITREACHED  555
#define TXT_CLSBETWEENMSGS     556
#define TXT_FLAGFORDOWNLOAD    557
#define TXT_USERSHEADER        558
#define TXT_USERSCAN           559
#define TXT_SETSTATSSYSTEM     560
#define TXT_DELETERECORD       561
#define TXT_CONFNUMBERS        562
#define TXT_CONFNUMBERS2       563
#define TXT_SELECTCONFFLAGS    564
#define TXT_SELECTINGALL       565
#define TXT_MAILWAITINGIN      566
#define TXT_USERSEARCHNAME     567
#define TXT_REQUIRETWONAMES    568
#define TXT_COPYMESSAGETOCONF  569
#define TXT_MESSAGECOPIED      570
#define TXT_COMMENTINSTEAD     571
#define TXT_FREEDOWNLOAD       572
#define TXT_NOTIMECHARGE       573
#define TXT_TESTFILENAME       574
#define TXT_VERIFYINGFILE      575
#define TXT_PASSED             576
#define TXT_FAILED             577
#define TXT_FILEVERIFYFAILED   578
#define TXT_PAGINGSYSOP        579
#define TXT_SCANHEADER1        580
#define TXT_SCANHEADER2        581
#define TXT_SCANHEADER3        582
#define TXT_SETFSEDEFAULT      583
#define TXT_MSGREADCMDEXPRT    584
#define TXT_FILELISTCMDEXPRT   585
#define TXT_CONFHEADER1        586
#define TXT_CONFHEADER2        587
#define TXT_CTTYON             588
#define TXT_ANSION             589
#define TXT_MODEM              590
#define TXT_CALLERNUM          591
#define TXT_CALLERSEC          592
#define TXT_SEPARATOR          593
#define TXT_OPENINGDOOR        594
#define TXT_WRONGPWRD          595
#define TXT_WRONGPWRDCMNT      596
#define TXT_WRONGPWRDSUBJECT   597
#define TXT_ISTHISCORRECT      598
#define TXT_CHANGENAMES        599
#define TXT_LOCKCALLEROUT      600
#define TXT_DISCONNECTNOW      601
#define TXT_GIVESYSOPPRIV      602
#define TXT_FILESAREFLAGGED    603
#define TXT_CONTINUEDOOR       604
#define TXT_CONTINUELOGOFF     605
#define TXT_SELECTED           606
#define TXT_DESELECTED         607
#define TXT_SEARCHINGFOR       608
#define TXT_UPLOADCREDITS      609
#define TXT_COULDNTFINDINUSERS 610
#define TXT_BLTLISTCMDEXPERT   611
#define TXT_ENDOFMSGEXPERT     612
#define TXT_MSGSCANCMDEXPERT   613
#define TXT_MAXMSGSPERCONF     614
#define TXT_MAXMSGS            615
#define TXT_BIRECEIVE          616
#define TXT_BIRECEIVELOG       617
#define TXT_RECEIVELOG         618
#define TXT_SENDLOG            619
#define TXT_BATCHSEND          620
#define TXT_BATCHRECEIVE       621
#define TXT_SENDAVECPS         622
#define TXT_RECEIVEAVECPS      623
#define TXT_SHOWATTACHCMDS     624
#define TXT_FILESIZE           625
#define TXT_PICKANOTHERHANDLE  626
#define TXT_SCROLLMSGBODY      627
#define TXT_USEBIGHEADERS      628
#define TXT_MSGCOMMANDNOVICE2  629
#define TXT_REQRETRECEIPT      630
#define TXT_RETRECEIPTREQ      631
#define TXT_GENERATERECEIPT    632
#define TXT_YOURMSGNUM         633
#define TXT_ADDRESSEDTO        634
#define TXT_RECEIVEDON         635
#define TXT_ROUTETO            636
#define TXT_DEFAULTWIDEMSGS    637
#define TXT_CONFISREADONLY     638
#define TXT_NOPRIVMSGS         639
#define TXT_PWRDTOJOIN         640
#define TXT_ALREADYATTACHED    641
#define TXT_CARBONLIST         642
#define TXT_CARBONNAME         643
#define TXT_USERSEARCHTONAME   644
#define TXT_USERSEARCHFROMNAME 645
#define TXT_ATTACHMENTMISSING  646
#define TXT_ATTACHNOTALLOWED   647
#define TXT_CARBONLIMITREACHED 648
#define TXT_ERRORSINPPE        649
#define TXT_NOMEMORYFORPPE     650
#define TXT_INVALIDTOKENINPPE  651
#define TXT_ERROREXECPPE       652
#define TXT_EVALERRORINPPE     653
#define TXT_ERRORLOADINGPPE    654
#define TXT_APPENDERRORINPPE   655
#define TXT_DELETEERRORINPPE   656
#define TXT_UPDATINGINDEX      657
#define TXT_72COLUMNS          658
#define TXT_79COLUMNS          659
#define TXT_45COLUMNS          660
#define TXT_CARBONLISTMSG      661
#define TXT_READMAILNOW        662
#define TXT_SCANNINGFORMAIL    663
#define TXT_FORCEREADMAIL      664
#define TXT_SCANNINGBLTS       665
#define TXT_FILERATIO          666
#define TXT_BYTERATIO          667
#define TXT_RATIOLIMIT         668
#define TXT_FILERATIOEXCEEDED  669
#define TXT_BYTERATIOEXCEEDED  670
#define TXT_FILESDOWNLOADED    671
#define TXT_BYTESDOWNLOADED    672
#define TXT_DOWNLOADLIMIT      673
#define TXT_FILELIMITEXCEEDED  674
#define TXT_BYTELIMITEXCEEDED  675
#define TXT_CREATINGQWK        676
#define TXT_ERRORCOMPRESSING   677
#define TXT_QWKCOMMANDS        678
#define TXT_EXTRACTINGMSGS     679
#define TXT_ERROREXTRACTING    680
#define TXT_INVALIDMENUOPTION  681
#define TXT_MENUCOMMAND        682
#define TXT_RUNNINGEVENT       683
#define TXT_EVENTFINISHED      684
#define TXT_REPSUCCESSFUL      685
#define TXT_REPFAILED          686
#define TXT_FILENOTALLOWED     687
#define TXT_ENTERPACKDATE      688
#define TXT_DATETOPACKOUT      689
#define TXT_GETALIASNAME       690
#define TXT_HIDINGIDENTITY     691
#define TXT_CHANGEDNAMETO      692
#define TXT_IDENTITYPROTECTED  693
#define TXT_CHANGEDALIASTO     694
#define TXT_ATTEMPTEDALIAS     695
#define TXT_SHOWBYTERATIO      696
#define TXT_SHOWFILERATIO      697
#define TXT_ENTERADDRESS       698
#define TXT_STREET1            699
#define TXT_STREET2            700
#define TXT_CITY               701
#define TXT_STATE              702
#define TXT_ZIP                703
#define TXT_COUNTRY            704
#define TXT_PREVIOUSLYUSEDPWRD 705
#define TXT_ENTERVERIFYTEXT    706
#define TXT_ENTERCOMPARETEXT   707
#define TXT_PASSWORDTOOSHORT   708
#define TXT_NEEDUNIQUEPASSWORD 709
#define TXT_PASSWORDEXPIRED    710
#define TXT_PASSWORDWILLEXP    711
#define TXT_MSGSDATETOSEARCH   712
#define TXT_RECEIPTLEFT        713
#define TXT_FORWARDFROM        714
#define TXT_FORWARDBY          715
#define TXT_INSUFCREDITS       716
#define TXT_CREDITSUSED        717
#define TXT_CREDITSLEFT        718
#define TXT_CREDITEXCEEDED     719
#define TXT_SECURITYCHANGED    720
#define TXT_NOCOST             721
#define TXT_FROMRETRECEIPT     722
#define TXT_COMMENT            723
#define TXT_ERRORINFROMNAME    724
#define TXT_QUICKSCANHEADER    725
#define TXT_FILEFAILED         726
#define TXT_UPLOADEDBY         727
#define TXT_FILENAMETODNLDBTCH 728
#define TXT_FILENAMETOUPLDBTCH 729
#define TXT_USERSCANLINE       730
#define TXT_NETSTATUS          731
#define TXT_PERSONALMSGLIMIT   732
#define TXT_PERSONALCONFLIMIT  733
#define TXT_PERSONALQWKLIMIT   734
#define TXT_PUBLICQWKLIMIT     735
#define TXT_DESTNEWSGROUP      736
#define TXT_FOLLOWUPNEWSGROUP  737
#define TXT_HANDLINGMAIL       738
#define TXT_FILESSHOWPROMPT    739
#define TXT_ENTERDIRCMD        740
#define TXT_NOFILESFOUND       741
#define TXT_DIRECTORYOF        742
#define TXT_SHORTINEFFECT      743
#define TXT_LONGINEFFECT       744
#define TXT_SHOWLONGDESC       745
#define TXT_USESHORTDESC       746

#endif  /* ifndef H_PCBTEXT */
